/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.attributes.Usage;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.mpp.IKotlinProjectStructureMetadataExtractorFactory;
import org.jetbrains.kotlin.gradle.plugin.mpp.MppDependencyProjectStructureMetadataExtractor;
import org.jetbrains.kotlin.gradle.plugin.mpp.ProjectStructureMetadataFileExtractor;
import org.jetbrains.kotlin.gradle.utils.LazyResolvedConfiguration;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinProjectStructureMetadataExtractorFactory;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/IKotlinProjectStructureMetadataExtractorFactory;", "logger", "Lorg/gradle/api/logging/Logger;", "(Lorg/gradle/api/logging/Logger;)V", "create", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/MppDependencyProjectStructureMetadataExtractor;", "dependency", "Lorg/gradle/api/artifacts/result/ResolvedDependencyResult;", "resolvedPsmConfiguration", "Lorg/jetbrains/kotlin/gradle/utils/LazyResolvedConfiguration;", "findPsmFileOrNull", "Ljava/io/File;", "moduleId", "Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "Companion", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nKotlinProjectStructureMetadataExtractorFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinProjectStructureMetadataExtractorFactory.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/KotlinProjectStructureMetadataExtractorFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1#2:65\n766#3:66\n857#3,2:67\n766#3:69\n857#3,2:70\n1549#3:72\n1620#3,3:73\n*S KotlinDebug\n*F\n+ 1 KotlinProjectStructureMetadataExtractorFactory.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/KotlinProjectStructureMetadataExtractorFactory\n*L\n52#1:66\n52#1:67,2\n53#1:69\n53#1:70,2\n54#1:72\n54#1:73,3\n*E\n"})
public final class KotlinProjectStructureMetadataExtractorFactory
implements IKotlinProjectStructureMetadataExtractorFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;

    private KotlinProjectStructureMetadataExtractorFactory(Logger logger2) {
        this.logger = logger2;
    }

    @Nullable
    public final MppDependencyProjectStructureMetadataExtractor create(@NotNull ResolvedDependencyResult dependency, @Nullable LazyResolvedConfiguration resolvedPsmConfiguration) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        if (resolvedPsmConfiguration == null) {
            boolean $i$a$-checkNotNull-KotlinProjectStructureMetadataExtractorFactory$create$22 = false;
            String $i$a$-checkNotNull-KotlinProjectStructureMetadataExtractorFactory$create$22 = "KotlinProjectStructureMetadataExtractorFactory must not receive null psmConfiguration";
            throw new IllegalStateException($i$a$-checkNotNull-KotlinProjectStructureMetadataExtractorFactory$create$22.toString());
        }
        ComponentIdentifier moduleId2 = dependency.getSelected().getId();
        Intrinsics.checkNotNullExpressionValue((Object)moduleId2, (String)"moduleId");
        File psmFile = this.findPsmFileOrNull(resolvedPsmConfiguration, moduleId2);
        if (psmFile == null) {
            this.logger.warn("Could not find Kotlin project structure metadata for module " + moduleId2 + "; Please report this: http://kotl.in/issue");
            return null;
        }
        return new ProjectStructureMetadataFileExtractor(psmFile);
    }

    /*
     * WARNING - void declaration
     */
    private final File findPsmFileOrNull(LazyResolvedConfiguration resolvedPsmConfiguration, ComponentIdentifier moduleId2) {
        void $this$mapTo$iv$iv;
        ResolvedArtifactResult it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = resolvedPsmConfiguration.getArtifacts(moduleId2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ResolvedArtifactResult)element$iv$iv;
            boolean bl = false;
            Usage usage = (Usage)it.getVariant().getAttributes().getAttribute(Usage.USAGE_ATTRIBUTE);
            if (!Intrinsics.areEqual((Object)(usage != null ? usage.getName() : null), (Object)"kotlin-psm-metadata")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ResolvedArtifactResult)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getFile().getName(), (Object)"empty-kotlin-project-structure-metadata"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ResolvedArtifactResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFile());
        }
        return (File)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
    }

    public /* synthetic */ KotlinProjectStructureMetadataExtractorFactory(Logger logger2, DefaultConstructorMarker $constructor_marker) {
        this(logger2);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinProjectStructureMetadataExtractorFactory$Companion;", "", "()V", "getOrCreate", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinProjectStructureMetadataExtractorFactory;", "project", "Lorg/gradle/api/Project;", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinProjectStructureMetadataExtractorFactory getOrCreate(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Logger logger2 = project.getLogger();
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"project.logger");
            return new KotlinProjectStructureMetadataExtractorFactory(logger2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

