/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.abi;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.TaskContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.abi.AbiFiltersSpec;
import org.jetbrains.kotlin.gradle.dsl.abi.AbiValidationLegacyDumpExtension;
import org.jetbrains.kotlin.gradle.dsl.abi.AbiValidationVariantSpec;
import org.jetbrains.kotlin.gradle.dsl.abi.ExperimentalAbiValidation;
import org.jetbrains.kotlin.gradle.internal.abi.AbiFiltersSpecImplKt;
import org.jetbrains.kotlin.gradle.internal.abi.AbiValidationExtensionKt;

@ExperimentalAbiValidation
@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0011\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0003H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/abi/AbiValidationVariantSpecImpl;", "Lorg/jetbrains/kotlin/gradle/dsl/abi/AbiValidationVariantSpec;", "variantName", "", "objects", "Lorg/gradle/api/model/ObjectFactory;", "tasks", "Lorg/gradle/api/tasks/TaskContainer;", "(Ljava/lang/String;Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/api/tasks/TaskContainer;)V", "filters", "Lorg/jetbrains/kotlin/gradle/dsl/abi/AbiFiltersSpec;", "getFilters", "()Lorg/jetbrains/kotlin/gradle/dsl/abi/AbiFiltersSpec;", "legacyDump", "Lorg/jetbrains/kotlin/gradle/dsl/abi/AbiValidationLegacyDumpExtension;", "getLegacyDump", "()Lorg/jetbrains/kotlin/gradle/dsl/abi/AbiValidationLegacyDumpExtension;", "getName", "kotlin-gradle-plugin_common"})
public class AbiValidationVariantSpecImpl
implements AbiValidationVariantSpec {
    @NotNull
    private final String variantName;
    @NotNull
    private final AbiFiltersSpec filters;
    @NotNull
    private final AbiValidationLegacyDumpExtension legacyDump;

    public AbiValidationVariantSpecImpl(@NotNull String variantName, @NotNull ObjectFactory objects, @NotNull TaskContainer tasks) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        Intrinsics.checkNotNullParameter((Object)tasks, (String)"tasks");
        this.variantName = variantName;
        this.filters = AbiFiltersSpecImplKt.AbiFiltersSpecImpl(objects);
        this.legacyDump = AbiValidationExtensionKt.AbiValidationLegacyDumpExtensionImpl(objects, this.variantName, tasks);
    }

    @NotNull
    public AbiFiltersSpec getFilters() {
        return this.filters;
    }

    @NotNull
    public AbiValidationLegacyDumpExtension getLegacyDump() {
        return this.legacyDump;
    }

    @NotNull
    public String getName() {
        return this.variantName;
    }

    @ExperimentalAbiValidation
    public void filters(@NotNull Action<AbiFiltersSpec> action2) {
        AbiValidationVariantSpec.DefaultImpls.filters((AbiValidationVariantSpec)this, action2);
    }

    @ExperimentalAbiValidation
    public void legacyDump(@NotNull Action<AbiValidationLegacyDumpExtension> action2) {
        AbiValidationVariantSpec.DefaultImpls.legacyDump((AbiValidationVariantSpec)this, action2);
    }
}

