/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.atomic.AtomicLongArray;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.BigArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Hash;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteBigArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongComparator;

public final class LongBigArrays {
    public static final long[][] EMPTY_BIG_ARRAY = new long[0][];
    public static final long[][] DEFAULT_EMPTY_BIG_ARRAY = new long[0][];
    public static final AtomicLongArray[] EMPTY_BIG_ATOMIC_ARRAY = new AtomicLongArray[0];
    public static final Hash.Strategy HASH_STRATEGY = new BigArrayHashStrategy();
    private static final int QUICKSORT_NO_REC = 7;
    private static final int PARALLEL_QUICKSORT_NO_FORK = 8192;
    private static final int MEDIUM = 40;
    private static final int DIGIT_BITS = 8;
    private static final int DIGIT_MASK = 255;
    private static final int DIGITS_PER_ELEMENT = 8;
    private static final int RADIXSORT_NO_REC = 1024;

    private LongBigArrays() {
    }

    @Deprecated
    public static long get(long[][] array2, long index) {
        return array2[BigArrays.segment(index)][BigArrays.displacement(index)];
    }

    @Deprecated
    public static void set(long[][] array2, long index, long value2) {
        array2[BigArrays.segment((long)index)][BigArrays.displacement((long)index)] = value2;
    }

    @Deprecated
    public static void swap(long[][] array2, long first, long second) {
        long t = array2[BigArrays.segment(first)][BigArrays.displacement(first)];
        array2[BigArrays.segment((long)first)][BigArrays.displacement((long)first)] = array2[BigArrays.segment(second)][BigArrays.displacement(second)];
        array2[BigArrays.segment((long)second)][BigArrays.displacement((long)second)] = t;
    }

    @Deprecated
    public static void add(long[][] array2, long index, long incr) {
        long[] lArray = array2[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        lArray[n] = lArray[n] + incr;
    }

    @Deprecated
    public static void mul(long[][] array2, long index, long factor) {
        long[] lArray = array2[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        lArray[n] = lArray[n] * factor;
    }

    @Deprecated
    public static void incr(long[][] array2, long index) {
        long[] lArray = array2[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        lArray[n] = lArray[n] + 1L;
    }

    @Deprecated
    public static void decr(long[][] array2, long index) {
        long[] lArray = array2[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        lArray[n] = lArray[n] - 1L;
    }

    @Deprecated
    public static long length(long[][] array2) {
        int length = array2.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array2[length - 1].length;
    }

    @Deprecated
    public static void copy(long[][] srcArray, long srcPos, long[][] destArray, long destPos, long length) {
        BigArrays.copy(srcArray, srcPos, destArray, destPos, length);
    }

    @Deprecated
    public static void copyFromBig(long[][] srcArray, long srcPos, long[] destArray, int destPos, int length) {
        BigArrays.copyFromBig(srcArray, srcPos, destArray, destPos, length);
    }

    @Deprecated
    public static void copyToBig(long[] srcArray, int srcPos, long[][] destArray, long destPos, long length) {
        BigArrays.copyToBig(srcArray, srcPos, destArray, destPos, length);
    }

    public static long[][] newBigArray(long length) {
        if (length == 0L) {
            return EMPTY_BIG_ARRAY;
        }
        BigArrays.ensureLength(length);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        long[][] base = new long[baseLength][];
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i2 = 0; i2 < baseLength - 1; ++i2) {
                base[i2] = new long[0x8000000];
            }
            base[baseLength - 1] = new long[residual];
        } else {
            for (int i3 = 0; i3 < baseLength; ++i3) {
                base[i3] = new long[0x8000000];
            }
        }
        return base;
    }

    public static AtomicLongArray[] newBigAtomicArray(long length) {
        if (length == 0L) {
            return EMPTY_BIG_ATOMIC_ARRAY;
        }
        BigArrays.ensureLength(length);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        AtomicLongArray[] base = new AtomicLongArray[baseLength];
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i2 = 0; i2 < baseLength - 1; ++i2) {
                base[i2] = new AtomicLongArray(0x8000000);
            }
            base[baseLength - 1] = new AtomicLongArray(residual);
        } else {
            for (int i3 = 0; i3 < baseLength; ++i3) {
                base[i3] = new AtomicLongArray(0x8000000);
            }
        }
        return base;
    }

    @Deprecated
    public static long[][] wrap(long[] array2) {
        return BigArrays.wrap(array2);
    }

    @Deprecated
    public static long[][] ensureCapacity(long[][] array2, long length) {
        return LongBigArrays.ensureCapacity(array2, length, LongBigArrays.length(array2));
    }

    @Deprecated
    public static long[][] forceCapacity(long[][] array2, long length, long preserve) {
        return BigArrays.forceCapacity(array2, length, preserve);
    }

    @Deprecated
    public static long[][] ensureCapacity(long[][] array2, long length, long preserve) {
        return length > LongBigArrays.length(array2) ? LongBigArrays.forceCapacity(array2, length, preserve) : array2;
    }

    @Deprecated
    public static long[][] grow(long[][] array2, long length) {
        long oldLength = LongBigArrays.length(array2);
        return length > oldLength ? LongBigArrays.grow(array2, length, oldLength) : array2;
    }

    @Deprecated
    public static long[][] grow(long[][] array2, long length, long preserve) {
        long oldLength = LongBigArrays.length(array2);
        return length > oldLength ? LongBigArrays.ensureCapacity(array2, Math.max(oldLength + (oldLength >> 1), length), preserve) : array2;
    }

    @Deprecated
    public static long[][] trim(long[][] array2, long length) {
        BigArrays.ensureLength(length);
        long oldLength = LongBigArrays.length(array2);
        if (length >= oldLength) {
            return array2;
        }
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        long[][] base = (long[][])Arrays.copyOf(array2, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = LongArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    @Deprecated
    public static long[][] setLength(long[][] array2, long length) {
        return BigArrays.setLength(array2, length);
    }

    @Deprecated
    public static long[][] copy(long[][] array2, long offset, long length) {
        return BigArrays.copy(array2, offset, length);
    }

    @Deprecated
    public static long[][] copy(long[][] array2) {
        return BigArrays.copy(array2);
    }

    @Deprecated
    public static void fill(long[][] array2, long value2) {
        int i2 = array2.length;
        while (i2-- != 0) {
            Arrays.fill(array2[i2], value2);
        }
    }

    @Deprecated
    public static void fill(long[][] array2, long from2, long to, long value2) {
        BigArrays.fill(array2, from2, to, value2);
    }

    @Deprecated
    public static boolean equals(long[][] a1, long[][] a2) {
        return BigArrays.equals(a1, a2);
    }

    @Deprecated
    public static String toString(long[][] a) {
        return BigArrays.toString(a);
    }

    @Deprecated
    public static void ensureFromTo(long[][] a, long from2, long to) {
        BigArrays.ensureFromTo(LongBigArrays.length(a), from2, to);
    }

    @Deprecated
    public static void ensureOffsetLength(long[][] a, long offset, long length) {
        BigArrays.ensureOffsetLength(LongBigArrays.length(a), offset, length);
    }

    @Deprecated
    public static void ensureSameLength(long[][] a, long[][] b) {
        if (LongBigArrays.length(a) != LongBigArrays.length(b)) {
            throw new IllegalArgumentException("Array size mismatch: " + LongBigArrays.length(a) + " != " + LongBigArrays.length(b));
        }
    }

    private static ForkJoinPool getPool() {
        ForkJoinPool current2 = ForkJoinTask.getPool();
        return current2 == null ? ForkJoinPool.commonPool() : current2;
    }

    private static void swap(long[][] x, long a, long b, long n) {
        int i2 = 0;
        while ((long)i2 < n) {
            BigArrays.swap(x, a, b);
            ++i2;
            ++a;
            ++b;
        }
    }

    private static long med3(long[][] x, long a, long b, long c, LongComparator comp) {
        int ab = comp.compare(BigArrays.get(x, a), BigArrays.get(x, b));
        int ac = comp.compare(BigArrays.get(x, a), BigArrays.get(x, c));
        int bc = comp.compare(BigArrays.get(x, b), BigArrays.get(x, c));
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(long[][] a, long from2, long to, LongComparator comp) {
        for (long i2 = from2; i2 < to - 1L; ++i2) {
            long m = i2;
            for (long j = i2 + 1L; j < to; ++j) {
                if (comp.compare(BigArrays.get(a, j), BigArrays.get(a, m)) >= 0) continue;
                m = j;
            }
            if (m == i2) continue;
            BigArrays.swap(a, i2, m);
        }
    }

    public static void quickSort(long[][] x, long from2, long to, LongComparator comp) {
        long c;
        long a;
        long len = to - from2;
        if (len < 7L) {
            LongBigArrays.selectionSort(x, from2, to, comp);
            return;
        }
        long m = from2 + len / 2L;
        if (len > 7L) {
            long l = from2;
            long n = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l = LongBigArrays.med3(x, l, l + s, l + 2L * s, comp);
                m = LongBigArrays.med3(x, m - s, m, m + s, comp);
                n = LongBigArrays.med3(x, n - 2L * s, n - s, n, comp);
            }
            m = LongBigArrays.med3(x, l, m, n, comp);
        }
        long v = BigArrays.get(x, m);
        long b = a = from2;
        long d = c = to - 1L;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(BigArrays.get(x, b), v)) <= 0) {
                if (comparison == 0) {
                    BigArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(BigArrays.get(x, c), v)) >= 0) {
                if (comparison == 0) {
                    BigArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            BigArrays.swap(x, b++, c--);
        }
        long n = to;
        long s = Math.min(a - from2, b - a);
        LongBigArrays.swap(x, from2, b - s, s);
        s = Math.min(d - c, n - d - 1L);
        LongBigArrays.swap(x, b, n - s, s);
        s = b - a;
        if (s > 1L) {
            LongBigArrays.quickSort(x, from2, from2 + s, comp);
        }
        if ((s = d - c) > 1L) {
            LongBigArrays.quickSort(x, n - s, n, comp);
        }
    }

    private static long med3(long[][] x, long a, long b, long c) {
        int ab = Long.compare(BigArrays.get(x, a), BigArrays.get(x, b));
        int ac = Long.compare(BigArrays.get(x, a), BigArrays.get(x, c));
        int bc = Long.compare(BigArrays.get(x, b), BigArrays.get(x, c));
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(long[][] a, long from2, long to) {
        for (long i2 = from2; i2 < to - 1L; ++i2) {
            long m = i2;
            for (long j = i2 + 1L; j < to; ++j) {
                if (BigArrays.get(a, j) >= BigArrays.get(a, m)) continue;
                m = j;
            }
            if (m == i2) continue;
            BigArrays.swap(a, i2, m);
        }
    }

    public static void quickSort(long[][] x, LongComparator comp) {
        LongBigArrays.quickSort(x, 0L, BigArrays.length(x), comp);
    }

    public static void quickSort(long[][] x, long from2, long to) {
        long c;
        long a;
        long len = to - from2;
        if (len < 7L) {
            LongBigArrays.selectionSort(x, from2, to);
            return;
        }
        long m = from2 + len / 2L;
        if (len > 7L) {
            long l = from2;
            long n = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l = LongBigArrays.med3(x, l, l + s, l + 2L * s);
                m = LongBigArrays.med3(x, m - s, m, m + s);
                n = LongBigArrays.med3(x, n - 2L * s, n - s, n);
            }
            m = LongBigArrays.med3(x, l, m, n);
        }
        long v = BigArrays.get(x, m);
        long b = a = from2;
        long d = c = to - 1L;
        while (true) {
            int comparison;
            if (b <= c && (comparison = Long.compare(BigArrays.get(x, b), v)) <= 0) {
                if (comparison == 0) {
                    BigArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = Long.compare(BigArrays.get(x, c), v)) >= 0) {
                if (comparison == 0) {
                    BigArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            BigArrays.swap(x, b++, c--);
        }
        long n = to;
        long s = Math.min(a - from2, b - a);
        LongBigArrays.swap(x, from2, b - s, s);
        s = Math.min(d - c, n - d - 1L);
        LongBigArrays.swap(x, b, n - s, s);
        s = b - a;
        if (s > 1L) {
            LongBigArrays.quickSort(x, from2, from2 + s);
        }
        if ((s = d - c) > 1L) {
            LongBigArrays.quickSort(x, n - s, n);
        }
    }

    public static void quickSort(long[][] x) {
        LongBigArrays.quickSort(x, 0L, BigArrays.length(x));
    }

    public static void parallelQuickSort(long[][] x, long from2, long to) {
        ForkJoinPool pool = LongBigArrays.getPool();
        if (to - from2 < 8192L || pool.getParallelism() == 1) {
            LongBigArrays.quickSort(x, from2, to);
        } else {
            pool.invoke(new ForkJoinQuickSort(x, from2, to));
        }
    }

    public static void parallelQuickSort(long[][] x) {
        LongBigArrays.parallelQuickSort(x, 0L, BigArrays.length(x));
    }

    public static void parallelQuickSort(long[][] x, long from2, long to, LongComparator comp) {
        ForkJoinPool pool = LongBigArrays.getPool();
        if (to - from2 < 8192L || pool.getParallelism() == 1) {
            LongBigArrays.quickSort(x, from2, to, comp);
        } else {
            pool.invoke(new ForkJoinQuickSortComp(x, from2, to, comp));
        }
    }

    public static void parallelQuickSort(long[][] x, LongComparator comp) {
        LongBigArrays.parallelQuickSort(x, 0L, BigArrays.length(x), comp);
    }

    public static long binarySearch(long[][] a, long from2, long to, long key) {
        --to;
        while (from2 <= to) {
            long mid = from2 + to >>> 1;
            long midVal = BigArrays.get(a, mid);
            if (midVal < key) {
                from2 = mid + 1L;
                continue;
            }
            if (midVal > key) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from2 + 1L);
    }

    public static long binarySearch(long[][] a, long key) {
        return LongBigArrays.binarySearch(a, 0L, BigArrays.length(a), key);
    }

    public static long binarySearch(long[][] a, long from2, long to, long key, LongComparator c) {
        --to;
        while (from2 <= to) {
            long mid = from2 + to >>> 1;
            long midVal = BigArrays.get(a, mid);
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                from2 = mid + 1L;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from2 + 1L);
    }

    public static long binarySearch(long[][] a, long key, LongComparator c) {
        return LongBigArrays.binarySearch(a, 0L, BigArrays.length(a), key, c);
    }

    public static void radixSort(long[][] a) {
        LongBigArrays.radixSort(a, 0L, BigArrays.length(a));
    }

    public static void radixSort(long[][] a, long from2, long to) {
        int maxLevel = 7;
        int stackSize = 1786;
        long[] offsetStack = new long[1786];
        int offsetPos = 0;
        long[] lengthStack = new long[1786];
        int lengthPos = 0;
        int[] levelStack = new int[1786];
        int levelPos = 0;
        offsetStack[offsetPos++] = from2;
        lengthStack[lengthPos++] = to - from2;
        levelStack[levelPos++] = 0;
        long[] count = new long[256];
        long[] pos = new long[256];
        byte[][] digit = ByteBigArrays.newBigArray(to - from2);
        while (offsetPos > 0) {
            int level;
            int signMask;
            long first = offsetStack[--offsetPos];
            long length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 40L) {
                LongBigArrays.selectionSort(a, first, first + length);
                continue;
            }
            int shift = (7 - level % 8) * 8;
            long i2 = length;
            while (i2-- != 0L) {
                BigArrays.set(digit, i2, (byte)(BigArrays.get(a, first + i2) >>> shift & 0xFFL ^ (long)signMask));
            }
            i2 = length;
            while (i2-- != 0L) {
                int n2 = BigArrays.get(digit, i2) & 0xFF;
                count[n2] = count[n2] + 1L;
            }
            int lastUsed = -1;
            long p = 0L;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count[i3] != 0L) {
                    lastUsed = i3;
                    if (level < 7 && count[i3] > 1L) {
                        offsetStack[offsetPos++] = p + first;
                        lengthStack[lengthPos++] = count[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p += count[i3];
            }
            long end = length - count[lastUsed];
            count[lastUsed] = 0L;
            int c = -1;
            for (long i4 = 0L; i4 < end; i4 += count[c]) {
                long t = BigArrays.get(a, i4 + first);
                c = BigArrays.get(digit, i4) & 0xFF;
                while (true) {
                    int n3 = c;
                    long l = pos[n3] - 1L;
                    pos[n3] = l;
                    long d = l;
                    if (l <= i4) break;
                    long z = t;
                    int zz = c;
                    t = BigArrays.get(a, d + first);
                    c = BigArrays.get(digit, d) & 0xFF;
                    BigArrays.set(a, d + first, z);
                    BigArrays.set(digit, d, (byte)zz);
                }
                BigArrays.set(a, i4 + first, t);
                count[c] = 0L;
            }
        }
    }

    private static void selectionSort(long[][] a, long[][] b, long from2, long to) {
        for (long i2 = from2; i2 < to - 1L; ++i2) {
            long m = i2;
            for (long j = i2 + 1L; j < to; ++j) {
                if (BigArrays.get(a, j) >= BigArrays.get(a, m) && (BigArrays.get(a, j) != BigArrays.get(a, m) || BigArrays.get(b, j) >= BigArrays.get(b, m))) continue;
                m = j;
            }
            if (m == i2) continue;
            long t = BigArrays.get(a, i2);
            BigArrays.set(a, i2, BigArrays.get(a, m));
            BigArrays.set(a, m, t);
            t = BigArrays.get(b, i2);
            BigArrays.set(b, i2, BigArrays.get(b, m));
            BigArrays.set(b, m, t);
        }
    }

    public static void radixSort(long[][] a, long[][] b) {
        LongBigArrays.radixSort(a, b, 0L, BigArrays.length(a));
    }

    public static void radixSort(long[][] a, long[][] b, long from2, long to) {
        int layers = 2;
        if (BigArrays.length(a) != BigArrays.length(b)) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 15;
        int stackSize = 3826;
        long[] offsetStack = new long[3826];
        int offsetPos = 0;
        long[] lengthStack = new long[3826];
        int lengthPos = 0;
        int[] levelStack = new int[3826];
        int levelPos = 0;
        offsetStack[offsetPos++] = from2;
        lengthStack[lengthPos++] = to - from2;
        levelStack[levelPos++] = 0;
        long[] count = new long[256];
        long[] pos = new long[256];
        byte[][] digit = ByteBigArrays.newBigArray(to - from2);
        while (offsetPos > 0) {
            int level;
            int signMask;
            long first = offsetStack[--offsetPos];
            long length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 40L) {
                LongBigArrays.selectionSort(a, b, first, first + length);
                continue;
            }
            long[][] k = level < 8 ? a : b;
            int shift = (7 - level % 8) * 8;
            long i2 = length;
            while (i2-- != 0L) {
                BigArrays.set(digit, i2, (byte)(BigArrays.get(k, first + i2) >>> shift & 0xFFL ^ (long)signMask));
            }
            i2 = length;
            while (i2-- != 0L) {
                int n2 = BigArrays.get(digit, i2) & 0xFF;
                count[n2] = count[n2] + 1L;
            }
            int lastUsed = -1;
            long p = 0L;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count[i3] != 0L) {
                    lastUsed = i3;
                    if (level < 15 && count[i3] > 1L) {
                        offsetStack[offsetPos++] = p + first;
                        lengthStack[lengthPos++] = count[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p += count[i3];
            }
            long end = length - count[lastUsed];
            count[lastUsed] = 0L;
            int c = -1;
            for (long i4 = 0L; i4 < end; i4 += count[c]) {
                long t = BigArrays.get(a, i4 + first);
                long u = BigArrays.get(b, i4 + first);
                c = BigArrays.get(digit, i4) & 0xFF;
                while (true) {
                    int n3 = c;
                    long l = pos[n3] - 1L;
                    pos[n3] = l;
                    long d = l;
                    if (l <= i4) break;
                    long z = t;
                    int zz = c;
                    t = BigArrays.get(a, d + first);
                    BigArrays.set(a, d + first, z);
                    z = u;
                    u = BigArrays.get(b, d + first);
                    BigArrays.set(b, d + first, z);
                    c = BigArrays.get(digit, d) & 0xFF;
                    BigArrays.set(digit, d, (byte)zz);
                }
                BigArrays.set(a, i4 + first, t);
                BigArrays.set(b, i4 + first, u);
                count[c] = 0L;
            }
        }
    }

    private static void insertionSortIndirect(long[][] perm, long[][] a, long[][] b, long from2, long to) {
        long i2 = from2;
        while (++i2 < to) {
            long t = BigArrays.get(perm, i2);
            long j = i2;
            long u = BigArrays.get(perm, j - 1L);
            while (BigArrays.get(a, t) < BigArrays.get(a, u) || BigArrays.get(a, t) == BigArrays.get(a, u) && BigArrays.get(b, t) < BigArrays.get(b, u)) {
                BigArrays.set(perm, j, u);
                if (from2 == j - 1L) {
                    --j;
                    break;
                }
                u = BigArrays.get(perm, --j - 1L);
            }
            BigArrays.set(perm, j, t);
        }
    }

    public static void radixSortIndirect(long[][] perm, long[][] a, long[][] b, boolean stable) {
        LongBigArrays.ensureSameLength(a, b);
        LongBigArrays.radixSortIndirect(perm, a, b, 0L, BigArrays.length(a), stable);
    }

    public static void radixSortIndirect(long[][] perm, long[][] a, long[][] b, long from2, long to, boolean stable) {
        long[][] support;
        if (to - from2 < 1024L) {
            LongBigArrays.insertionSortIndirect(perm, a, b, from2, to);
            return;
        }
        int layers = 2;
        int maxLevel = 15;
        int stackSize = 3826;
        int stackPos = 0;
        long[] offsetStack = new long[3826];
        long[] lengthStack = new long[3826];
        int[] levelStack = new int[3826];
        offsetStack[stackPos] = from2;
        lengthStack[stackPos] = to - from2;
        levelStack[stackPos++] = 0;
        long[] count = new long[256];
        long[] pos = new long[256];
        long[][] lArray = support = stable ? LongBigArrays.newBigArray(BigArrays.length(perm)) : null;
        while (stackPos > 0) {
            long first = offsetStack[--stackPos];
            long length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 8 == 0 ? 128 : 0;
            long[][] k = level < 8 ? a : b;
            int shift = (7 - level % 8) * 8;
            long i2 = first + length;
            while (i2-- != first) {
                int n = (int)(BigArrays.get(k, BigArrays.get(perm, i2)) >>> shift & 0xFFL ^ (long)signMask);
                count[n] = count[n] + 1L;
            }
            int lastUsed = -1;
            long p = stable ? 0L : first;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count[i3] != 0L) {
                    lastUsed = i3;
                }
                pos[i3] = p += count[i3];
            }
            if (stable) {
                long i4 = first + length;
                while (i4-- != first) {
                    int n = (int)(BigArrays.get(k, BigArrays.get(perm, i4)) >>> shift & 0xFFL ^ (long)signMask);
                    long l = pos[n] - 1L;
                    pos[n] = l;
                    BigArrays.set(support, l, BigArrays.get(perm, i4));
                }
                BigArrays.copy(support, 0L, perm, first, length);
                p = first;
                for (int i5 = 0; i5 < 256; ++i5) {
                    if (level < 15 && count[i5] > 1L) {
                        if (count[i5] < 1024L) {
                            LongBigArrays.insertionSortIndirect(perm, a, b, p, p + count[i5]);
                        } else {
                            offsetStack[stackPos] = p;
                            lengthStack[stackPos] = count[i5];
                            levelStack[stackPos++] = level + 1;
                        }
                    }
                    p += count[i5];
                }
                Arrays.fill(count, 0L);
                continue;
            }
            long end = first + length - count[lastUsed];
            int c = -1;
            for (long i6 = first; i6 <= end; i6 += count[c]) {
                long t = BigArrays.get(perm, i6);
                c = (int)(BigArrays.get(k, t) >>> shift & 0xFFL ^ (long)signMask);
                if (i6 < end) {
                    while (true) {
                        int n = c;
                        long l = pos[n] - 1L;
                        pos[n] = l;
                        long d = l;
                        if (l <= i6) break;
                        long z = t;
                        t = BigArrays.get(perm, d);
                        BigArrays.set(perm, d, z);
                        c = (int)(BigArrays.get(k, t) >>> shift & 0xFFL ^ (long)signMask);
                    }
                    BigArrays.set(perm, i6, t);
                }
                if (level < 15 && count[c] > 1L) {
                    if (count[c] < 1024L) {
                        LongBigArrays.insertionSortIndirect(perm, a, b, i6, i6 + count[c]);
                    } else {
                        offsetStack[stackPos] = i6;
                        lengthStack[stackPos] = count[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count[c] = 0L;
            }
        }
    }

    public static long[][] shuffle(long[][] a, long from2, long to, Random random2) {
        return BigArrays.shuffle(a, from2, to, random2);
    }

    public static long[][] shuffle(long[][] a, Random random2) {
        return BigArrays.shuffle(a, random2);
    }

    protected static class ForkJoinQuickSort
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final long from;
        private final long to;
        private final long[][] x;

        public ForkJoinQuickSort(long[][] x, long from2, long to) {
            this.from = from2;
            this.to = to;
            this.x = x;
        }

        @Override
        protected void compute() {
            long c;
            long a;
            long[][] x = this.x;
            long len = this.to - this.from;
            if (len < 8192L) {
                LongBigArrays.quickSort(x, this.from, this.to);
                return;
            }
            long m = this.from + len / 2L;
            long l = this.from;
            long n = this.to - 1L;
            long s = len / 8L;
            l = LongBigArrays.med3(x, l, l + s, l + 2L * s);
            m = LongBigArrays.med3(x, m - s, m, m + s);
            n = LongBigArrays.med3(x, n - 2L * s, n - s, n);
            m = LongBigArrays.med3(x, l, m, n);
            long v = BigArrays.get(x, m);
            long b = a = this.from;
            long d = c = this.to - 1L;
            while (true) {
                int comparison;
                if (b <= c && (comparison = Long.compare(BigArrays.get(x, b), v)) <= 0) {
                    if (comparison == 0) {
                        BigArrays.swap(x, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c >= b && (comparison = Long.compare(BigArrays.get(x, c), v)) >= 0) {
                    if (comparison == 0) {
                        BigArrays.swap(x, c, d--);
                    }
                    --c;
                }
                if (b > c) break;
                BigArrays.swap(x, b++, c--);
            }
            s = Math.min(a - this.from, b - a);
            LongBigArrays.swap(x, this.from, b - s, s);
            s = Math.min(d - c, this.to - d - 1L);
            LongBigArrays.swap(x, b, this.to - s, s);
            s = b - a;
            long t = d - c;
            if (s > 1L && t > 1L) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.from, this.from + s), new ForkJoinQuickSort(x, this.to - t, this.to));
            } else if (s > 1L) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.from, this.from + s));
            } else {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.to - t, this.to));
            }
        }
    }

    protected static class ForkJoinQuickSortComp
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final long from;
        private final long to;
        private final long[][] x;
        private final LongComparator comp;

        public ForkJoinQuickSortComp(long[][] x, long from2, long to, LongComparator comp) {
            this.from = from2;
            this.to = to;
            this.x = x;
            this.comp = comp;
        }

        @Override
        protected void compute() {
            long c;
            long a;
            long[][] x = this.x;
            long len = this.to - this.from;
            if (len < 8192L) {
                LongBigArrays.quickSort(x, this.from, this.to, this.comp);
                return;
            }
            long m = this.from + len / 2L;
            long l = this.from;
            long n = this.to - 1L;
            long s = len / 8L;
            l = LongBigArrays.med3(x, l, l + s, l + 2L * s, this.comp);
            m = LongBigArrays.med3(x, m - s, m, m + s, this.comp);
            n = LongBigArrays.med3(x, n - 2L * s, n - s, n, this.comp);
            m = LongBigArrays.med3(x, l, m, n, this.comp);
            long v = BigArrays.get(x, m);
            long b = a = this.from;
            long d = c = this.to - 1L;
            while (true) {
                int comparison;
                if (b <= c && (comparison = this.comp.compare(BigArrays.get(x, b), v)) <= 0) {
                    if (comparison == 0) {
                        BigArrays.swap(x, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c >= b && (comparison = this.comp.compare(BigArrays.get(x, c), v)) >= 0) {
                    if (comparison == 0) {
                        BigArrays.swap(x, c, d--);
                    }
                    --c;
                }
                if (b > c) break;
                BigArrays.swap(x, b++, c--);
            }
            s = Math.min(a - this.from, b - a);
            LongBigArrays.swap(x, this.from, b - s, s);
            s = Math.min(d - c, this.to - d - 1L);
            LongBigArrays.swap(x, b, this.to - s, s);
            s = b - a;
            long t = d - c;
            if (s > 1L && t > 1L) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.from, this.from + s, this.comp), new ForkJoinQuickSortComp(x, this.to - t, this.to, this.comp));
            } else if (s > 1L) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.from, this.from + s, this.comp));
            } else {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.to - t, this.to, this.comp));
            }
        }
    }

    private static final class BigArrayHashStrategy
    implements Hash.Strategy<long[][]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private BigArrayHashStrategy() {
        }

        @Override
        public int hashCode(long[][] o) {
            return Arrays.deepHashCode((Object[])o);
        }

        @Override
        public boolean equals(long[][] a, long[][] b) {
            return LongBigArrays.equals(a, b);
        }
    }
}

