/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnosticsCollectorKt;
import org.jetbrains.kotlin.gradle.targets.native.internal.NativeDistributionType;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionTypeProvider;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "propertiesProvider", "Lorg/jetbrains/kotlin/gradle/plugin/PropertiesProvider;", "getDistributionType", "Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionType;", "kotlin-gradle-plugin_common"})
public final class NativeDistributionTypeProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final PropertiesProvider propertiesProvider;

    public NativeDistributionTypeProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.propertiesProvider = PropertiesProvider.Companion.invoke(this.project);
    }

    @NotNull
    public final NativeDistributionType getDistributionType() {
        NativeDistributionType nativeDistributionType;
        String type;
        String string2 = this.propertiesProvider.getNativeDistributionType();
        String string3 = type = string2 != null ? CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly(string2) : null;
        if (type == null) {
            nativeDistributionType = NativeDistributionType.PREBUILT;
        } else if (Intrinsics.areEqual((Object)type, (Object)"prebuilt")) {
            nativeDistributionType = NativeDistributionType.PREBUILT;
        } else if (Intrinsics.areEqual((Object)type, (Object)"light")) {
            nativeDistributionType = NativeDistributionType.LIGHT;
        } else {
            KotlinToolingDiagnosticsCollectorKt.reportDiagnosticOncePerBuild$default(this.project, KotlinToolingDiagnostics.UnrecognizedKotlinNativeDistributionType.INSTANCE.invoke(type), null, 2, null);
            nativeDistributionType = NativeDistributionType.PREBUILT;
        }
        return nativeDistributionType;
    }
}

