/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.indexing.impl;

import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.ThrowableComputable;
import org.jetbrains.kotlin.com.intellij.util.ThrowableRunnable;
import org.jetbrains.kotlin.com.intellij.util.indexing.IndexId;
import org.jetbrains.kotlin.com.intellij.util.indexing.StorageException;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.AbstractUpdateData;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.InputDataDiffBuilder;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.RemovedKeyProcessor;

public final class UpdateData<Key, Value>
extends AbstractUpdateData<Key, Value> {
    private final Map<Key, Value> myNewData;
    @NotNull
    private final ThrowableComputable<? extends InputDataDiffBuilder<Key, Value>, IOException> myCurrentDataEvaluator;
    private final IndexId<Key, Value> myIndexId;
    private final ThrowableRunnable<? extends IOException> myForwardIndexUpdate;

    public UpdateData(int inputId, @NotNull Map<Key, Value> newData, @NotNull ThrowableComputable<? extends InputDataDiffBuilder<Key, Value>, IOException> currentDataEvaluator, @NotNull IndexId<Key, Value> indexId, @Nullable ThrowableRunnable<? extends IOException> forwardIndexUpdate) {
        if (newData == null) {
            UpdateData.$$$reportNull$$$0(0);
        }
        if (currentDataEvaluator == null) {
            UpdateData.$$$reportNull$$$0(1);
        }
        if (indexId == null) {
            UpdateData.$$$reportNull$$$0(2);
        }
        super(inputId);
        this.myNewData = newData;
        this.myCurrentDataEvaluator = currentDataEvaluator;
        this.myIndexId = indexId;
        this.myForwardIndexUpdate = forwardIndexUpdate;
    }

    @Override
    protected boolean iterateKeys(@NotNull KeyValueUpdateProcessor<? super Key, ? super Value> addProcessor, @NotNull KeyValueUpdateProcessor<? super Key, ? super Value> updateProcessor, @NotNull RemovedKeyProcessor<? super Key> removeProcessor) throws StorageException {
        InputDataDiffBuilder<? super Key, ? super Value> currentData;
        if (addProcessor == null) {
            UpdateData.$$$reportNull$$$0(3);
        }
        if (updateProcessor == null) {
            UpdateData.$$$reportNull$$$0(4);
        }
        if (removeProcessor == null) {
            UpdateData.$$$reportNull$$$0(5);
        }
        try {
            currentData = this.myCurrentDataEvaluator.compute();
        }
        catch (IOException e) {
            throw new StorageException("Error while applying " + this, e);
        }
        return currentData.differentiate(this.myNewData, addProcessor, updateProcessor, removeProcessor);
    }

    @Override
    protected void updateForwardIndex() throws IOException {
        if (this.myForwardIndexUpdate != null) {
            this.myForwardIndexUpdate.run();
        }
    }

    public String toString() {
        return "update data for " + this.getInputId() + " of " + this.myIndexId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentDataEvaluator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removeProcessor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/indexing/impl/UpdateData";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "iterateKeys";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

