/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.indexing.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.indexing.impl.ValueContainerImpl;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Pair;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

final class FileId2ValueMapping<Value> {
    @NotNull
    private final Int2ObjectMap<Value> id2ValueMap;
    @NotNull
    private final ValueContainerImpl<Value> valueContainer;

    FileId2ValueMapping(@NotNull ValueContainerImpl<Value> valueContainer) {
        if (valueContainer == null) {
            FileId2ValueMapping.$$$reportNull$$$0(0);
        }
        this.id2ValueMap = new Int2ObjectOpenHashMap<Value>();
        this.valueContainer = valueContainer;
        SmartList cleanupDeletions = new SmartList();
        valueContainer.forEach((id, value2) -> {
            Object previousValue = this.associateFileIdToValueSkippingContainer(id, value2);
            if (previousValue != null) {
                cleanupDeletions.add(Pair.of(previousValue, id));
            }
            return true;
        });
        for (Pair deletion : cleanupDeletions) {
            valueContainer.removeValue((Integer)deletion.second(), ValueContainerImpl.unwrap(deletion.first()));
        }
    }

    void associateFileIdToValue(int fileId, Value value2) {
        Value previousValue = this.associateFileIdToValueSkippingContainer(fileId, value2);
        if (previousValue != null) {
            this.valueContainer.removeValue(fileId, ValueContainerImpl.unwrap(previousValue));
        }
        this.valueContainer.addValue(fileId, value2);
    }

    Value associateFileIdToValueSkippingContainer(int fileId, Value value2) {
        return this.id2ValueMap.put(fileId, ValueContainerImpl.wrapValue(value2));
    }

    boolean removeFileId(int inputId) {
        Object mapped = this.id2ValueMap.remove(inputId);
        if (mapped != null) {
            this.valueContainer.removeValue(inputId, ValueContainerImpl.unwrap(mapped));
        }
        return mapped != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueContainer", "org/jetbrains/kotlin/com/intellij/util/indexing/impl/FileId2ValueMapping", "<init>"));
    }
}

