/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.io;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;

public final class JarUtil {
    private static final Logger LOG = Logger.getInstance(JarUtil.class);

    public static boolean containsClass(@NotNull String jarPath, @NotNull String className) {
        if (jarPath == null) {
            JarUtil.$$$reportNull$$$0(0);
        }
        if (className == null) {
            JarUtil.$$$reportNull$$$0(1);
        }
        return JarUtil.containsClass(new File(jarPath), className);
    }

    public static boolean containsClass(@NotNull File file2, String className) {
        if (file2 == null) {
            JarUtil.$$$reportNull$$$0(2);
        }
        String entryPath = className.replace('.', '/') + ".class";
        return JarUtil.containsEntry(file2, entryPath);
    }

    public static boolean containsEntry(File file2, String entryPath) {
        if (file2.canRead()) {
            boolean bl;
            JarFile jarFile = new JarFile(file2);
            try {
                bl = jarFile.getEntry(entryPath) != null;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            jarFile.close();
            return bl;
        }
        return false;
    }

    @Nullable
    public static String getJarAttribute(@NotNull File file2, @NotNull Attributes.Name attribute) {
        if (file2 == null) {
            JarUtil.$$$reportNull$$$0(3);
        }
        if (attribute == null) {
            JarUtil.$$$reportNull$$$0(4);
        }
        return JarUtil.getJarAttributeImpl(file2, null, attribute);
    }

    @Nullable
    public static String getJarAttribute(@NotNull File file2, @NotNull String entryName, @NotNull Attributes.Name attribute) {
        if (file2 == null) {
            JarUtil.$$$reportNull$$$0(5);
        }
        if (entryName == null) {
            JarUtil.$$$reportNull$$$0(6);
        }
        if (attribute == null) {
            JarUtil.$$$reportNull$$$0(7);
        }
        return JarUtil.getJarAttributeImpl(file2, entryName, attribute);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getJarAttributeImpl(@NotNull File file2, @Nullable String entryName, @NotNull Attributes.Name attribute) {
        if (file2 == null) {
            JarUtil.$$$reportNull$$$0(8);
        }
        if (attribute == null) {
            JarUtil.$$$reportNull$$$0(9);
        }
        if (!file2.canRead()) return null;
        try (JarFile jarFile = new JarFile(file2);){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) return null;
            Attributes attributes2 = entryName != null ? manifest.getAttributes(entryName) : manifest.getMainAttributes();
            String string2 = attributes2.getValue(attribute);
            return string2;
        }
        catch (IOException e) {
            LOG.debug(e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Properties loadProperties(@NotNull File file2, @NotNull String entryName) {
        if (file2 == null) {
            JarUtil.$$$reportNull$$$0(10);
        }
        if (entryName == null) {
            JarUtil.$$$reportNull$$$0(11);
        }
        if (!file2.canRead()) return null;
        try (ZipFile zipFile = new ZipFile(file2);){
            ZipEntry entry2 = zipFile.getEntry(entryName);
            if (entry2 == null) return null;
            Properties properties2 = new Properties();
            properties2.load(zipFile.getInputStream(entry2));
            Properties properties3 = properties2;
            return properties3;
        }
        catch (IOException e) {
            LOG.debug(e);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/io/JarUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "containsClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getJarAttribute";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getJarAttributeImpl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "loadProperties";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

