/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MutualMap<Key, Value> {
    private final Map<Key, Value> myKey2Value;
    private final Map<Value, Key> myValue2Key;

    public MutualMap(boolean ordered) {
        if (ordered) {
            this.myKey2Value = new LinkedHashMap<Key, Value>();
            this.myValue2Key = new LinkedHashMap<Value, Key>();
        } else {
            this.myKey2Value = new HashMap<Key, Value>();
            this.myValue2Key = new HashMap<Value, Key>();
        }
    }

    public MutualMap() {
        this(false);
    }

    public void put(Key key, Value value2) {
        this.myKey2Value.put(key, value2);
        this.myValue2Key.put(value2, key);
    }

    public Value getValue(Key key) {
        return this.myKey2Value.get(key);
    }

    public Key getKey(Value value2) {
        return this.myValue2Key.get(value2);
    }

    public int size() {
        return this.myValue2Key.size();
    }

    public boolean containsKey(Key key) {
        return this.myKey2Value.containsKey(key);
    }

    public void remove(Key key) {
        Value value2 = this.myKey2Value.get(key);
        this.myKey2Value.remove(key);
        this.myValue2Key.remove(value2);
    }

    public Collection<Value> getValues() {
        return this.myKey2Value.values();
    }

    public Collection<Key> getKeys() {
        return this.myKey2Value.keySet();
    }

    public void clear() {
        this.myKey2Value.clear();
        this.myValue2Key.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutualMap mutualMap = (MutualMap)o;
        return this.myKey2Value.equals(mutualMap.myKey2Value) && this.myValue2Key.equals(mutualMap.myValue2Key);
    }

    public int hashCode() {
        return 31 * this.myKey2Value.hashCode() + this.myValue2Key.hashCode();
    }

    public String toString() {
        return this.myKey2Value.toString();
    }
}

