/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.primitives;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import javax.annotation.CheckForNull;
import org.jetbrains.kotlin.com.google.common.annotations.GwtCompatible;
import org.jetbrains.kotlin.com.google.common.base.Converter;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.primitives.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.errorprone.annotations.InlineMe;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Longs {
    public static final int BYTES = 8;
    public static final long MAX_POWER_OF_TWO = 0x4000000000000000L;

    private Longs() {
    }

    public static int hashCode(long value2) {
        return (int)(value2 ^ value2 >>> 32);
    }

    @InlineMe(replacement="Long.compare(a, b)")
    public static int compare(long a, long b) {
        return Long.compare(a, b);
    }

    public static boolean contains(long[] array2, long target2) {
        for (long value2 : array2) {
            if (value2 != target2) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(long[] array2, long target2) {
        return Longs.indexOf(array2, target2, 0, array2.length);
    }

    private static int indexOf(long[] array2, long target2, int start2, int end) {
        for (int i2 = start2; i2 < end; ++i2) {
            if (array2[i2] != target2) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(long[] array2, long[] target2) {
        Preconditions.checkNotNull(array2, "array");
        Preconditions.checkNotNull(target2, "target");
        if (target2.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < array2.length - target2.length + 1; ++i2) {
            for (int j = 0; j < target2.length; ++j) {
                if (array2[i2 + j] != target2[j]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(long[] array2, long target2) {
        return Longs.lastIndexOf(array2, target2, 0, array2.length);
    }

    private static int lastIndexOf(long[] array2, long target2, int start2, int end) {
        for (int i2 = end - 1; i2 >= start2; --i2) {
            if (array2[i2] != target2) continue;
            return i2;
        }
        return -1;
    }

    public static long min(long ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        long min = array2[0];
        for (int i2 = 1; i2 < array2.length; ++i2) {
            if (array2[i2] >= min) continue;
            min = array2[i2];
        }
        return min;
    }

    public static long max(long ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        long max = array2[0];
        for (int i2 = 1; i2 < array2.length; ++i2) {
            if (array2[i2] <= max) continue;
            max = array2[i2];
        }
        return max;
    }

    public static long constrainToRange(long value2, long min, long max) {
        Preconditions.checkArgument(min <= max, "min (%s) must be less than or equal to max (%s)", min, max);
        return Math.min(Math.max(value2, min), max);
    }

    public static long[] concat(long[] ... arrays) {
        long length = 0L;
        for (long[] array2 : arrays) {
            length += (long)array2.length;
        }
        long[] result2 = new long[Longs.checkNoOverflow(length)];
        int pos = 0;
        for (long[] array3 : arrays) {
            System.arraycopy(array3, 0, result2, pos, array3.length);
            pos += array3.length;
        }
        return result2;
    }

    private static int checkNoOverflow(long result2) {
        Preconditions.checkArgument(result2 == (long)((int)result2), "the total number of elements (%s) in the arrays must fit in an int", result2);
        return (int)result2;
    }

    public static byte[] toByteArray(long value2) {
        byte[] result2 = new byte[8];
        for (int i2 = 7; i2 >= 0; --i2) {
            result2[i2] = (byte)(value2 & 0xFFL);
            value2 >>= 8;
        }
        return result2;
    }

    public static long fromByteArray(byte[] bytes) {
        Preconditions.checkArgument(bytes.length >= 8, "array too small: %s < %s", bytes.length, 8);
        return Longs.fromBytes(bytes[0], bytes[1], bytes[2], bytes[3], bytes[4], bytes[5], bytes[6], bytes[7]);
    }

    public static long fromBytes(byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7, byte b8) {
        return ((long)b1 & 0xFFL) << 56 | ((long)b2 & 0xFFL) << 48 | ((long)b3 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b5 & 0xFFL) << 24 | ((long)b6 & 0xFFL) << 16 | ((long)b7 & 0xFFL) << 8 | (long)b8 & 0xFFL;
    }

    @CheckForNull
    public static Long tryParse(String string2) {
        return Longs.tryParse(string2, 10);
    }

    @CheckForNull
    public static Long tryParse(String string2, int radix) {
        int digit;
        int index;
        if (Preconditions.checkNotNull(string2).isEmpty()) {
            return null;
        }
        if (radix < 2 || radix > 36) {
            throw new IllegalArgumentException("radix must be between MIN_RADIX and MAX_RADIX but was " + radix);
        }
        boolean negative = string2.charAt(0) == '-';
        int n = index = negative ? 1 : 0;
        if (index == string2.length()) {
            return null;
        }
        if ((digit = AsciiDigits.digit(string2.charAt(index++))) < 0 || digit >= radix) {
            return null;
        }
        long accum = -digit;
        long cap = Long.MIN_VALUE / (long)radix;
        while (index < string2.length()) {
            if ((digit = AsciiDigits.digit(string2.charAt(index++))) < 0 || digit >= radix || accum < cap) {
                return null;
            }
            if ((accum *= (long)radix) < Long.MIN_VALUE + (long)digit) {
                return null;
            }
            accum -= (long)digit;
        }
        if (negative) {
            return accum;
        }
        if (accum == Long.MIN_VALUE) {
            return null;
        }
        return -accum;
    }

    public static Converter<String, Long> stringConverter() {
        return LongConverter.INSTANCE;
    }

    public static long[] ensureCapacity(long[] array2, int minLength, int padding) {
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        return array2.length < minLength ? Arrays.copyOf(array2, minLength + padding) : array2;
    }

    public static String join(String separator, long ... array2) {
        Preconditions.checkNotNull(separator);
        if (array2.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array2.length * 10);
        builder.append(array2[0]);
        for (int i2 = 1; i2 < array2.length; ++i2) {
            builder.append(separator).append(array2[i2]);
        }
        return builder.toString();
    }

    public static Comparator<long[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(long[] array2) {
        Preconditions.checkNotNull(array2);
        Longs.sortDescending(array2, 0, array2.length);
    }

    public static void sortDescending(long[] array2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        Arrays.sort(array2, fromIndex, toIndex);
        Longs.reverse(array2, fromIndex, toIndex);
    }

    public static void reverse(long[] array2) {
        Preconditions.checkNotNull(array2);
        Longs.reverse(array2, 0, array2.length);
    }

    public static void reverse(long[] array2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        int i2 = fromIndex;
        for (int j = toIndex - 1; i2 < j; ++i2, --j) {
            long tmp = array2[i2];
            array2[i2] = array2[j];
            array2[j] = tmp;
        }
    }

    public static void rotate(long[] array2, int distance) {
        Longs.rotate(array2, distance, 0, array2.length);
    }

    public static void rotate(long[] array2, int distance, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        if (array2.length <= 1) {
            return;
        }
        int length = toIndex - fromIndex;
        int m = -distance % length;
        m = m < 0 ? m + length : m;
        int newFirstIndex = m + fromIndex;
        if (newFirstIndex == fromIndex) {
            return;
        }
        Longs.reverse(array2, fromIndex, newFirstIndex);
        Longs.reverse(array2, newFirstIndex, toIndex);
        Longs.reverse(array2, fromIndex, toIndex);
    }

    public static long[] toArray(Collection<? extends Number> collection) {
        if (collection instanceof LongArrayAsList) {
            return ((LongArrayAsList)collection).toLongArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        long[] array2 = new long[len];
        for (int i2 = 0; i2 < len; ++i2) {
            array2[i2] = ((Number)Preconditions.checkNotNull(boxedArray[i2])).longValue();
        }
        return array2;
    }

    public static List<Long> asList(long ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new LongArrayAsList(backingArray);
    }

    static final class AsciiDigits {
        private static final byte[] asciiDigits;

        private AsciiDigits() {
        }

        static int digit(char c) {
            return c < '\u0080' ? asciiDigits[c] : -1;
        }

        static {
            int i2;
            byte[] result2 = new byte[128];
            Arrays.fill(result2, (byte)-1);
            for (i2 = 0; i2 < 10; ++i2) {
                result2[48 + i2] = (byte)i2;
            }
            for (i2 = 0; i2 < 26; ++i2) {
                result2[65 + i2] = (byte)(10 + i2);
                result2[97 + i2] = (byte)(10 + i2);
            }
            asciiDigits = result2;
        }
    }

    private static final class LongConverter
    extends Converter<String, Long>
    implements Serializable {
        static final Converter<String, Long> INSTANCE = new LongConverter();
        private static final long serialVersionUID = 1L;

        private LongConverter() {
        }

        @Override
        protected Long doForward(String value2) {
            return Long.decode(value2);
        }

        @Override
        protected String doBackward(Long value2) {
            return value2.toString();
        }

        public String toString() {
            return "Longs.stringConverter()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static enum LexicographicalComparator implements Comparator<long[]>
    {
        INSTANCE;


        @Override
        public int compare(long[] left, long[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i2 = 0; i2 < minLength; ++i2) {
                int result2 = Long.compare(left[i2], right[i2]);
                if (result2 == 0) continue;
                return result2;
            }
            return left.length - right.length;
        }

        public String toString() {
            return "Longs.lexicographicalComparator()";
        }
    }

    @GwtCompatible
    private static class LongArrayAsList
    extends AbstractList<Long>
    implements RandomAccess,
    Serializable {
        final long[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        LongArrayAsList(long[] array2) {
            this(array2, 0, array2.length);
        }

        LongArrayAsList(long[] array2, int start2, int end) {
            this.array = array2;
            this.start = start2;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Long get(int index) {
            Preconditions.checkElementIndex(index, this.size());
            return this.array[this.start + index];
        }

        public Spliterator.OfLong spliterator() {
            return Spliterators.spliterator(this.array, this.start, this.end, 0);
        }

        @Override
        public boolean contains(@CheckForNull Object target2) {
            return target2 instanceof Long && Longs.indexOf(this.array, (Long)target2, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(@CheckForNull Object target2) {
            int i2;
            if (target2 instanceof Long && (i2 = Longs.indexOf(this.array, (Long)target2, this.start, this.end)) >= 0) {
                return i2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(@CheckForNull Object target2) {
            int i2;
            if (target2 instanceof Long && (i2 = Longs.lastIndexOf(this.array, (Long)target2, this.start, this.end)) >= 0) {
                return i2 - this.start;
            }
            return -1;
        }

        @Override
        public Long set(int index, Long element) {
            Preconditions.checkElementIndex(index, this.size());
            long oldValue = this.array[this.start + index];
            this.array[this.start + index] = Preconditions.checkNotNull(element);
            return oldValue;
        }

        @Override
        public List<Long> subList(int fromIndex, int toIndex) {
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, size);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new LongArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public boolean equals(@CheckForNull Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof LongArrayAsList) {
                LongArrayAsList that = (LongArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i2 = 0; i2 < size; ++i2) {
                    if (this.array[this.start + i2] == that.array[that.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int result2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                result2 = 31 * result2 + Longs.hashCode(this.array[i2]);
            }
            return result2;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 10);
            builder.append('[').append(this.array[this.start]);
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                builder.append(", ").append(this.array[i2]);
            }
            return builder.append(']').toString();
        }

        long[] toLongArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }
}

