/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.gradle.internal.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.gradle.internal.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.gradle.internal.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.gradle.internal.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.gradle.internal.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.gradle.internal.types.AnnotationsTypeAttributeKt;
import org.jetbrains.kotlin.gradle.internal.types.DynamicType;
import org.jetbrains.kotlin.gradle.internal.types.DynamicTypesKt;
import org.jetbrains.kotlin.gradle.internal.types.KotlinType;
import org.jetbrains.kotlin.gradle.internal.types.KotlinTypeFactory;
import org.jetbrains.kotlin.gradle.internal.types.KotlinTypeKt;
import org.jetbrains.kotlin.gradle.internal.types.SimpleType;
import org.jetbrains.kotlin.gradle.internal.types.SpecialTypesKt;
import org.jetbrains.kotlin.gradle.internal.types.TypeAliasExpansion;
import org.jetbrains.kotlin.gradle.internal.types.TypeAliasExpansionReportStrategy;
import org.jetbrains.kotlin.gradle.internal.types.TypeAttributes;
import org.jetbrains.kotlin.gradle.internal.types.TypeConstructor;
import org.jetbrains.kotlin.gradle.internal.types.TypeProjection;
import org.jetbrains.kotlin.gradle.internal.types.TypeProjectionImpl;
import org.jetbrains.kotlin.gradle.internal.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.gradle.internal.types.TypeSubstitutor;
import org.jetbrains.kotlin.gradle.internal.types.TypeUtils;
import org.jetbrains.kotlin.gradle.internal.types.UnwrappedType;
import org.jetbrains.kotlin.gradle.internal.types.Variance;
import org.jetbrains.kotlin.gradle.internal.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.gradle.internal.types.error.ErrorUtils;
import org.jetbrains.kotlin.gradle.internal.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 -2\u00020\u0001:\u0001-B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ0\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u001c\u0010\u0014\u001a\u00020\t*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J*\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u001a\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\rH\u0002J\u0014\u0010\u001a\u001a\u00020\t*\u00020\t2\u0006\u0010\u001c\u001a\u00020\rH\u0002J\u0014\u0010\u001d\u001a\u00020\r*\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\rH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002J\u0014\u0010$\u001a\u00020\t*\u00020\t2\u0006\u0010%\u001a\u00020\u001eH\u0002J\u0014\u0010&\u001a\u00020\t*\u00020\t2\u0006\u0010%\u001a\u00020\u001eH\u0002J \u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001c\u0010)\u001a\u00020\t*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/gradle/internal/types/TypeAliasExpander;", "", "reportStrategy", "Lorg/jetbrains/kotlin/gradle/internal/types/TypeAliasExpansionReportStrategy;", "shouldCheckBounds", "", "<init>", "(Lorg/jetbrains/kotlin/types/TypeAliasExpansionReportStrategy;Z)V", "expand", "Lorg/jetbrains/kotlin/gradle/internal/types/SimpleType;", "typeAliasExpansion", "Lorg/jetbrains/kotlin/gradle/internal/types/TypeAliasExpansion;", "attributes", "Lorg/jetbrains/kotlin/gradle/internal/types/TypeAttributes;", "expandWithoutAbbreviation", "expandRecursively", "isNullable", "recursionDepth", "", "withAbbreviatedType", "createAbbreviation", "expandTypeProjection", "Lorg/jetbrains/kotlin/gradle/internal/types/TypeProjection;", "underlyingProjection", "typeParameterDescriptor", "Lorg/jetbrains/kotlin/gradle/internal/descriptors/TypeParameterDescriptor;", "combineAttributes", "Lorg/jetbrains/kotlin/gradle/internal/types/DynamicType;", "newAttributes", "createdCombinedAttributes", "Lorg/jetbrains/kotlin/gradle/internal/types/KotlinType;", "checkRepeatedAnnotations", "", "existingAnnotations", "Lorg/jetbrains/kotlin/gradle/internal/descriptors/annotations/Annotations;", "newAnnotations", "combineNullability", "fromType", "combineNullabilityAndAnnotations", "expandNonArgumentTypeProjection", "originalProjection", "substituteArguments", "checkTypeArgumentsSubstitution", "unsubstitutedType", "substitutedType", "Companion", "descriptors"})
@SourceDebugExtension(value={"SMAP\nTypeAliasExpander.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeAliasExpander.kt\norg/jetbrains/kotlin/types/TypeAliasExpander\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,278:1\n1#2:279\n1628#3,3:280\n1567#3:283\n1598#3,4:284\n1567#3:288\n1598#3,4:289\n1872#3,3:293\n*S KotlinDebug\n*F\n+ 1 TypeAliasExpander.kt\norg/jetbrains/kotlin/types/TypeAliasExpander\n*L\n148#1:280,3\n197#1:283\n197#1:284,4\n232#1:288\n232#1:289,4\n249#1:293,3\n*E\n"})
public final class TypeAliasExpander {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TypeAliasExpansionReportStrategy reportStrategy;
    private final boolean shouldCheckBounds;
    private static final int MAX_RECURSION_DEPTH = 100;
    @NotNull
    private static final TypeAliasExpander NON_REPORTING = new TypeAliasExpander(TypeAliasExpansionReportStrategy.DO_NOTHING.INSTANCE, false);

    public TypeAliasExpander(@NotNull TypeAliasExpansionReportStrategy reportStrategy, boolean shouldCheckBounds) {
        Intrinsics.checkNotNullParameter((Object)reportStrategy, (String)"reportStrategy");
        this.reportStrategy = reportStrategy;
        this.shouldCheckBounds = shouldCheckBounds;
    }

    @NotNull
    public final SimpleType expand(@NotNull TypeAliasExpansion typeAliasExpansion, @NotNull TypeAttributes attributes2) {
        Intrinsics.checkNotNullParameter((Object)typeAliasExpansion, (String)"typeAliasExpansion");
        Intrinsics.checkNotNullParameter((Object)attributes2, (String)"attributes");
        return this.expandRecursively(typeAliasExpansion, attributes2, false, 0, true);
    }

    @NotNull
    public final SimpleType expandWithoutAbbreviation(@NotNull TypeAliasExpansion typeAliasExpansion, @NotNull TypeAttributes attributes2) {
        Intrinsics.checkNotNullParameter((Object)typeAliasExpansion, (String)"typeAliasExpansion");
        Intrinsics.checkNotNullParameter((Object)attributes2, (String)"attributes");
        return this.expandRecursively(typeAliasExpansion, attributes2, false, 0, false);
    }

    private final SimpleType expandRecursively(TypeAliasExpansion typeAliasExpansion, TypeAttributes attributes2, boolean isNullable, int recursionDepth, boolean withAbbreviatedType) {
        boolean bl;
        TypeProjectionImpl underlyingProjection = new TypeProjectionImpl(Variance.INVARIANT, typeAliasExpansion.getDescriptor().getUnderlyingType());
        TypeProjection expandedProjection = this.expandTypeProjection(underlyingProjection, typeAliasExpansion, null, recursionDepth);
        KotlinType kotlinType = expandedProjection.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        SimpleType expandedType = TypeSubstitutionKt.asSimpleType(kotlinType);
        if (KotlinTypeKt.isError(expandedType)) {
            return expandedType;
        }
        boolean bl2 = bl = expandedProjection.getProjectionKind() == Variance.INVARIANT;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Type alias expansion: result for " + typeAliasExpansion.getDescriptor() + " is " + (Object)((Object)expandedProjection.getProjectionKind()) + ", should be invariant";
            throw new AssertionError((Object)string2);
        }
        this.checkRepeatedAnnotations(expandedType.getAnnotations(), AnnotationsTypeAttributeKt.getAnnotations(attributes2));
        SimpleType it = this.combineAttributes(expandedType, attributes2);
        boolean bl4 = false;
        SimpleType simpleType = TypeUtils.makeNullableIfNeeded(it, isNullable);
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"let(...)");
        SimpleType expandedTypeWithExtraAnnotations = simpleType;
        return withAbbreviatedType ? SpecialTypesKt.withAbbreviation(expandedTypeWithExtraAnnotations, this.createAbbreviation(typeAliasExpansion, attributes2, isNullable)) : expandedTypeWithExtraAnnotations;
    }

    private final SimpleType createAbbreviation(TypeAliasExpansion $this$createAbbreviation, TypeAttributes attributes2, boolean isNullable) {
        TypeConstructor typeConstructor2 = $this$createAbbreviation.getDescriptor().getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"getTypeConstructor(...)");
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(attributes2, typeConstructor2, $this$createAbbreviation.getArguments(), isNullable, MemberScope.Empty.INSTANCE);
    }

    private final TypeProjection expandTypeProjection(TypeProjection underlyingProjection, TypeAliasExpansion typeAliasExpansion, TypeParameterDescriptor typeParameterDescriptor, int recursionDepth) {
        Variance variance;
        Object object;
        Variance substitutionVariance;
        Variance variance2;
        TypeAliasExpander.Companion.assertRecursionDepth(recursionDepth, typeAliasExpansion.getDescriptor());
        if (underlyingProjection.isStarProjection()) {
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
            Intrinsics.checkNotNull((Object)typeParameterDescriptor2);
            TypeProjection typeProjection = TypeUtils.makeStarProjection(typeParameterDescriptor2);
            Intrinsics.checkNotNullExpressionValue((Object)typeProjection, (String)"makeStarProjection(...)");
            return typeProjection;
        }
        KotlinType kotlinType = underlyingProjection.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        KotlinType underlyingType = kotlinType;
        TypeProjection typeProjection = typeAliasExpansion.getReplacement(underlyingType.getConstructor());
        if (typeProjection == null) {
            return this.expandNonArgumentTypeProjection(underlyingProjection, typeAliasExpansion, recursionDepth);
        }
        TypeProjection argument = typeProjection;
        if (argument.isStarProjection()) {
            TypeParameterDescriptor typeParameterDescriptor3 = typeParameterDescriptor;
            Intrinsics.checkNotNull((Object)typeParameterDescriptor3);
            TypeProjection typeProjection2 = TypeUtils.makeStarProjection(typeParameterDescriptor3);
            Intrinsics.checkNotNullExpressionValue((Object)typeProjection2, (String)"makeStarProjection(...)");
            return typeProjection2;
        }
        UnwrappedType argumentType = argument.getType().unwrap();
        TypeAliasExpander $this$expandTypeProjection_u24lambda_u242 = this;
        boolean bl = false;
        Variance variance3 = argument.getProjectionKind();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)variance3), (String)"getProjectionKind(...)");
        Variance argumentVariance = variance3;
        Variance variance4 = underlyingProjection.getProjectionKind();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)variance4), (String)"getProjectionKind(...)");
        Variance underlyingVariance = variance4;
        if (underlyingVariance == argumentVariance) {
            variance2 = argumentVariance;
        } else if (underlyingVariance == Variance.INVARIANT) {
            variance2 = argumentVariance;
        } else if (argumentVariance == Variance.INVARIANT) {
            variance2 = underlyingVariance;
        } else {
            $this$expandTypeProjection_u24lambda_u242.reportStrategy.conflictingProjection(typeAliasExpansion.getDescriptor(), typeParameterDescriptor, argumentType);
            variance2 = substitutionVariance = argumentVariance;
        }
        if ((object = typeParameterDescriptor) == null || (object = object.getVariance()) == null) {
            object = Variance.INVARIANT;
        }
        Object parameterVariance = object;
        if (parameterVariance == substitutionVariance) {
            variance = substitutionVariance;
        } else if (parameterVariance == Variance.INVARIANT) {
            variance = substitutionVariance;
        } else if (substitutionVariance == Variance.INVARIANT) {
            variance = Variance.INVARIANT;
        } else {
            $this$expandTypeProjection_u24lambda_u242.reportStrategy.conflictingProjection(typeAliasExpansion.getDescriptor(), typeParameterDescriptor, argumentType);
            variance = substitutionVariance;
        }
        Variance resultingVariance = variance;
        this.checkRepeatedAnnotations(underlyingType.getAnnotations(), argumentType.getAnnotations());
        UnwrappedType substitutedType = argumentType instanceof DynamicType ? (UnwrappedType)this.combineAttributes((DynamicType)argumentType, underlyingType.getAttributes()) : (UnwrappedType)this.combineNullabilityAndAnnotations(TypeSubstitutionKt.asSimpleType(argumentType), underlyingType);
        return new TypeProjectionImpl(resultingVariance, substitutedType);
    }

    private final DynamicType combineAttributes(DynamicType $this$combineAttributes, TypeAttributes newAttributes) {
        return $this$combineAttributes.replaceAttributes(this.createdCombinedAttributes($this$combineAttributes, newAttributes));
    }

    private final SimpleType combineAttributes(SimpleType $this$combineAttributes, TypeAttributes newAttributes) {
        return KotlinTypeKt.isError($this$combineAttributes) ? $this$combineAttributes : TypeSubstitutionKt.replace$default($this$combineAttributes, null, this.createdCombinedAttributes($this$combineAttributes, newAttributes), 1, null);
    }

    private final TypeAttributes createdCombinedAttributes(KotlinType $this$createdCombinedAttributes, TypeAttributes newAttributes) {
        if (KotlinTypeKt.isError($this$createdCombinedAttributes)) {
            return $this$createdCombinedAttributes.getAttributes();
        }
        return newAttributes.add($this$createdCombinedAttributes.getAttributes());
    }

    /*
     * WARNING - void declaration
     */
    private final void checkRepeatedAnnotations(Annotations existingAnnotations, Annotations newAnnotations) {
        void destination$iv;
        void $this$mapTo$iv;
        Iterable iterable = existingAnnotations;
        Collection collection = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)item$iv;
            void var11_10 = destination$iv;
            boolean bl = false;
            var11_10.add(it.getFqName());
        }
        HashSet existingAnnotationFqNames = (HashSet)destination$iv;
        for (AnnotationDescriptor annotation : newAnnotations) {
            if (!existingAnnotationFqNames.contains(annotation.getFqName())) continue;
            this.reportStrategy.repeatedAnnotation(annotation);
        }
    }

    private final SimpleType combineNullability(SimpleType $this$combineNullability, KotlinType fromType) {
        SimpleType simpleType = TypeUtils.makeNullableIfNeeded($this$combineNullability, fromType.isMarkedNullable());
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"makeNullableIfNeeded(...)");
        return simpleType;
    }

    private final SimpleType combineNullabilityAndAnnotations(SimpleType $this$combineNullabilityAndAnnotations, KotlinType fromType) {
        return this.combineAttributes(this.combineNullability($this$combineNullabilityAndAnnotations, fromType), fromType.getAttributes());
    }

    /*
     * WARNING - void declaration
     */
    private final TypeProjection expandNonArgumentTypeProjection(TypeProjection originalProjection, TypeAliasExpansion typeAliasExpansion, int recursionDepth) {
        TypeProjection typeProjection;
        boolean bl;
        UnwrappedType originalType = originalProjection.getType().unwrap();
        if (DynamicTypesKt.isDynamic(originalType)) {
            return originalProjection;
        }
        SimpleType type = TypeSubstitutionKt.asSimpleType(originalType);
        if (KotlinTypeKt.isError(type) || !TypeUtilsKt.requiresTypeAliasExpansion(type)) {
            return originalProjection;
        }
        TypeConstructor typeConstructor2 = type.getConstructor();
        ClassifierDescriptor typeDescriptor = typeConstructor2.getDeclarationDescriptor();
        boolean bl2 = bl = typeConstructor2.getParameters().size() == type.getArguments().size();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-TypeAliasExpander$expandNonArgumentTypeProjection$22 = false;
            String $i$a$-assert-TypeAliasExpander$expandNonArgumentTypeProjection$22 = "Unexpected malformed type: " + type;
            throw new AssertionError((Object)$i$a$-assert-TypeAliasExpander$expandNonArgumentTypeProjection$22);
        }
        ClassifierDescriptor classifierDescriptor = typeDescriptor;
        if (classifierDescriptor instanceof TypeParameterDescriptor) {
            typeProjection = originalProjection;
        } else if (classifierDescriptor instanceof TypeAliasDescriptor) {
            void $this$mapIndexedTo$iv$iv;
            if (typeAliasExpansion.isRecursion((TypeAliasDescriptor)typeDescriptor)) {
                this.reportStrategy.recursiveTypeAlias((TypeAliasDescriptor)typeDescriptor);
                String[] $i$a$-assert-TypeAliasExpander$expandNonArgumentTypeProjection$22 = new String[]{((TypeAliasDescriptor)typeDescriptor).getName().toString()};
                return new TypeProjectionImpl(Variance.INVARIANT, ErrorUtils.createErrorType(ErrorTypeKind.RECURSIVE_TYPE_ALIAS, $i$a$-assert-TypeAliasExpander$expandNonArgumentTypeProjection$22));
            }
            Iterable $this$mapIndexed$iv = type.getArguments();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i2;
                void typeAliasArgument;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                TypeProjection typeProjection2 = (TypeProjection)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(this.expandTypeProjection((TypeProjection)typeAliasArgument, typeAliasExpansion, typeConstructor2.getParameters().get((int)i2), recursionDepth + 1));
            }
            List expandedArguments = (List)destination$iv$iv;
            TypeAliasExpansion nestedExpansion = TypeAliasExpansion.Companion.create(typeAliasExpansion, (TypeAliasDescriptor)typeDescriptor, expandedArguments);
            SimpleType nestedExpandedType = this.expandRecursively(nestedExpansion, type.getAttributes(), type.isMarkedNullable(), recursionDepth + 1, false);
            SimpleType substitutedType = this.substituteArguments(type, typeAliasExpansion, recursionDepth);
            SimpleType typeWithAbbreviation = DynamicTypesKt.isDynamic(nestedExpandedType) ? nestedExpandedType : SpecialTypesKt.withAbbreviation(nestedExpandedType, substitutedType);
            typeProjection = new TypeProjectionImpl(originalProjection.getProjectionKind(), typeWithAbbreviation);
        } else {
            SimpleType substitutedType = this.substituteArguments(type, typeAliasExpansion, recursionDepth);
            this.checkTypeArgumentsSubstitution(type, substitutedType);
            typeProjection = new TypeProjectionImpl(originalProjection.getProjectionKind(), substitutedType);
        }
        return typeProjection;
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleType substituteArguments(SimpleType $this$substituteArguments, TypeAliasExpansion typeAliasExpansion, int recursionDepth) {
        void $this$mapIndexedTo$iv$iv;
        TypeConstructor typeConstructor2 = $this$substituteArguments.getConstructor();
        Iterable $this$mapIndexed$iv = $this$substituteArguments.getArguments();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i2;
            void originalArgument;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TypeProjection projection = this.expandTypeProjection((TypeProjection)originalArgument, typeAliasExpansion, typeConstructor2.getParameters().get((int)i2), recursionDepth + 1);
            collection.add(projection.isStarProjection() ? projection : (TypeProjection)new TypeProjectionImpl(projection.getProjectionKind(), TypeUtils.makeNullableIfNeeded(projection.getType(), originalArgument.getType().isMarkedNullable())));
        }
        List substitutedArguments = (List)destination$iv$iv;
        return TypeSubstitutionKt.replace$default($this$substituteArguments, substitutedArguments, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeArgumentsSubstitution(KotlinType unsubstitutedType, KotlinType substitutedType) {
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(substitutedType);
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"create(...)");
        TypeSubstitutor typeSubstitutor3 = typeSubstitutor2;
        Iterable $this$forEachIndexed$iv = substitutedType.getArguments();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void substitutedArgument;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TypeProjection typeProjection = (TypeProjection)item$iv;
            int i2 = n;
            boolean bl = false;
            if (substitutedArgument.isStarProjection()) continue;
            KotlinType kotlinType = substitutedArgument.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            if (TypeUtilsKt.containsTypeAliasParameters(kotlinType)) continue;
            TypeProjection unsubstitutedArgument = unsubstitutedType.getArguments().get(i2);
            TypeParameterDescriptor typeParameter = unsubstitutedType.getConstructor().getParameters().get(i2);
            if (!this.shouldCheckBounds) continue;
            KotlinType kotlinType2 = unsubstitutedArgument.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
            KotlinType kotlinType3 = substitutedArgument.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType3, (String)"getType(...)");
            Intrinsics.checkNotNull((Object)typeParameter);
            this.reportStrategy.boundsViolationInSubstitution(typeSubstitutor3, kotlinType2, kotlinType3, typeParameter);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/types/TypeAliasExpander$Companion;", "", "<init>", "()V", "MAX_RECURSION_DEPTH", "", "assertRecursionDepth", "", "recursionDepth", "typeAliasDescriptor", "Lorg/jetbrains/kotlin/gradle/internal/descriptors/TypeAliasDescriptor;", "NON_REPORTING", "Lorg/jetbrains/kotlin/gradle/internal/types/TypeAliasExpander;", "getNON_REPORTING", "()Lorg/jetbrains/kotlin/types/TypeAliasExpander;", "descriptors"})
    public static final class Companion {
        private Companion() {
        }

        private final void assertRecursionDepth(int recursionDepth, TypeAliasDescriptor typeAliasDescriptor) {
            if (recursionDepth > 100) {
                throw new AssertionError((Object)("Too deep recursion while expanding type alias " + typeAliasDescriptor.getName()));
            }
        }

        @NotNull
        public final TypeAliasExpander getNON_REPORTING() {
            return NON_REPORTING;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

