/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.Conditions;
import org.jetbrains.kotlin.com.intellij.util.Processor;

@Deprecated
public class TransferToEDTQueue<T> {
    private static final int DEFAULT_THRESHOLD = 30;
    private final String myName;
    private final Processor<? super T> myProcessor;
    private volatile boolean stopped;
    private final Condition<?> myShutUpCondition;
    private final int myMaxUnitOfWorkThresholdMs;
    private final Deque<T> myQueue;
    private final AtomicBoolean invokeLaterScheduled;
    private final Runnable myUpdateRunnable;

    public TransferToEDTQueue(@NotNull @NonNls String name2, @NotNull Processor<? super T> processor, @NotNull Condition<?> shutUpCondition, int maxUnitOfWorkThresholdMs) {
        if (name2 == null) {
            TransferToEDTQueue.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            TransferToEDTQueue.$$$reportNull$$$0(1);
        }
        if (shutUpCondition == null) {
            TransferToEDTQueue.$$$reportNull$$$0(2);
        }
        this.myQueue = new ArrayDeque<T>(10);
        this.invokeLaterScheduled = new AtomicBoolean();
        this.myUpdateRunnable = new Runnable(){

            @Override
            public void run() {
                boolean b = TransferToEDTQueue.this.invokeLaterScheduled.compareAndSet(true, false);
                assert (b);
                if (TransferToEDTQueue.this.stopped || TransferToEDTQueue.this.myShutUpCondition.value(null)) {
                    TransferToEDTQueue.this.stop();
                    return;
                }
                long start2 = System.currentTimeMillis();
                while (TransferToEDTQueue.this.processNext()) {
                    long finish = System.currentTimeMillis();
                    if (TransferToEDTQueue.this.myMaxUnitOfWorkThresholdMs == -1 || finish - start2 <= (long)TransferToEDTQueue.this.myMaxUnitOfWorkThresholdMs) continue;
                    break;
                }
                if (!TransferToEDTQueue.this.isEmpty()) {
                    TransferToEDTQueue.this.scheduleUpdate();
                }
            }

            public String toString() {
                return TransferToEDTQueue.this.getClass().getSimpleName() + "[" + TransferToEDTQueue.this.myName + "]";
            }
        };
        this.myName = name2;
        this.myProcessor = processor;
        this.myShutUpCondition = shutUpCondition;
        this.myMaxUnitOfWorkThresholdMs = maxUnitOfWorkThresholdMs;
    }

    @NotNull
    public static TransferToEDTQueue<Runnable> createRunnableMerger(@NotNull @NonNls String name2) {
        if (name2 == null) {
            TransferToEDTQueue.$$$reportNull$$$0(3);
        }
        return TransferToEDTQueue.createRunnableMerger(name2, 30);
    }

    @NotNull
    public static TransferToEDTQueue<Runnable> createRunnableMerger(@NotNull @NonNls String name2, int maxUnitOfWorkThresholdMs) {
        if (name2 == null) {
            TransferToEDTQueue.$$$reportNull$$$0(4);
        }
        return new TransferToEDTQueue<Runnable>(name2, runnable -> {
            runnable.run();
            return true;
        }, Conditions.alwaysFalse(), maxUnitOfWorkThresholdMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEmpty() {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            return this.myQueue.isEmpty();
        }
    }

    private boolean processNext() {
        T thing = this.pollFirst();
        if (thing == null) {
            return false;
        }
        if (!this.myProcessor.process(thing)) {
            this.stop();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T pollFirst() {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            return this.myQueue.pollFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(@NotNull T thing) {
        if (thing == null) {
            TransferToEDTQueue.$$$reportNull$$$0(5);
        }
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            this.myQueue.addLast(thing);
        }
        this.scheduleUpdate();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offerIfAbsent(@NotNull T thing) {
        if (thing == null) {
            TransferToEDTQueue.$$$reportNull$$$0(6);
        }
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            boolean absent;
            boolean bl = absent = !this.myQueue.contains(thing);
            if (absent) {
                this.myQueue.addLast(thing);
                this.scheduleUpdate();
            }
            return absent;
        }
    }

    private void scheduleUpdate() {
        if (!this.stopped && this.invokeLaterScheduled.compareAndSet(false, true)) {
            this.schedule(this.myUpdateRunnable);
        }
    }

    protected void schedule(@NotNull Runnable updateRunnable) {
        if (updateRunnable == null) {
            TransferToEDTQueue.$$$reportNull$$$0(7);
        }
        SwingUtilities.invokeLater(updateRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.stopped = true;
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            this.myQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            return this.myQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @TestOnly
    @NotNull
    public Collection<T> dump() {
        Deque<T> deque = this.myQueue;
        // MONITORENTER : deque
        ArrayList<T> arrayList = new ArrayList<T>(this.myQueue);
        // MONITOREXIT : deque
        if (arrayList != null) return arrayList;
        TransferToEDTQueue.$$$reportNull$$$0(8);
        return arrayList;
    }

    public void drain() {
        int processed = 0;
        while (this.processNext()) {
            ++processed;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shutUpCondition";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thing";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateRunnable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/TransferToEDTQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/TransferToEDTQueue";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "dump";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createRunnableMerger";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "offer";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "offerIfAbsent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "schedule";
                break;
            }
            case 8: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

