/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.jna;

import com.sun.jna.Native;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfoRt;
import org.jetbrains.kotlin.com.intellij.util.system.CpuArch;

public final class JnaLoader {
    private static Boolean ourJnaLoaded = null;

    public static synchronized void load(@NotNull Logger logger) {
        if (logger == null) {
            JnaLoader.$$$reportNull$$$0(0);
        }
        if (ourJnaLoaded == null) {
            ourJnaLoaded = Boolean.FALSE;
            try {
                long t = System.currentTimeMillis();
                int ptrSize = Native.POINTER_SIZE;
                t = System.currentTimeMillis() - t;
                logger.info("JNA library (" + (ptrSize << 3) + "-bit) loaded in " + t + " ms");
                ourJnaLoaded = Boolean.TRUE;
            }
            catch (Throwable t) {
                logger.warn("Unable to load JNA library (os=" + SystemInfoRt.OS_NAME + " " + SystemInfoRt.OS_VERSION + ", jna.boot.library.path=" + System.getProperty("jna.boot.library.path") + ")", t);
            }
        }
    }

    public static synchronized boolean isLoaded() {
        if (ourJnaLoaded == null) {
            JnaLoader.load(Logger.getInstance(JnaLoader.class));
        }
        return ourJnaLoaded;
    }

    public static boolean isSupportsDirectMapping() {
        return !SystemInfoRt.isMac || !CpuArch.isArm64();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "org/jetbrains/kotlin/com/intellij/jna/JnaLoader", "load"));
    }
}

