/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.compilerRunner.CompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.IncrementalCompilationEnvironment;
import org.jetbrains.kotlin.compilerRunner.KotlinCompilerArgumentsLogLevel;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollector;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.gradle.logging.GradleErrorMessageCollector;
import org.jetbrains.kotlin.gradle.report.ReportingSettings;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0011\b\u0000\u0018\u00002\u00020\u0001B]\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\b\u0010#\u001a\u0004\u0018\u00010\u0004R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0019\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerEnvironment;", "Lorg/jetbrains/kotlin/compilerRunner/CompilerEnvironment;", "compilerClasspath", "", "Ljava/io/File;", "messageCollector", "Lorg/jetbrains/kotlin/gradle/logging/GradleErrorMessageCollector;", "outputItemsCollector", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollector;", "outputFiles", "", "reportingSettings", "Lorg/jetbrains/kotlin/gradle/report/ReportingSettings;", "compilerArgumentsLogLevel", "Lorg/jetbrains/kotlin/compilerRunner/KotlinCompilerArgumentsLogLevel;", "incrementalCompilationEnvironment", "Lorg/jetbrains/kotlin/compilerRunner/IncrementalCompilationEnvironment;", "kotlinScriptExtensions", "", "", "(Ljava/lang/Iterable;Lorg/jetbrains/kotlin/gradle/logging/GradleErrorMessageCollector;Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollector;Ljava/util/List;Lorg/jetbrains/kotlin/gradle/report/ReportingSettings;Lorg/jetbrains/kotlin/compilerRunner/KotlinCompilerArgumentsLogLevel;Lorg/jetbrains/kotlin/compilerRunner/IncrementalCompilationEnvironment;[Ljava/lang/String;)V", "getCompilerArgumentsLogLevel", "()Lorg/jetbrains/kotlin/compilerRunner/KotlinCompilerArgumentsLogLevel;", "getCompilerClasspath", "()Ljava/lang/Iterable;", "getIncrementalCompilationEnvironment", "()Lorg/jetbrains/kotlin/compilerRunner/IncrementalCompilationEnvironment;", "getKotlinScriptExtensions", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getOutputFiles", "()Ljava/util/List;", "getReportingSettings", "()Lorg/jetbrains/kotlin/gradle/report/ReportingSettings;", "compilerFullClasspath", "toolsJar", "kotlin-gradle-plugin_common"})
public final class GradleCompilerEnvironment
extends CompilerEnvironment {
    @NotNull
    private final Iterable<File> compilerClasspath;
    @NotNull
    private final List<File> outputFiles;
    @NotNull
    private final ReportingSettings reportingSettings;
    @NotNull
    private final KotlinCompilerArgumentsLogLevel compilerArgumentsLogLevel;
    @Nullable
    private final IncrementalCompilationEnvironment incrementalCompilationEnvironment;
    @NotNull
    private final String[] kotlinScriptExtensions;

    public GradleCompilerEnvironment(@NotNull Iterable<? extends File> compilerClasspath2, @NotNull GradleErrorMessageCollector messageCollector, @NotNull OutputItemsCollector outputItemsCollector, @NotNull List<? extends File> outputFiles, @NotNull ReportingSettings reportingSettings, @NotNull KotlinCompilerArgumentsLogLevel compilerArgumentsLogLevel, @Nullable IncrementalCompilationEnvironment incrementalCompilationEnvironment, @NotNull String[] kotlinScriptExtensions) {
        Intrinsics.checkNotNullParameter(compilerClasspath2, (String)"compilerClasspath");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkNotNullParameter((Object)outputItemsCollector, (String)"outputItemsCollector");
        Intrinsics.checkNotNullParameter(outputFiles, (String)"outputFiles");
        Intrinsics.checkNotNullParameter((Object)reportingSettings, (String)"reportingSettings");
        Intrinsics.checkNotNullParameter((Object)((Object)compilerArgumentsLogLevel), (String)"compilerArgumentsLogLevel");
        Intrinsics.checkNotNullParameter((Object)kotlinScriptExtensions, (String)"kotlinScriptExtensions");
        super(Services.EMPTY, (MessageCollector)messageCollector, outputItemsCollector);
        this.compilerClasspath = compilerClasspath2;
        this.outputFiles = outputFiles;
        this.reportingSettings = reportingSettings;
        this.compilerArgumentsLogLevel = compilerArgumentsLogLevel;
        this.incrementalCompilationEnvironment = incrementalCompilationEnvironment;
        this.kotlinScriptExtensions = kotlinScriptExtensions;
    }

    public /* synthetic */ GradleCompilerEnvironment(Iterable iterable, GradleErrorMessageCollector gradleErrorMessageCollector, OutputItemsCollector outputItemsCollector, List list, ReportingSettings reportingSettings, KotlinCompilerArgumentsLogLevel kotlinCompilerArgumentsLogLevel2, IncrementalCompilationEnvironment incrementalCompilationEnvironment, String[] stringArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            incrementalCompilationEnvironment = null;
        }
        if ((n & 0x80) != 0) {
            stringArray = new String[]{};
        }
        this(iterable, gradleErrorMessageCollector, outputItemsCollector, list, reportingSettings, kotlinCompilerArgumentsLogLevel2, incrementalCompilationEnvironment, stringArray);
    }

    @NotNull
    public final Iterable<File> getCompilerClasspath() {
        return this.compilerClasspath;
    }

    @NotNull
    public final List<File> getOutputFiles() {
        return this.outputFiles;
    }

    @NotNull
    public final ReportingSettings getReportingSettings() {
        return this.reportingSettings;
    }

    @NotNull
    public final KotlinCompilerArgumentsLogLevel getCompilerArgumentsLogLevel() {
        return this.compilerArgumentsLogLevel;
    }

    @Nullable
    public final IncrementalCompilationEnvironment getIncrementalCompilationEnvironment() {
        return this.incrementalCompilationEnvironment;
    }

    @NotNull
    public final String[] getKotlinScriptExtensions() {
        return this.kotlinScriptExtensions;
    }

    @NotNull
    public final List<File> compilerFullClasspath(@Nullable File toolsJar) {
        return toolsJar != null ? CollectionsKt.plus(this.compilerClasspath, (Object)toolsJar) : CollectionsKt.toList(this.compilerClasspath);
    }
}

