/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.Attribute;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.CPUTF8;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.ClassConstantPool;
import org.jetbrains.kotlin.org.apache.commons.compress.harmony.unpack200.bytecode.ClassFileEntry;

public class SourceFileAttribute
extends Attribute {
    private static CPUTF8 attributeName;
    private final CPUTF8 name;
    private int nameIndex;

    public static void setAttributeName(CPUTF8 cpUTF8Value) {
        attributeName = cpUTF8Value;
    }

    public SourceFileAttribute(CPUTF8 name2) {
        super(attributeName);
        this.name = name2;
    }

    @Override
    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (!super.equals(obj2)) {
            return false;
        }
        if (this.getClass() != obj2.getClass()) {
            return false;
        }
        SourceFileAttribute other = (SourceFileAttribute)obj2;
        return Objects.equals(this.name, other.name);
    }

    @Override
    protected int getLength() {
        return 2;
    }

    @Override
    protected ClassFileEntry[] getNestedClassFileEntries() {
        return new ClassFileEntry[]{this.getAttributeName(), this.name};
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.name == null ? 0 : this.name.hashCode());
        return result2;
    }

    @Override
    public boolean isSourceFileAttribute() {
        return true;
    }

    @Override
    protected void resolve(ClassConstantPool pool) {
        super.resolve(pool);
        this.nameIndex = pool.indexOf(this.name);
    }

    @Override
    public String toString() {
        return "SourceFile: " + this.name;
    }

    @Override
    protected void writeBody(DataOutputStream dos) throws IOException {
        dos.writeShort(this.nameIndex);
    }
}

