/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.compress.archivers.tar;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.kotlin.org.apache.commons.codec.Charsets;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.jetbrains.kotlin.org.apache.commons.compress.utils.CharsetNames;
import org.jetbrains.kotlin.org.apache.commons.compress.utils.FixedLengthBlockOutputStream;
import org.jetbrains.kotlin.org.apache.commons.compress.utils.TimeUtils;
import org.jetbrains.kotlin.org.apache.commons.io.output.CountingOutputStream;

public class TarArchiveOutputStream
extends ArchiveOutputStream<TarArchiveEntry> {
    public static final int LONGFILE_ERROR = 0;
    public static final int LONGFILE_TRUNCATE = 1;
    public static final int LONGFILE_GNU = 2;
    public static final int LONGFILE_POSIX = 3;
    public static final int BIGNUMBER_ERROR = 0;
    public static final int BIGNUMBER_STAR = 1;
    public static final int BIGNUMBER_POSIX = 2;
    private static final int RECORD_SIZE = 512;
    private static final ZipEncoding ASCII = ZipEncodingHelper.getZipEncoding(CharsetNames.US_ASCII);
    private static final int BLOCK_SIZE_UNSPECIFIED = -511;
    private long currSize;
    private String currName;
    private long currBytes;
    private final byte[] recordBuf;
    private int longFileMode = 0;
    private int bigNumberMode = 0;
    private long recordsWritten;
    private final int recordsPerBlock;
    private boolean closed;
    private boolean haveUnclosedEntry;
    private boolean finished;
    private final FixedLengthBlockOutputStream out;
    private final CountingOutputStream countingOut;
    private final ZipEncoding zipEncoding;
    final String charsetName;
    private boolean addPaxHeadersForNonAsciiNames;

    public TarArchiveOutputStream(OutputStream os) {
        this(os, -511);
    }

    public TarArchiveOutputStream(OutputStream os, int blockSize) {
        this(os, blockSize, null);
    }

    @Deprecated
    public TarArchiveOutputStream(OutputStream os, int blockSize, int recordSize) {
        this(os, blockSize, recordSize, null);
    }

    @Deprecated
    public TarArchiveOutputStream(OutputStream os, int blockSize, int recordSize, String encoding) {
        this(os, blockSize, encoding);
        if (recordSize != 512) {
            throw new IllegalArgumentException("Tar record size must always be 512 bytes. Attempt to set size of " + recordSize);
        }
    }

    public TarArchiveOutputStream(OutputStream os, int blockSize, String encoding) {
        int realBlockSize = -511 == blockSize ? 512 : blockSize;
        if (realBlockSize <= 0 || realBlockSize % 512 != 0) {
            throw new IllegalArgumentException("Block size must be a multiple of 512 bytes. Attempt to use set size of " + blockSize);
        }
        this.countingOut = new CountingOutputStream(os);
        this.out = new FixedLengthBlockOutputStream(this.countingOut, 512);
        this.charsetName = Charsets.toCharset((String)encoding).name();
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(encoding);
        this.recordBuf = new byte[512];
        this.recordsPerBlock = realBlockSize / 512;
    }

    public TarArchiveOutputStream(OutputStream os, String encoding) {
        this(os, -511, encoding);
    }

    private void addFileTimePaxHeader(Map<String, String> paxHeaders, String header, FileTime value2) {
        if (value2 != null) {
            Instant instant = value2.toInstant();
            long seconds = instant.getEpochSecond();
            int nanos = instant.getNano();
            if (nanos == 0) {
                paxHeaders.put(header, String.valueOf(seconds));
            } else {
                this.addInstantPaxHeader(paxHeaders, header, seconds, nanos);
            }
        }
    }

    private void addFileTimePaxHeaderForBigNumber(Map<String, String> paxHeaders, String header, FileTime value2, long maxValue) {
        if (value2 != null) {
            Instant instant = value2.toInstant();
            long seconds = instant.getEpochSecond();
            int nanos = instant.getNano();
            if (nanos == 0) {
                this.addPaxHeaderForBigNumber(paxHeaders, header, seconds, maxValue);
            } else {
                this.addInstantPaxHeader(paxHeaders, header, seconds, nanos);
            }
        }
    }

    private void addInstantPaxHeader(Map<String, String> paxHeaders, String header, long seconds, int nanos) {
        BigDecimal bdSeconds = BigDecimal.valueOf(seconds);
        BigDecimal bdNanos = BigDecimal.valueOf(nanos).movePointLeft(9).setScale(7, RoundingMode.DOWN);
        BigDecimal timestamp = bdSeconds.add(bdNanos);
        paxHeaders.put(header, timestamp.toPlainString());
    }

    private void addPaxHeaderForBigNumber(Map<String, String> paxHeaders, String header, long value2, long maxValue) {
        if (value2 < 0L || value2 > maxValue) {
            paxHeaders.put(header, String.valueOf(value2));
        }
    }

    private void addPaxHeadersForBigNumbers(Map<String, String> paxHeaders, TarArchiveEntry entry2) {
        this.addPaxHeaderForBigNumber(paxHeaders, "size", entry2.getSize(), 0x1FFFFFFFFL);
        this.addPaxHeaderForBigNumber(paxHeaders, "gid", entry2.getLongGroupId(), 0x1FFFFFL);
        this.addFileTimePaxHeaderForBigNumber(paxHeaders, "mtime", entry2.getLastModifiedTime(), 0x1FFFFFFFFL);
        this.addFileTimePaxHeader(paxHeaders, "atime", entry2.getLastAccessTime());
        if (entry2.getStatusChangeTime() != null) {
            this.addFileTimePaxHeader(paxHeaders, "ctime", entry2.getStatusChangeTime());
        } else {
            this.addFileTimePaxHeader(paxHeaders, "ctime", entry2.getCreationTime());
        }
        this.addPaxHeaderForBigNumber(paxHeaders, "uid", entry2.getLongUserId(), 0x1FFFFFL);
        this.addFileTimePaxHeader(paxHeaders, "LIBARCHIVE.creationtime", entry2.getCreationTime());
        this.addPaxHeaderForBigNumber(paxHeaders, "SCHILY.devmajor", entry2.getDevMajor(), 0x1FFFFFL);
        this.addPaxHeaderForBigNumber(paxHeaders, "SCHILY.devminor", entry2.getDevMinor(), 0x1FFFFFL);
        this.failForBigNumber("mode", entry2.getMode(), 0x1FFFFFL);
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.finished) {
                this.finish();
            }
        }
        finally {
            if (!this.closed) {
                this.out.close();
                this.closed = true;
            }
        }
    }

    @Override
    public void closeArchiveEntry() throws IOException {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        if (!this.haveUnclosedEntry) {
            throw new IOException("No current entry to close");
        }
        this.out.flushBlock();
        if (this.currBytes < this.currSize) {
            throw new IOException("Entry '" + this.currName + "' closed at '" + this.currBytes + "' before the '" + this.currSize + "' bytes specified in the header were written");
        }
        this.recordsWritten += this.currSize / 512L;
        if (0L != this.currSize % 512L) {
            ++this.recordsWritten;
        }
        this.haveUnclosedEntry = false;
    }

    @Override
    public TarArchiveEntry createArchiveEntry(File inputFile, String entryName) throws IOException {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        return new TarArchiveEntry(inputFile, entryName);
    }

    @Override
    public TarArchiveEntry createArchiveEntry(Path inputPath, String entryName, LinkOption ... options) throws IOException {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        return new TarArchiveEntry(inputPath, entryName, options);
    }

    private byte[] encodeExtendedPaxHeadersContents(Map<String, String> headers) {
        StringWriter w = new StringWriter();
        headers.forEach((k, v) -> {
            int len = k.length() + v.length() + 3 + 2;
            String line = len + " " + k + "=" + v + "\n";
            int actualLength = line.getBytes(StandardCharsets.UTF_8).length;
            while (len != actualLength) {
                len = actualLength;
                line = len + " " + k + "=" + v + "\n";
                actualLength = line.getBytes(StandardCharsets.UTF_8).length;
            }
            w.write(line);
        });
        return w.toString().getBytes(StandardCharsets.UTF_8);
    }

    private void failForBigNumber(String field, long value2, long maxValue) {
        this.failForBigNumber(field, value2, maxValue, "");
    }

    private void failForBigNumber(String field, long value2, long maxValue, String additionalMsg) {
        if (value2 < 0L || value2 > maxValue) {
            throw new IllegalArgumentException(field + " '" + value2 + "' is too big ( > " + maxValue + " )." + additionalMsg);
        }
    }

    private void failForBigNumbers(TarArchiveEntry entry2) {
        this.failForBigNumber("entry size", entry2.getSize(), 0x1FFFFFFFFL);
        this.failForBigNumberWithPosixMessage("group id", entry2.getLongGroupId(), 0x1FFFFFL);
        this.failForBigNumber("last modification time", TimeUtils.toUnixTime(entry2.getLastModifiedTime()), 0x1FFFFFFFFL);
        this.failForBigNumber("user id", entry2.getLongUserId(), 0x1FFFFFL);
        this.failForBigNumber("mode", entry2.getMode(), 0x1FFFFFL);
        this.failForBigNumber("major device number", entry2.getDevMajor(), 0x1FFFFFL);
        this.failForBigNumber("minor device number", entry2.getDevMinor(), 0x1FFFFFL);
    }

    private void failForBigNumberWithPosixMessage(String field, long value2, long maxValue) {
        this.failForBigNumber(field, value2, maxValue, " Use STAR or POSIX extensions to overcome this limit");
    }

    @Override
    public void finish() throws IOException {
        if (this.finished) {
            throw new IOException("This archive has already been finished");
        }
        if (this.haveUnclosedEntry) {
            throw new IOException("This archive contains unclosed entries.");
        }
        this.writeEOFRecord();
        this.writeEOFRecord();
        this.padAsNeeded();
        this.out.flush();
        this.finished = true;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public long getBytesWritten() {
        return this.countingOut.getByteCount();
    }

    @Override
    @Deprecated
    public int getCount() {
        return (int)this.getBytesWritten();
    }

    @Deprecated
    public int getRecordSize() {
        return 512;
    }

    private boolean handleLongName(TarArchiveEntry entry2, String name2, Map<String, String> paxHeaders, String paxHeaderName, byte linkType, String fieldName) throws IOException {
        ByteBuffer encodedName = this.zipEncoding.encode(name2);
        int len = encodedName.limit() - encodedName.position();
        if (len >= 100) {
            if (this.longFileMode == 3) {
                paxHeaders.put(paxHeaderName, name2);
                return true;
            }
            if (this.longFileMode == 2) {
                TarArchiveEntry longLinkEntry = new TarArchiveEntry("././@LongLink", linkType);
                longLinkEntry.setSize((long)len + 1L);
                this.transferModTime(entry2, longLinkEntry);
                this.putArchiveEntry(longLinkEntry);
                this.write(encodedName.array(), encodedName.arrayOffset(), len);
                this.write(0);
                this.closeArchiveEntry();
            } else if (this.longFileMode != 1) {
                throw new IllegalArgumentException(fieldName + " '" + name2 + "' is too long ( > " + 100 + " bytes)");
            }
        }
        return false;
    }

    private void padAsNeeded() throws IOException {
        int start2 = Math.toIntExact(this.recordsWritten % (long)this.recordsPerBlock);
        if (start2 != 0) {
            for (int i2 = start2; i2 < this.recordsPerBlock; ++i2) {
                this.writeEOFRecord();
            }
        }
    }

    @Override
    public void putArchiveEntry(TarArchiveEntry archiveEntry) throws IOException {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        if (archiveEntry.isGlobalPaxHeader()) {
            byte[] data = this.encodeExtendedPaxHeadersContents(archiveEntry.getExtraPaxHeaders());
            archiveEntry.setSize(data.length);
            archiveEntry.writeEntryHeader(this.recordBuf, this.zipEncoding, this.bigNumberMode == 1);
            this.writeRecord(this.recordBuf);
            this.currSize = archiveEntry.getSize();
            this.currBytes = 0L;
            this.haveUnclosedEntry = true;
            this.write(data);
            this.closeArchiveEntry();
        } else {
            boolean paxHeaderContainsLinkPath;
            HashMap<String, String> paxHeaders = new HashMap<String, String>();
            String entryName = archiveEntry.getName();
            boolean paxHeaderContainsPath = this.handleLongName(archiveEntry, entryName, paxHeaders, "path", (byte)76, "file name");
            String linkName = archiveEntry.getLinkName();
            boolean bl = paxHeaderContainsLinkPath = linkName != null && !linkName.isEmpty() && this.handleLongName(archiveEntry, linkName, paxHeaders, "linkpath", (byte)75, "link name");
            if (this.bigNumberMode == 2) {
                this.addPaxHeadersForBigNumbers(paxHeaders, archiveEntry);
            } else if (this.bigNumberMode != 1) {
                this.failForBigNumbers(archiveEntry);
            }
            if (this.addPaxHeadersForNonAsciiNames && !paxHeaderContainsPath && !ASCII.canEncode(entryName)) {
                paxHeaders.put("path", entryName);
            }
            if (this.addPaxHeadersForNonAsciiNames && !paxHeaderContainsLinkPath && (archiveEntry.isLink() || archiveEntry.isSymbolicLink()) && !ASCII.canEncode(linkName)) {
                paxHeaders.put("linkpath", linkName);
            }
            paxHeaders.putAll(archiveEntry.getExtraPaxHeaders());
            if (!paxHeaders.isEmpty()) {
                this.writePaxHeaders(archiveEntry, entryName, paxHeaders);
            }
            archiveEntry.writeEntryHeader(this.recordBuf, this.zipEncoding, this.bigNumberMode == 1);
            this.writeRecord(this.recordBuf);
            this.currBytes = 0L;
            this.currSize = archiveEntry.isDirectory() ? 0L : archiveEntry.getSize();
            this.currName = entryName;
            this.haveUnclosedEntry = true;
        }
    }

    public void setAddPaxHeadersForNonAsciiNames(boolean b) {
        this.addPaxHeadersForNonAsciiNames = b;
    }

    public void setBigNumberMode(int bigNumberMode) {
        this.bigNumberMode = bigNumberMode;
    }

    public void setLongFileMode(int longFileMode) {
        this.longFileMode = longFileMode;
    }

    private boolean shouldBeReplaced(char c) {
        return c == '\u0000' || c == '/' || c == '\\';
    }

    private String stripTo7Bits(String name2) {
        int length = name2.length();
        StringBuilder result2 = new StringBuilder(length);
        for (int i2 = 0; i2 < length; ++i2) {
            char stripped = (char)(name2.charAt(i2) & 0x7F);
            if (this.shouldBeReplaced(stripped)) {
                result2.append("_");
                continue;
            }
            result2.append(stripped);
        }
        return result2.toString();
    }

    private void transferModTime(TarArchiveEntry from2, TarArchiveEntry to) {
        long fromModTimeSeconds = TimeUtils.toUnixTime(from2.getLastModifiedTime());
        if (fromModTimeSeconds < 0L || fromModTimeSeconds > 0x1FFFFFFFFL) {
            fromModTimeSeconds = 0L;
        }
        to.setLastModifiedTime(TimeUtils.unixTimeToFileTime(fromModTimeSeconds));
    }

    @Override
    public void write(byte[] wBuf, int wOffset, int numToWrite) throws IOException {
        if (!this.haveUnclosedEntry) {
            throw new IllegalStateException("No current tar entry");
        }
        if (this.currBytes + (long)numToWrite > this.currSize) {
            throw new IOException("Request to write '" + numToWrite + "' bytes exceeds size in header of '" + this.currSize + "' bytes for entry '" + this.currName + "'");
        }
        this.out.write(wBuf, wOffset, numToWrite);
        this.currBytes += (long)numToWrite;
    }

    private void writeEOFRecord() throws IOException {
        Arrays.fill(this.recordBuf, (byte)0);
        this.writeRecord(this.recordBuf);
    }

    void writePaxHeaders(TarArchiveEntry entry2, String entryName, Map<String, String> headers) throws IOException {
        String name2 = "./PaxHeaders.X/" + this.stripTo7Bits(entryName);
        if (name2.length() >= 100) {
            name2 = name2.substring(0, 99);
        }
        TarArchiveEntry pex = new TarArchiveEntry(name2, 120);
        this.transferModTime(entry2, pex);
        byte[] data = this.encodeExtendedPaxHeadersContents(headers);
        pex.setSize(data.length);
        this.putArchiveEntry(pex);
        this.write(data);
        this.closeArchiveEntry();
    }

    private void writeRecord(byte[] record) throws IOException {
        if (record.length != 512) {
            throw new IOException("Record to write has length '" + record.length + "' which is not the record size of '" + 512 + "'");
        }
        this.out.write(record);
        ++this.recordsWritten;
    }
}

