/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.toolchain;

import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault(because="Does only I/O")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/toolchain/UnzipTransformationAction;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lorg/gradle/api/artifacts/transform/TransformParameters$None;", "()V", "archiveOperations", "Lorg/gradle/api/file/ArchiveOperations;", "getArchiveOperations", "()Lorg/gradle/api/file/ArchiveOperations;", "fileSystemOperations", "Lorg/gradle/api/file/FileSystemOperations;", "getFileSystemOperations", "()Lorg/gradle/api/file/FileSystemOperations;", "inputArtifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInputArtifact", "()Lorg/gradle/api/provider/Provider;", "transform", "", "outputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "unzipTo", "archive", "Ljava/io/File;", "outputDir", "kotlin-gradle-plugin_common"})
public abstract class UnzipTransformationAction
implements TransformAction<TransformParameters.None> {
    @Inject
    @NotNull
    public abstract ArchiveOperations getArchiveOperations();

    @Inject
    @NotNull
    public abstract FileSystemOperations getFileSystemOperations();

    @InputArtifact
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract Provider<FileSystemLocation> getInputArtifact();

    public void transform(@NotNull TransformOutputs outputs) {
        Intrinsics.checkNotNullParameter((Object)outputs, (String)"outputs");
        File input = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
        File unzipDir = outputs.dir((Object)"extracted");
        Intrinsics.checkNotNullExpressionValue((Object)input, (String)"input");
        Intrinsics.checkNotNullExpressionValue((Object)unzipDir, (String)"unzipDir");
        this.unzipTo(input, unzipDir);
    }

    private final void unzipTo(File archive, File outputDir) {
        this.getFileSystemOperations().copy(new Action(archive, this, outputDir){
            final /* synthetic */ File $archive;
            final /* synthetic */ UnzipTransformationAction this$0;
            final /* synthetic */ File $outputDir;
            {
                this.$archive = $archive;
                this.this$0 = $receiver;
                this.$outputDir = $outputDir;
            }

            public final void execute(CopySpec it) {
                FileTree fileTree;
                Object[] objectArray = new Object[1];
                String string = this.$archive.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"archive.name");
                if (StringsKt.endsWith$default((String)string, (String)"zip", (boolean)false, (int)2, null)) {
                    fileTree = this.this$0.getArchiveOperations().zipTree((Object)this.$archive);
                } else {
                    String string2 = this.$archive.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"archive.name");
                    if (StringsKt.endsWith$default((String)string2, (String)".tar.gz", (boolean)false, (int)2, null)) {
                        fileTree = this.this$0.getArchiveOperations().tarTree((Object)this.$archive);
                    } else {
                        throw new IllegalStateException(("Unsupported format for unzipping " + this.$archive).toString());
                    }
                }
                objectArray[0] = fileTree;
                it.from(objectArray);
                it.into((Object)this.$outputDir);
            }
        });
    }
}

