/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.scripting.internal;

import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Internal;
import org.gradle.work.NormalizeLineEndings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.buildtools.api.CompilationService;
import org.jetbrains.kotlin.compilerRunner.btapi.SharedApiClassesClassLoaderProvider;
import org.jetbrains.kotlin.gradle.internal.ClassLoadersCachingBuildService;

@CacheableTransform
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b!\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/gradle/scripting/internal/DiscoverScriptExtensionsTransformAction;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lorg/jetbrains/kotlin/gradle/scripting/internal/DiscoverScriptExtensionsTransformAction$Parameters;", "()V", "inputArtifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInputArtifact", "()Lorg/gradle/api/provider/Provider;", "transform", "", "outputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "Parameters", "kotlin-gradle-plugin_common"})
public abstract class DiscoverScriptExtensionsTransformAction
implements TransformAction<Parameters> {
    @Classpath
    @InputArtifact
    @NormalizeLineEndings
    @NotNull
    public abstract Provider<FileSystemLocation> getInputArtifact();

    public void transform(@NotNull TransformOutputs outputs) {
        Intrinsics.checkNotNullParameter((Object)outputs, (String)"outputs");
        File input = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
        ClassLoader classLoader = ((ClassLoadersCachingBuildService)((Parameters)this.getParameters()).getClassLoadersCachingService().get()).getClassLoader(CollectionsKt.toList((Iterable)((Iterable)((Parameters)this.getParameters()).getCompilerClasspath())), SharedApiClassesClassLoaderProvider.INSTANCE);
        CompilationService compilationService = CompilationService.Companion.loadImplementation(classLoader);
        Collection extensions = compilationService.getCustomKotlinScriptFilenameExtensions(CollectionsKt.listOf((Object)input));
        if (!extensions.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)input, (String)"input");
            File outputFile2 = outputs.file((Object)stringBuilder.append(FilesKt.getNameWithoutExtension((File)input)).append(".discoveredScriptsExtensions.txt").toString());
            Intrinsics.checkNotNullExpressionValue((Object)outputFile2, (String)"outputFile");
            FilesKt.writeText$default((File)outputFile2, (String)CollectionsKt.joinToString$default((Iterable)extensions, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (int)2, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/gradle/scripting/internal/DiscoverScriptExtensionsTransformAction$Parameters;", "Lorg/gradle/api/artifacts/transform/TransformParameters;", "classLoadersCachingService", "Lorg/gradle/api/provider/Property;", "Lorg/jetbrains/kotlin/gradle/internal/ClassLoadersCachingBuildService;", "getClassLoadersCachingService", "()Lorg/gradle/api/provider/Property;", "compilerClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getCompilerClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "kotlin-gradle-plugin_common"})
    public static interface Parameters
    extends TransformParameters {
        @Internal
        @NotNull
        public Property<ClassLoadersCachingBuildService> getClassLoadersCachingService();

        @Classpath
        @NotNull
        public ConfigurableFileCollection getCompilerClasspath();
    }
}

