/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.model.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.file.Directory;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.model.CompilerArguments;
import org.jetbrains.kotlin.gradle.model.KotlinProject;
import org.jetbrains.kotlin.gradle.model.SourceSet;
import org.jetbrains.kotlin.gradle.model.impl.CompilerArgumentsImpl;
import org.jetbrains.kotlin.gradle.model.impl.KotlinProjectImpl;
import org.jetbrains.kotlin.gradle.model.impl.SourceSetImpl;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.VariantImplementationFactories;
import org.jetbrains.kotlin.gradle.plugin.internal.JavaSourceSetsAccessor;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinAndroidTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinJvmAndroidCompilation;
import org.jetbrains.kotlin.gradle.tasks.AbstractKotlinCompile;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0003H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/gradle/model/builder/KotlinModelBuilder;", "Lorg/gradle/tooling/provider/model/ToolingModelBuilder;", "kotlinPluginVersion", "", "androidTarget", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;)V", "buildAll", "", "modelName", "project", "Lorg/gradle/api/Project;", "canBuild", "", "Companion", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nKotlinModelBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinModelBuilder.kt\norg/jetbrains/kotlin/gradle/model/builder/KotlinModelBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1#2:136\n1#2:147\n1611#3,9:137\n1863#3:146\n1864#3:148\n1620#3:149\n*S KotlinDebug\n*F\n+ 1 KotlinModelBuilder.kt\norg/jetbrains/kotlin/gradle/model/builder/KotlinModelBuilder\n*L\n44#1:147\n44#1:137,9\n44#1:146\n44#1:148\n44#1:149\n*E\n"})
public final class KotlinModelBuilder
implements ToolingModelBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String kotlinPluginVersion;
    @Nullable
    private final KotlinAndroidTarget androidTarget;

    public KotlinModelBuilder(@NotNull String kotlinPluginVersion, @Nullable KotlinAndroidTarget androidTarget2) {
        Intrinsics.checkNotNullParameter((Object)kotlinPluginVersion, (String)"kotlinPluginVersion");
        this.kotlinPluginVersion = kotlinPluginVersion;
        this.androidTarget = androidTarget2;
    }

    public boolean canBuild(@NotNull String modelName) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        return Intrinsics.areEqual((Object)modelName, (Object)KotlinProject.class.getName());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Object buildAll(@NotNull String modelName, @NotNull Project project) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!this.canBuild(modelName)) {
            boolean $i$a$-require-KotlinModelBuilder$buildAll$22 = false;
            String $i$a$-require-KotlinModelBuilder$buildAll$22 = "buildAll(\"" + modelName + "\") has been called while canBeBuild is false";
            throw new IllegalArgumentException($i$a$-require-KotlinModelBuilder$buildAll$22.toString());
        }
        TaskCollection taskCollection = project.getTasks().withType(AbstractKotlinCompile.class);
        Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"project.tasks.withType(A\u2026otlinCompile::class.java)");
        List kotlinCompileTasks = CollectionsKt.toList((Iterable)((Iterable)taskCollection));
        KotlinProject.ProjectType projectType = KotlinModelBuilder.Companion.getProjectType(project);
        String string = project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.name");
        Iterable iterable = kotlinCompileTasks;
        KotlinProject.ProjectType projectType2 = projectType;
        String string2 = this.kotlinPluginVersion;
        String string3 = string;
        boolean $i$f$mapNotNull = false;
        void var7_12 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            SourceSet sourceSet;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            AbstractKotlinCompile it = (AbstractKotlinCompile)element$iv$iv;
            boolean bl2 = false;
            if (this.androidTarget != null) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                sourceSet = KotlinModelBuilder.Companion.createAndroidSourceSet(it, this.androidTarget);
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                sourceSet = KotlinModelBuilder.Companion.createSourceSet(it, project, projectType);
            }
            if (sourceSet == null) continue;
            SourceSet it$iv$iv = sourceSet;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        Collection collection = KotlinModelBuilder.Companion.getExpectedByDependencies(project);
        Collection collection2 = list;
        KotlinProject.ProjectType projectType3 = projectType2;
        String string4 = string2;
        String string5 = string3;
        return new KotlinProjectImpl(string5, string4, projectType3, collection2, collection);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u000b*\u0006\u0012\u0002\b\u00030\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e*\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\"\u0010\u0011\u001a\u0004\u0018\u00010\u000e*\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\tH\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0007H\u0002J\u0014\u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010\u00050\u0005*\u00020\u0007H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/gradle/model/builder/KotlinModelBuilder$Companion;", "", "()V", "getExpectedByDependencies", "", "", "project", "Lorg/gradle/api/Project;", "getProjectType", "Lorg/jetbrains/kotlin/gradle/model/KotlinProject$ProjectType;", "buildCompilerArguments", "Lorg/jetbrains/kotlin/gradle/model/CompilerArguments;", "Lorg/jetbrains/kotlin/gradle/tasks/AbstractKotlinCompile;", "createAndroidSourceSet", "Lorg/jetbrains/kotlin/gradle/model/SourceSet;", "androidTarget", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;", "createSourceSet", "projectType", "isAndroid", "", "pathOrName", "kotlin.jvm.PlatformType", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nKotlinModelBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinModelBuilder.kt\norg/jetbrains/kotlin/gradle/model/builder/KotlinModelBuilder$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 VariantImplementationFactories.kt\norg/jetbrains/kotlin/gradle/plugin/VariantImplementationFactoriesKt\n+ 5 gradleUtils.kt\norg/jetbrains/kotlin/gradle/plugin/GradleUtilsKt\n*L\n1#1,135:1\n1368#2:136\n1454#2,5:137\n808#2,11:142\n1611#2,9:153\n1863#2:162\n1864#2:164\n1620#2:165\n1557#2:166\n1628#2,3:167\n1368#2:173\n1454#2,5:174\n1663#2,8:179\n1368#2:187\n1454#2,5:188\n1663#2,8:193\n1#3:163\n1#3:171\n118#4:170\n29#5:172\n*S KotlinDebug\n*F\n+ 1 KotlinModelBuilder.kt\norg/jetbrains/kotlin/gradle/model/builder/KotlinModelBuilder$Companion\n*L\n70#1:136\n70#1:137,5\n71#1:142,11\n72#1:153,9\n72#1:162\n72#1:164\n72#1:165\n73#1:166\n73#1:167,3\n107#1:173\n107#1:174,5\n109#1:179,8\n110#1:187\n110#1:188,5\n112#1:193,8\n72#1:163\n80#1:170\n85#1:172\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isAndroid(Project $this$isAndroid) {
            return $this$isAndroid.getProject().getPlugins().hasPlugin("kotlin-android");
        }

        private final KotlinProject.ProjectType getProjectType(Project project) {
            return project.getPlugins().hasPlugin("kotlin") || project.getPlugins().hasPlugin("kotlin-platform-jvm") || this.isAndroid(project) ? KotlinProject.ProjectType.PLATFORM_JVM : (project.getPlugins().hasPlugin("kotlin2js") || project.getPlugins().hasPlugin("kotlin-platform-js") ? KotlinProject.ProjectType.PLATFORM_JS : KotlinProject.ProjectType.PLATFORM_COMMON);
        }

        /*
         * WARNING - void declaration
         */
        private final Collection<String> getExpectedByDependencies(Project project) {
            void $this$mapTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            Object list$iv$iv;
            String it;
            Iterable $this$flatMapTo$iv$iv;
            Object[] objectArray = new String[]{"expectedBy", "implement"};
            Iterable $this$flatMap$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Set set2;
                DependencySet dependencySet;
                it = (String)element$iv$iv;
                boolean bl = false;
                Configuration configuration2 = (Configuration)project.getConfigurations().findByName(it);
                DependencySet dependencySet2 = dependencySet = configuration2 != null ? configuration2.getDependencies() : null;
                if (dependencySet2 == null) {
                    set2 = SetsKt.emptySet();
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)dependencySet2, (String)"project.configurations.f\u2026?: emptySet<Dependency>()");
                    set2 = (Set)dependencySet;
                }
                list$iv$iv = set2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filterIsInstance = false;
            $this$flatMapTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ProjectDependency)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            list$iv$iv = $this$forEach$iv$iv$iv.iterator();
            while (list$iv$iv.hasNext()) {
                Project it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
                boolean bl = false;
                ProjectDependency it2 = (ProjectDependency)element$iv$iv;
                boolean bl2 = false;
                if (it2.getDependencyProject() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (Project)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.pathOrName((Project)it));
            }
            return (List)destination$iv$iv;
        }

        private final String pathOrName(Project $this$pathOrName) {
            return Intrinsics.areEqual((Object)$this$pathOrName.getPath(), (Object)":") ? $this$pathOrName.getName() : $this$pathOrName.getPath();
        }

        /*
         * WARNING - void declaration
         */
        private final SourceSet createSourceSet(AbstractKotlinCompile<?> $this$createSourceSet, Project project, KotlinProject.ProjectType projectType) {
            SourceSet sourceSet;
            SourceDirectorySet kotlinSourceSet;
            SourceDirectorySet sourceDirectorySet;
            org.gradle.api.tasks.SourceSet javaSourceSet2;
            org.gradle.api.tasks.SourceSet sourceSet2;
            org.gradle.api.tasks.SourceSet $this$variantImplementationFactory$iv;
            Project project2 = project;
            boolean $i$f$variantImplementationFactory2 = false;
            SourceSetContainer sourceSetContainer = ((JavaSourceSetsAccessor.JavaSourceSetsAccessorVariantFactory)VariantImplementationFactories.Companion.get((Project)$this$variantImplementationFactory$iv).get(Reflection.getOrCreateKotlinClass(JavaSourceSetsAccessor.JavaSourceSetsAccessorVariantFactory.class))).getInstance(project).getSourceSetsIfAvailable();
            if (sourceSetContainer != null) {
                Object v0;
                block7: {
                    Iterable $i$f$variantImplementationFactory2 = (Iterable)sourceSetContainer;
                    for (Object t : $i$f$variantImplementationFactory2) {
                        org.gradle.api.tasks.SourceSet it = (org.gradle.api.tasks.SourceSet)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)$this$createSourceSet.getSourceSetName().get())) continue;
                        v0 = t;
                        break block7;
                    }
                    v0 = null;
                }
                sourceSet2 = v0;
            } else {
                sourceSet2 = javaSourceSet2 = null;
            }
            if (javaSourceSet2 != null) {
                void $this$getExtension$iv;
                $this$variantImplementationFactory$iv = javaSourceSet2;
                String name$iv = projectType == KotlinProject.ProjectType.PLATFORM_JS ? "kotlin2js" : "kotlin";
                boolean $i$f$getExtension = false;
                sourceDirectorySet = (SourceDirectorySet)((ExtensionAware)$this$getExtension$iv).getExtensions().getByName(name$iv);
            } else {
                sourceDirectorySet = kotlinSourceSet = null;
            }
            if (kotlinSourceSet != null) {
                Object object = $this$createSourceSet.getSourceSetName().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sourceSetName.get()");
                String string = (String)object;
                Object object2 = $this$createSourceSet.getSourceSetName().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"sourceSetName.get()");
                SourceSet.SourceSetType sourceSetType = StringsKt.contains((CharSequence)((CharSequence)object2), (CharSequence)"test", (boolean)true) ? SourceSet.SourceSetType.TEST : SourceSet.SourceSetType.PRODUCTION;
                Object object3 = $this$createSourceSet.getFriendSourceSets$kotlin_gradle_plugin_common().get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"friendSourceSets.get()");
                Collection collection = (Collection)object3;
                Set set2 = kotlinSourceSet.getSrcDirs();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"kotlinSourceSet.srcDirs");
                Collection collection2 = set2;
                Set set3 = javaSourceSet2.getResources().getSrcDirs();
                Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"javaSourceSet.resources.srcDirs");
                Collection collection3 = set3;
                File file = ((Directory)$this$createSourceSet.getDestinationDirectory().get()).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"destinationDirectory.get().asFile");
                File file2 = javaSourceSet2.getOutput().getResourcesDir();
                Intrinsics.checkNotNull((Object)file2);
                sourceSet = new SourceSetImpl(string, sourceSetType, collection, collection2, collection3, file, file2, this.buildCompilerArguments($this$createSourceSet));
            } else {
                sourceSet = null;
            }
            return sourceSet;
        }

        /*
         * WARNING - void declaration
         */
        private final SourceSet createAndroidSourceSet(AbstractKotlinCompile<?> $this$createAndroidSourceSet, KotlinAndroidTarget androidTarget2) {
            void $this$distinctBy$iv;
            void $this$flatMapTo$iv$iv;
            void $this$distinctBy$iv2;
            void $this$flatMapTo$iv$iv2;
            String variantName = (String)$this$createAndroidSourceSet.getSourceSetName().get();
            KotlinJvmAndroidCompilation compilation2 = (KotlinJvmAndroidCompilation)androidTarget2.getCompilations().getByName(variantName);
            Iterable $this$flatMap$iv = compilation2.getAllKotlinSourceSets();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                KotlinSourceSet it = (KotlinSourceSet)element$iv$iv;
                boolean bl = false;
                Set set2 = it.getKotlin().getSrcDirs();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"it.kotlin.srcDirs");
                Iterable list$iv$iv = set2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            Iterable list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv2) {
                File it = (File)e$iv;
                boolean bl = false;
                String key$iv = it.getAbsolutePath();
                if (!set$iv.add(key$iv)) continue;
                ((ArrayList)list$iv).add(e$iv);
            }
            List sources2 = (List)list$iv;
            Iterable $this$flatMap$iv2 = compilation2.getAllKotlinSourceSets();
            boolean $i$f$flatMap2 = false;
            list$iv = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                KotlinSourceSet it = (KotlinSourceSet)element$iv$iv;
                boolean bl = false;
                Set set3 = it.getResources().getSrcDirs();
                Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"it.resources.srcDirs");
                Iterable list$iv$iv = set3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv2 = (List)destination$iv$iv2;
            boolean $i$f$distinctBy2 = false;
            HashSet<String> set$iv2 = new HashSet<String>();
            ArrayList list$iv2 = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                File it = (File)e$iv;
                boolean bl = false;
                String key$iv = it.getAbsolutePath();
                if (!set$iv2.add(key$iv)) continue;
                list$iv2.add(e$iv);
            }
            List resources = list$iv2;
            Object object = $this$createAndroidSourceSet.getSourceSetName().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sourceSetName.get()");
            String string = (String)object;
            Object object2 = $this$createAndroidSourceSet.getSourceSetName().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"sourceSetName.get()");
            SourceSet.SourceSetType sourceSetType = StringsKt.contains((CharSequence)((CharSequence)object2), (CharSequence)"test", (boolean)true) ? SourceSet.SourceSetType.TEST : SourceSet.SourceSetType.PRODUCTION;
            Object object3 = $this$createAndroidSourceSet.getFriendSourceSets$kotlin_gradle_plugin_common().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"friendSourceSets.get()");
            Collection collection = (Collection)object3;
            Collection collection2 = sources2;
            Collection collection3 = resources;
            File file = ((Directory)$this$createAndroidSourceSet.getDestinationDirectory().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"destinationDirectory.get().asFile");
            return new SourceSetImpl(string, sourceSetType, collection, collection2, collection3, file, compilation2.getOutput().getResourcesDir(), this.buildCompilerArguments($this$createAndroidSourceSet));
        }

        private final CompilerArguments buildCompilerArguments(AbstractKotlinCompile<?> $this$buildCompilerArguments) {
            return new CompilerArgumentsImpl($this$buildCompilerArguments.getSerializedCompilerArguments(), $this$buildCompilerArguments.getDefaultSerializedCompilerArguments(), CollectionsKt.toList((Iterable)((Iterable)$this$buildCompilerArguments.getLibraries())));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

