/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.github.gundy.semver4j.visitor;

import org.jetbrains.kotlin.com.github.gundy.semver4j.generated.grammar.NodeSemverExpressionBaseVisitor;
import org.jetbrains.kotlin.com.github.gundy.semver4j.generated.grammar.NodeSemverExpressionParser;
import org.jetbrains.kotlin.com.github.gundy.semver4j.model.Version;

public final class SemVerRangeExpressionVisitor
extends NodeSemverExpressionBaseVisitor<Boolean> {
    private final Version fullySpecifiedComparisonVersion;

    public SemVerRangeExpressionVisitor(Version fullySpecifiedComparisonVersion) {
        this.fullySpecifiedComparisonVersion = fullySpecifiedComparisonVersion;
    }

    @Override
    public Boolean visitHyphenatedRangeOfFullySpecifiedVersions(NodeSemverExpressionParser.HyphenatedRangeOfFullySpecifiedVersionsContext ctx) {
        boolean result2;
        boolean verGtLeft;
        Version left = Version.fromString(ctx.left.getText());
        Version right = Version.fromString(ctx.right.getText());
        boolean bl = verGtLeft = this.fullySpecifiedComparisonVersion.compareTo(left) >= 0;
        if (this.isEmpty(ctx.right.patch) && this.isEmpty(ctx.right.minor)) {
            right = right.incrementMajor();
            result2 = verGtLeft && this.fullySpecifiedComparisonVersion.compareTo(right) < 0;
        } else if (this.isEmpty(ctx.right.patch)) {
            right = right.incrementMinor();
            result2 = verGtLeft && this.fullySpecifiedComparisonVersion.compareTo(right) < 0;
        } else {
            boolean bl2 = result2 = this.fullySpecifiedComparisonVersion.compareTo(left) >= 0 && this.fullySpecifiedComparisonVersion.compareTo(right) <= 0;
        }
        if (this.fullySpecifiedComparisonVersion.getPreReleaseIdentifiers().size() > 0) {
            if (left.getPreReleaseIdentifiers().size() > 0 && SemVerRangeExpressionVisitor.majorMinorPatchMatch(left, this.fullySpecifiedComparisonVersion) || right.getPreReleaseIdentifiers().size() > 0 && SemVerRangeExpressionVisitor.majorMinorPatchMatch(right, this.fullySpecifiedComparisonVersion)) {
                return result2;
            }
            return Boolean.FALSE;
        }
        return result2;
    }

    @Override
    public Boolean visitEmptyRange(NodeSemverExpressionParser.EmptyRangeContext ctx) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitOperator(NodeSemverExpressionParser.OperatorContext ctx) {
        boolean result2;
        String operator = ctx.unaryOperator().getText();
        String wc = ctx.partialWildcardSemver().getText().replace(".x", "").replace(".X", "").replace(".*", "");
        Version partiallySpecifiedVersion = Version.fromString(wc);
        if (">".equals(operator)) {
            if (ctx.partialWildcardSemver().patch == null || ctx.partialWildcardSemver().minor == null) {
                if (ctx.partialWildcardSemver().patch == null) {
                    partiallySpecifiedVersion = partiallySpecifiedVersion.incrementMinor();
                }
                if (ctx.partialWildcardSemver().minor == null) {
                    partiallySpecifiedVersion = partiallySpecifiedVersion.incrementMajor();
                }
                result2 = this.fullySpecifiedComparisonVersion.compareTo(partiallySpecifiedVersion) >= 0;
            } else {
                result2 = this.fullySpecifiedComparisonVersion.compareTo(partiallySpecifiedVersion) > 0;
            }
        } else if (">=".equals(operator)) {
            result2 = this.fullySpecifiedComparisonVersion.compareTo(partiallySpecifiedVersion) >= 0 || this.matchesWildcard(ctx.partialWildcardSemver());
        } else if ("<".equals(operator)) {
            result2 = this.fullySpecifiedComparisonVersion.compareTo(partiallySpecifiedVersion) < 0;
        } else if ("<=".equals(operator)) {
            result2 = this.fullySpecifiedComparisonVersion.compareTo(partiallySpecifiedVersion) <= 0 || this.matchesWildcard(ctx.partialWildcardSemver());
        } else if ("=".equals(operator)) {
            result2 = this.fullySpecifiedComparisonVersion.compareTo(partiallySpecifiedVersion) == 0 || this.matchesWildcard(ctx.partialWildcardSemver());
        } else {
            return false;
        }
        if (this.fullySpecifiedComparisonVersion.getPreReleaseIdentifiers().size() > 0) {
            result2 = result2 && partiallySpecifiedVersion.getMajor() == this.fullySpecifiedComparisonVersion.getMajor() && partiallySpecifiedVersion.getMinor() == this.fullySpecifiedComparisonVersion.getMinor() && partiallySpecifiedVersion.getPatch() == this.fullySpecifiedComparisonVersion.getPatch() && partiallySpecifiedVersion.getPreReleaseIdentifiers().size() > 0;
        }
        return result2;
    }

    private boolean matchesWildcard(NodeSemverExpressionParser.PartialWildcardSemverContext partialWildcardSemverContext) {
        if (this.fullySpecifiedComparisonVersion.toString().trim().equals(partialWildcardSemverContext.getText().trim())) {
            return true;
        }
        if (this.fullySpecifiedComparisonVersion.getPreReleaseIdentifiers().size() > 0) {
            return false;
        }
        if (partialWildcardSemverContext.getText().trim().matches("^[*xX]$")) {
            return Boolean.TRUE;
        }
        boolean result2 = true;
        if (this.needsMatching(partialWildcardSemverContext.major)) {
            boolean bl = result2 = result2 && Integer.valueOf(partialWildcardSemverContext.major.getText()).intValue() == this.fullySpecifiedComparisonVersion.getMajor();
        }
        if (this.needsMatching(partialWildcardSemverContext.minor)) {
            boolean bl = result2 = result2 && Integer.valueOf(partialWildcardSemverContext.minor.getText()).intValue() == this.fullySpecifiedComparisonVersion.getMinor();
        }
        if (this.needsMatching(partialWildcardSemverContext.patch)) {
            result2 = result2 && Integer.valueOf(partialWildcardSemverContext.patch.getText()).intValue() == this.fullySpecifiedComparisonVersion.getPatch();
        }
        return result2;
    }

    @Override
    public Boolean visitWildcardOperator(NodeSemverExpressionParser.WildcardOperatorContext ctx) {
        return this.fullySpecifiedComparisonVersion.getPreReleaseIdentifiers().size() == 0;
    }

    @Override
    public Boolean visitFullySpecifiedSemver(NodeSemverExpressionParser.FullySpecifiedSemverContext ctx) {
        Version version2 = Version.fromString(ctx.getText());
        if (this.isEmpty(ctx.fullSemver().patch) && this.isEmpty(ctx.fullSemver().minor)) {
            return version2.getMajor() == this.fullySpecifiedComparisonVersion.getMajor() && this.fullySpecifiedComparisonVersion.getPreReleaseIdentifiers().size() == 0;
        }
        if (this.isEmpty(ctx.fullSemver().patch)) {
            return version2.getMajor() == this.fullySpecifiedComparisonVersion.getMajor() && version2.getMinor() == this.fullySpecifiedComparisonVersion.getMinor() && this.fullySpecifiedComparisonVersion.getPreReleaseIdentifiers().size() == 0;
        }
        return this.fullySpecifiedComparisonVersion.compareTo(version2) == 0;
    }

    @Override
    public Boolean visitWildcardRange(NodeSemverExpressionParser.WildcardRangeContext ctx) {
        return this.matchesWildcard(ctx.partialWildcardSemver());
    }

    private boolean needsMatching(NodeSemverExpressionParser.IntegerContext ctx) {
        String text = ctx != null ? ctx.getText() : null;
        return text != null && !"".equals(text);
    }

    private boolean isEmpty(NodeSemverExpressionParser.IntegerContext ctx) {
        return ctx == null || ctx.getText() == null || "".equals(ctx.getText());
    }

    @Override
    public Boolean visitTildeRange(NodeSemverExpressionParser.TildeRangeContext ctx) {
        Version left = Version.fromString(ctx.fullSemver().getText());
        Version right = this.isEmpty(ctx.fullSemver().minor) && this.isEmpty(ctx.fullSemver().patch) ? left.incrementMajor() : (this.isEmpty(ctx.fullSemver().patch) ? left.incrementMinor() : left.incrementMinor());
        if (SemVerRangeExpressionVisitor.majorMinorPatchMatch(left, this.fullySpecifiedComparisonVersion) && left.getPreReleaseIdentifiers().size() > 0) {
            return this.compareLeftInclusiveRightExclusive(left, right);
        }
        if (this.fullySpecifiedComparisonVersion.getPreReleaseIdentifiers().size() > 0) {
            return Boolean.FALSE;
        }
        return this.compareLeftInclusiveRightExclusive(left, right);
    }

    private boolean compareLeftInclusiveRightExclusive(Version left, Version right) {
        return this.fullySpecifiedComparisonVersion.compareTo(left) >= 0 && this.fullySpecifiedComparisonVersion.compareTo(right) < 0;
    }

    @Override
    public Boolean visitCaretRange(NodeSemverExpressionParser.CaretRangeContext ctx) {
        Version left = Version.fromString(ctx.fullSemver().getText());
        Version right = left.getMajor() == 0 && left.getMinor() == 0 ? left.incrementPatch() : (left.getMajor() == 0 ? left.incrementMinor() : left.incrementMajor());
        if (SemVerRangeExpressionVisitor.majorMinorPatchMatch(left, this.fullySpecifiedComparisonVersion) && left.getPreReleaseIdentifiers().size() > 0) {
            return this.compareLeftInclusiveRightExclusive(left, right);
        }
        if (this.fullySpecifiedComparisonVersion.getPreReleaseIdentifiers().size() > 0) {
            return Boolean.FALSE;
        }
        return this.compareLeftInclusiveRightExclusive(left, right);
    }

    private static boolean majorMinorPatchMatch(Version left, Version right) {
        return left.getMajor() == right.getMajor() && left.getMinor() == right.getMinor() && left.getPatch() == right.getPatch();
    }

    @Override
    public Boolean visitLogicalAndOfSimpleExpressions(NodeSemverExpressionParser.LogicalAndOfSimpleExpressionsContext ctx) {
        for (NodeSemverExpressionParser.SimpleContext simpleContext : ctx.simple()) {
            if (((Boolean)this.visit(simpleContext)).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitLogicalOrOfMultipleRanges(NodeSemverExpressionParser.LogicalOrOfMultipleRangesContext ctx) {
        for (NodeSemverExpressionParser.BasicRangeContext brc : ctx.basicRange()) {
            if (!((Boolean)this.visitBasicRange(brc)).booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

