/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.github.gundy.hidden.antlr.v4.runtime.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.kotlin.com.github.gundy.hidden.antlr.v4.runtime.misc.IntegerList;
import org.jetbrains.kotlin.com.github.gundy.hidden.antlr.v4.runtime.misc.IntervalSet;

public class Utils {
    public static <T> String join(Iterator<T> iter, String separator) {
        StringBuilder buf = new StringBuilder();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static <T> String join(T[] array2, String separator) {
        StringBuilder builder = new StringBuilder();
        for (int i2 = 0; i2 < array2.length; ++i2) {
            builder.append(array2[i2]);
            if (i2 >= array2.length - 1) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    public static int numNonnull(Object[] data) {
        int n = 0;
        if (data == null) {
            return n;
        }
        for (Object o : data) {
            if (o == null) continue;
            ++n;
        }
        return n;
    }

    public static <T> void removeAllElements(Collection<T> data, T value2) {
        if (data == null) {
            return;
        }
        while (data.contains(value2)) {
            data.remove(value2);
        }
    }

    public static String escapeWhitespace(String s, boolean escapeSpaces) {
        StringBuilder buf = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (c == ' ' && escapeSpaces) {
                buf.append('\u00b7');
                continue;
            }
            if (c == '\t') {
                buf.append("\\t");
                continue;
            }
            if (c == '\n') {
                buf.append("\\n");
                continue;
            }
            if (c == '\r') {
                buf.append("\\r");
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static void writeFile(String fileName, String content2) throws IOException {
        Utils.writeFile(fileName, content2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String fileName, String content2, String encoding) throws IOException {
        File f = new File(fileName);
        FileOutputStream fos = new FileOutputStream(f);
        OutputStreamWriter osw = encoding != null ? new OutputStreamWriter((OutputStream)fos, encoding) : new OutputStreamWriter(fos);
        try {
            osw.write(content2);
        }
        finally {
            osw.close();
        }
    }

    public static char[] readFile(String fileName) throws IOException {
        return Utils.readFile(fileName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readFile(String fileName, String encoding) throws IOException {
        File f = new File(fileName);
        int size = (int)f.length();
        FileInputStream fis = new FileInputStream(fileName);
        InputStreamReader isr = encoding != null ? new InputStreamReader((InputStream)fis, encoding) : new InputStreamReader(fis);
        char[] data = null;
        try {
            data = new char[size];
            int n = isr.read(data);
            if (n < data.length) {
                data = Arrays.copyOf(data, n);
            }
        }
        finally {
            isr.close();
        }
        return data;
    }

    public static Map<String, Integer> toMap(String[] keys) {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < keys.length; ++i2) {
            m.put(keys[i2], i2);
        }
        return m;
    }

    public static char[] toCharArray(IntegerList data) {
        if (data == null) {
            return null;
        }
        char[] cdata = new char[data.size()];
        for (int i2 = 0; i2 < data.size(); ++i2) {
            cdata[i2] = (char)data.get(i2);
        }
        return cdata;
    }

    public static IntervalSet toSet(BitSet bits) {
        IntervalSet s = new IntervalSet(new int[0]);
        int i2 = bits.nextSetBit(0);
        while (i2 >= 0) {
            s.add(i2);
            i2 = bits.nextSetBit(i2 + 1);
        }
        return s;
    }
}

