/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.internal;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.internal.HttpClientFactory;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.internal.InsecureHostnameVerifier;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.internal.InsecureTrustManager;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.commons.logging.impl.NoOpLog;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.HttpHost;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.client.HttpRequestRetryHandler;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.config.Registry;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.config.RegistryBuilder;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.conn.socket.ConnectionSocketFactory;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.impl.client.CloseableHttpClient;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.http.protocol.HttpContext;

public class DefaultHttpClientFactory
implements HttpClientFactory {
    private static String LOG_PROPERTY = "org.jetbrains.kotlin.de.undercouch.gradle.tasks.download.org.apache.commons.logging.Log";
    private static final HostnameVerifier INSECURE_HOSTNAME_VERIFIER = new InsecureHostnameVerifier();
    private static final TrustManager[] INSECURE_TRUST_MANAGERS = new TrustManager[]{new InsecureTrustManager()};
    private SSLConnectionSocketFactory insecureSSLSocketFactory = null;

    @Override
    public CloseableHttpClient createHttpClient(HttpHost httpHost, boolean acceptAnyCertificate, final int retries) {
        if (System.getProperty(LOG_PROPERTY) == null) {
            System.setProperty(LOG_PROPERTY, NoOpLog.class.getName());
        }
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (retries == 0) {
            builder.disableAutomaticRetries();
        } else {
            builder.setRetryHandler(new HttpRequestRetryHandler(){

                @Override
                public boolean retryRequest(IOException e, int i2, HttpContext httpContext) {
                    return retries < 0 || i2 <= retries;
                }
            });
        }
        builder.setRoutePlanner(new SystemDefaultRoutePlanner(null));
        if ("https".equals(httpHost.getSchemeName()) && acceptAnyCertificate) {
            SSLConnectionSocketFactory icsf = this.getInsecureSSLSocketFactory();
            builder.setSSLSocketFactory(icsf);
            Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("https", icsf).register("http", (SSLConnectionSocketFactory)((Object)PlainConnectionSocketFactory.INSTANCE)).build();
            BasicHttpClientConnectionManager cm = new BasicHttpClientConnectionManager(registry);
            builder.setConnectionManager(cm);
        }
        return builder.build();
    }

    private SSLConnectionSocketFactory getInsecureSSLSocketFactory() {
        if (this.insecureSSLSocketFactory == null) {
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, INSECURE_TRUST_MANAGERS, new SecureRandom());
                this.insecureSSLSocketFactory = new SSLConnectionSocketFactory(sc, INSECURE_HOSTNAME_VERIFIER);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return this.insecureSSLSocketFactory;
    }
}

