/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a8\u0006\u000f"}, d2={"copyZipFilePartially", "", "sourceZipFile", "Ljava/io/File;", "destinationZipFile", "path", "", "ensureValidZipDirectoryPath", "isValidZipDirectoryPath", "", "requireValidZipDirectoryPath", "listDescendants", "Lkotlin/sequences/Sequence;", "Ljava/util/zip/ZipEntry;", "Ljava/util/zip/ZipFile;", "kotlin-gradle-plugin"})
public final class ZipUtilsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyZipFilePartially(@NotNull File sourceZipFile, @NotNull File destinationZipFile, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)sourceZipFile, (String)"sourceZipFile");
        Intrinsics.checkNotNullParameter((Object)destinationZipFile, (String)"destinationZipFile");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ZipUtilsKt.requireValidZipDirectoryPath(path);
        Closeable closeable = new ZipFile(sourceZipFile);
        Throwable throwable = null;
        try {
            ZipFile zip = (ZipFile)closeable;
            boolean bl = false;
            List entries = SequencesKt.toList(ZipUtilsKt.listDescendants(zip, path));
            if (entries.isEmpty()) {
                return;
            }
            Closeable closeable2 = new ZipOutputStream(new FileOutputStream(destinationZipFile));
            Throwable throwable2 = null;
            try {
                ZipOutputStream destinationZipOutputStream = (ZipOutputStream)closeable2;
                boolean bl2 = false;
                Iterable $this$forEach$iv = entries;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ZipEntry sourceEntry = (ZipEntry)element$iv;
                    boolean bl3 = false;
                    String string = sourceEntry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourceEntry.name");
                    ZipEntry destinationEntry = new ZipEntry(StringsKt.substringAfter$default((String)string, (String)path, null, (int)2, null));
                    destinationZipOutputStream.putNextEntry(destinationEntry);
                    if (!sourceEntry.isDirectory()) {
                        Closeable closeable3 = zip.getInputStream(sourceEntry);
                        Throwable throwable3 = null;
                        try {
                            InputStream inputStream = (InputStream)closeable3;
                            boolean bl4 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
                            long l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)destinationZipOutputStream, (int)0, (int)2, null);
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                        }
                    }
                    destinationZipOutputStream.closeEntry();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final Sequence<ZipEntry> listDescendants(@NotNull ZipFile $this$listDescendants, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$listDescendants, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ZipUtilsKt.requireValidZipDirectoryPath(path);
        Enumeration<? extends ZipEntry> enumeration = $this$listDescendants.entries();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries()");
        Enumeration<? extends ZipEntry> enumeration2 = enumeration;
        return SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration2)), (Function1)((Function1)new Function1<ZipEntry, Boolean>(path){
            final /* synthetic */ String $path;
            {
                this.$path = $path;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(ZipEntry entry) {
                boolean bl;
                if (!Intrinsics.areEqual((Object)entry.getName(), (Object)this.$path)) {
                    String string = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
                    if (StringsKt.startsWith$default((String)string, (String)this.$path, (boolean)false, (int)2, null)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
    }

    @NotNull
    public static final String ensureValidZipDirectoryPath(@NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (ZipUtilsKt.isValidZipDirectoryPath(path)) {
            return path;
        }
        String p0 = string = path + '/';
        boolean bl = false;
        ZipUtilsKt.requireValidZipDirectoryPath(p0);
        return string;
    }

    private static final void requireValidZipDirectoryPath(String path) {
        boolean bl = ZipUtilsKt.isValidZipDirectoryPath(path);
        if (!bl) {
            boolean bl2 = false;
            String string = "Expected path to end with '/', found '" + path + '\'';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    private static final boolean isValidZipDirectoryPath(String path) {
        return ((CharSequence)path).length() == 0 || StringsKt.endsWith$default((String)path, (String)"/", (boolean)false, (int)2, null);
    }
}

