/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.statistics;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.task.TaskFailureResult;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationResult;
import org.gradle.tooling.events.task.TaskSkippedResult;
import org.gradle.tooling.events.task.TaskSuccessResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskExecutionResults;
import org.jetbrains.kotlin.gradle.plugin.stat.CompileStatData;
import org.jetbrains.kotlin.gradle.plugin.stat.ReportStatistics;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatListener;
import org.jetbrains.kotlin.gradle.plugin.statistics.TaskExecutionState;
import org.jetbrains.kotlin.gradle.report.TaskExecutionInfo;
import org.jetbrains.kotlin.gradle.report.TaskExecutionProperties;
import org.jetbrains.kotlin.gradle.report.TaskExecutionResult;
import org.jetbrains.kotlin.incremental.ChangedFiles;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0001%B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J \u0010 \u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000f\u0010\u000bR\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/KotlinBuildStatListener;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "Ljava/lang/AutoCloseable;", "projectName", "", "reportStatistics", "", "Lorg/jetbrains/kotlin/gradle/plugin/stat/ReportStatistics;", "(Ljava/lang/String;Ljava/util/List;)V", "buildUuid", "getBuildUuid", "()Ljava/lang/String;", "hostName", "getHostName", "label", "getLabel", "label$delegate", "Lkotlin/Lazy;", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getProjectName", "getReportStatistics", "()Ljava/util/List;", "availableForStat", "", "taskPath", "close", "", "onFinish", "event", "Lorg/gradle/tooling/events/FinishEvent;", "reportData", "duration", "", "taskResult", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/TaskExecutionState;", "Companion", "kotlin-gradle-plugin"})
public final class KotlinBuildStatListener
implements OperationCompletionListener,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String projectName;
    @NotNull
    private final List<ReportStatistics> reportStatistics;
    private final Logger log;
    @NotNull
    private final String buildUuid;
    @NotNull
    private final Lazy label$delegate;
    @Nullable
    private final String hostName;
    public static final int LIMIT_DURATION_MS = 5000;

    public KotlinBuildStatListener(@NotNull String projectName, @NotNull List<? extends ReportStatistics> reportStatistics) {
        String string;
        KotlinBuildStatListener kotlinBuildStatListener;
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter(reportStatistics, (String)"reportStatistics");
        this.projectName = projectName;
        this.reportStatistics = reportStatistics;
        this.log = Logging.getLogger(this.getClass());
        String string2 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUUID().toString()");
        this.buildUuid = string2;
        this.label$delegate = LazyKt.lazy((Function0)label.2.INSTANCE);
        KotlinBuildStatListener kotlinBuildStatListener2 = this;
        try {
            kotlinBuildStatListener = kotlinBuildStatListener2;
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            kotlinBuildStatListener = kotlinBuildStatListener2;
            string = null;
        }
        kotlinBuildStatListener.hostName = string;
    }

    @NotNull
    public final String getProjectName() {
        return this.projectName;
    }

    @NotNull
    public final List<ReportStatistics> getReportStatistics() {
        return this.reportStatistics;
    }

    @NotNull
    public final String getBuildUuid() {
        return this.buildUuid;
    }

    @Nullable
    public final String getLabel() {
        Lazy lazy = this.label$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getHostName() {
        return this.hostName;
    }

    public void onFinish(@Nullable FinishEvent event) {
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        if (event instanceof TaskFinishEvent) {
            TaskOperationResult result2 = ((TaskFinishEvent)event).getResult();
            String taskPath = ((TaskFinishEvent)event).getDescriptor().getTaskPath();
            long duration = result2.getEndTime() - result2.getStartTime();
            TaskOperationResult taskOperationResult = result2;
            TaskExecutionState taskResult = taskOperationResult instanceof TaskSuccessResult ? (((TaskSuccessResult)result2).isFromCache() ? TaskExecutionState.FROM_CACHE : (((TaskSuccessResult)result2).isUpToDate() ? TaskExecutionState.UP_TO_DATE : TaskExecutionState.SUCCESS)) : (taskOperationResult instanceof TaskSkippedResult ? TaskExecutionState.SKIPPED : (taskOperationResult instanceof TaskFailureResult ? TaskExecutionState.FAILED : TaskExecutionState.UNKNOWN));
            Intrinsics.checkNotNullExpressionValue((Object)taskPath, (String)"taskPath");
            this.reportData(taskPath, duration, taskResult);
        }
        long measuredTimeMs = System.currentTimeMillis() - start$iv;
        if (measuredTimeMs > 5000L) {
            this.log.warn("Exceed time limit for " + event + ". Takes " + measuredTimeMs + "ms ");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportData(String taskPath, long duration, TaskExecutionState taskResult) {
        Object object;
        List destination$iv$iv4;
        List list2;
        List list3;
        Collection collection;
        Collection collection2;
        Object $this$map$iv;
        ChangedFiles changedFiles;
        Map map;
        Iterator iterator;
        Object object2;
        Map timeData;
        Map map2;
        boolean $i$f$measureTimeMillisWithResult = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        if (!this.availableForStat(taskPath)) {
            return;
        }
        TaskExecutionResult taskExecutionResult = TaskExecutionResults.INSTANCE.get(taskPath);
        Object object3 = taskExecutionResult;
        if (object3 != null && (object3 = ((TaskExecutionResult)object3).getBuildMetrics()) != null && (object3 = object3.getBuildTimes()) != null && (object3 = object3.asMap()) != null) {
            Object $this$filterValues$iv = object3;
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            Object object4 = $this$filterValues$iv;
            for (Map.Entry string2 : object4.entrySet()) {
                long value = ((Number)string2.getValue()).longValue();
                boolean bl2 = false;
                if (!(value != 0L)) continue;
                result$iv.put(string2.getKey(), string2.getValue());
            }
            map2 = result$iv;
        } else {
            map2 = timeData = MapsKt.emptyMap();
        }
        if ((object2 = taskExecutionResult) != null && (object2 = ((TaskExecutionResult)object2).getBuildMetrics()) != null && (object2 = object2.getBuildPerformanceMetrics()) != null && (object2 = object2.asMap()) != null) {
            Object $this$filterValues$iv = object2;
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            iterator = $this$filterValues$iv;
            for (Map.Entry entry : iterator.entrySet()) {
                long value = ((Number)entry.getValue()).longValue();
                boolean bl3 = false;
                if (!(value != 0L)) continue;
                result$iv.put(entry.getKey(), entry.getValue());
            }
            map = result$iv;
        } else {
            map = MapsKt.emptyMap();
        }
        Map perfData = map;
        Object object4 = taskExecutionResult;
        ChangedFiles changedFiles2 = object4 != null && (object4 = ((TaskExecutionResult)object4).getTaskInfo()) != null ? ((TaskExecutionInfo)object4).getChangedFiles() : (changedFiles = null);
        if (changedFiles instanceof ChangedFiles.Known) {
            Object $this$mapTo$iv$iv;
            $this$map$iv = ((ChangedFiles.Known)changedFiles).getModified();
            boolean $i$f$map = false;
            Iterable $this$filterValues$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                File file = (File)t;
                collection2 = destination$iv$iv2;
                boolean bl4 = false;
                collection2.add(file.getAbsolutePath());
            }
            $this$map$iv = ((ChangedFiles.Known)changedFiles).getRemoved();
            collection2 = (List)destination$iv$iv2;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                File file = (File)t;
                collection = destination$iv$iv3;
                boolean bl5 = false;
                collection.add(file.getAbsolutePath());
            }
            list3 = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv3));
        } else if (changedFiles instanceof ChangedFiles.Dependencies) {
            $this$map$iv = ((ChangedFiles.Dependencies)changedFiles).getModified();
            boolean $i$f$map = false;
            Object $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                File file = (File)t;
                collection2 = destination$iv$iv3;
                boolean bl6 = false;
                collection2.add(file.getAbsolutePath());
            }
            $this$map$iv = ((ChangedFiles.Dependencies)changedFiles).getRemoved();
            collection2 = (List)destination$iv$iv3;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                File file = (File)t;
                collection = destination$iv$iv4;
                boolean bl7 = false;
                collection.add(file.getAbsolutePath());
            }
            list3 = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv4));
        } else {
            list3 = CollectionsKt.emptyList();
        }
        List changes = list3;
        $this$map$iv = taskResult.name();
        String $i$f$map = this.getLabel();
        String string = this.projectName;
        Object object5 = taskExecutionResult;
        if (object5 != null && (object5 = ((TaskExecutionResult)object5).getTaskInfo()) != null && (object5 = ((TaskExecutionInfo)object5).getProperties()) != null) {
            void $this$mapTo$iv$iv;
            Iterable iterable = (Iterable)object5;
            boolean $i$f$map2 = false;
            Iterable bl2 = iterable;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void it2;
                TaskExecutionProperties taskExecutionProperties = (TaskExecutionProperties)((Object)item$iv$iv2);
                collection2 = destination$iv$iv4;
                boolean bl8 = false;
                collection2.add(it2.name());
            }
            list2 = (List)destination$iv$iv4;
        } else {
            list2 = destination$iv$iv4 = CollectionsKt.emptyList();
        }
        if ((object = taskExecutionResult) == null || (object = ((TaskExecutionResult)object).getBuildMetrics()) == null || (object = object.getBuildAttributes()) == null || (object = object.asMap()) == null) {
            object = MapsKt.emptyMap();
        }
        Object $i$f$mapTo = object;
        iterator = this.hostName;
        String string2 = this.buildUuid;
        long l = System.currentTimeMillis();
        CompileStatData compileStatData = new CompileStatData(0, string, $i$f$map, taskPath, (String)$this$map$iv, duration, destination$iv$iv4, changes, string2, "1.6", (String)((Object)iterator), l, (Map)$i$f$mapTo, timeData, perfData, 1, null);
        Iterable $this$forEach$iv = this.reportStatistics;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ReportStatistics it3 = (ReportStatistics)element$iv;
            boolean bl9 = false;
            it3.report(compileStatData);
        }
        CompileStatData result$iv = compileStatData;
        Pair pair = new Pair((Object)(System.currentTimeMillis() - start$iv), (Object)result$iv);
        long reportDataDuration = ((Number)pair.component1()).longValue();
        CompileStatData compileStatData2 = (CompileStatData)pair.component2();
        this.log.debug("Report data takes " + reportDataDuration + ": " + compileStatData2);
    }

    private final boolean availableForStat(String taskPath) {
        return StringsKt.contains$default((CharSequence)taskPath, (CharSequence)"Kotlin", (boolean)false, (int)2, null) && TaskExecutionResults.INSTANCE.get(taskPath) != null;
    }

    @Override
    public void close() {
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/KotlinBuildStatListener$Companion;", "", "()V", "LIMIT_DURATION_MS", "", "kotlin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

