/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.statistics;

import java.io.File;
import javax.management.ObjectName;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.BuildResult;
import org.gradle.api.invocation.Gradle;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.invocation.DefaultGradle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.statistics.DaemonReuseCounter;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatHandler;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatsMXBean;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatsService;
import org.jetbrains.kotlin.statistics.BuildSessionLogger;
import org.jetbrains.kotlin.statistics.metrics.BooleanMetrics;
import org.jetbrains.kotlin.statistics.metrics.NumericalMetrics;
import org.jetbrains.kotlin.statistics.metrics.StringMetrics;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\"\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\"\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\"\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u001a2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\"\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\"\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\"\u0010 \u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u001a2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/DefaultKotlinBuildStatsService;", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/KotlinBuildStatsService;", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/KotlinBuildStatsMXBean;", "gradle", "Lorg/gradle/api/invocation/Gradle;", "beanName", "Ljavax/management/ObjectName;", "(Lorg/gradle/api/invocation/Gradle;Ljavax/management/ObjectName;)V", "getBeanName", "()Ljavax/management/ObjectName;", "sessionLogger", "Lorg/jetbrains/kotlin/statistics/BuildSessionLogger;", "buildFinished", "", "result", "Lorg/gradle/BuildResult;", "gradleBuildStartTime", "", "(Lorg/gradle/api/invocation/Gradle;)Ljava/lang/Long;", "projectsEvaluated", "report", "metric", "Lorg/jetbrains/kotlin/statistics/metrics/BooleanMetrics;", "value", "", "subprojectName", "", "Lorg/jetbrains/kotlin/statistics/metrics/NumericalMetrics;", "Lorg/jetbrains/kotlin/statistics/metrics/StringMetrics;", "reportBoolean", "name", "reportNumber", "reportString", "kotlin-gradle-plugin"})
public final class DefaultKotlinBuildStatsService
extends KotlinBuildStatsService
implements KotlinBuildStatsMXBean {
    @NotNull
    private final ObjectName beanName;
    @NotNull
    private final BuildSessionLogger sessionLogger;

    public DefaultKotlinBuildStatsService(@NotNull Gradle gradle, @NotNull ObjectName beanName) {
        Intrinsics.checkNotNullParameter((Object)gradle, (String)"gradle");
        Intrinsics.checkNotNullParameter((Object)beanName, (String)"beanName");
        this.beanName = beanName;
        File file = gradle.getGradleUserHomeDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"gradle.gradleUserHomeDir");
        this.sessionLogger = new BuildSessionLogger(file, 0, 0L, 0L, 14, null);
    }

    @NotNull
    public final ObjectName getBeanName() {
        return this.beanName;
    }

    private final Long gradleBuildStartTime(Gradle gradle) {
        DefaultGradle defaultGradle = gradle instanceof DefaultGradle ? (DefaultGradle)gradle : null;
        return defaultGradle != null && (defaultGradle = defaultGradle.getServices()) != null && (defaultGradle = (BuildRequestMetaData)defaultGradle.get(BuildRequestMetaData.class)) != null ? Long.valueOf(defaultGradle.getStartTime()) : null;
    }

    public void projectsEvaluated(@NotNull Gradle gradle) {
        Intrinsics.checkNotNullParameter((Object)gradle, (String)"gradle");
        KotlinBuildStatHandler.Companion.runSafe$kotlin_gradle_plugin(DefaultKotlinBuildStatsService.class + ".projectEvaluated", (Function0)new Function0<Unit>(this, gradle){
            final /* synthetic */ DefaultKotlinBuildStatsService this$0;
            final /* synthetic */ Gradle $gradle;
            {
                this.this$0 = $receiver;
                this.$gradle = $gradle;
                super(0);
            }

            public final void invoke() {
                if (!DefaultKotlinBuildStatsService.access$getSessionLogger$p(this.this$0).isBuildSessionStarted()) {
                    DefaultKotlinBuildStatsService.access$getSessionLogger$p(this.this$0).startBuildSession(DaemonReuseCounter.Companion.incrementAndGetOrdinal(), DefaultKotlinBuildStatsService.access$gradleBuildStartTime(this.this$0, this.$gradle));
                }
            }
        });
    }

    public synchronized void buildFinished(@NotNull BuildResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        new KotlinBuildStatHandler().buildFinished(result2.getGradle(), this.beanName, this.sessionLogger, result2.getAction(), result2.getFailure());
        KotlinBuildStatsService.Companion.setInstance$kotlin_gradle_plugin(null);
    }

    @Override
    public void report(@NotNull BooleanMetrics metric, boolean value, @Nullable String subprojectName) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        new KotlinBuildStatHandler().report$kotlin_gradle_plugin(this.sessionLogger, metric, value, subprojectName);
    }

    @Override
    public void report(@NotNull NumericalMetrics metric, long value, @Nullable String subprojectName) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        new KotlinBuildStatHandler().report$kotlin_gradle_plugin(this.sessionLogger, metric, value, subprojectName);
    }

    @Override
    public void report(@NotNull StringMetrics metric, @NotNull String value, @Nullable String subprojectName) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        new KotlinBuildStatHandler().report$kotlin_gradle_plugin(this.sessionLogger, metric, value, subprojectName);
    }

    @Override
    public void reportBoolean(@NotNull String name2, boolean value, @Nullable String subprojectName) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.report(BooleanMetrics.valueOf(name2), value, subprojectName);
    }

    @Override
    public void reportNumber(@NotNull String name2, long value, @Nullable String subprojectName) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.report(NumericalMetrics.valueOf(name2), value, subprojectName);
    }

    @Override
    public void reportString(@NotNull String name2, @NotNull String value, @Nullable String subprojectName) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.report(StringMetrics.valueOf(name2), value, subprojectName);
    }

    public static final /* synthetic */ BuildSessionLogger access$getSessionLogger$p(DefaultKotlinBuildStatsService $this) {
        return $this.sessionLogger;
    }

    public static final /* synthetic */ Long access$gradleBuildStartTime(DefaultKotlinBuildStatsService $this, Gradle gradle) {
        return $this.gradleBuildStartTime(gradle);
    }
}

