/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp;

import java.io.Closeable;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.mpp.CompositeMetadataJar;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinProjectStructureMetadata;
import org.jetbrains.kotlin.gradle.plugin.mpp.SourceSetMetadataLayout;
import org.jetbrains.kotlin.gradle.utils.ZipUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0003H\u0002J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0011H\u0016R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataJarImpl;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/CompositeMetadataJar;", "moduleIdentifier", "", "projectStructureMetadata", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinProjectStructureMetadata;", "primaryArtifactFile", "Ljava/io/File;", "hostSpecificArtifactsBySourceSet", "", "(Ljava/lang/String;Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinProjectStructureMetadata;Ljava/io/File;Ljava/util/Map;)V", "getArtifactFile", "sourceSetName", "getSourceSetCInteropMetadata", "", "outputDirectory", "materializeFiles", "", "getSourceSetCompiledMetadata", "materializeFile", "kotlin-gradle-plugin"})
final class CompositeMetadataJarImpl
implements CompositeMetadataJar {
    @NotNull
    private final String moduleIdentifier;
    @NotNull
    private final KotlinProjectStructureMetadata projectStructureMetadata;
    @NotNull
    private final File primaryArtifactFile;
    @NotNull
    private final Map<String, File> hostSpecificArtifactsBySourceSet;

    public CompositeMetadataJarImpl(@NotNull String moduleIdentifier, @NotNull KotlinProjectStructureMetadata projectStructureMetadata, @NotNull File primaryArtifactFile, @NotNull Map<String, ? extends File> hostSpecificArtifactsBySourceSet) {
        Intrinsics.checkNotNullParameter((Object)moduleIdentifier, (String)"moduleIdentifier");
        Intrinsics.checkNotNullParameter((Object)projectStructureMetadata, (String)"projectStructureMetadata");
        Intrinsics.checkNotNullParameter((Object)primaryArtifactFile, (String)"primaryArtifactFile");
        Intrinsics.checkNotNullParameter(hostSpecificArtifactsBySourceSet, (String)"hostSpecificArtifactsBySourceSet");
        this.moduleIdentifier = moduleIdentifier;
        this.projectStructureMetadata = projectStructureMetadata;
        this.primaryArtifactFile = primaryArtifactFile;
        this.hostSpecificArtifactsBySourceSet = hostSpecificArtifactsBySourceSet;
    }

    @Override
    @NotNull
    public File getSourceSetCompiledMetadata(@NotNull String sourceSetName, @NotNull File outputDirectory2, boolean materializeFile) {
        File file;
        Intrinsics.checkNotNullParameter((Object)sourceSetName, (String)"sourceSetName");
        Intrinsics.checkNotNullParameter((Object)outputDirectory2, (String)"outputDirectory");
        File artifactFile = this.getArtifactFile(sourceSetName);
        File it = file = FilesKt.resolve((File)outputDirectory2, (String)this.moduleIdentifier);
        boolean bl = false;
        it.mkdirs();
        File moduleOutputDirectory = file;
        Object object = this.projectStructureMetadata.getSourceSetBinaryLayout().get(sourceSetName);
        if (object == null || (object = ((SourceSetMetadataLayout)object).getArchiveExtension()) == null) {
            object = SourceSetMetadataLayout.METADATA.INSTANCE.getArchiveExtension();
        }
        Object extension = object;
        File metadataOutputFile = FilesKt.resolve((File)moduleOutputDirectory, (String)(this.moduleIdentifier + '-' + sourceSetName + '.' + (String)extension));
        if (!artifactFile.isFile()) {
            return metadataOutputFile;
        }
        if (!materializeFile) {
            return metadataOutputFile;
        }
        if (metadataOutputFile.exists()) {
            metadataOutputFile.delete();
        }
        ZipUtilsKt.copyZipFilePartially(artifactFile, metadataOutputFile, sourceSetName + '/');
        return metadataOutputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<File> getSourceSetCInteropMetadata(@NotNull String sourceSetName, @NotNull File outputDirectory2, boolean materializeFiles) {
        Intrinsics.checkNotNullParameter((Object)sourceSetName, (String)"sourceSetName");
        Intrinsics.checkNotNullParameter((Object)outputDirectory2, (String)"outputDirectory");
        File artifactFile = this.getArtifactFile(sourceSetName);
        Object object = FilesKt.resolve((File)outputDirectory2, (String)this.moduleIdentifier);
        File p0 = object;
        boolean bl = false;
        p0.mkdirs();
        File moduleOutputDirectory = object;
        object = new ZipFile(this.getArtifactFile(sourceSetName));
        Throwable throwable = null;
        try {
            String cinteropName;
            void $this$associateByTo$iv$iv;
            String string;
            ZipFile artifactZipFile = (ZipFile)object;
            boolean bl2 = false;
            if (this.projectStructureMetadata.getSourceSetCInteropMetadataDirectory().get(sourceSetName) == null) {
                Set set2 = SetsKt.emptySet();
                return set2;
            }
            String cinteropMetadataDirectory = string;
            String cinteropMetadataDirectoryPath = ZipUtilsKt.ensureValidZipDirectoryPath(cinteropMetadataDirectory);
            Sequence<ZipEntry> cinteropEntries = ZipUtilsKt.listDescendants(artifactZipFile, cinteropMetadataDirectoryPath);
            Set cinteropNames2 = SequencesKt.toSet((Sequence)SequencesKt.map(cinteropEntries, (Function1)((Function1)new Function1<ZipEntry, String>(cinteropMetadataDirectoryPath){
                final /* synthetic */ String $cinteropMetadataDirectoryPath;
                {
                    this.$cinteropMetadataDirectoryPath = $cinteropMetadataDirectoryPath;
                    super(1);
                }

                @NotNull
                public final String invoke(@NotNull ZipEntry entry) {
                    Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                    String string = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
                    String[] stringArray = new String[]{"/"};
                    return (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)string, (CharSequence)this.$cinteropMetadataDirectoryPath), (String[])stringArray, (boolean)false, (int)2, (int)2, null));
                }
            })));
            Iterable $this$associateBy$iv = cinteropNames2;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Object object2 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                String string2 = (String)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl3 = false;
                map.put(FilesKt.resolve((File)moduleOutputDirectory, (String)(cinteropName + ".klib")), element$iv$iv);
            }
            Map cinteropsByOutputFile = destination$iv$iv;
            if (materializeFiles) {
                Map $this$forEach$iv = cinteropsByOutputFile;
                boolean $i$f$forEach = false;
                Map map = $this$forEach$iv;
                object2 = map.entrySet().iterator();
                while (object2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = (Map.Entry)object2.next();
                    boolean bl4 = false;
                    File cinteropOutputFile = (File)entry.getKey();
                    cinteropName = (String)entry.getValue();
                    ZipUtilsKt.copyZipFilePartially(artifactFile, cinteropOutputFile, cinteropMetadataDirectoryPath + cinteropName + '/');
                }
            }
            Set<File> set3 = cinteropsByOutputFile.keySet();
            return set3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private final File getArtifactFile(String sourceSetName) {
        File file = this.hostSpecificArtifactsBySourceSet.get(sourceSetName);
        if (file == null) {
            file = this.primaryArtifactFile;
        }
        return file;
    }
}

