/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal;

import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.AndroidExtensionsExtension;
import org.jetbrains.kotlin.gradle.internal.AndroidSubplugin;
import org.jetbrains.kotlin.gradle.model.builder.KotlinAndroidExtensionModelBuilder;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/AndroidExtensionsSubpluginIndicator;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "registry", "Lorg/gradle/tooling/provider/model/ToolingModelBuilderRegistry;", "(Lorg/gradle/tooling/provider/model/ToolingModelBuilderRegistry;)V", "addAndroidExtensionsRuntime", "", "project", "apply", "kotlin-gradle-plugin"})
public final class AndroidExtensionsSubpluginIndicator
implements Plugin<Project> {
    @NotNull
    private final ToolingModelBuilderRegistry registry;

    @Inject
    public AndroidExtensionsSubpluginIndicator(@NotNull ToolingModelBuilderRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.registry = registry;
    }

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.getExtensions().create("androidExtensions", AndroidExtensionsExtension.class, new Object[0]);
        this.addAndroidExtensionsRuntime(project);
        this.registry.register((ToolingModelBuilder)new KotlinAndroidExtensionModelBuilder());
        project.getPlugins().apply(AndroidSubplugin.class);
        project.getLogger().warn("Warning: The 'kotlin-android-extensions' Gradle plugin is deprecated. Please use this migration guide (https://goo.gle/kotlin-android-extensions-deprecation) to start working with View Binding (https://developer.android.com/topic/libraries/view-binding) and the 'kotlin-parcelize' plugin.");
    }

    private final void addAndroidExtensionsRuntime(Project project) {
        String kotlinPluginVersion2 = KotlinPluginWrapperKt.getKotlinPluginVersion(project);
        project.getConfigurations().all(new Action(project, kotlinPluginVersion2){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $kotlinPluginVersion;
            {
                this.$project = $project;
                this.$kotlinPluginVersion = $kotlinPluginVersion;
            }

            public final void execute(Configuration configuration2) {
                String requiredConfigurationName;
                String name2 = configuration2.getName();
                if (!Intrinsics.areEqual((Object)name2, (Object)"implementation") && !Intrinsics.areEqual((Object)name2, (Object)"compile")) {
                    return;
                }
                if (KotlinPluginKt.getAndroidPluginVersion() == null) {
                    return;
                }
                String string = requiredConfigurationName = KotlinPluginKt.compareVersionNumbers(KotlinPluginKt.getAndroidPluginVersion(), "2.5") > 0 ? "implementation" : "compile";
                if (!Intrinsics.areEqual((Object)name2, (Object)requiredConfigurationName)) {
                    return;
                }
                configuration2.getDependencies().add((Object)this.$project.getDependencies().create((Object)("org.jetbrains.kotlin:kotlin-android-extensions-runtime:" + this.$kotlinPluginVersion)));
            }
        });
    }
}

