/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.statistics;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Base64;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.gson.Gson;
import org.jetbrains.kotlin.gradle.plugin.stat.CompileStatData;
import org.jetbrains.kotlin.gradle.plugin.stat.ReportStatistics;
import org.jetbrains.kotlin.gradle.plugin.statistics.ReportStatisticsToElasticSearch;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001d\u0010\t\u001a\u0004\u0018\u00010\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u000e\u001a\u0004\u0018\u00010\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\b\u001a\u0004\b\u000f\u0010\fR\u001d\u0010\u0011\u001a\u0004\u0018\u00010\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\b\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/ReportStatisticsToElasticSearch;", "Lorg/jetbrains/kotlin/gradle/plugin/stat/ReportStatistics;", "()V", "enable", "", "getEnable", "()Z", "enable$delegate", "Lkotlin/Lazy;", "password", "", "getPassword", "()Ljava/lang/String;", "password$delegate", "url", "getUrl", "url$delegate", "user", "getUser", "user$delegate", "checkResponseAndLog", "", "connection", "Ljava/net/HttpURLConnection;", "report", "data", "Lorg/jetbrains/kotlin/gradle/plugin/stat/CompileStatData;", "kotlin-gradle-plugin"})
public final class ReportStatisticsToElasticSearch
implements ReportStatistics {
    @NotNull
    public static final ReportStatisticsToElasticSearch INSTANCE = new ReportStatisticsToElasticSearch();
    @NotNull
    private static final Lazy url$delegate = LazyKt.lazy((Function0)url.2.INSTANCE);
    @NotNull
    private static final Lazy user$delegate = LazyKt.lazy((Function0)user.2.INSTANCE);
    @NotNull
    private static final Lazy enable$delegate = LazyKt.lazy((Function0)enable.2.INSTANCE);
    @NotNull
    private static final Lazy password$delegate = LazyKt.lazy((Function0)password.2.INSTANCE);

    private ReportStatisticsToElasticSearch() {
    }

    @Nullable
    public final String getUrl() {
        Lazy lazy = url$delegate;
        Object var2_2 = null;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getUser() {
        Lazy lazy = user$delegate;
        Object var2_2 = null;
        return (String)lazy.getValue();
    }

    public final boolean getEnable() {
        Lazy lazy = enable$delegate;
        Object var2_2 = null;
        return (Boolean)lazy.getValue();
    }

    @Nullable
    public final String getPassword() {
        Lazy lazy = password$delegate;
        Object var2_2 = null;
        return (String)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(@NotNull CompileStatData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!this.getEnable()) {
            return;
        }
        URLConnection uRLConnection = new URL(this.getUrl()).openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        try {
            Object object;
            Object object2;
            Closeable it2;
            Object auth;
            Object object3;
            String string;
            if (this.getUser() != null && this.getPassword() != null) {
                boolean bl = false;
                Base64.Encoder encoder = Base64.getEncoder();
                string = this.getUser() + ':' + this.getPassword();
                Charset charset = Charsets.UTF_8;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string2.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                object3 = encoder.encode(byArray);
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getEncoder()\n           \u2026$password\".toByteArray())");
                auth = new String((byte[])object3, Charsets.UTF_8);
                connection.addRequestProperty("Authorization", Intrinsics.stringPlus((String)"Basic ", (Object)auth));
            }
            connection.addRequestProperty("Content-Type", "application/json");
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            auth = connection.getOutputStream();
            object3 = null;
            try {
                it2 = (OutputStream)auth;
                boolean bl = false;
                object2 = new Gson().toJson(data);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"Gson().toJson(data)");
                object = Charsets.UTF_8;
                byte[] byArray = ((String)object2).getBytes((Charset)object);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                it2.write(byArray);
                it2 = Unit.INSTANCE;
            }
            catch (Throwable it2) {
                object3 = it2;
                throw it2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)auth, (Throwable)object3);
            }
            connection.connect();
            this.checkResponseAndLog(connection);
            auth = connection.getInputStream();
            object3 = null;
            try {
                String string3;
                it2 = (InputStream)auth;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                object2 = it2;
                object = Charsets.UTF_8;
                object2 = new InputStreamReader((InputStream)object2, (Charset)object);
                object = null;
                try {
                    InputStreamReader reader = (InputStreamReader)object2;
                    boolean bl2 = false;
                    string3 = TextStreamsKt.readText((Reader)reader);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
                }
                string = string3;
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)auth, (Throwable)object3);
            }
        }
        catch (Exception e) {
            this.checkResponseAndLog(connection);
        }
        finally {
            connection.disconnect();
        }
    }

    private final void checkResponseAndLog(HttpURLConnection connection) {
        boolean isResponseBad;
        int n = connection.getResponseCode();
        boolean bl = isResponseBad = !(200 <= n ? n < 300 : false);
        if (isResponseBad) {
            throw new Exception("Failed to send statistic to " + connection.getURL() + ": " + connection.getResponseMessage());
        }
    }
}

