/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.jvm.tasks.Jar;
import org.gradle.workers.WorkQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArgumentsKt;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2MetadataCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.compilerRunner.ArgumentUtils;
import org.jetbrains.kotlin.compilerRunner.GradleCompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.GradleKotlinCompilerWork;
import org.jetbrains.kotlin.compilerRunner.GradleKotlinCompilerWorkArguments;
import org.jetbrains.kotlin.compilerRunner.IncrementalCompilationEnvironment;
import org.jetbrains.kotlin.compilerRunner.KotlinCompilerRunnerUtils;
import org.jetbrains.kotlin.compilerRunner.ProjectFilesForCompilation;
import org.jetbrains.kotlin.compilerRunner.ReportUtilsKt;
import org.jetbrains.kotlin.daemon.client.CompileServiceSession;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.RestPropMapper;
import org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.incremental.IncrementalModuleInfoProvider;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskLoggers;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinWithJavaTarget;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatsService;
import org.jetbrains.kotlin.gradle.tasks.AbstractKotlinCompile;
import org.jetbrains.kotlin.gradle.tasks.GradleCompileTaskProvider;
import org.jetbrains.kotlin.gradle.tasks.InspectClassesForMultiModuleIC;
import org.jetbrains.kotlin.gradle.tasks.Kotlin2JsCompile;
import org.jetbrains.kotlin.gradle.tasks.TaskOutputsBackup;
import org.jetbrains.kotlin.gradle.utils.CompatibiltiyKt;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;
import org.jetbrains.kotlin.incremental.IncrementalModuleEntry;
import org.jetbrains.kotlin.incremental.IncrementalModuleInfo;
import org.jetbrains.kotlin.statistics.metrics.BooleanMetrics;
import org.jetbrains.kotlin.statistics.metrics.IStatisticsValuesConsumer;
import org.jetbrains.kotlin.statistics.metrics.StringMetrics;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 A2\u00020\u0001:\u0001AB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ.\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/H\u0002J\u001c\u0010'\u001a\u0004\u0018\u00010(2\u0006\u00100\u001a\u0002012\b\u0010.\u001a\u0004\u0018\u00010/H\u0014J>\u00102\u001a\u0004\u0018\u00010(2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u00105\u001a\u0002062\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/J^\u00107\u001a\u0004\u0018\u00010(2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00050;2\b\u0010<\u001a\u0004\u0018\u00010\b2\u0006\u00105\u001a\u00020=2\u0006\u0010,\u001a\u00020-2\u0006\u0010>\u001a\u00020\u00052\b\u0010.\u001a\u0004\u0018\u00010/J&\u0010?\u001a\u0004\u0018\u00010(2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u00105\u001a\u00020@2\u0006\u0010,\u001a\u00020-R\u001c\u0010\n\u001a\n \u000b*\u0004\u0018\u00010\u00050\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u001c\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\n \u000b*\u0004\u0018\u00010\u00170\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\n \u000b*\u0004\u0018\u00010\b0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\n \u000b*\u0004\u0018\u00010\u00050\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\rR\u001c\u0010\u001f\u001a\n \u000b*\u0004\u0018\u00010\b0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u001c\u0010!\u001a\n \u000b*\u0004\u0018\u00010\u00050\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\rR\u001c\u0010#\u001a\n \u000b*\u0004\u0018\u00010\u00050\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerRunner;", "", "taskProvider", "Lorg/jetbrains/kotlin/gradle/tasks/GradleCompileTaskProvider;", "jdkToolsJar", "Ljava/io/File;", "kotlinDaemonJvmArgs", "", "", "(Lorg/jetbrains/kotlin/gradle/tasks/GradleCompileTaskProvider;Ljava/io/File;Ljava/util/List;)V", "buildDirProvider", "kotlin.jvm.PlatformType", "getBuildDirProvider$kotlin_gradle_plugin", "()Ljava/io/File;", "incrementalModuleInfoProvider", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/incremental/IncrementalModuleInfoProvider;", "getIncrementalModuleInfoProvider$kotlin_gradle_plugin", "()Lorg/gradle/api/provider/Provider;", "getJdkToolsJar", "getKotlinDaemonJvmArgs", "()Ljava/util/List;", "loggerProvider", "Lorg/gradle/api/logging/Logger;", "getLoggerProvider$kotlin_gradle_plugin", "()Lorg/gradle/api/logging/Logger;", "pathProvider", "getPathProvider$kotlin_gradle_plugin", "()Ljava/lang/String;", "projectDirProvider", "getProjectDirProvider$kotlin_gradle_plugin", "projectNameProvider", "getProjectNameProvider$kotlin_gradle_plugin", "projectRootDirProvider", "getProjectRootDirProvider$kotlin_gradle_plugin", "sessionDirProvider", "getSessionDirProvider$kotlin_gradle_plugin", "getTaskProvider", "()Lorg/jetbrains/kotlin/gradle/tasks/GradleCompileTaskProvider;", "runCompilerAsync", "Lorg/gradle/workers/WorkQueue;", "compilerClassName", "compilerArgs", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "environment", "Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerEnvironment;", "taskOutputsBackup", "Lorg/jetbrains/kotlin/gradle/tasks/TaskOutputsBackup;", "workArgs", "Lorg/jetbrains/kotlin/compilerRunner/GradleKotlinCompilerWorkArguments;", "runJsCompilerAsync", "kotlinSources", "kotlinCommonSources", "args", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "runJvmCompilerAsync", "sourcesToCompile", "commonSources", "javaSourceRoots", "", "javaPackagePrefix", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "jdkHome", "runMetadataCompilerAsync", "Lorg/jetbrains/kotlin/cli/common/arguments/K2MetadataCompilerArguments;", "Companion", "kotlin-gradle-plugin"})
public class GradleCompilerRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GradleCompileTaskProvider taskProvider;
    @Nullable
    private final File jdkToolsJar;
    @Nullable
    private final List<String> kotlinDaemonJvmArgs;
    private final String pathProvider;
    private final Logger loggerProvider;
    private final File buildDirProvider;
    private final File projectDirProvider;
    private final File projectRootDirProvider;
    private final File sessionDirProvider;
    private final String projectNameProvider;
    @NotNull
    private final Provider<? extends IncrementalModuleInfoProvider> incrementalModuleInfoProvider;
    @NotNull
    private static volatile WeakReference<Gradle> cachedGradle = new WeakReference<Object>(null);
    @Nullable
    private static volatile IncrementalModuleInfo cachedModulesInfo;
    @Nullable
    private static volatile File clientIsAliveFlagFile;
    @Nullable
    private static volatile File sessionFlagFile;

    public GradleCompilerRunner(@NotNull GradleCompileTaskProvider taskProvider, @Nullable File jdkToolsJar, @Nullable List<String> kotlinDaemonJvmArgs2) {
        Intrinsics.checkNotNullParameter((Object)taskProvider, (String)"taskProvider");
        this.taskProvider = taskProvider;
        this.jdkToolsJar = jdkToolsJar;
        this.kotlinDaemonJvmArgs = kotlinDaemonJvmArgs2;
        this.pathProvider = (String)this.taskProvider.getPath().get();
        this.loggerProvider = (Logger)this.taskProvider.getLogger().get();
        this.buildDirProvider = ((Directory)this.taskProvider.getBuildDir().get()).getAsFile();
        this.projectDirProvider = (File)this.taskProvider.getProjectDir().get();
        this.projectRootDirProvider = (File)this.taskProvider.getRootDir().get();
        this.sessionDirProvider = (File)this.taskProvider.getSessionsDir().get();
        this.projectNameProvider = (String)this.taskProvider.getProjectName().get();
        this.incrementalModuleInfoProvider = this.taskProvider.getBuildModulesInfo();
    }

    @NotNull
    protected final GradleCompileTaskProvider getTaskProvider() {
        return this.taskProvider;
    }

    @Nullable
    protected final File getJdkToolsJar() {
        return this.jdkToolsJar;
    }

    @Nullable
    protected final List<String> getKotlinDaemonJvmArgs() {
        return this.kotlinDaemonJvmArgs;
    }

    public final String getPathProvider$kotlin_gradle_plugin() {
        return this.pathProvider;
    }

    public final Logger getLoggerProvider$kotlin_gradle_plugin() {
        return this.loggerProvider;
    }

    public final File getBuildDirProvider$kotlin_gradle_plugin() {
        return this.buildDirProvider;
    }

    public final File getProjectDirProvider$kotlin_gradle_plugin() {
        return this.projectDirProvider;
    }

    public final File getProjectRootDirProvider$kotlin_gradle_plugin() {
        return this.projectRootDirProvider;
    }

    public final File getSessionDirProvider$kotlin_gradle_plugin() {
        return this.sessionDirProvider;
    }

    public final String getProjectNameProvider$kotlin_gradle_plugin() {
        return this.projectNameProvider;
    }

    @NotNull
    public final Provider<? extends IncrementalModuleInfoProvider> getIncrementalModuleInfoProvider$kotlin_gradle_plugin() {
        return this.incrementalModuleInfoProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final WorkQueue runJvmCompilerAsync(@NotNull List<? extends File> sourcesToCompile, @NotNull List<? extends File> commonSources, @NotNull Iterable<? extends File> javaSourceRoots, @Nullable String javaPackagePrefix, @NotNull K2JVMCompilerArguments args, @NotNull GradleCompilerEnvironment environment, @NotNull File jdkHome, @Nullable TaskOutputsBackup taskOutputsBackup) {
        Iterable<? extends File> $this$toTypedArray$iv;
        File it;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkNotNullParameter(sourcesToCompile, (String)"sourcesToCompile");
        Intrinsics.checkNotNullParameter(commonSources, (String)"commonSources");
        Intrinsics.checkNotNullParameter(javaSourceRoots, (String)"javaSourceRoots");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        Intrinsics.checkNotNullParameter((Object)jdkHome, (String)"jdkHome");
        Object object2 = args;
        Iterable iterable = sourcesToCompile;
        Collection collection = object2.getFreeArgs();
        K2JVMCompilerArguments k2JVMCompilerArguments = object2;
        boolean $i$f$map22 = false;
        void var12_16 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it2;
            File file = (File)item$iv$iv2;
            object = destination$iv$iv;
            boolean bl = false;
            String string = it2.getAbsolutePath();
            object.add(string);
        }
        object = (List)destination$iv$iv;
        k2JVMCompilerArguments.setFreeArgs(CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object)));
        object2 = commonSources;
        k2JVMCompilerArguments = args;
        boolean $i$f$map = false;
        void $i$f$map22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object item$iv$iv2;
            item$iv$iv2 = (File)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            object = it.getAbsolutePath();
            collection.add(object);
        }
        $this$map$iv = collection = (List)destination$iv$iv2;
        boolean $i$f$toTypedArray = false;
        Iterable<Object> thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        k2JVMCompilerArguments.setCommonSources(stringArray);
        $this$toTypedArray$iv = javaSourceRoots;
        k2JVMCompilerArguments = args;
        $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            object = it.getAbsolutePath();
            collection.add(object);
        }
        $this$map$iv = collection = (List)destination$iv$iv2;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        k2JVMCompilerArguments.setJavaSourceRoots(stringArray2);
        args.setJavaPackagePrefix(javaPackagePrefix);
        if (args.getJdkHome() == null && !args.getNoJdk()) {
            args.setJdkHome(jdkHome.getAbsolutePath());
        }
        object2 = this.loggerProvider;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"loggerProvider");
        GradleLoggingUtilsKt.kotlinInfo((Logger)object2, Intrinsics.stringPlus((String)"Kotlin compilation 'jdkHome' argument: ", (Object)args.getJdkHome()));
        return this.runCompilerAsync("org.jetbrains.kotlin.cli.jvm.K2JVMCompiler", (CommonCompilerArguments)args, environment, taskOutputsBackup);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final WorkQueue runJsCompilerAsync(@NotNull List<? extends File> kotlinSources, @NotNull List<? extends File> kotlinCommonSources, @NotNull K2JSCompilerArguments args, @NotNull GradleCompilerEnvironment environment, @Nullable TaskOutputsBackup taskOutputsBackup) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkNotNullParameter(kotlinSources, (String)"kotlinSources");
        Intrinsics.checkNotNullParameter(kotlinCommonSources, (String)"kotlinCommonSources");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        Object object2 = args;
        Iterable iterable = kotlinSources;
        Collection collection = object2.getFreeArgs();
        K2JSCompilerArguments k2JSCompilerArguments = object2;
        boolean $i$f$map22 = false;
        void var9_13 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it;
            File file = (File)item$iv$iv2;
            object = destination$iv$iv;
            boolean bl = false;
            String string = it.getAbsolutePath();
            object.add(string);
        }
        object = (List)destination$iv$iv;
        k2JSCompilerArguments.setFreeArgs(CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object)));
        object2 = kotlinCommonSources;
        k2JSCompilerArguments = args;
        boolean $i$f$map = false;
        void $i$f$map22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object item$iv$iv2;
            item$iv$iv2 = (File)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            object = it.getAbsolutePath();
            collection.add(object);
        }
        $this$map$iv = collection = (List)destination$iv$iv2;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        k2JSCompilerArguments.setCommonSources(stringArray);
        return this.runCompilerAsync("org.jetbrains.kotlin.cli.js.K2JSCompiler", (CommonCompilerArguments)args, environment, taskOutputsBackup);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final WorkQueue runMetadataCompilerAsync(@NotNull List<? extends File> kotlinSources, @NotNull K2MetadataCompilerArguments args, @NotNull GradleCompilerEnvironment environment) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(kotlinSources, (String)"kotlinSources");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        K2MetadataCompilerArguments k2MetadataCompilerArguments = args;
        Iterable iterable = kotlinSources;
        Collection collection2 = k2MetadataCompilerArguments.getFreeArgs();
        K2MetadataCompilerArguments k2MetadataCompilerArguments2 = k2MetadataCompilerArguments;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getAbsolutePath();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        k2MetadataCompilerArguments2.setFreeArgs(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
        return GradleCompilerRunner.runCompilerAsync$default(this, "org.jetbrains.kotlin.cli.metadata.K2MetadataCompiler", (CommonCompilerArguments)args, environment, null, 8, null);
    }

    private final WorkQueue runCompilerAsync(String compilerClassName, CommonCompilerArguments compilerArgs, GradleCompilerEnvironment environment, TaskOutputsBackup taskOutputsBackup) {
        Object object;
        IncrementalModuleInfo incrementalModuleInfo;
        if (compilerArgs.getVersion()) {
            this.loggerProvider.lifecycle("Kotlin version " + ReportUtilsKt.loadCompilerVersion(environment.getCompilerClasspath()) + " (JRE " + System.getProperty("java.runtime.version") + ')');
            compilerArgs.setVersion(false);
        }
        List list2 = ArgumentUtils.convertArgumentsToStringList((CommonToolArguments)((CommonToolArguments)compilerArgs));
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"convertArgumentsToStringList(compilerArgs)");
        Collection $this$toTypedArray$iv = list2;
        boolean $i$f$toTypedArray = false;
        Object thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] argsArray = stringArray;
        KotlinBuildStatsService.Companion.applyIfInitialised((Function1<? super IStatisticsValuesConsumer, Unit>)((Function1)new Function1<IStatisticsValuesConsumer, Unit>(compilerArgs, argsArray){
            final /* synthetic */ CommonCompilerArguments $compilerArgs;
            final /* synthetic */ String[] $argsArray;
            {
                this.$compilerArgs = $compilerArgs;
                this.$argsArray = $argsArray;
                super(1);
            }

            public final void invoke(@NotNull IStatisticsValuesConsumer it) {
                IStatisticsValuesConsumer iStatisticsValuesConsumer;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CommonCompilerArguments commonCompilerArguments = this.$compilerArgs;
                if (commonCompilerArguments instanceof K2JVMCompilerArguments) {
                    IStatisticsValuesConsumer iStatisticsValuesConsumer2 = KotlinBuildStatsService.Companion.getInstance();
                    if (iStatisticsValuesConsumer2 != null) {
                        IStatisticsValuesConsumer iStatisticsValuesConsumer3 = iStatisticsValuesConsumer2;
                        Object[] objectArray = this.$argsArray;
                        IStatisticsValuesConsumer $this$invoke_u24lambda_u2d0 = iStatisticsValuesConsumer3;
                        boolean bl = false;
                        K2JVMCompilerArguments args = new K2JVMCompilerArguments();
                        ParseCommandLineArgumentsKt.parseCommandLineArguments((List)ArraysKt.toList((Object[])objectArray), (CommonToolArguments)((CommonToolArguments)args));
                        IStatisticsValuesConsumer.DefaultImpls.report$default($this$invoke_u24lambda_u2d0, BooleanMetrics.JVM_COMPILER_IR_MODE, args.getUseIR(), null, 4, null);
                        IStatisticsValuesConsumer.DefaultImpls.report$default($this$invoke_u24lambda_u2d0, StringMetrics.JVM_DEFAULTS, args.getJvmDefault(), null, 4, null);
                        IStatisticsValuesConsumer.DefaultImpls.report$default($this$invoke_u24lambda_u2d0, StringMetrics.USE_OLD_BACKEND, String.valueOf(args.getUseOldBackend()), null, 4, null);
                    }
                } else if (commonCompilerArguments instanceof K2JSCompilerArguments && (iStatisticsValuesConsumer = KotlinBuildStatsService.Companion.getInstance()) != null) {
                    IStatisticsValuesConsumer iStatisticsValuesConsumer4 = iStatisticsValuesConsumer;
                    Object[] objectArray = this.$argsArray;
                    IStatisticsValuesConsumer $this$invoke_u24lambda_u2d1 = iStatisticsValuesConsumer4;
                    boolean bl = false;
                    K2JSCompilerArguments args = new K2JSCompilerArguments();
                    ParseCommandLineArgumentsKt.parseCommandLineArguments((List)ArraysKt.toList((Object[])objectArray), (CommonToolArguments)((CommonToolArguments)args));
                    if (!K2JSCompilerArgumentsKt.isPreIrBackendDisabled((K2JSCompilerArguments)args) || args.getIrProduceJs()) {
                        IStatisticsValuesConsumer.DefaultImpls.report$default($this$invoke_u24lambda_u2d1, BooleanMetrics.JS_SOURCE_MAP, args.getSourceMap(), null, 4, null);
                    }
                    if (args.getIrProduceJs()) {
                        IStatisticsValuesConsumer.DefaultImpls.report$default($this$invoke_u24lambda_u2d1, StringMetrics.JS_PROPERTY_LAZY_INITIALIZATION, String.valueOf(args.getIrPropertyLazyInitialization()), null, 4, null);
                    }
                }
            }
        }));
        IncrementalCompilationEnvironment incrementalCompilationEnvironment = environment.getIncrementalCompilationEnvironment();
        thisCollection$iv = incrementalCompilationEnvironment;
        if (thisCollection$iv == null) {
            incrementalModuleInfo = null;
        } else {
            Object it = object = thisCollection$iv;
            boolean bl = false;
            incrementalModuleInfo = ((IncrementalModuleInfoProvider)this.getIncrementalModuleInfoProvider$kotlin_gradle_plugin().get()).getInfo();
        }
        IncrementalModuleInfo modulesInfo = incrementalModuleInfo;
        object = this.loggerProvider;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"loggerProvider");
        Object object2 = object;
        object = this.projectDirProvider;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"projectDirProvider");
        Object object3 = object;
        object = this.buildDirProvider;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"buildDirProvider");
        Object object4 = object;
        object = this.projectNameProvider;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"projectNameProvider");
        Object object5 = object;
        object = this.projectRootDirProvider;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"projectRootDirProvider");
        Object object6 = object;
        object = this.sessionDirProvider;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sessionDirProvider");
        ProjectFilesForCompilation projectFilesForCompilation = new ProjectFilesForCompilation((Logger)object2, (File)object3, (File)object4, (String)object5, (File)object6, (File)object);
        List<File> list3 = environment.compilerFullClasspath(this.jdkToolsJar);
        boolean bl = compilerArgs.getVerbose();
        List list4 = CollectionsKt.toList((Iterable)((Iterable)environment.getOutputFiles()));
        object = this.pathProvider;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pathProvider");
        GradleKotlinCompilerWorkArguments workArgs = new GradleKotlinCompilerWorkArguments(projectFilesForCompilation, list3, compilerClassName, argsArray, bl, incrementalCompilationEnvironment, modulesInfo, list4, (String)object, environment.getReportingSettings(), environment.getKotlinScriptExtensions(), compilerArgs.getAllWarningsAsErrors(), this.kotlinDaemonJvmArgs);
        object = this.pathProvider;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pathProvider");
        Object object7 = object;
        object = this.loggerProvider;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"loggerProvider");
        TaskLoggers.INSTANCE.put((String)object7, (Logger)object);
        return this.runCompilerAsync(workArgs, taskOutputsBackup);
    }

    static /* synthetic */ WorkQueue runCompilerAsync$default(GradleCompilerRunner gradleCompilerRunner, String string, CommonCompilerArguments commonCompilerArguments, GradleCompilerEnvironment gradleCompilerEnvironment, TaskOutputsBackup taskOutputsBackup, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: runCompilerAsync");
        }
        if ((n & 8) != 0) {
            taskOutputsBackup = null;
        }
        return gradleCompilerRunner.runCompilerAsync(string, commonCompilerArguments, gradleCompilerEnvironment, taskOutputsBackup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected WorkQueue runCompilerAsync(@NotNull GradleKotlinCompilerWorkArguments workArgs, @Nullable TaskOutputsBackup taskOutputsBackup) {
        Intrinsics.checkNotNullParameter((Object)workArgs, (String)"workArgs");
        GradleKotlinCompilerWork kotlinCompilerRunnable = new GradleKotlinCompilerWork(workArgs);
        try {
            kotlinCompilerRunnable.run();
        }
        catch (GradleException e) {
            this.loggerProvider.info("Restoring task outputs to pre-compilation state");
            TaskOutputsBackup taskOutputsBackup2 = taskOutputsBackup;
            if (taskOutputsBackup2 != null) {
                taskOutputsBackup2.restoreOutputs();
            }
            throw e;
        }
        finally {
            TaskOutputsBackup taskOutputsBackup3 = taskOutputsBackup;
            if (taskOutputsBackup3 != null) {
                taskOutputsBackup3.deleteSnapshot();
            }
        }
        return null;
    }

    public static final /* synthetic */ File access$getClientIsAliveFlagFile$cp() {
        return clientIsAliveFlagFile;
    }

    public static final /* synthetic */ void access$setClientIsAliveFlagFile$cp(File file) {
        clientIsAliveFlagFile = file;
    }

    public static final /* synthetic */ File access$getSessionFlagFile$cp() {
        return sessionFlagFile;
    }

    public static final /* synthetic */ void access$setSessionFlagFile$cp(File file) {
        sessionFlagFile = file;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\rJ\r\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010JM\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\u001d\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b!J%\u0010\"\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b%J\u001a\u0010&\u001a\u0004\u0018\u00010\t2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0019H\u0002J\u0015\u0010#\u001a\u00020\t2\u0006\u0010*\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b+J\u0011\u0010,\u001a\u00020\u0019*\u00020\u0019H\u0000\u00a2\u0006\u0002\b-R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerRunner$Companion;", "", "()V", "cachedGradle", "Ljava/lang/ref/WeakReference;", "Lorg/gradle/api/invocation/Gradle;", "cachedModulesInfo", "Lorg/jetbrains/kotlin/incremental/IncrementalModuleInfo;", "clientIsAliveFlagFile", "Ljava/io/File;", "sessionFlagFile", "buildModulesInfo", "gradle", "buildModulesInfo$kotlin_gradle_plugin", "clearBuildModulesInfo", "", "clearBuildModulesInfo$kotlin_gradle_plugin", "getDaemonConnectionImpl", "Lorg/jetbrains/kotlin/daemon/client/CompileServiceSession;", "sessionIsAliveFlagFile", "compilerFullClasspath", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "daemonJvmArgs", "", "isDebugEnabled", "", "getDaemonConnectionImpl$kotlin_gradle_plugin", "getOrCreateClientFlagFile", "log", "Lorg/gradle/api/logging/Logger;", "projectName", "getOrCreateClientFlagFile$kotlin_gradle_plugin", "getOrCreateSessionFlagFile", "sessionsDir", "projectRootDir", "getOrCreateSessionFlagFile$kotlin_gradle_plugin", "jarForSourceSet", "project", "Lorg/gradle/api/Project;", "sourceSetName", "rootProjectBuildDir", "sessionsDir$kotlin_gradle_plugin", "normalizeForFlagFile", "normalizeForFlagFile$kotlin_gradle_plugin", "kotlin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final synchronized CompileServiceSession getDaemonConnectionImpl$kotlin_gradle_plugin(@NotNull File clientIsAliveFlagFile, @NotNull File sessionIsAliveFlagFile, @NotNull List<? extends File> compilerFullClasspath, @NotNull MessageCollector messageCollector, @Nullable List<String> daemonJvmArgs, boolean isDebugEnabled) {
            DaemonJVMOptions daemonJVMOptions;
            Intrinsics.checkNotNullParameter((Object)clientIsAliveFlagFile, (String)"clientIsAliveFlagFile");
            Intrinsics.checkNotNullParameter((Object)sessionIsAliveFlagFile, (String)"sessionIsAliveFlagFile");
            Intrinsics.checkNotNullParameter(compilerFullClasspath, (String)"compilerFullClasspath");
            Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
            CompilerId compilerId = CompilerId.Companion.makeCompilerId((Iterable)compilerFullClasspath);
            DaemonJVMOptions opts = daemonJVMOptions = DaemonParamsKt.configureDaemonJVMOptions((String[])new String[0], (boolean)true, (boolean)false, (boolean)true);
            boolean bl = false;
            Collection collection = daemonJvmArgs;
            if (!(collection == null || collection.isEmpty())) {
                CollectionsKt.addAll((Collection)opts.getJvmParams(), (Iterable)DaemonParamsKt.filterExtractProps((Iterable)daemonJvmArgs, (List)opts.getMappers(), (String)"", (RestPropMapper)opts.getRestMapper()));
            }
            DaemonJVMOptions daemonJvmOptions = daemonJVMOptions;
            return KotlinCompilerRunnerUtils.newDaemonConnection$default((CompilerId)compilerId, (File)clientIsAliveFlagFile, (File)sessionIsAliveFlagFile, (MessageCollector)messageCollector, (boolean)isDebugEnabled, null, (DaemonJVMOptions)daemonJvmOptions, (int)32, null);
        }

        @NotNull
        public final synchronized IncrementalModuleInfo buildModulesInfo$kotlin_gradle_plugin(@NotNull Gradle gradle) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)gradle, (String)"gradle");
            if (cachedGradle.get() == gradle && cachedModulesInfo != null) {
                IncrementalModuleInfo incrementalModuleInfo = cachedModulesInfo;
                Intrinsics.checkNotNull((Object)incrementalModuleInfo);
                return incrementalModuleInfo;
            }
            HashMap dirToModule = new HashMap();
            HashMap nameToModules = new HashMap();
            HashMap jarToClassListFile = new HashMap();
            HashMap jarToModule = new HashMap();
            HashMap jarToAbiSnapshot = new HashMap();
            Map multiplatformProjectTasks = new LinkedHashMap();
            Object object2 = gradle.getTaskGraph().getAllTasks();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"gradle.taskGraph.allTasks");
            Iterable $this$forEach$iv = (Iterable)object2;
            boolean bl = false;
            for (Object element$iv : $this$forEach$iv) {
                File $this$getOrPut$iv;
                Object key$iv;
                Object object3;
                Object object4;
                Task task = (Task)element$iv;
                boolean bl2 = false;
                Project project = task.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                if (KotlinProjectExtensionKt.getMultiplatformExtensionOrNull(project) != null) {
                    object4 = (Set)multiplatformProjectTasks.get(project);
                    Set tasksInProject = object4 == null ? (Set)new LinkedHashSet() : object4;
                    object4 = task.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"task.name");
                    tasksInProject.add(object4);
                    object4 = multiplatformProjectTasks;
                    object3 = project;
                    object4.put(object3, tasksInProject);
                }
                if (task instanceof AbstractKotlinCompile) {
                    Object object5;
                    object4 = project.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"project.path");
                    Object object6 = object4;
                    object4 = ((AbstractKotlinCompile)task).getModuleName$kotlin_gradle_plugin().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"task.moduleName.get()");
                    String string = (String)object4;
                    object4 = project.getBuildDir();
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"project.buildDir");
                    Object object7 = object4;
                    object4 = ((RegularFile)((AbstractKotlinCompile)task).getBuildHistoryFile$kotlin_gradle_plugin().get()).getAsFile();
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"task.buildHistoryFile.get().asFile");
                    Object object8 = object4;
                    object4 = ((RegularFile)((AbstractKotlinCompile)task).getAbiSnapshotFile().get()).getAsFile();
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"task.abiSnapshotFile.get().asFile");
                    IncrementalModuleEntry module2 = new IncrementalModuleEntry((String)object6, string, (File)object7, (File)object8, (File)object4);
                    object4 = dirToModule;
                    object3 = ((AbstractKotlinCompile)task).getDestinationDir();
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"task.destinationDir");
                    object4.put(object3, module2);
                    object4 = (Directory)((AbstractKotlinCompile)task).getJavaOutputDir$kotlin_gradle_plugin().getOrNull();
                    if (object4 != null && (object3 = object4.getAsFile()) != null) {
                        Object object9;
                        Object it = object9 = object3;
                        boolean bl3 = false;
                        object = dirToModule;
                        object.put(it, module2);
                    }
                    object4 = nameToModules;
                    key$iv = module2.getName();
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl4 = false;
                        HashSet answer$iv = new HashSet();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object5 = answer$iv;
                    } else {
                        object5 = value$iv;
                    }
                    ((HashSet)object5).add(module2);
                    if (!(task instanceof Kotlin2JsCompile)) continue;
                    key$iv = ((AbstractKotlinCompile)task).getSourceSetName$kotlin_gradle_plugin().get();
                    Intrinsics.checkNotNullExpressionValue((Object)key$iv, (String)"task.sourceSetName.get()");
                    $this$getOrPut$iv = Companion.jarForSourceSet(project, (String)key$iv);
                    if ($this$getOrPut$iv == null) continue;
                    Object it = key$iv = $this$getOrPut$iv;
                    boolean bl5 = false;
                    Map answer$iv = jarToModule;
                    answer$iv.put(it, module2);
                    continue;
                }
                if (!(task instanceof InspectClassesForMultiModuleIC)) continue;
                Map map = jarToClassListFile;
                $this$getOrPut$iv = new File((String)((InspectClassesForMultiModuleIC)task).getArchivePath$kotlin_gradle_plugin().get());
                key$iv = ((InspectClassesForMultiModuleIC)task).getClassesListFile$kotlin_gradle_plugin();
                map.put($this$getOrPut$iv, key$iv);
            }
            for (Map.Entry entry : multiplatformProjectTasks.entrySet()) {
                KotlinMultiplatformExtension kotlinMultiplatformExtension;
                Project project = (Project)entry.getKey();
                Set tasksInProject = (Set)entry.getValue();
                KotlinMultiplatformExtension kotlinMultiplatformExtension2 = (KotlinMultiplatformExtension)project.getExtensions().findByType(KotlinMultiplatformExtension.class);
                if (kotlinMultiplatformExtension2 == null) continue;
                KotlinMultiplatformExtension kotlinExt = kotlinMultiplatformExtension = kotlinMultiplatformExtension2;
                boolean bl6 = false;
                for (KotlinTarget target2 : kotlinExt.getTargets()) {
                    Object object10;
                    KotlinCompilation mainCompilation;
                    KotlinCompilation it = (KotlinCompilation)target2.getCompilations().findByName("main");
                    if (it == null || !tasksInProject.contains((mainCompilation = it).getCompileKotlinTaskName()) || !tasksInProject.contains(target2.getArtifactsTaskName())) continue;
                    Object answer$iv = mainCompilation.getCompileKotlinTask();
                    Object object11 = object = answer$iv instanceof AbstractKotlinCompile ? (AbstractKotlinCompile)answer$iv : null;
                    if (object == null) continue;
                    AbstractKotlinCompile kotlinTask = object;
                    answer$iv = project.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)answer$iv, (String)"project.path");
                    Object object12 = answer$iv;
                    answer$iv = kotlinTask.getModuleName$kotlin_gradle_plugin().get();
                    Intrinsics.checkNotNullExpressionValue((Object)answer$iv, (String)"kotlinTask.moduleName.get()");
                    String string = (String)answer$iv;
                    answer$iv = project.getBuildDir();
                    Intrinsics.checkNotNullExpressionValue((Object)answer$iv, (String)"project.buildDir");
                    Object object13 = answer$iv;
                    answer$iv = ((RegularFile)kotlinTask.getBuildHistoryFile$kotlin_gradle_plugin().get()).getAsFile();
                    Intrinsics.checkNotNullExpressionValue((Object)answer$iv, (String)"kotlinTask.buildHistoryFile.get().asFile");
                    Object object14 = answer$iv;
                    answer$iv = ((RegularFile)kotlinTask.getAbiSnapshotFile().get()).getAsFile();
                    Intrinsics.checkNotNullExpressionValue((Object)answer$iv, (String)"kotlinTask.abiSnapshotFile.get().asFile");
                    IncrementalModuleEntry module3 = new IncrementalModuleEntry((String)object12, string, (File)object13, (File)object14, (File)answer$iv);
                    Object object15 = project.getTasks().findByName(target2.getArtifactsTaskName());
                    Object object16 = object10 = object15 instanceof AbstractArchiveTask ? (AbstractArchiveTask)object15 : null;
                    if (object10 == null) continue;
                    AbstractArchiveTask jarTask = object10;
                    object10 = jarToModule;
                    object15 = CompatibiltiyKt.getArchivePathCompatible(jarTask).getCanonicalFile();
                    Intrinsics.checkNotNullExpressionValue((Object)object15, (String)"jarTask.archivePathCompatible.canonicalFile");
                    object10.put(object15, module3);
                    if (!(target2 instanceof KotlinWithJavaTarget)) continue;
                    object15 = project.getTasks().getByName(target2.getArtifactsTaskName());
                    if (object15 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.gradle.jvm.tasks.Jar");
                    }
                    Jar jar = (Jar)object15;
                    object15 = jarToClassListFile;
                    File file = CompatibiltiyKt.getArchivePathCompatible((AbstractArchiveTask)jar).getCanonicalFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"jar.archivePathCompatible.canonicalFile");
                    Object object17 = ((KotlinWithJavaTarget)target2).getDefaultArtifactClassesListFile$kotlin_gradle_plugin().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object17, (String)"target.defaultArtifactClassesListFile.get()");
                    object15.put(file, object17);
                    object15 = jarToAbiSnapshot;
                    file = CompatibiltiyKt.getArchivePathCompatible((AbstractArchiveTask)jar).getCanonicalFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"jar.archivePathCompatible.canonicalFile");
                    object17 = ((RegularFile)((Directory)((KotlinWithJavaTarget)target2).getBuildDir$kotlin_gradle_plugin().get()).file((Provider)kotlinTask.getAbiSnapshotRelativePath()).get()).getAsFile();
                    Intrinsics.checkNotNullExpressionValue((Object)object17, (String)"target.buildDir.get().fi\u2026elativePath).get().asFile");
                    object15.put(file, object17);
                }
            }
            object2 = gradle.getRootProject().getProjectDir();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"gradle.rootProject.projectDir");
            Object object18 = object2;
            object2 = gradle.getRootProject().getBuildDir();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"gradle.rootProject.buildDir");
            Object object19 = object2 = new IncrementalModuleInfo((File)object18, (File)object2, (Map)dirToModule, (Map)nameToModules, (Map)jarToClassListFile, (Map)jarToModule, (Map)jarToAbiSnapshot);
            boolean bl7 = false;
            cachedGradle = new WeakReference<Gradle>(gradle);
            cachedModulesInfo = (IncrementalModuleInfo)object19;
            return object2;
        }

        private final File jarForSourceSet(Project project, String sourceSetName) {
            RegularFile regularFile;
            Provider provider;
            JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
            if (javaPluginConvention == null) {
                return null;
            }
            JavaPluginConvention javaPluginConvention2 = javaPluginConvention;
            JavaPluginConvention javaConvention = javaPluginConvention2;
            Object object = (SourceSet)javaConvention.getSourceSets().findByName(sourceSetName);
            if (object == null) {
                return null;
            }
            JavaPluginConvention sourceSet = javaPluginConvention = object;
            object = project.getTasks().findByName(sourceSet.getJarTaskName());
            Jar jarTask = object instanceof Jar ? (Jar)object : null;
            object = jarTask;
            return object == null ? null : ((provider = object.getArchiveFile()) == null ? null : ((regularFile = (RegularFile)provider.get()) == null ? null : regularFile.getAsFile()));
        }

        public final synchronized void clearBuildModulesInfo$kotlin_gradle_plugin() {
            cachedGradle = new WeakReference<Object>(null);
            cachedModulesInfo = null;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final synchronized File getOrCreateClientFlagFile$kotlin_gradle_plugin(@NotNull Logger log, @NotNull String projectName) {
            Intrinsics.checkNotNullParameter((Object)log, (String)"log");
            Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
            if (GradleCompilerRunner.access$getClientIsAliveFlagFile$cp() == null) ** GOTO lbl-1000
            v0 = GradleCompilerRunner.access$getClientIsAliveFlagFile$cp();
            Intrinsics.checkNotNull((Object)v0);
            if (!v0.exists()) lbl-1000:
            // 2 sources

            {
                GradleCompilerRunner.access$setClientIsAliveFlagFile$cp(FileUtilsKt.newTmpFile$default("kotlin-compiler-in-" + projectName + '-', ".alive", null, false, 12, null));
                $this$kotlinDebug$iv = log;
                $i$f$kotlinDebug = false;
                if ($this$kotlinDebug$iv.isDebugEnabled()) {
                    var6_7 = $this$kotlinDebug$iv;
                    $i$a$-kotlinDebug-GradleCompilerRunner$Companion$getOrCreateClientFlagFile$1 = false;
                    v1 = GradleCompilerRunner.access$getClientIsAliveFlagFile$cp();
                    Intrinsics.checkNotNull((Object)v1);
                    var7_11 = Intrinsics.stringPlus((String)"Created client-is-alive flag file: ", (Object)v1.getCanonicalPath());
                    GradleLoggingUtilsKt.kotlinDebug(var6_7, var7_11);
                }
            } else {
                $this$kotlinDebug$iv = log;
                $i$f$kotlinDebug = false;
                if ($this$kotlinDebug$iv.isDebugEnabled()) {
                    var6_8 = $this$kotlinDebug$iv;
                    $i$a$-kotlinDebug-GradleCompilerRunner$Companion$getOrCreateClientFlagFile$2 = false;
                    v2 = GradleCompilerRunner.access$getClientIsAliveFlagFile$cp();
                    Intrinsics.checkNotNull((Object)v2);
                    var7_12 = Intrinsics.stringPlus((String)"Existing client-is-alive flag file: ", (Object)v2.getCanonicalPath());
                    GradleLoggingUtilsKt.kotlinDebug(var6_8, var7_12);
                }
            }
            v3 = GradleCompilerRunner.access$getClientIsAliveFlagFile$cp();
            Intrinsics.checkNotNull((Object)v3);
            return v3;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String normalizeForFlagFile$kotlin_gradle_plugin(@NotNull String $this$normalizeForFlagFile) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$normalizeForFlagFile, (String)"<this>");
            List validChars = CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('0', '9'))), (Object)"-_");
            String $this$filter$iv = $this$normalizeForFlagFile;
            boolean $i$f$filter = false;
            CharSequence charSequence = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = 0;
            int n2 = $this$filterTo$iv$iv.length();
            while (n < n2) {
                void index$iv$iv;
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt((int)index$iv$iv);
                boolean bl = false;
                if (validChars.contains(Character.valueOf(it))) {
                    destination$iv$iv.append(element$iv$iv);
                }
                ++index$iv$iv;
            }
            String string = ((StringBuilder)destination$iv$iv).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filterTo(StringBuilder(), predicate).toString()");
            return string;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final synchronized File getOrCreateSessionFlagFile$kotlin_gradle_plugin(@NotNull Logger log, @NotNull File sessionsDir, @NotNull File projectRootDir) {
            Intrinsics.checkNotNullParameter((Object)log, (String)"log");
            Intrinsics.checkNotNullParameter((Object)sessionsDir, (String)"sessionsDir");
            Intrinsics.checkNotNullParameter((Object)projectRootDir, (String)"projectRootDir");
            if (GradleCompilerRunner.access$getSessionFlagFile$cp() == null) ** GOTO lbl-1000
            v0 = GradleCompilerRunner.access$getSessionFlagFile$cp();
            Intrinsics.checkNotNull((Object)v0);
            if (!v0.exists()) lbl-1000:
            // 2 sources

            {
                $this$getOrCreateSessionFlagFile_u24lambda_u2d10 = var5_4 = sessionsDir;
                $i$a$-apply-GradleCompilerRunner$Companion$getOrCreateSessionFlagFile$sessionFilesDir$1 = false;
                $this$getOrCreateSessionFlagFile_u24lambda_u2d10.mkdirs();
                sessionFilesDir = var5_4;
                GradleCompilerRunner.access$setSessionFlagFile$cp(FileUtilsKt.newTmpFile$default("kotlin-compiler-", ".salive", sessionFilesDir, false, 8, null));
                $this$kotlinDebug$iv = log;
                $i$f$kotlinDebug = false;
                if ($this$kotlinDebug$iv.isDebugEnabled()) {
                    var8_12 = $this$kotlinDebug$iv;
                    $i$a$-kotlinDebug-GradleCompilerRunner$Companion$getOrCreateSessionFlagFile$1 = false;
                    v1 = GradleCompilerRunner.access$getSessionFlagFile$cp();
                    Intrinsics.checkNotNull((Object)v1);
                    var9_14 = Intrinsics.stringPlus((String)"Created session-is-alive flag file: ", (Object)FileUtilsKt.relativeOrCanonical(v1, projectRootDir));
                    GradleLoggingUtilsKt.kotlinDebug(var8_12, var9_14);
                }
            } else {
                $this$kotlinDebug$iv = log;
                $i$f$kotlinDebug = false;
                if ($this$kotlinDebug$iv.isDebugEnabled()) {
                    var8_13 = $this$kotlinDebug$iv;
                    $i$a$-kotlinDebug-GradleCompilerRunner$Companion$getOrCreateSessionFlagFile$2 = false;
                    v2 = GradleCompilerRunner.access$getSessionFlagFile$cp();
                    Intrinsics.checkNotNull((Object)v2);
                    var9_15 = Intrinsics.stringPlus((String)"Existing session-is-alive flag file: ", (Object)FileUtilsKt.relativeOrCanonical(v2, projectRootDir));
                    GradleLoggingUtilsKt.kotlinDebug(var8_13, var9_15);
                }
            }
            v3 = GradleCompilerRunner.access$getSessionFlagFile$cp();
            Intrinsics.checkNotNull((Object)v3);
            return v3;
        }

        @NotNull
        public final File sessionsDir$kotlin_gradle_plugin(@NotNull File rootProjectBuildDir) {
            Intrinsics.checkNotNullParameter((Object)rootProjectBuildDir, (String)"rootProjectBuildDir");
            return new File(new File(rootProjectBuildDir, "kotlin"), "sessions");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

