/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u0005J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\fH\u0002J@\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00052\u001e\b\u0002\u0010\u000f\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\u00050\u0010H\u0007J\u000f\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0013H\u0082\u0010J:\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017J>\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u001c\u0010\u000f\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\u00050\u00102\u0006\u0010\t\u001a\u00020\u0005H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/DescriptorEquivalenceForOverrides;", "", "<init>", "()V", "areEquivalent", "", "a", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "b", "allowCopiesFromTheSameDeclaration", "distinguishExpectsAndNonExpects", "areClassesEquivalent", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "areTypeParametersEquivalent", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "equivalentCallables", "Lkotlin/Function2;", "singleSource", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "areCallableDescriptorsEquivalent", "ignoreReturnType", "kotlinTypeRefiner", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "ownersEquivalent", "descriptors"})
public final class DescriptorEquivalenceForOverrides {
    @NotNull
    public static final DescriptorEquivalenceForOverrides INSTANCE = new DescriptorEquivalenceForOverrides();

    private DescriptorEquivalenceForOverrides() {
    }

    public final boolean areEquivalent(@Nullable DeclarationDescriptor a2, @Nullable DeclarationDescriptor b2, boolean allowCopiesFromTheSameDeclaration, boolean distinguishExpectsAndNonExpects) {
        return a2 instanceof ClassDescriptor && b2 instanceof ClassDescriptor ? this.areClassesEquivalent((ClassDescriptor)a2, (ClassDescriptor)b2) : (a2 instanceof TypeParameterDescriptor && b2 instanceof TypeParameterDescriptor ? DescriptorEquivalenceForOverrides.areTypeParametersEquivalent$default(this, (TypeParameterDescriptor)a2, (TypeParameterDescriptor)b2, allowCopiesFromTheSameDeclaration, null, 8, null) : (a2 instanceof CallableDescriptor && b2 instanceof CallableDescriptor ? DescriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent$default(this, (CallableDescriptor)a2, (CallableDescriptor)b2, allowCopiesFromTheSameDeclaration, distinguishExpectsAndNonExpects, false, KotlinTypeRefiner.Default.INSTANCE, 16, null) : (a2 instanceof PackageFragmentDescriptor && b2 instanceof PackageFragmentDescriptor ? Intrinsics.areEqual((Object)((PackageFragmentDescriptor)a2).getFqName(), (Object)((PackageFragmentDescriptor)b2).getFqName()) : Intrinsics.areEqual((Object)a2, (Object)b2))));
    }

    public static /* synthetic */ boolean areEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl2 = true;
        }
        return descriptorEquivalenceForOverrides.areEquivalent(declarationDescriptor, declarationDescriptor2, bl, bl2);
    }

    private final boolean areClassesEquivalent(ClassDescriptor a2, ClassDescriptor b2) {
        return Intrinsics.areEqual((Object)a2.getTypeConstructor(), (Object)b2.getTypeConstructor());
    }

    @JvmOverloads
    public final boolean areTypeParametersEquivalent(@NotNull TypeParameterDescriptor a2, @NotNull TypeParameterDescriptor b2, boolean allowCopiesFromTheSameDeclaration, @NotNull Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean> equivalentCallables) {
        Intrinsics.checkNotNullParameter((Object)a2, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b2, (String)"b");
        Intrinsics.checkNotNullParameter(equivalentCallables, (String)"equivalentCallables");
        if (Intrinsics.areEqual((Object)a2, (Object)b2)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)a2.getContainingDeclaration(), (Object)b2.getContainingDeclaration())) {
            return false;
        }
        if (!this.ownersEquivalent(a2, b2, equivalentCallables, allowCopiesFromTheSameDeclaration)) {
            return false;
        }
        return a2.getIndex() == b2.getIndex();
    }

    public static /* synthetic */ boolean areTypeParametersEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, TypeParameterDescriptor typeParameterDescriptor, TypeParameterDescriptor typeParameterDescriptor2, boolean bl, Function2 function2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            function2 = DescriptorEquivalenceForOverrides::areTypeParametersEquivalent$lambda$0;
        }
        return descriptorEquivalenceForOverrides.areTypeParametersEquivalent(typeParameterDescriptor, typeParameterDescriptor2, bl, (Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean>)function2);
    }

    private final SourceElement singleSource(CallableDescriptor $this$singleSource) {
        DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides = this;
        while (true) {
            if (!($this$singleSource instanceof CallableMemberDescriptor) || ((CallableMemberDescriptor)$this$singleSource).getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                return $this$singleSource.getSource();
            }
            Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)$this$singleSource).getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getOverriddenDescriptors(...)");
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
            if (callableMemberDescriptor == null) break;
            DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides2 = descriptorEquivalenceForOverrides;
            CallableMemberDescriptor callableMemberDescriptor2 = callableMemberDescriptor;
            descriptorEquivalenceForOverrides = descriptorEquivalenceForOverrides2;
            $this$singleSource = callableMemberDescriptor2;
        }
        return null;
    }

    public final boolean areCallableDescriptorsEquivalent(@NotNull CallableDescriptor a2, @NotNull CallableDescriptor b2, boolean allowCopiesFromTheSameDeclaration, boolean distinguishExpectsAndNonExpects, boolean ignoreReturnType, @NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)a2, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b2, (String)"b");
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
        if (Intrinsics.areEqual((Object)a2, (Object)b2)) {
            return true;
        }
        if (!Intrinsics.areEqual((Object)a2.getName(), (Object)b2.getName())) {
            return false;
        }
        if (distinguishExpectsAndNonExpects && a2 instanceof MemberDescriptor && b2 instanceof MemberDescriptor && ((MemberDescriptor)((Object)a2)).isExpect() != ((MemberDescriptor)((Object)b2)).isExpect()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)a2.getContainingDeclaration(), (Object)b2.getContainingDeclaration())) {
            if (!allowCopiesFromTheSameDeclaration) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.singleSource(a2), (Object)this.singleSource(b2))) {
                return false;
            }
        }
        if (DescriptorUtils.isLocal(a2) || DescriptorUtils.isLocal(b2)) {
            return false;
        }
        if (!this.ownersEquivalent(a2, b2, (Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean>)((Function2)DescriptorEquivalenceForOverrides::areCallableDescriptorsEquivalent$lambda$0), allowCopiesFromTheSameDeclaration)) {
            return false;
        }
        OverridingUtil overridingUtil = OverridingUtil.create(kotlinTypeRefiner, (arg_0, arg_1) -> DescriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent$lambda$1(allowCopiesFromTheSameDeclaration, a2, b2, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)overridingUtil, (String)"create(...)");
        OverridingUtil overridingUtil2 = overridingUtil;
        return overridingUtil2.isOverridableBy(a2, b2, null, !ignoreReturnType).getResult() == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE && overridingUtil2.isOverridableBy(b2, a2, null, !ignoreReturnType).getResult() == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE;
    }

    public static /* synthetic */ boolean areCallableDescriptorsEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2, boolean bl, boolean bl2, boolean bl3, KotlinTypeRefiner kotlinTypeRefiner, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x10) != 0) {
            bl3 = false;
        }
        return descriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent(callableDescriptor, callableDescriptor2, bl, bl2, bl3, kotlinTypeRefiner);
    }

    private final boolean ownersEquivalent(DeclarationDescriptor a2, DeclarationDescriptor b2, Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean> equivalentCallables, boolean allowCopiesFromTheSameDeclaration) {
        DeclarationDescriptor aOwner = a2.getContainingDeclaration();
        DeclarationDescriptor bOwner = b2.getContainingDeclaration();
        return aOwner instanceof CallableMemberDescriptor || bOwner instanceof CallableMemberDescriptor ? (Boolean)equivalentCallables.invoke((Object)aOwner, (Object)bOwner) : DescriptorEquivalenceForOverrides.areEquivalent$default(this, aOwner, bOwner, allowCopiesFromTheSameDeclaration, false, 8, null);
    }

    @JvmOverloads
    public final boolean areTypeParametersEquivalent(@NotNull TypeParameterDescriptor a2, @NotNull TypeParameterDescriptor b2, boolean allowCopiesFromTheSameDeclaration) {
        Intrinsics.checkNotNullParameter((Object)a2, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b2, (String)"b");
        return DescriptorEquivalenceForOverrides.areTypeParametersEquivalent$default(this, a2, b2, allowCopiesFromTheSameDeclaration, null, 8, null);
    }

    private static final boolean areTypeParametersEquivalent$lambda$0(DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2) {
        return false;
    }

    private static final boolean areCallableDescriptorsEquivalent$lambda$0(DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2) {
        return false;
    }

    private static final boolean areCallableDescriptorsEquivalent$lambda$1(boolean $allowCopiesFromTheSameDeclaration, CallableDescriptor $a, CallableDescriptor $b, TypeConstructor c1, TypeConstructor c2) {
        Intrinsics.checkNotNullParameter((Object)c1, (String)"c1");
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c2");
        if (Intrinsics.areEqual((Object)c1, (Object)c2)) {
            return true;
        }
        ClassifierDescriptor d1 = c1.getDeclarationDescriptor();
        ClassifierDescriptor d2 = c2.getDeclarationDescriptor();
        if (!(d1 instanceof TypeParameterDescriptor) || !(d2 instanceof TypeParameterDescriptor)) {
            return false;
        }
        return INSTANCE.areTypeParametersEquivalent((TypeParameterDescriptor)d1, (TypeParameterDescriptor)d2, $allowCopiesFromTheSameDeclaration, (Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean>)((Function2)(arg_0, arg_1) -> DescriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent$lambda$1$0($a, $b, arg_0, arg_1)));
    }

    private static final boolean areCallableDescriptorsEquivalent$lambda$1$0(CallableDescriptor $a, CallableDescriptor $b, DeclarationDescriptor x2, DeclarationDescriptor y2) {
        return Intrinsics.areEqual((Object)x2, (Object)$a) && Intrinsics.areEqual((Object)y2, (Object)$b);
    }
}

