/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBigIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsDoubleLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsRegExp;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsSuperRef;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsYield;

class JsPrecedenceVisitor
extends JsVisitor {
    private int answer = -1;

    private JsPrecedenceVisitor() {
    }

    public static int exec(JsExpression expression2) {
        JsPrecedenceVisitor visitor2 = new JsPrecedenceVisitor();
        visitor2.accept(expression2);
        if (visitor2.answer < 0) {
            throw new RuntimeException("Precedence must be >= 0!");
        }
        return visitor2.answer;
    }

    @Override
    public void visitArrayAccess(@NotNull JsArrayAccess x2) {
        if (x2 == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(0);
        }
        this.answer = 16;
    }

    @Override
    public void visitArray(@NotNull JsArrayLiteral x2) {
        if (x2 == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(1);
        }
        this.answer = 17;
    }

    @Override
    public void visitBinaryExpression(@NotNull JsBinaryOperation x2) {
        if (x2 == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(2);
        }
        this.answer = x2.getOperator().getPrecedence();
    }

    @Override
    public void visitBoolean(@NotNull JsBooleanLiteral x2) {
        if (x2 == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(3);
        }
        this.answer = 17;
    }

    @Override
    public void visitConditional(@NotNull JsConditional x2) {
        if (x2 == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(4);
        }
        this.answer = 3;
    }

    @Override
    public void visitFunction(@NotNull JsFunction x2) {
        if (x2 == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(5);
        }
        this.answer = x2.isEs6Arrow() ? 2 : 17;
    }

    @Override
    public void visitInvocation(@NotNull JsInvocation invocation) {
        if (invocation == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(6);
        }
        this.answer = 16;
    }

    @Override
    public void visitYield(@NotNull JsYield yield) {
        if (yield == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(7);
        }
        this.answer = 2;
    }

    @Override
    public void visitNameRef(@NotNull JsNameRef nameRef) {
        if (nameRef == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(8);
        }
        this.answer = nameRef.isLeaf() ? 17 : 16;
    }

    @Override
    public void visitNew(@NotNull JsNew x2) {
        if (x2 == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(9);
        }
        this.answer = 15;
    }

    @Override
    public void visitNull(@NotNull JsNullLiteral x2) {
        if (x2 == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(10);
        }
        this.answer = 17;
    }

    @Override
    public void visitInt(@NotNull JsIntLiteral x2) {
        if (x2 == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(11);
        }
        this.answer = 17;
    }

    @Override
    public void visitDouble(@NotNull JsDoubleLiteral x2) {
        if (x2 == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(12);
        }
        this.answer = 17;
    }

    @Override
    public void visitBigInt(@NotNull JsBigIntLiteral x2) {
        if (x2 == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(13);
        }
        this.answer = 17;
    }

    @Override
    public void visitObjectLiteral(@NotNull JsObjectLiteral x2) {
        if (x2 == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(14);
        }
        this.answer = 17;
    }

    @Override
    public void visitPostfixOperation(@NotNull JsPostfixOperation x2) {
        if (x2 == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(15);
        }
        this.answer = x2.getOperator().getPrecedence();
    }

    @Override
    public void visitPrefixOperation(@NotNull JsPrefixOperation x2) {
        if (x2 == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(16);
        }
        this.answer = x2.getOperator().getPrecedence();
    }

    @Override
    public void visitPropertyInitializer(@NotNull JsPropertyInitializer x2) {
        if (x2 == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(17);
        }
        this.answer = 17;
    }

    @Override
    public void visitRegExp(@NotNull JsRegExp x2) {
        if (x2 == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(18);
        }
        this.answer = 17;
    }

    @Override
    public void visitString(@NotNull JsStringLiteral x2) {
        if (x2 == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(19);
        }
        this.answer = 17;
    }

    @Override
    public void visitThis(@NotNull JsThisRef x2) {
        if (x2 == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(20);
        }
        this.answer = 17;
    }

    @Override
    public void visitSuper(@NotNull JsSuperRef x2) {
        if (x2 == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(21);
        }
        this.answer = 17;
    }

    @Override
    protected void visitElement(@NotNull JsNode node) {
        if (node == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(22);
        }
        throw new RuntimeException("Only expressions have precedence.");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yield";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameRef";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/js/backend/JsPrecedenceVisitor";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitArrayAccess";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitArray";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBinaryExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBoolean";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitConditional";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitFunction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitInvocation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitYield";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNameRef";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNew";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNull";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "visitInt";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDouble";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBigInt";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "visitObjectLiteral";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPostfixOperation";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPrefixOperation";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPropertyInitializer";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRegExp";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "visitString";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "visitThis";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSuper";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

