/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.coroutines;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/coroutines/LiveLocalsTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "localMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "receiver", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "unitType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "<init>", "(Ljava/util/Map;Lkotlin/jvm/functions/Function0;Lorg/jetbrains/kotlin/ir/types/IrType;)V", "visitGetValue", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitVariable", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nSuspendLoweringUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuspendLoweringUtils.kt\norg/jetbrains/kotlin/ir/backend/js/lower/coroutines/LiveLocalsTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
public final class LiveLocalsTransformer
extends IrElementTransformerVoid {
    @NotNull
    private final Map<IrValueSymbol, IrFieldSymbol> localMap;
    @NotNull
    private final Function0<IrExpression> receiver;
    @NotNull
    private final IrType unitType;

    public LiveLocalsTransformer(@NotNull Map<IrValueSymbol, ? extends IrFieldSymbol> localMap, @NotNull Function0<? extends IrExpression> receiver, @NotNull IrType unitType) {
        Intrinsics.checkNotNullParameter(localMap, (String)"localMap");
        Intrinsics.checkNotNullParameter(receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)unitType, (String)"unitType");
        this.localMap = localMap;
        this.receiver = receiver;
        this.unitType = unitType;
    }

    @Override
    @NotNull
    public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrFieldSymbol irFieldSymbol = this.localMap.get(expression2.getSymbol());
        if (irFieldSymbol == null) {
            return MiscKt.isDispatchReceiver(expression2.getSymbol().getOwner()) ? (IrExpression)this.receiver.invoke() : (IrExpression)expression2;
        }
        IrFieldSymbol field = irFieldSymbol;
        IrGetValue $this$visitGetValue_u24lambda_u240 = expression2;
        boolean bl = false;
        return BuildersKt.IrGetFieldImpl$default($this$visitGetValue_u24lambda_u240.getStartOffset(), $this$visitGetValue_u24lambda_u240.getEndOffset(), field, $this$visitGetValue_u24lambda_u240.getType(), (IrExpression)this.receiver.invoke(), $this$visitGetValue_u24lambda_u240.getOrigin(), null, 64, null);
    }

    @Override
    @NotNull
    public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        IrFieldSymbol irFieldSymbol = this.localMap.get(expression2.getSymbol());
        if (irFieldSymbol == null) {
            return expression2;
        }
        IrFieldSymbol field = irFieldSymbol;
        IrSetValue $this$visitSetValue_u24lambda_u240 = expression2;
        boolean bl = false;
        return BuildersKt.IrSetFieldImpl$default($this$visitSetValue_u24lambda_u240.getStartOffset(), $this$visitSetValue_u24lambda_u240.getEndOffset(), field, (IrExpression)this.receiver.invoke(), $this$visitSetValue_u24lambda_u240.getValue(), this.unitType, $this$visitSetValue_u24lambda_u240.getOrigin(), null, 128, null);
    }

    @Override
    @NotNull
    public IrStatement visitVariable(@NotNull IrVariable declaration) {
        IrStatement irStatement;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrElementTransformerVoidKt.transformChildrenVoid(declaration, this);
        IrFieldSymbol irFieldSymbol = this.localMap.get(declaration.getSymbol());
        if (irFieldSymbol == null) {
            return declaration;
        }
        IrFieldSymbol field = irFieldSymbol;
        IrExpression initializer = declaration.getInitializer();
        if (initializer != null) {
            IrVariable $this$visitVariable_u24lambda_u240 = declaration;
            boolean bl = false;
            irStatement = BuildersKt.IrSetFieldImpl$default($this$visitVariable_u24lambda_u240.getStartOffset(), $this$visitVariable_u24lambda_u240.getEndOffset(), field, (IrExpression)this.receiver.invoke(), initializer, this.unitType, null, null, 192, null);
        } else {
            irStatement = JsIrBuilder.buildComposite$default(JsIrBuilder.INSTANCE, this.unitType, null, 2, null);
        }
        return irStatement;
    }
}

