/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree.converter;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCallBuilder;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtPsiUtil;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0002*\u00020\u0005\u001a'\u0010\u0006\u001a\u0002H\u0007\"\b\b\u0000\u0010\u0007*\u00020\b*\u0002H\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\f\u001a/\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0019\u0010\u0010\u001a\u0015\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0011\u00a2\u0006\u0002\b\u0012H\u0086\b\u00f8\u0001\u0000\u001a)\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00052\u0019\u0010\u0010\u001a\u0015\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0011\u00a2\u0006\u0002\b\u0012\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0015"}, d2={"nameAsSafeName", "Lorg/jetbrains/kotlin/name/Name;", "", "defaultName", "getAsStringWithoutBacktick", "Lcom/intellij/lang/LighterASTNode;", "extractArgumentsFrom", "T", "Lorg/jetbrains/kotlin/fir/expressions/builder/FirCallBuilder;", "container", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/builder/FirCallBuilder;Ljava/util/List;)Lorg/jetbrains/kotlin/fir/expressions/builder/FirCallBuilder;", "isClassLocal", "", "classNode", "getParent", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "isCallableLocal", "callableNode", "light-tree2fir"})
@SourceDebugExtension(value={"SMAP\nConverterUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConverterUtil.kt\norg/jetbrains/kotlin/fir/lightTree/converter/ConverterUtilKt\n+ 2 FirArgumentListBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirArgumentListBuilderKt\n*L\n1#1,76:1\n39#2:77\n*S KotlinDebug\n*F\n+ 1 ConverterUtil.kt\norg/jetbrains/kotlin/fir/lightTree/converter/ConverterUtilKt\n*L\n32#1:77\n*E\n"})
public final class ConverterUtilKt {
    @NotNull
    public static final Name nameAsSafeName(@Nullable String $this$nameAsSafeName, @NotNull String defaultName) {
        Name name2;
        Intrinsics.checkNotNullParameter((Object)defaultName, (String)"defaultName");
        String string = $this$nameAsSafeName;
        if (string != null) {
            Name name3 = Name.identifier(KtPsiUtil.unquoteIdentifier(string));
            name2 = name3;
            Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        } else if (((CharSequence)defaultName).length() > 0) {
            Name name4 = Name.identifier(defaultName);
            name2 = name4;
            Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(...)");
        } else {
            name2 = SpecialNames.NO_NAME_PROVIDED;
        }
        return name2;
    }

    public static /* synthetic */ Name nameAsSafeName$default(String string, String string2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string2 = "";
        }
        return ConverterUtilKt.nameAsSafeName(string, string2);
    }

    @NotNull
    public static final String getAsStringWithoutBacktick(@NotNull LighterASTNode $this$getAsStringWithoutBacktick) {
        Intrinsics.checkNotNullParameter((Object)$this$getAsStringWithoutBacktick, (String)"<this>");
        return StringsKt.replace$default((String)$this$getAsStringWithoutBacktick.toString(), (String)"`", (String)"", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T extends FirCallBuilder> T extractArgumentsFrom(@NotNull T $this$extractArgumentsFrom, @NotNull List<? extends FirExpression> container) {
        void $this$extractArgumentsFrom_u24lambda_u240;
        FirArgumentListBuilder firArgumentListBuilder;
        Intrinsics.checkNotNullParameter($this$extractArgumentsFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter(container, (String)"container");
        boolean $i$f$buildArgumentList = false;
        FirArgumentListBuilder firArgumentListBuilder2 = firArgumentListBuilder = new FirArgumentListBuilder();
        T t2 = $this$extractArgumentsFrom;
        boolean bl = false;
        CollectionsKt.addAll((Collection)$this$extractArgumentsFrom_u24lambda_u240.getArguments(), (Iterable)container);
        t2.setArgumentList(firArgumentListBuilder.build());
        return $this$extractArgumentsFrom;
    }

    public static final boolean isClassLocal(@NotNull LighterASTNode classNode, @NotNull Function1<? super LighterASTNode, ? extends LighterASTNode> getParent) {
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        Intrinsics.checkNotNullParameter(getParent, (String)"getParent");
        boolean $i$f$isClassLocal = false;
        LighterASTNode lighterASTNode = (LighterASTNode)getParent.invoke((Object)classNode);
        if (Intrinsics.areEqual(lighterASTNode != null && (lighterASTNode = (LighterASTNode)getParent.invoke((Object)lighterASTNode)) != null ? lighterASTNode.getTokenType() : null, (Object)KtNodeTypes.SCRIPT)) {
            return false;
        }
        LighterASTNode currentNode = classNode;
        while (currentNode != null) {
            IElementType parentTokenType;
            LighterASTNode parent2;
            IElementType tokenType;
            block10: {
                LighterASTNode grandParent;
                block11: {
                    block12: {
                        tokenType = currentNode.getTokenType();
                        LighterASTNode lighterASTNode2 = parent2 = (LighterASTNode)getParent.invoke((Object)currentNode);
                        IElementType iElementType = parentTokenType = lighterASTNode2 != null ? lighterASTNode2.getTokenType() : null;
                        if (!Intrinsics.areEqual((Object)tokenType, (Object)KtNodeTypes.PROPERTY) && !Intrinsics.areEqual((Object)tokenType, (Object)KtNodeTypes.FUN)) break block10;
                        LighterASTNode lighterASTNode3 = parent2;
                        grandParent = lighterASTNode3 != null ? (LighterASTNode)getParent.invoke((Object)lighterASTNode3) : null;
                        if (Intrinsics.areEqual((Object)parentTokenType, (Object)KtNodeTypes.KT_FILE)) {
                            return true;
                        }
                        if (!Intrinsics.areEqual((Object)parentTokenType, (Object)KtNodeTypes.CLASS_BODY)) break block11;
                        LighterASTNode lighterASTNode4 = grandParent;
                        if (!Intrinsics.areEqual((Object)(lighterASTNode4 != null ? lighterASTNode4.getTokenType() : null), (Object)KtNodeTypes.OBJECT_DECLARATION)) break block12;
                        LighterASTNode lighterASTNode5 = (LighterASTNode)getParent.invoke((Object)grandParent);
                        if (Intrinsics.areEqual((Object)(lighterASTNode5 != null ? lighterASTNode5.getTokenType() : null), (Object)KtNodeTypes.OBJECT_LITERAL)) break block11;
                    }
                    return true;
                }
                if (Intrinsics.areEqual((Object)parentTokenType, (Object)KtNodeTypes.BLOCK)) {
                    LighterASTNode lighterASTNode6 = grandParent;
                    if (Intrinsics.areEqual((Object)(lighterASTNode6 != null ? lighterASTNode6.getTokenType() : null), (Object)KtNodeTypes.SCRIPT)) {
                        return true;
                    }
                }
            }
            if (Intrinsics.areEqual((Object)parentTokenType, (Object)KtNodeTypes.ENUM_ENTRY)) {
                return true;
            }
            if (Intrinsics.areEqual((Object)tokenType, (Object)KtNodeTypes.BLOCK)) {
                return true;
            }
            currentNode = parent2;
        }
        return false;
    }

    public static final boolean isCallableLocal(@NotNull LighterASTNode callableNode, @NotNull Function1<? super LighterASTNode, ? extends LighterASTNode> getParent) {
        boolean bl;
        IElementType iElementType;
        LighterASTNode parentNode;
        Intrinsics.checkNotNullParameter((Object)callableNode, (String)"callableNode");
        Intrinsics.checkNotNullParameter(getParent, (String)"getParent");
        LighterASTNode lighterASTNode = parentNode = (LighterASTNode)getParent.invoke((Object)callableNode);
        IElementType iElementType2 = iElementType = lighterASTNode != null ? lighterASTNode.getTokenType() : null;
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.KT_FILE) || Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CLASS_BODY)) {
            bl = false;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BLOCK)) {
            LighterASTNode lighterASTNode2 = (LighterASTNode)getParent.invoke((Object)parentNode);
            bl = !Intrinsics.areEqual((Object)(lighterASTNode2 != null ? lighterASTNode2.getTokenType() : null), (Object)KtNodeTypes.SCRIPT);
        } else {
            bl = true;
        }
        return bl;
    }
}

