/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.java.parser.BasicJavaParser;
import com.intellij.lang.java.parser.BasicJavaParserUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.AbstractBasicJavaElementTypeFactory;
import com.intellij.psi.impl.source.WhiteSpaceAndCommentSetHolder;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicPatternParser {
    private static final TokenSet PATTERN_MODIFIERS = TokenSet.create(JavaTokenType.FINAL_KEYWORD);
    private final BasicJavaParser myParser;
    private final AbstractBasicJavaElementTypeFactory.JavaElementTypeContainer myJavaElementTypeContainer;
    private final WhiteSpaceAndCommentSetHolder myWhiteSpaceAndCommentSetHolder;

    public BasicPatternParser(@NotNull BasicJavaParser javaParser) {
        if (javaParser == null) {
            BasicPatternParser.$$$reportNull$$$0(0);
        }
        this.myWhiteSpaceAndCommentSetHolder = WhiteSpaceAndCommentSetHolder.INSTANCE;
        this.myParser = javaParser;
        this.myJavaElementTypeContainer = javaParser.getJavaElementTypeFactory().getContainer();
    }

    @Contract(pure=true)
    public boolean isPattern(PsiBuilder builder) {
        PsiBuilder.Marker patternStart = this.preParsePattern(builder);
        if (patternStart == null) {
            return false;
        }
        patternStart.rollbackTo();
        return true;
    }

    private boolean parseUnnamedPattern(PsiBuilder builder) {
        PsiBuilder.Marker patternStart = builder.mark();
        if (builder.getTokenType() == JavaTokenType.IDENTIFIER && "_".equals(builder.getTokenText())) {
            BasicJavaParserUtil.emptyElement(builder, this.myJavaElementTypeContainer.TYPE);
            builder.advanceLexer();
            BasicJavaParserUtil.done(patternStart, this.myJavaElementTypeContainer.UNNAMED_PATTERN, this.myWhiteSpaceAndCommentSetHolder);
            return true;
        }
        patternStart.rollbackTo();
        return false;
    }

    @Nullable(value="when not pattern")
    @Nullable(value="when not pattern") PsiBuilder.Marker preParsePattern(PsiBuilder builder) {
        boolean isPattern;
        PsiBuilder.Marker patternStart = builder.mark();
        Boolean hasNoModifier = (Boolean)this.myParser.getDeclarationParser().parseModifierList((PsiBuilder)builder, (TokenSet)BasicPatternParser.PATTERN_MODIFIERS).second;
        PsiBuilder.Marker type = this.myParser.getReferenceParser().parseType(builder, 5);
        boolean bl = isPattern = type != null && (builder.getTokenType() == JavaTokenType.IDENTIFIER || builder.getTokenType() == JavaTokenType.LPARENTH && hasNoModifier != false);
        if (!isPattern) {
            patternStart.rollbackTo();
            return null;
        }
        return patternStart;
    }

    public @NotNull PsiBuilder.Marker parsePattern(PsiBuilder builder) {
        return this.parsePattern(builder, false);
    }

    private @NotNull PsiBuilder.Marker parsePattern(PsiBuilder builder, boolean expectVar) {
        PsiBuilder.Marker marker = this.parsePrimaryPattern(builder, expectVar);
        if (marker == null) {
            BasicPatternParser.$$$reportNull$$$0(1);
        }
        return marker;
    }

    @NotNull PsiBuilder.Marker parsePrimaryPattern(PsiBuilder builder, boolean expectVar) {
        return this.parseTypeOrRecordPattern(builder, expectVar);
    }

    private void parseRecordStructurePattern(PsiBuilder builder) {
        PsiBuilder.Marker recordStructure = builder.mark();
        boolean hasLparen = PsiBuilderUtil.expect(builder, JavaTokenType.LPARENTH);
        assert (hasLparen);
        boolean isFirst = true;
        while (builder.getTokenType() != JavaTokenType.RPARENTH) {
            if (!isFirst) {
                BasicJavaParserUtil.expectOrError(builder, JavaTokenType.COMMA, "expected.comma");
            }
            if (builder.getTokenType() == null) break;
            if (this.isPattern(builder)) {
                this.parsePattern(builder, true);
                isFirst = false;
                continue;
            }
            if (this.parseUnnamedPattern(builder)) {
                isFirst = false;
                continue;
            }
            int flags = 133;
            this.myParser.getReferenceParser().parseType(builder, flags);
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.pattern", new Object[0]));
            if (builder.getTokenType() == JavaTokenType.RPARENTH) break;
            builder.advanceLexer();
        }
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
            builder.error(JavaPsiBundle.message("expected.rparen", new Object[0]));
        }
        recordStructure.done(this.myJavaElementTypeContainer.DECONSTRUCTION_LIST);
    }

    private @NotNull PsiBuilder.Marker parseTypeOrRecordPattern(PsiBuilder builder, boolean expectVar) {
        boolean hasIdentifier;
        PsiBuilder.Marker pattern = builder.mark();
        PsiBuilder.Marker patternVariable = builder.mark();
        Boolean hasNoModifiers = (Boolean)this.myParser.getDeclarationParser().parseModifierList((PsiBuilder)builder, (TokenSet)BasicPatternParser.PATTERN_MODIFIERS).second;
        int flags = 5;
        if (expectVar) {
            flags |= 0x80;
        }
        PsiBuilder.Marker type = this.myParser.getReferenceParser().parseType(builder, flags);
        assert (type != null);
        boolean isRecord = false;
        if (builder.getTokenType() == JavaTokenType.LPARENTH && hasNoModifiers.booleanValue()) {
            this.parseRecordStructurePattern(builder);
            isRecord = true;
        }
        if (builder.getTokenType() == JavaTokenType.IDENTIFIER && (!"when".equals(builder.getTokenText()) || BasicPatternParser.isWhenAsIdentifier(isRecord))) {
            if (isRecord) {
                PsiBuilder.Marker variable = builder.mark();
                builder.advanceLexer();
                variable.done(this.myJavaElementTypeContainer.DECONSTRUCTION_PATTERN_VARIABLE);
            } else {
                builder.advanceLexer();
            }
            hasIdentifier = true;
        } else {
            hasIdentifier = false;
        }
        if (isRecord) {
            patternVariable.drop();
            BasicJavaParserUtil.done(pattern, this.myJavaElementTypeContainer.DECONSTRUCTION_PATTERN, this.myWhiteSpaceAndCommentSetHolder);
        } else {
            if (hasIdentifier) {
                BasicJavaParserUtil.done(patternVariable, this.myJavaElementTypeContainer.PATTERN_VARIABLE, this.myWhiteSpaceAndCommentSetHolder);
            } else {
                patternVariable.drop();
            }
            BasicJavaParserUtil.done(pattern, this.myJavaElementTypeContainer.TYPE_TEST_PATTERN, this.myWhiteSpaceAndCommentSetHolder);
        }
        PsiBuilder.Marker marker = pattern;
        if (marker == null) {
            BasicPatternParser.$$$reportNull$$$0(2);
        }
        return marker;
    }

    private static boolean isWhenAsIdentifier(boolean previousIsRecord) {
        return !previousIsRecord;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParser";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/parser/BasicPatternParser";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/parser/BasicPatternParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePattern";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeOrRecordPattern";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

