/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ$\u0010\u000e\u001a\u00020\u0005*\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010\u0013\u001a\u00020\u0005*\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010\u0014\u001a\u00020\u0005*\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u0015\u001a\u00020\u0005*\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J$\u0010\u0018\u001a\u00020\u0005*\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u0017H\u0002J\u001c\u0010\u001b\u001a\u00020\u0005*\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J0\u0010\u001c\u001a\u00020\u0012*\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001a0\u001eH\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/resolve/AnnotationUseSiteTargetChecker;", "", "<init>", "()V", "check", "", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkTypeReference", "topLevelTypeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "isReceiver", "", "checkAsTopLevelTypeReference", "checkDeclaration", "checkIfDelegatedProperty", "annotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "checkIfHasBackingField", "useSiteDescription", "", "checkIfMutableProperty", "checkIfProperty", "diagnosticFactory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;", "Lcom/intellij/psi/PsiElement;", "frontend"})
@SourceDebugExtension(value={"SMAP\nAnnotationUseSiteTargetChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationUseSiteTargetChecker.kt\norg/jetbrains/kotlin/resolve/AnnotationUseSiteTargetChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n1#2:176\n*E\n"})
public final class AnnotationUseSiteTargetChecker {
    @NotNull
    public static final AnnotationUseSiteTargetChecker INSTANCE = new AnnotationUseSiteTargetChecker();

    private AnnotationUseSiteTargetChecker() {
    }

    public final void check(@NotNull KtAnnotated annotated, @NotNull DeclarationDescriptor descriptor, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)annotated, (String)"annotated");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.checkDeclaration(trace, annotated, languageVersionSettings, descriptor);
        if (annotated instanceof KtCallableDeclaration) {
            KtTypeReference it;
            KtTypeReference ktTypeReference = ((KtCallableDeclaration)annotated).getReceiverTypeReference();
            if (ktTypeReference != null) {
                it = ktTypeReference;
                boolean bl = false;
                INSTANCE.checkTypeReference(trace, it, languageVersionSettings, true);
            }
            KtTypeReference ktTypeReference2 = ((KtCallableDeclaration)annotated).getTypeReference();
            if (ktTypeReference2 != null) {
                it = ktTypeReference2;
                boolean bl = false;
                INSTANCE.checkTypeReference(trace, it, languageVersionSettings, false);
            }
        }
        if (annotated instanceof KtFunction) {
            for (KtParameter parameter : ((KtFunction)annotated).getValueParameters()) {
                VariableDescriptor parameterDescriptor;
                if (parameter.hasValOrVar() || (VariableDescriptor)trace.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter) == null) continue;
                Intrinsics.checkNotNull((Object)parameter);
                this.checkDeclaration(trace, parameter, languageVersionSettings, parameterDescriptor);
                if (parameter.getTypeReference() != null) {
                    KtTypeReference it;
                    boolean bl = false;
                    INSTANCE.checkTypeReference(trace, it, languageVersionSettings, false);
                }
            }
        }
    }

    private final void checkTypeReference(BindingTrace $this$checkTypeReference, KtTypeReference topLevelTypeReference, LanguageVersionSettings languageVersionSettings, boolean isReceiver) {
        this.checkAsTopLevelTypeReference($this$checkTypeReference, topLevelTypeReference, languageVersionSettings, isReceiver);
        topLevelTypeReference.acceptChildren(VisitorWrappersKt.typeReferenceRecursiveVisitor((Function1<? super KtTypeReference, Unit>)((Function1)arg_0 -> AnnotationUseSiteTargetChecker.checkTypeReference$lambda$0($this$checkTypeReference, languageVersionSettings, arg_0))));
    }

    private final void checkAsTopLevelTypeReference(BindingTrace $this$checkAsTopLevelTypeReference, KtTypeReference topLevelTypeReference, LanguageVersionSettings languageVersionSettings, boolean isReceiver) {
        for (KtAnnotationEntry annotationEntry : topLevelTypeReference.getAnnotationEntries()) {
            Object target;
            Object object = annotationEntry.getUseSiteTarget();
            if (object == null || (object = ((KtAnnotationUseSiteTarget)object).getAnnotationUseSiteTarget()) == null || (target = object) == AnnotationUseSiteTarget.RECEIVER && isReceiver) continue;
            ParametrizedDiagnostic<KtAnnotationEntry> parametrizedDiagnostic = languageVersionSettings.supportsFeature(LanguageFeature.RestrictionOfWrongAnnotationsWithUseSiteTargetsOnTypes) ? Errors.WRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET.on((KtAnnotationEntry)((PsiElement)annotationEntry), "undefined target", ((AnnotationUseSiteTarget)((Object)target)).getRenderName()) : Errors.WRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET_ON_TYPE.on((KtAnnotationEntry)((PsiElement)annotationEntry), ((AnnotationUseSiteTarget)((Object)target)).getRenderName());
            Intrinsics.checkNotNull(parametrizedDiagnostic);
            ParametrizedDiagnostic<KtAnnotationEntry> diagnostic = parametrizedDiagnostic;
            DiagnosticUtilsKt.reportDiagnosticOnce($this$checkAsTopLevelTypeReference, diagnostic);
        }
    }

    private final void checkDeclaration(BindingTrace $this$checkDeclaration, KtAnnotated annotated, LanguageVersionSettings languageVersionSettings, DeclarationDescriptor descriptor) {
        block11: for (KtAnnotationEntry annotation : annotated.getAnnotationEntries()) {
            KtAnnotationUseSiteTarget useSiteTarget = annotation.getUseSiteTarget();
            Object object = useSiteTarget;
            if (object == null || (object = ((KtAnnotationUseSiteTarget)object).getAnnotationUseSiteTarget()) == null) continue;
            Object target = object;
            switch (WhenMappings.$EnumSwitchMapping$0[((Enum)target).ordinal()]) {
                case 1: {
                    Intrinsics.checkNotNull((Object)annotation);
                    this.checkIfHasBackingField($this$checkDeclaration, annotated, descriptor, annotation);
                    continue block11;
                }
                case 2: 
                case 3: {
                    DiagnosticFactory1<PsiElement, String> diagnosticFactory1;
                    Intrinsics.checkNotNull((Object)annotation);
                    boolean bl = languageVersionSettings.supportsFeature(LanguageFeature.ProhibitUseSiteGetTargetAnnotations);
                    if (bl) {
                        diagnosticFactory1 = Errors.INAPPLICABLE_TARGET_ON_PROPERTY;
                    } else if (!bl) {
                        diagnosticFactory1 = Errors.INAPPLICABLE_TARGET_ON_PROPERTY_WARNING;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    DiagnosticFactory1<PsiElement, String> diagnosticFactory12 = diagnosticFactory1;
                    Intrinsics.checkNotNull(diagnosticFactory12);
                    this.checkIfProperty($this$checkDeclaration, annotated, annotation, diagnosticFactory12);
                    continue block11;
                }
                case 4: {
                    Intrinsics.checkNotNull((Object)annotation);
                    this.checkIfDelegatedProperty($this$checkDeclaration, annotated, annotation);
                    continue block11;
                }
                case 5: {
                    Intrinsics.checkNotNull((Object)annotation);
                    this.checkIfMutableProperty($this$checkDeclaration, annotated, annotation);
                    continue block11;
                }
                case 6: {
                    DeclarationDescriptor containingDeclaration;
                    if (!(annotated instanceof KtParameter)) {
                        $this$checkDeclaration.report(Errors.INAPPLICABLE_PARAM_TARGET.on(annotation));
                        continue block11;
                    }
                    VariableDescriptor variableDescriptor = (VariableDescriptor)$this$checkDeclaration.getBindingContext().get(BindingContext.VALUE_PARAMETER, annotated);
                    DeclarationDescriptor declarationDescriptor = containingDeclaration = variableDescriptor != null ? variableDescriptor.getContainingDeclaration() : null;
                    if (!(containingDeclaration instanceof ConstructorDescriptor) || !((ConstructorDescriptor)containingDeclaration).isPrimary()) {
                        $this$checkDeclaration.report(Errors.INAPPLICABLE_PARAM_TARGET.on(annotation));
                        continue block11;
                    }
                    if (((KtParameter)annotated).hasValOrVar()) continue block11;
                    $this$checkDeclaration.report(Errors.REDUNDANT_ANNOTATION_TARGET.on(annotation, ((AnnotationUseSiteTarget)((Object)target)).getRenderName()));
                    continue block11;
                }
                case 7: {
                    Intrinsics.checkNotNull((Object)annotation);
                    this.checkIfMutableProperty($this$checkDeclaration, annotated, annotation);
                    continue block11;
                }
                case 8: {
                    SimpleDiagnostic<KtAnnotationUseSiteTarget> simpleDiagnostic = Errors.INAPPLICABLE_FILE_TARGET.on((KtAnnotationUseSiteTarget)((PsiElement)useSiteTarget));
                    Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, (String)"on(...)");
                    DiagnosticUtilsKt.reportDiagnosticOnce($this$checkDeclaration, simpleDiagnostic);
                    continue block11;
                }
                case 9: {
                    ParametrizedDiagnostic<KtAnnotationEntry> parametrizedDiagnostic = Errors.WRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET.on((KtAnnotationEntry)((PsiElement)annotation), "declaration", ((AnnotationUseSiteTarget)((Object)target)).getRenderName());
                    Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
                    DiagnosticUtilsKt.reportDiagnosticOnce($this$checkDeclaration, parametrizedDiagnostic);
                    continue block11;
                }
                case 10: {
                    ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.UNSUPPORTED_FEATURE.on(annotation, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.AnnotationAllUseSiteTarget), (Object)languageVersionSettings));
                    Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
                    DiagnosticUtilsKt.reportDiagnosticOnce($this$checkDeclaration, parametrizedDiagnostic);
                    continue block11;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void checkIfDelegatedProperty(BindingTrace $this$checkIfDelegatedProperty, KtAnnotated annotated, KtAnnotationEntry annotation) {
        if (annotated instanceof KtProperty && !((KtProperty)annotated).hasDelegate() || annotated instanceof KtParameter && ((KtParameter)annotated).hasValOrVar()) {
            $this$checkIfDelegatedProperty.report(Errors.INAPPLICABLE_TARGET_PROPERTY_HAS_NO_DELEGATE.on(annotation));
        }
    }

    private final void checkIfHasBackingField(BindingTrace $this$checkIfHasBackingField, KtAnnotated annotated, DeclarationDescriptor descriptor, KtAnnotationEntry annotation) {
        if (annotated instanceof KtProperty && ((KtProperty)annotated).hasDelegate() && descriptor instanceof PropertyDescriptor && !Intrinsics.areEqual($this$checkIfHasBackingField.get(BindingContext.BACKING_FIELD_REQUIRED, descriptor), (Object)true)) {
            $this$checkIfHasBackingField.report(Errors.INAPPLICABLE_TARGET_PROPERTY_HAS_NO_BACKING_FIELD.on(annotation));
        }
    }

    private final String useSiteDescription(KtAnnotationEntry $this$useSiteDescription) {
        Object object = $this$useSiteDescription.getUseSiteTarget();
        if (object == null || (object = ((KtAnnotationUseSiteTarget)object).getAnnotationUseSiteTarget()) == null || (object = ((AnnotationUseSiteTarget)((Object)object)).getRenderName()) == null) {
            object = "unknown target";
        }
        return object;
    }

    private final void checkIfMutableProperty(BindingTrace $this$checkIfMutableProperty, KtAnnotated annotated, KtAnnotationEntry annotation) {
        boolean isMutable;
        DiagnosticFactory1<PsiElement, String> diagnosticFactory1 = Errors.INAPPLICABLE_TARGET_ON_PROPERTY;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory1, (String)"INAPPLICABLE_TARGET_ON_PROPERTY");
        if (!this.checkIfProperty($this$checkIfMutableProperty, annotated, annotation, diagnosticFactory1)) {
            return;
        }
        KtAnnotated ktAnnotated = annotated;
        boolean bl = ktAnnotated instanceof KtProperty ? ((KtProperty)annotated).isVar() : (isMutable = ktAnnotated instanceof KtParameter ? ((KtParameter)annotated).isMutable() : false);
        if (!isMutable) {
            $this$checkIfMutableProperty.report(Errors.INAPPLICABLE_TARGET_PROPERTY_IMMUTABLE.on(annotation, this.useSiteDescription(annotation)));
        }
    }

    private final boolean checkIfProperty(BindingTrace $this$checkIfProperty, KtAnnotated annotated, KtAnnotationEntry annotation, DiagnosticFactory1<PsiElement, String> diagnosticFactory) {
        boolean isProperty;
        KtAnnotated ktAnnotated = annotated;
        boolean bl = ktAnnotated instanceof KtProperty ? !((KtProperty)annotated).isLocal() : (isProperty = ktAnnotated instanceof KtParameter ? ((KtParameter)annotated).hasValOrVar() : false);
        if (!isProperty) {
            $this$checkIfProperty.report(diagnosticFactory.on(annotation, this.useSiteDescription(annotation)));
        }
        return isProperty;
    }

    private static final Unit checkTypeReference$lambda$0(BindingTrace $this_checkTypeReference, LanguageVersionSettings $languageVersionSettings, KtTypeReference typeReference) {
        Intrinsics.checkNotNullParameter((Object)typeReference, (String)"typeReference");
        INSTANCE.checkAsTopLevelTypeReference($this_checkTypeReference, typeReference, $languageVersionSettings, false);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnnotationUseSiteTarget.values().length];
            try {
                nArray[AnnotationUseSiteTarget.FIELD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY_GETTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY_SETTER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.SETTER_PARAMETER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.FILE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.RECEIVER.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.ALL.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

