/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import kotlinx.collections.immutable.PersistentSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.DfaType;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.dfa.DataFlowVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.Flow;
import org.jetbrains.kotlin.fir.resolve.dfa.Implication;
import org.jetbrains.kotlin.fir.resolve.dfa.LogicSystemKt;
import org.jetbrains.kotlin.fir.resolve.dfa.ModelKt;
import org.jetbrains.kotlin.fir.resolve.dfa.MutableFlow;
import org.jetbrains.kotlin.fir.resolve.dfa.MutableTypeStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.Operation;
import org.jetbrains.kotlin.fir.resolve.dfa.OperationStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.PersistentFlow;
import org.jetbrains.kotlin.fir.resolve.dfa.PersistentTypeStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.RealVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.Statement;
import org.jetbrains.kotlin.fir.resolve.dfa.SyntheticVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.TypeStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.VariableStorage;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeIntersector;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0014J*\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u001a\u001a\u00020\u0012J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fJ\u0018\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\"J,\u0010$\u001a\b\u0012\u0004\u0012\u00020\"0%2\u0006\u0010\u001d\u001a\u00020\u00152\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\"0'j\u0002`)J\u0016\u0010*\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010+\u001a\u00020,J\u0014\u0010-\u001a\u00020\u0012*\u00020\u00152\u0006\u0010.\u001a\u00020\"H\u0002J6\u0010/\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u00100\u001a\u00020(2\u0006\u00101\u001a\u00020(2\u0016\b\u0002\u00102\u001a\u0010\u0012\u0004\u0012\u00020,\u0012\u0006\u0012\u0004\u0018\u00010,03J&\u00104\u001a\u0012\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\"0'j\u0002`)2\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010#\u001a\u000205J.\u00104\u001a\u0012\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\"0'j\u0002`)2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010#\u001a\u0002052\u0006\u00106\u001a\u00020\u0012J\u001e\u00107\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u00108\u001a\u00020\u001f2\u0006\u00109\u001a\u00020:J\u001e\u0010;\u001a\u00020\u00122\u0006\u0010<\u001a\u00020\u00182\u0006\u0010=\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u001fJ\u001e\u0010;\u001a\u00020\u00122\u0006\u0010<\u001a\u00020\u00182\u0006\u0010=\u001a\u00020\u00152\u0006\u00108\u001a\u00020\u001fJ\u001a\u0010>\u001a\u00020\u001c*\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u001a\u0010?\u001a\u00020\u001c*\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\"\u0010@\u001a\u00020\u001c*\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010A\u001a\u00020\u0018H\u0002J*\u0010B\u001a\u00020\u001c*\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010A\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u001a\u0010C\u001a\u00020\u001c*\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u001e\u0010D\u001a\u00020\u001c*\u00020\u00152\u0006\u00108\u001a\u00020\u001f2\b\u0010E\u001a\u0004\u0018\u00010\u001fH\u0002JB\u00104\u001a\u0012\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\"0'j\u0002`)2\u0018\u0010F\u001a\u0014\u0012\u0004\u0012\u00020(\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0G0'2\u0006\u0010H\u001a\u0002052\u0006\u00106\u001a\u00020\u0012H\u0002J\u0016\u0010I\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020J2\u0006\u0010#\u001a\u00020\"JF\u0010K\u001a\u0012\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\"0'j\u0002`)2\u0016\u0010L\u001a\u0012\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\"0'j\u0002`)2\u0016\u0010M\u001a\u0012\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\"0'j\u0002`)JF\u0010N\u001a\u0012\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\"0'j\u0002`)2\u0016\u0010L\u001a\u0012\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\"0'j\u0002`)2\u0016\u0010M\u001a\u0012\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\"0'j\u0002`)J\u0015\u0010O\u001a\u00020\u001c*\u00020P2\u0006\u0010Q\u001a\u00020\"H\u0082\u0002J\u0018\u0010R\u001a\u00020\"2\b\u0010<\u001a\u0004\u0018\u00010\"2\u0006\u0010=\u001a\u00020\"J\u0016\u0010R\u001a\u0004\u0018\u00010\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0\u0017J\u0016\u0010S\u001a\u0004\u0018\u00010\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0\u0017J\u0014\u0010T\u001a\u0004\u0018\u00010\u0013*\b\u0012\u0004\u0012\u00020\"0\u0017H\u0002J\u0014\u0010U\u001a\u0004\u0018\u00010\u0013*\b\u0012\u0004\u0012\u00020\"0\u0017H\u0002J\u0018\u0010V\u001a\b\u0012\u0004\u0012\u00020X0W*\b\u0012\u0004\u0012\u00020\"0\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006Y"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/LogicSystem;", "", "context", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "<init>", "(Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;)V", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "nullableNothingType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "anyType", "variableStorage", "Lorg/jetbrains/kotlin/fir/resolve/dfa/VariableStorage;", "getVariableStorage", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/VariableStorage;", "isAcceptableForSmartcast", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "joinFlow", "Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableFlow;", "flows", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/PersistentFlow;", "statementFlows", "union", "addLocalVariableAlias", "", "flow", "alias", "Lorg/jetbrains/kotlin/fir/resolve/dfa/RealVariable;", "underlyingVariable", "addTypeStatement", "Lorg/jetbrains/kotlin/fir/resolve/dfa/TypeStatement;", "statement", "addTypeStatements", "", "statements", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/DataFlowVariable;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/TypeStatements;", "addImplication", "implication", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Implication;", "containsAlready", "effect", "translateVariableFromConditionInStatements", "originalVariable", "newVariable", "transform", "Lkotlin/Function1;", "approveOperationStatement", "Lorg/jetbrains/kotlin/fir/resolve/dfa/OperationStatement;", "removeApprovedOrImpossible", "recordNewAssignment", "variable", "index", "", "isSameValueIn", "a", "b", "mergeAssignments", "copyCommonAliases", "copyNonConflictingAliases", "commonFlow", "copyStatements", "copyImplications", "replaceVariable", "replacement", "logicStatements", "Lkotlinx/collections/immutable/PersistentList;", "approvedStatement", "approveTypeStatement", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Flow;", "orForTypeStatements", "left", "right", "andForTypeStatements", "plusAssign", "Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableTypeStatement;", "other", "and", "or", "getUnifiedUpperType", "getIntersectedLowerType", "getCommonExcludedValues", "", "Lorg/jetbrains/kotlin/fir/DfaType$Symbol;", "semantics"})
@SourceDebugExtension(value={"SMAP\nLogicSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogicSystem.kt\norg/jetbrains/kotlin/fir/resolve/dfa/LogicSystem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 extensions.kt\nkotlinx/collections/immutable/ExtensionsKt\n*L\n1#1,497:1\n2783#2,7:498\n1617#2,9:506\n1869#2:515\n1870#2:517\n1626#2:518\n1625#2:519\n1869#2:520\n1870#2:522\n1626#2:523\n1740#2,3:524\n1460#2,5:527\n1869#2:532\n1634#2,3:533\n1625#2:536\n1869#2:537\n1870#2:539\n1626#2:540\n1534#2,3:541\n1537#2,3:551\n1634#2,3:554\n1870#2:557\n1299#2,4:559\n1740#2,3:570\n1761#2,3:573\n1563#2:576\n1634#2,3:577\n1374#2:580\n1460#2,2:581\n1617#2,9:583\n1869#2:592\n1870#2:594\n1626#2:595\n1462#2,3:596\n1374#2:599\n1460#2,2:600\n808#2,11:602\n1462#2,3:613\n1550#2:616\n1#3:505\n1#3:516\n1#3:521\n1#3:538\n1#3:593\n382#4,7:544\n382#4,7:563\n504#4,7:617\n382#4,7:624\n231#5:558\n*S KotlinDebug\n*F\n+ 1 LogicSystem.kt\norg/jetbrains/kotlin/fir/resolve/dfa/LogicSystem\n*L\n45#1:498,7\n78#1:506,9\n78#1:515\n78#1:517\n78#1:518\n112#1:519\n112#1:520\n112#1:522\n112#1:523\n164#1:524,3\n192#1:527,5\n192#1:532\n197#1:533,3\n200#1:536\n200#1:537\n200#1:539\n200#1:540\n204#1:541,3\n204#1:551,3\n213#1:554,3\n192#1:557\n258#1:559,4\n391#1:570,3\n392#1:573,3\n410#1:576\n410#1:577,3\n417#1:580\n417#1:581,2\n418#1:583,9\n418#1:592\n418#1:594\n418#1:595\n417#1:596,3\n425#1:599\n425#1:600,2\n425#1:602,11\n425#1:613,3\n426#1:616\n78#1:516\n112#1:521\n200#1:538\n418#1:593\n204#1:544,7\n282#1:563,7\n428#1:617,7\n300#1:624,7\n256#1:558\n*E\n"})
public abstract class LogicSystem {
    @NotNull
    private final ConeInferenceContext context;
    @NotNull
    private final ConeClassLikeType nullableNothingType;
    @NotNull
    private final ConeClassLikeType anyType;

    public LogicSystem(@NotNull ConeInferenceContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.nullableNothingType = this.getSession().getBuiltinTypes().getNullableNothingType().getConeType();
        this.anyType = this.getSession().getBuiltinTypes().getAnyType().getConeType();
    }

    @NotNull
    public final FirSession getSession() {
        return this.context.getSession();
    }

    @NotNull
    public abstract VariableStorage getVariableStorage();

    protected boolean isAcceptableForSmartcast(@NotNull ConeKotlinType $this$isAcceptableForSmartcast) {
        Intrinsics.checkNotNullParameter((Object)$this$isAcceptableForSmartcast, (String)"<this>");
        return !ConeBuiltinTypeUtilsKt.isNullableNothing($this$isAcceptableForSmartcast);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MutableFlow joinFlow(@NotNull Collection<PersistentFlow> flows, @NotNull Collection<PersistentFlow> statementFlows, boolean union) {
        Intrinsics.checkNotNullParameter(flows, (String)"flows");
        Intrinsics.checkNotNullParameter(statementFlows, (String)"statementFlows");
        switch (flows.size()) {
            case 0: {
                return new MutableFlow();
            }
            case 1: {
                return ((PersistentFlow)CollectionsKt.first((Iterable)flows)).fork();
            }
        }
        Iterable $this$reduce$iv = flows;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void b2;
            PersistentFlow persistentFlow = (PersistentFlow)iterator$iv.next();
            PersistentFlow a2 = (PersistentFlow)accumulator$iv;
            boolean bl = false;
            if (a2.lowestCommonAncestor((PersistentFlow)b2) != null) continue;
            throw new IllegalStateException(("no common ancestor in " + a2 + ", " + b2).toString());
        }
        PersistentFlow commonFlow = (PersistentFlow)accumulator$iv;
        MutableFlow result2 = commonFlow.fork();
        this.mergeAssignments(result2, flows);
        if (union) {
            this.copyNonConflictingAliases(result2, flows, commonFlow);
        } else {
            this.copyCommonAliases(result2, flows);
        }
        this.copyStatements(result2, statementFlows, commonFlow, union);
        this.copyImplications(result2, statementFlows);
        return result2;
    }

    public final void addLocalVariableAlias(@NotNull MutableFlow flow, @NotNull RealVariable alias, @NotNull RealVariable underlyingVariable) {
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        Intrinsics.checkNotNullParameter((Object)underlyingVariable, (String)"underlyingVariable");
        if (Intrinsics.areEqual((Object)underlyingVariable, (Object)alias)) {
            return;
        }
        ((Map)flow.getDirectAliasMap$semantics()).put(alias, underlyingVariable);
        Map map = flow.getBackwardsAliasMap$semantics();
        PersistentSet<RealVariable> persistentSet = (PersistentSet<RealVariable>)flow.getBackwardsAliasMap$semantics().get(underlyingVariable);
        if (persistentSet == null || (persistentSet = persistentSet.add(alias)) == null) {
            RealVariable[] realVariableArray = new RealVariable[]{alias};
            persistentSet = ExtensionsKt.persistentSetOf(realVariableArray);
        }
        PersistentSet<RealVariable> persistentSet2 = persistentSet;
        map.put(underlyingVariable, persistentSet2);
    }

    @Nullable
    public final TypeStatement addTypeStatement(@NotNull MutableFlow flow, @NotNull TypeStatement statement) {
        PersistentTypeStatement persistentTypeStatement;
        PersistentSet newLowerTypes;
        PersistentSet persistentSet;
        PersistentSet newUpperTypes;
        PersistentTypeStatement oldStatement;
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        if (statement.isEmpty()) {
            return null;
        }
        DataFlowVariable variable = statement.getVariable();
        PersistentTypeStatement persistentTypeStatement2 = oldStatement = (PersistentTypeStatement)flow.getApprovedTypeStatements$semantics().get(variable);
        PersistentSet oldUpperTypes = persistentTypeStatement2 != null ? persistentTypeStatement2.getUpperTypes() : null;
        PersistentTypeStatement persistentTypeStatement3 = oldStatement;
        PersistentSet oldLowerTypes = persistentTypeStatement3 != null ? persistentTypeStatement3.getLowerTypes() : null;
        PersistentSet persistentSet2 = oldUpperTypes;
        if (persistentSet2 == null || (persistentSet2 = persistentSet2.addAll(statement.getUpperTypes())) == null) {
            persistentSet2 = newUpperTypes = ExtensionsKt.toPersistentSet((Iterable)statement.getUpperTypes());
        }
        if ((persistentSet = oldLowerTypes) == null || (persistentSet = persistentSet.addAll(statement.getLowerTypes())) == null) {
            persistentSet = newLowerTypes = ExtensionsKt.toPersistentSet((Iterable)statement.getLowerTypes());
        }
        if (newUpperTypes == oldUpperTypes && newLowerTypes == oldLowerTypes) {
            return null;
        }
        PersistentTypeStatement it = persistentTypeStatement = new PersistentTypeStatement(variable, newUpperTypes, newLowerTypes);
        boolean bl = false;
        ((Map)flow.getApprovedTypeStatements$semantics()).put(variable, it);
        return persistentTypeStatement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TypeStatement> addTypeStatements(@NotNull MutableFlow flow, @NotNull Map<DataFlowVariable, ? extends TypeStatement> statements) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter(statements, (String)"statements");
        Iterable $this$mapNotNull$iv = statements.values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            TypeStatement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            TypeStatement it = (TypeStatement)element$iv$iv;
            boolean bl2 = false;
            if (this.addTypeStatement(flow, it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void addImplication(@NotNull MutableFlow flow, @NotNull Implication implication) {
        boolean redundant;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)implication, (String)"implication");
        Statement effect = implication.getEffect();
        if (Intrinsics.areEqual((Object)effect, (Object)implication.getCondition())) return;
        if (effect instanceof TypeStatement) {
            if (((TypeStatement)effect).isEmpty()) return;
            if (this.containsAlready(flow, (TypeStatement)effect)) {
                return;
            }
            bl = false;
        } else {
            if (effect.getVariable() instanceof SyntheticVariable && !((Map)flow.getImplications$semantics()).containsKey(effect.getVariable())) {
                return;
            }
            bl = false;
        }
        if (bl) {
            return;
        }
        boolean bl2 = redundant = false;
        if (redundant) {
            return;
        }
        DataFlowVariable variable = implication.getCondition().getVariable();
        Map map = flow.getImplications$semantics();
        PersistentList<Implication> persistentList = (PersistentList<Implication>)flow.getImplications$semantics().get(variable);
        if (persistentList == null || (persistentList = persistentList.add(implication)) == null) {
            Implication[] implicationArray = new Implication[]{implication};
            persistentList = ExtensionsKt.persistentListOf(implicationArray);
        }
        PersistentList<Implication> persistentList2 = persistentList;
        map.put(variable, persistentList2);
    }

    private final boolean containsAlready(MutableFlow $this$containsAlready, TypeStatement effect) {
        PersistentTypeStatement persistentTypeStatement = (PersistentTypeStatement)$this$containsAlready.getApprovedTypeStatements$semantics().get(effect.getVariable());
        if (persistentTypeStatement == null) {
            return false;
        }
        PersistentTypeStatement approved = persistentTypeStatement;
        return approved.getUpperTypes().containsAll((Collection)effect.getUpperTypes()) && approved.getLowerTypes().containsAll((Collection)effect.getLowerTypes());
    }

    /*
     * WARNING - void declaration
     */
    public final void translateVariableFromConditionInStatements(@NotNull MutableFlow flow, @NotNull DataFlowVariable originalVariable, @NotNull DataFlowVariable newVariable, @NotNull Function1<? super Implication, Implication> transform2) {
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)originalVariable, (String)"originalVariable");
        Intrinsics.checkNotNullParameter((Object)newVariable, (String)"newVariable");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        PersistentList statements = ModelKt.isSynthetic(originalVariable) ? (PersistentList)flow.getImplications$semantics().remove(originalVariable) : (PersistentList)flow.getImplications$semantics().get(originalVariable);
        Collection collection = statements;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        PersistentList persistentList = (PersistentList)flow.getImplications$semantics().get(newVariable);
        if (persistentList == null) {
            persistentList = ExtensionsKt.persistentListOf();
        }
        PersistentList existing = persistentList;
        Map map = flow.getImplications$semantics();
        PersistentList persistentList2 = statements;
        Collection destination$iv = existing.builder();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Implication it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            Implication it = (Implication)element$iv;
            boolean bl2 = false;
            if ((Implication)transform2.invoke((Object)ModelKt.implies(new OperationStatement(newVariable, it.getCondition().getOperation()), it.getEffect())) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        persistentList2 = ((PersistentList.Builder)destination$iv).build();
        map.put(newVariable, persistentList2);
    }

    public static /* synthetic */ void translateVariableFromConditionInStatements$default(LogicSystem logicSystem2, MutableFlow mutableFlow, DataFlowVariable dataFlowVariable, DataFlowVariable dataFlowVariable2, Function1 function1, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: translateVariableFromConditionInStatements");
        }
        if ((n2 & 8) != 0) {
            function1 = LogicSystem::translateVariableFromConditionInStatements$lambda$0;
        }
        logicSystem2.translateVariableFromConditionInStatements(mutableFlow, dataFlowVariable, dataFlowVariable2, (Function1<? super Implication, Implication>)function1);
    }

    @NotNull
    public final Map<DataFlowVariable, TypeStatement> approveOperationStatement(@NotNull PersistentFlow flow, @NotNull OperationStatement statement) {
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        return this.approveOperationStatement(MapsKt.toMutableMap((Map)flow.getImplications$semantics()), statement, false);
    }

    @NotNull
    public final Map<DataFlowVariable, TypeStatement> approveOperationStatement(@NotNull MutableFlow flow, @NotNull OperationStatement statement, boolean removeApprovedOrImpossible) {
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        return this.approveOperationStatement((Map<DataFlowVariable, ? extends PersistentList<Implication>>)flow.getImplications$semantics(), statement, removeApprovedOrImpossible);
    }

    public final void recordNewAssignment(@NotNull MutableFlow flow, @NotNull RealVariable variable, int index) {
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        this.replaceVariable(flow, variable, null);
        ((Map)flow.getAssignmentIndex$semantics()).put(variable, index);
    }

    public final boolean isSameValueIn(@NotNull PersistentFlow a2, @NotNull PersistentFlow b2, @NotNull RealVariable variable) {
        Intrinsics.checkNotNullParameter((Object)a2, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b2, (String)"b");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return Intrinsics.areEqual(a2.getAssignmentIndex$semantics().get(variable), b2.getAssignmentIndex$semantics().get(variable));
    }

    public final boolean isSameValueIn(@NotNull PersistentFlow a2, @NotNull MutableFlow b2, @NotNull RealVariable variable) {
        Intrinsics.checkNotNullParameter((Object)a2, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b2, (String)"b");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return Intrinsics.areEqual(a2.getAssignmentIndex$semantics().get(variable), b2.getAssignmentIndex$semantics().get(variable));
    }

    private final void mergeAssignments(MutableFlow $this$mergeAssignments, Collection<PersistentFlow> flows) {
        Map reassignedVariables = new LinkedHashMap();
        for (PersistentFlow entry : flows) {
            for (Map.Entry entry2 : ((Map)entry.getAssignmentIndex$semantics()).entrySet()) {
                RealVariable variable = (RealVariable)entry2.getKey();
                int index = ((Number)entry2.getValue()).intValue();
                Integer n2 = (Integer)$this$mergeAssignments.getAssignmentIndex$semantics().get(variable);
                int n3 = index;
                if (n2 != null && n2 == n3) continue;
                Map map = reassignedVariables;
                Integer n4 = (Integer)reassignedVariables.get(variable);
                int n5 = n4 != null ? n4 : 0;
                Integer n6 = Math.max(index, n5);
                map.put(variable, n6);
            }
        }
        for (Map.Entry entry : reassignedVariables.entrySet()) {
            RealVariable variable = (RealVariable)entry.getKey();
            int index = ((Number)entry.getValue()).intValue();
            this.recordNewAssignment($this$mergeAssignments, variable, index);
        }
    }

    private final void copyCommonAliases(MutableFlow $this$copyCommonAliases, Collection<PersistentFlow> flows) {
        for (Map.Entry entry : ((Map)((PersistentFlow)CollectionsKt.first((Iterable)flows)).getDirectAliasMap$semantics()).entrySet()) {
            boolean bl;
            RealVariable to;
            RealVariable from2;
            block4: {
                from2 = (RealVariable)entry.getKey();
                to = (RealVariable)entry.getValue();
                if (Intrinsics.areEqual($this$copyCommonAliases.getDirectAliasMap$semantics().get(from2), (Object)to)) continue;
                Iterable $this$all$iv = flows;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        PersistentFlow it = (PersistentFlow)element$iv;
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)it.unwrapVariable(from2), (Object)to)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            this.addLocalVariableAlias($this$copyCommonAliases, from2, to);
        }
    }

    private final void copyNonConflictingAliases(MutableFlow $this$copyNonConflictingAliases, Collection<PersistentFlow> flows, PersistentFlow commonFlow) {
        Map candidates = new LinkedHashMap();
        for (PersistentFlow entry : flows) {
            for (Map.Entry entry2 : ((Map)entry.getDirectAliasMap$semantics()).entrySet()) {
                RealVariable from2 = (RealVariable)entry2.getKey();
                RealVariable to = (RealVariable)entry2.getValue();
                Map map = candidates;
                if (Intrinsics.areEqual(commonFlow.getAssignmentIndex$semantics().get(from2), entry.getAssignmentIndex$semantics().get(from2))) continue;
                RealVariable realVariable = candidates.containsKey(from2) && !Intrinsics.areEqual(candidates.get(from2), (Object)to) ? null : to;
                map.put(from2, realVariable);
            }
        }
        for (Map.Entry entry : candidates.entrySet()) {
            RealVariable from3 = (RealVariable)entry.getKey();
            RealVariable to = (RealVariable)entry.getValue();
            RealVariable realVariable = to;
            if (realVariable == null) continue;
            this.addLocalVariableAlias($this$copyNonConflictingAliases, from3, realVariable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void copyStatements(MutableFlow $this$copyStatements, Collection<PersistentFlow> flows, PersistentFlow commonFlow, boolean union) {
        void $this$forEach$iv;
        void destination$iv;
        Iterable $this$flatMapTo$iv;
        Iterable iterable = flows;
        Collection collection = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            PersistentFlow it = (PersistentFlow)element$iv;
            boolean bl2 = false;
            Iterable list$iv = it.getKnownVariables();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        $this$flatMapTo$iv = (Iterable)destination$iv;
        boolean $i$f$forEach = false;
        block1: for (Object element$iv : $this$forEach$iv) {
            TypeStatement statement;
            PersistentFlow it;
            TypeStatement typeStatement;
            Iterator it2;
            Iterable iterable2;
            Iterable destination$iv2;
            Iterable $this$mapTo$iv;
            Object object;
            DataFlowVariable variable = (DataFlowVariable)element$iv;
            boolean bl = false;
            if (((Map)$this$copyStatements.getDirectAliasMap$semantics()).containsKey(variable)) continue;
            if (!union) {
                Iterable bl2 = flows;
                Collection collection2 = new LinkedHashSet();
                object = this;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    PersistentFlow persistentFlow = (PersistentFlow)item$iv;
                    iterable2 = destination$iv2;
                    boolean bl3 = false;
                    TypeStatement typeStatement2 = ((PersistentFlow)((Object)it2)).getTypeStatement(variable);
                    if (typeStatement2 == null) continue block1;
                    iterable2.add(typeStatement2);
                }
                typeStatement = ((LogicSystem)object).or((Collection<? extends TypeStatement>)destination$iv2);
            } else if (Intrinsics.areEqual(((Map)$this$copyStatements.getAssignmentIndex$semantics()).get(variable), ((Map)commonFlow.getAssignmentIndex$semantics()).get(variable))) {
                void $this$mapNotNullTo$iv;
                $this$mapTo$iv = flows;
                destination$iv2 = new LinkedHashSet();
                object = this;
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach2 = false;
                it2 = $this$forEach$iv$iv.iterator();
                while (it2.hasNext()) {
                    TypeStatement it$iv;
                    Object element$iv$iv;
                    Object element$iv2 = element$iv$iv = it2.next();
                    boolean bl4 = false;
                    it = (PersistentFlow)element$iv2;
                    boolean bl5 = false;
                    if (it.getTypeStatement(variable) == null) continue;
                    boolean bl6 = false;
                    destination$iv2.add(it$iv);
                }
                typeStatement = ((LogicSystem)object).and((Collection<? extends TypeStatement>)destination$iv2);
            } else {
                void $this$mapTo$iv2;
                Collection destination$iv3;
                Iterable $this$groupByTo$iv;
                destination$iv2 = flows;
                Map $i$f$mapNotNullTo = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv3 : $this$groupByTo$iv) {
                    Object object2;
                    void $this$getOrPut$iv$iv;
                    PersistentFlow it3 = (PersistentFlow)element$iv3;
                    boolean bl7 = false;
                    Integer n2 = (Integer)((Map)it3.getAssignmentIndex$semantics()).get(variable);
                    Integer key$iv = n2 != null ? n2 : -1;
                    it = destination$iv3;
                    Integer key$iv$iv = key$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
                    if (value$iv$iv == null) {
                        boolean bl8 = false;
                        List answer$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
                        object2 = answer$iv$iv;
                    } else {
                        object2 = value$iv$iv;
                    }
                    List list$iv = (List)object2;
                    it3 = (PersistentFlow)element$iv3;
                    object = list$iv;
                    boolean bl9 = false;
                    object.add(it3.getTypeStatement(variable));
                }
                void byAssignment = destination$iv3;
                Integer n3 = (Integer)((Map)commonFlow.getAssignmentIndex$semantics()).get(variable);
                byAssignment.remove(n3 != null ? n3 : -1);
                $this$groupByTo$iv = byAssignment.values();
                destination$iv3 = new LinkedHashSet();
                object = this;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv2) {
                    List it4 = (List)item$iv;
                    iterable2 = destination$iv3;
                    boolean bl10 = false;
                    TypeStatement typeStatement3 = this.and(CollectionsKt.filterNotNull((Iterable)it4));
                    if (typeStatement3 == null) continue block1;
                    iterable2.add(typeStatement3);
                }
                typeStatement = ((LogicSystem)object).or(destination$iv3);
            }
            TypeStatement typeStatement4 = statement = typeStatement;
            boolean bl11 = typeStatement4 != null ? typeStatement4.isNotEmpty() : false;
            if (!bl11) continue;
            ((Map)$this$copyStatements.getApprovedTypeStatements$semantics()).put(variable, LogicSystemKt.access$toPersistent(statement));
        }
    }

    private final void copyImplications(MutableFlow $this$copyImplications, Collection<PersistentFlow> flows) {
        switch (flows.size()) {
            case 0: {
                break;
            }
            case 1: {
                ((Map)$this$copyImplications.getImplications$semantics()).putAll((Map)((PersistentFlow)CollectionsKt.first((Iterable)flows)).getImplications$semantics());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceVariable(MutableFlow $this$replaceVariable, RealVariable variable, RealVariable replacement) {
        RealVariable original = (RealVariable)$this$replaceVariable.getDirectAliasMap$semantics().remove(variable);
        if (original != null) {
            PersistentSet siblings2;
            if (AbstractTypeChecker.RUN_SLOW_ASSERTIONS) {
                boolean bl;
                boolean bl2 = bl = !((Map)$this$replaceVariable.getBackwardsAliasMap$semantics()).containsKey(variable);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                boolean bl3 = bl = !((Map)$this$replaceVariable.getImplications$semantics()).containsKey(variable);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                boolean bl4 = bl = !((Map)$this$replaceVariable.getApprovedTypeStatements$semantics()).containsKey(variable);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
            }
            if ((siblings2 = (PersistentSet)MapsKt.getValue((Map)$this$replaceVariable.getBackwardsAliasMap$semantics(), (Object)original)).size() > 1) {
                ((Map)$this$replaceVariable.getBackwardsAliasMap$semantics()).put(original, siblings2.remove(variable));
            } else {
                $this$replaceVariable.getBackwardsAliasMap$semantics().remove(original);
            }
            if (replacement != null) {
                this.addLocalVariableAlias($this$replaceVariable, replacement, original);
            }
        } else {
            PersistentSet aliases = (PersistentSet)$this$replaceVariable.getBackwardsAliasMap$semantics().remove(variable);
            RealVariable realVariable = replacement;
            if (realVariable == null) {
                PersistentSet persistentSet = aliases;
                realVariable = persistentSet != null ? (RealVariable)CollectionsKt.first((Iterable)persistentSet) : null;
            }
            RealVariable replacementOrNext = realVariable;
            this.getVariableStorage().replaceReceiverReferencesInMembers(variable, replacementOrNext, (Function2<? super RealVariable, ? super RealVariable, Unit>)((Function2)(arg_0, arg_1) -> LogicSystem.replaceVariable$lambda$0(this, $this$replaceVariable, arg_0, arg_1)));
            LogicSystemKt.access$replaceVariableInImplications($this$replaceVariable.getImplications$semantics(), variable, replacementOrNext);
            LogicSystemKt.access$replaceVariableInStatements($this$replaceVariable.getApprovedTypeStatements$semantics(), variable, replacementOrNext);
            if (aliases != null && replacementOrNext != null) {
                Iterable $this$minus$iv;
                ((Map)$this$replaceVariable.getDirectAliasMap$semantics()).remove(replacementOrNext);
                Object object = aliases;
                RealVariable element$iv = replacementOrNext;
                boolean $i$f$minus = false;
                PersistentSet<RealVariable> withoutSelf = $this$minus$iv.remove(element$iv);
                if (!((Collection)withoutSelf).isEmpty()) {
                    void $this$associateWithTo$iv;
                    $this$minus$iv = withoutSelf;
                    Map destination$iv = $this$replaceVariable.getDirectAliasMap$semantics();
                    boolean $i$f$associateWithTo = false;
                    for (Object element$iv2 : $this$associateWithTo$iv) {
                        RealVariable realVariable2 = (RealVariable)element$iv2;
                        Object t2 = element$iv2;
                        Map map = destination$iv;
                        boolean bl = false;
                        RealVariable realVariable3 = replacementOrNext;
                        map.put(t2, realVariable3);
                    }
                    object = $this$replaceVariable.getBackwardsAliasMap$semantics();
                    RealVariable realVariable4 = replacementOrNext;
                    PersistentSet<RealVariable> persistentSet = (PersistentSet<RealVariable>)$this$replaceVariable.getBackwardsAliasMap$semantics().get(replacementOrNext);
                    if (persistentSet == null || (persistentSet = persistentSet.addAll((Collection<RealVariable>)withoutSelf)) == null) {
                        persistentSet = withoutSelf;
                    }
                    PersistentSet<RealVariable> persistentSet2 = persistentSet;
                    object.put(realVariable4, persistentSet2);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<DataFlowVariable, TypeStatement> approveOperationStatement(Map<DataFlowVariable, ? extends PersistentList<Implication>> logicStatements, OperationStatement approvedStatement, boolean removeApprovedOrImpossible) {
        LinkedList linkedList;
        Map result2 = new LinkedHashMap();
        LinkedList $this$approveOperationStatement_u24lambda_u240 = linkedList = new LinkedList();
        boolean bl = false;
        ((Collection)$this$approveOperationStatement_u24lambda_u240).add(approvedStatement);
        LinkedList queue = linkedList;
        Set approved = new LinkedHashSet();
        while (!((Collection)queue).isEmpty()) {
            PersistentList<Implication> statements;
            PersistentList<Implication> stillUnknown;
            Object object;
            void $this$getOrPut$iv;
            Object e2 = queue.removeFirst();
            Intrinsics.checkNotNullExpressionValue(e2, (String)"removeFirst(...)");
            OperationStatement next = (OperationStatement)e2;
            if (!removeApprovedOrImpossible && !approved.add(next)) continue;
            Operation operation = next.getOperation();
            DataFlowVariable variable = next.getVariable();
            ConeClassLikeType impliedType = operation == Operation.EqNull ? this.nullableNothingType : this.anyType;
            Map map = result2;
            DataFlowVariable key$iv = variable;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                MutableTypeStatement answer$iv = new MutableTypeStatement(variable, null, null, 6, null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            MutableTypeStatement resultStatement = (MutableTypeStatement)object;
            resultStatement.getUpperTypes().add(impliedType);
            switch (WhenMappings.$EnumSwitchMapping$0[operation.ordinal()]) {
                case 1: {
                    resultStatement.getLowerTypes().add(new DfaType.BooleanLiteral(false));
                    break;
                }
                case 2: {
                    resultStatement.getLowerTypes().add(new DfaType.BooleanLiteral(true));
                }
            }
            if (logicStatements.get(variable) == null || Intrinsics.areEqual(stillUnknown = statements.removeAll((Function1<Implication, Boolean>)((Function1)arg_0 -> LogicSystem.approveOperationStatement$lambda$2(operation, queue, this, result2, removeApprovedOrImpossible, arg_0))), statements) || !TypeIntrinsics.isMutableMap(logicStatements)) continue;
            if (stillUnknown.isEmpty()) {
                logicStatements.remove(variable);
                continue;
            }
            logicStatements.put(variable, stillUnknown);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean approveTypeStatement(@NotNull Flow flow, @NotNull TypeStatement statement) {
        Map map;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        DataFlowVariable variable = statement.getVariable();
        ConeKotlinType typeFromVar = variable instanceof SyntheticVariable ? ((SyntheticVariable)variable).getFir().getConeTypeOrNull() : variable.getOriginalType();
        TypeStatement known = flow.getTypeStatement(variable);
        if (known != null && typeFromVar != null) {
            void it;
            Object[] objectArray2 = objectArray = LogicSystemKt.access$toMutable(known);
            DataFlowVariable dataFlowVariable = variable;
            boolean bl = false;
            ((Collection)it.getUpperTypes()).add(typeFromVar);
            map = MapsKt.mapOf((Pair)TuplesKt.to((Object)dataFlowVariable, (Object)objectArray));
        } else if (known != null && typeFromVar == null) {
            map = MapsKt.mapOf((Pair)TuplesKt.to((Object)variable, (Object)known));
        } else if (known == null && typeFromVar != null) {
            objectArray = new ConeKotlinType[]{typeFromVar};
            map = MapsKt.mapOf((Pair)TuplesKt.to((Object)variable, (Object)new MutableTypeStatement(variable, SetsKt.mutableSetOf((Object[])objectArray), null, 4, null)));
        } else {
            return false;
        }
        Map approvedStatements = map;
        ConeKotlinType approvedUpper = this.getUnifiedUpperType(approvedStatements.values());
        ConeKotlinType approvedLower = this.getIntersectedLowerType(approvedStatements.values());
        ConeKotlinType statementUpper = this.getUnifiedUpperType(CollectionsKt.listOf((Object)statement));
        ConeKotlinType statementLower = this.getIntersectedLowerType(CollectionsKt.listOf((Object)statement));
        return !(approvedUpper != null && statementUpper != null && !AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, this.context, (KotlinTypeMarker)approvedUpper, (KotlinTypeMarker)statementUpper, false, 8, null) || approvedLower != null && statementUpper != null && AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, this.context, (KotlinTypeMarker)statementUpper, (KotlinTypeMarker)approvedLower, false, 8, null) || statementLower != null && approvedUpper != null && AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, this.context, (KotlinTypeMarker)approvedUpper, (KotlinTypeMarker)statementLower, false, 8, null));
    }

    @NotNull
    public final Map<DataFlowVariable, TypeStatement> orForTypeStatements(@NotNull Map<DataFlowVariable, ? extends TypeStatement> left, @NotNull Map<DataFlowVariable, ? extends TypeStatement> right) {
        Map map;
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        if (left.isEmpty()) {
            map = left;
        } else if (right.isEmpty()) {
            map = right;
        } else {
            Map map2;
            Map $this$orForTypeStatements_u24lambda_u240 = map2 = MapsKt.createMapBuilder();
            boolean bl = false;
            for (Map.Entry<DataFlowVariable, TypeStatement> entry : left.entrySet()) {
                DataFlowVariable variable = entry.getKey();
                TypeStatement leftStatement = entry.getValue();
                Object[] objectArray = new TypeStatement[2];
                objectArray[0] = leftStatement;
                if (right.get(variable) == null) continue;
                objectArray[1] = objectArray[1];
                TypeStatement typeStatement = this.or(CollectionsKt.listOf((Object[])objectArray));
                if (typeStatement == null) continue;
                $this$orForTypeStatements_u24lambda_u240.put(variable, typeStatement);
            }
            map = MapsKt.build((Map)map2);
        }
        return map;
    }

    @NotNull
    public final Map<DataFlowVariable, TypeStatement> andForTypeStatements(@NotNull Map<DataFlowVariable, ? extends TypeStatement> left, @NotNull Map<DataFlowVariable, ? extends TypeStatement> right) {
        Map map;
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        if (left.isEmpty()) {
            map = right;
        } else if (right.isEmpty()) {
            map = left;
        } else {
            Map map2;
            Map $this$andForTypeStatements_u24lambda_u240 = map2 = MapsKt.toMutableMap(left);
            boolean bl = false;
            for (Map.Entry<DataFlowVariable, TypeStatement> entry : right.entrySet()) {
                DataFlowVariable variable = entry.getKey();
                TypeStatement rightStatement = entry.getValue();
                $this$andForTypeStatements_u24lambda_u240.put(variable, this.and((TypeStatement)$this$andForTypeStatements_u24lambda_u240.get(variable), rightStatement));
            }
            map = map2;
        }
        return map;
    }

    private final void plusAssign(MutableTypeStatement $this$plusAssign, TypeStatement other) {
        Intrinsics.checkNotNullParameter((Object)$this$plusAssign, (String)"<this>");
        CollectionsKt.addAll((Collection)$this$plusAssign.getUpperTypes(), (Iterable)other.getUpperTypes());
        CollectionsKt.addAll((Collection)$this$plusAssign.getLowerTypes(), (Iterable)other.getLowerTypes());
    }

    @NotNull
    public final TypeStatement and(@Nullable TypeStatement a2, @NotNull TypeStatement b2) {
        TypeStatement typeStatement;
        Intrinsics.checkNotNullParameter((Object)b2, (String)"b");
        TypeStatement typeStatement2 = a2;
        if (typeStatement2 != null && (typeStatement2 = LogicSystemKt.access$toMutable(typeStatement2)) != null) {
            TypeStatement typeStatement3;
            TypeStatement $this$and_u24lambda_u240 = typeStatement3 = typeStatement2;
            boolean bl = false;
            this.plusAssign((MutableTypeStatement)$this$and_u24lambda_u240, b2);
            typeStatement = typeStatement3;
        } else {
            typeStatement = b2;
        }
        return typeStatement;
    }

    @Nullable
    public final TypeStatement and(@NotNull Collection<? extends TypeStatement> statements) {
        Intrinsics.checkNotNullParameter(statements, (String)"statements");
        switch (statements.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (TypeStatement)CollectionsKt.first((Iterable)statements);
            }
        }
        Iterator<? extends TypeStatement> iterator2 = statements.iterator();
        MutableTypeStatement result2 = LogicSystemKt.access$toMutable(iterator2.next());
        while (iterator2.hasNext()) {
            this.plusAssign(result2, iterator2.next());
        }
        return result2;
    }

    @Nullable
    public final TypeStatement or(@NotNull Collection<? extends TypeStatement> statements) {
        DfaType.Cone cone;
        ConeKotlinType[] coneKotlinTypeArray;
        PersistentSet<Object> persistentSet;
        boolean bl;
        DataFlowVariable variable;
        block23: {
            boolean $this$all$iv2;
            TypeStatement it;
            block22: {
                boolean bl2;
                Intrinsics.checkNotNullParameter(statements, (String)"statements");
                switch (statements.size()) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return (TypeStatement)CollectionsKt.first((Iterable)statements);
                    }
                }
                variable = ((TypeStatement)CollectionsKt.first((Iterable)statements)).getVariable();
                Iterable $this$all$iv2 = statements;
                boolean $i$f$all = false;
                if (((Collection)$this$all$iv2).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv2) {
                        it = (TypeStatement)element$iv;
                        boolean bl3 = false;
                        if (Intrinsics.areEqual((Object)it.getVariable(), (Object)variable)) continue;
                        bl2 = false;
                        break block22;
                    }
                    bl2 = $this$all$iv2 = true;
                }
            }
            if (_Assertions.ENABLED && !$this$all$iv2) {
                boolean $i$a$-assert-LogicSystem$or$32 = false;
                String $i$a$-assert-LogicSystem$or$32 = "folding statements for different variables";
                throw new AssertionError((Object)$i$a$-assert-LogicSystem$or$32);
            }
            Iterable $this$any$iv = statements;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (TypeStatement)element$iv;
                    boolean bl4 = false;
                    if (!it.isEmpty()) continue;
                    bl = true;
                    break block23;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        ConeKotlinType unifiedUpperType = this.getUnifiedUpperType(statements);
        if (unifiedUpperType == null) {
            persistentSet = ExtensionsKt.persistentSetOf();
        } else if (ConeBuiltinTypeUtilsKt.isNullableAny(unifiedUpperType)) {
            persistentSet = ExtensionsKt.persistentSetOf();
        } else if (this.isAcceptableForSmartcast(unifiedUpperType)) {
            coneKotlinTypeArray = new ConeKotlinType[]{unifiedUpperType};
            persistentSet = ExtensionsKt.persistentSetOf(coneKotlinTypeArray);
        } else if (TypeUtilsKt.canBeNull$default(unifiedUpperType, this.context.getSession(), false, 2, null)) {
            persistentSet = ExtensionsKt.persistentSetOf();
        } else {
            coneKotlinTypeArray = new ConeClassLikeType[]{this.context.anyType()};
            persistentSet = ExtensionsKt.persistentSetOf(coneKotlinTypeArray);
        }
        PersistentSet newUpperTypes = persistentSet;
        ConeKotlinType coneKotlinType = this.getIntersectedLowerType(statements);
        if (coneKotlinType != null) {
            ConeKotlinType p0 = coneKotlinType;
            boolean bl5 = false;
            cone = new DfaType.Cone(p0);
        } else {
            cone = null;
        }
        Set newLowerTypes = SetsKt.plus((Set)SetsKt.setOfNotNull(cone), (Iterable)this.getCommonExcludedValues(statements));
        return !((Collection)newUpperTypes).isEmpty() || !((Collection)newLowerTypes).isEmpty() ? (TypeStatement)new PersistentTypeStatement(variable, newUpperTypes, ExtensionsKt.toPersistentSet(newLowerTypes)) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final ConeKotlinType getUnifiedUpperType(Collection<? extends TypeStatement> $this$getUnifiedUpperType) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$getUnifiedUpperType;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Set<ConeKotlinType> set;
            Collection collection;
            block4: {
                block3: {
                    void statement;
                    TypeStatement typeStatement = (TypeStatement)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    set = statement.getUpperTypesOrNull();
                    if (set == null || (set = CollectionsKt.toList((Iterable)set)) == null) break block3;
                    Collection<ConeKotlinType> it = set;
                    boolean bl2 = false;
                    ConeKotlinType coneKotlinType = ConeTypeIntersector.INSTANCE.intersectTypes(this.context, (Collection<? extends ConeKotlinType>)it);
                    set = coneKotlinType;
                    if (coneKotlinType != null) break block4;
                }
                set = this.context.nullableAnyType();
            }
            collection.add(set);
        }
        List intersectedUpperTypes = (List)destination$iv$iv;
        return TypeUtilsKt.commonSuperTypeOrNull(this.context, intersectedUpperTypes);
    }

    /*
     * WARNING - void declaration
     */
    private final ConeKotlinType getIntersectedLowerType(Collection<? extends TypeStatement> $this$getIntersectedLowerType) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$getIntersectedLowerType;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            void $this$mapNotNullTo$iv$iv;
            TypeStatement statement = (TypeStatement)element$iv$iv;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = statement.getLowerTypes();
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ConeKotlinType it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                DfaType it = (DfaType)element$iv$iv2;
                boolean bl3 = false;
                DfaType.Cone cone = it instanceof DfaType.Cone ? (DfaType.Cone)it : null;
                if ((cone != null ? cone.getType() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List it = list = (List)destination$iv$iv2;
            boolean bl5 = false;
            List list2 = !((Collection)it).isEmpty() ? list : null;
            if (list2 == null) {
                list2 = CollectionsKt.listOf((Object)this.context.nothingType());
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Object it = (List)destination$iv$iv;
        boolean bl = false;
        ConeKotlinType coneKotlinType = ConeTypeIntersector.INSTANCE.intersectTypes(this.context, (Collection)it);
        it = coneKotlinType;
        boolean bl6 = false;
        return !ConeBuiltinTypeUtilsKt.isNothing((ConeKotlinType)it) ? coneKotlinType : null;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<DfaType.Symbol> getCommonExcludedValues(Collection<? extends TypeStatement> $this$getCommonExcludedValues) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$getCommonExcludedValues;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$filterIsInstanceTo$iv$iv;
            TypeStatement it = (TypeStatement)element$iv$iv;
            boolean bl = false;
            Iterable $this$filterIsInstance$iv = it.getLowerTypes();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv2 instanceof DfaType.Symbol)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$groupingBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupingBy = false;
        Map $this$filterValues$iv = GroupingKt.eachCount((Grouping)((Grouping)new Grouping<DfaType.Symbol, DfaType.Symbol>($this$groupingBy$iv){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            public Iterator<DfaType.Symbol> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public Object keyOf(Object element) {
                void var2_2;
                DfaType.Symbol it = (DfaType.Symbol)element;
                boolean bl = false;
                return var2_2;
            }
        }));
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            int it = ((Number)entry$iv.getValue()).intValue();
            boolean bl = false;
            if (!(it == $this$getCommonExcludedValues.size())) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return ((Map)result$iv).keySet();
    }

    private static final Implication translateVariableFromConditionInStatements$lambda$0(Implication it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final Unit replaceVariable$lambda$0(LogicSystem this$0, MutableFlow $this_replaceVariable, RealVariable old, RealVariable realVariable) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        this$0.replaceVariable($this_replaceVariable, old, realVariable);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean approveOperationStatement$lambda$2(Operation $operation, LinkedList $queue, LogicSystem this$0, Map $result, boolean $removeApprovedOrImpossible, Implication it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Boolean knownValue = it.getCondition().getOperation().valueIfKnown($operation);
        if (Intrinsics.areEqual((Object)knownValue, (Object)true)) {
            Statement effect = it.getEffect();
            if (effect instanceof OperationStatement) {
                ((Collection)$queue).add(effect);
            } else if (effect instanceof TypeStatement) {
                Object object;
                void $this$getOrPut$iv;
                LogicSystem logicSystem2 = this$0;
                Map map = $result;
                DataFlowVariable key$iv = ((TypeStatement)effect).getVariable();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    LogicSystem logicSystem3 = logicSystem2;
                    boolean bl = false;
                    logicSystem2 = logicSystem3;
                    MutableTypeStatement answer$iv = new MutableTypeStatement(((TypeStatement)effect).getVariable(), null, null, 6, null);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                logicSystem2.plusAssign((MutableTypeStatement)object, (TypeStatement)effect);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return $removeApprovedOrImpossible && knownValue != null;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Operation.values().length];
            try {
                nArray[Operation.EqTrue.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operation.EqFalse.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

