/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.type;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakePsiSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.config.FirContextParametersLanguageVersionSettingsChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirContextParametersDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirTypeChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.utils.exceptions.FirExceptionUtilsKt;
import org.jetbrains.kotlin.psi.KtContextReceiverList;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.stubs.elements.KtParameterElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.elements.KtTokenSets;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u0013H\u0002R\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirContextualFunctionTypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeChecker;", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirResolvedTypeRefChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "typeRef", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;)V", "valueParameterElementSet", "", "Lorg/jetbrains/kotlin/psi/stubs/elements/KtParameterElementType;", "kotlin.jvm.PlatformType", "findContextReceiverListSource", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirContextualFunctionTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContextualFunctionTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirContextualFunctionTypeChecker\n+ 2 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n+ 3 FirSourceUtils.kt\norg/jetbrains/kotlin/fir/analysis/FirSourceUtilsKt\n+ 4 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n81#2,7:97\n76#2,2:104\n57#2:106\n78#2:107\n42#3,8:108\n68#3:116\n67#3:117\n102#3,6:118\n69#3:124\n108#3:125\n50#3:126\n51#3:131\n111#3,5:132\n70#3:137\n116#3,2:140\n119#3:143\n73#3:144\n52#3:145\n86#3:146\n85#3:147\n102#3,6:148\n87#3:154\n108#3:155\n53#3:156\n54#3:163\n111#3,5:164\n88#3:169\n116#3,4:170\n91#3:174\n56#3:175\n890#4,4:127\n896#4,6:157\n890#4,4:176\n896#4,6:180\n236#5:138\n1869#6:139\n1870#6:142\n*S KotlinDebug\n*F\n+ 1 FirContextualFunctionTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirContextualFunctionTypeChecker\n*L\n43#1:97,7\n43#1:104,2\n43#1:106\n43#1:107\n47#1:108,8\n47#1:116\n47#1:117\n47#1:118,6\n47#1:124\n47#1:125\n47#1:126\n47#1:131\n47#1:132,5\n47#1:137\n47#1:140,2\n47#1:143\n47#1:144\n47#1:145\n47#1:146\n47#1:147\n47#1:148,6\n47#1:154\n47#1:155\n47#1:156\n47#1:163\n47#1:164,5\n47#1:169\n47#1:170,4\n47#1:174\n47#1:175\n47#1:127,4\n47#1:157,6\n72#1:176,4\n84#1:180,6\n47#1:138\n47#1:139\n47#1:142\n*E\n"})
public final class FirContextualFunctionTypeChecker
extends FirTypeChecker<FirResolvedTypeRef> {
    @NotNull
    public static final FirContextualFunctionTypeChecker INSTANCE = new FirContextualFunctionTypeChecker();
    @NotNull
    private static final Set<KtParameterElementType> valueParameterElementSet = SetsKt.setOf((Object)KtStubElementTypes.VALUE_PARAMETER);

    private FirContextualFunctionTypeChecker() {
        super(MppCheckerKind.Platform);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirResolvedTypeRef typeRef) {
        void types$iv;
        void $this$forEachChildOfType_u24default$iv;
        KtSourceElement source;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        KtSourceElement ktSourceElement = typeRef.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        if (!CompilerConeAttributesKt.getHasContextParameters(AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(typeRef.getConeType()))) {
            return;
        }
        KtSourceElement ktSourceElement2 = typeRef.getSource();
        if (ktSourceElement2 == null || (ktSourceElement2 = this.findContextReceiverListSource(ktSourceElement2)) == null) {
            void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            void $this$buildAttachment$iv$iv$iv;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder;
            void cause$iv$iv;
            void message$iv$iv;
            String message$iv = "Source for type ref of contextual function type doesn't contain context list.";
            Object cause$iv = null;
            String attachmentName$iv = "info.txt";
            boolean $i$f$errorWithAttachment = false;
            String string = message$iv;
            Object var12_15 = cause$iv;
            String attachmentName$iv$iv = attachmentName$iv;
            boolean $i$f$buildErrorWithAttachment = false;
            KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments((String)message$iv$iv, (Throwable)cause$iv$iv);
            KotlinExceptionWithAttachments kotlinExceptionWithAttachments = exception$iv$iv;
            String name$iv$iv$iv = attachmentName$iv$iv;
            boolean $i$f$buildAttachment = false;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
            String string2 = name$iv$iv$iv;
            void var22_45 = $this$buildAttachment$iv$iv$iv;
            boolean bl = false;
            void $this$check_u24lambda_u240 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            boolean bl2 = false;
            FirExceptionUtilsKt.withFirEntry((ExceptionAttachmentBuilder)$this$check_u24lambda_u240, "fir", typeRef);
            var22_45.withAttachment(string2, exceptionAttachmentBuilder.buildString());
            throw (Throwable)exception$iv$iv;
        }
        KtSourceElement ktSourceElement3 = source = ktSourceElement2;
        Set<KtParameterElementType> set = valueParameterElementSet;
        boolean depth$iv = true;
        boolean reverse$iv = false;
        boolean $i$f$forEachChildOfType = false;
        void var10_11 = $this$forEachChildOfType_u24default$iv;
        if (var10_11 instanceof KtPsiSourceElement) {
            void root$iv$iv$iv;
            void depth$iv$iv;
            void types$iv$iv;
            void $this$forEachChildOfType$iv$iv;
            PsiElement message$iv$iv = ((KtPsiSourceElement)$this$forEachChildOfType_u24default$iv).getPsi();
            void cause$iv$iv = types$iv;
            boolean attachmentName$iv$iv = depth$iv;
            boolean reverse$iv$iv = reverse$iv;
            boolean $i$f$forEachChildOfType2 = false;
            void $this$buildAttachment$iv$iv$iv = $this$forEachChildOfType$iv$iv;
            void name$iv$iv$iv = types$iv$iv;
            void $i$f$buildAttachment = depth$iv$iv;
            boolean bl = reverse$iv$iv;
            boolean $i$f$forEachChildOfType3 = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)root$iv$iv$iv, (Object)0)};
            List stack$iv$iv$iv = CollectionsKt.mutableListOf((Object[])pairArray);
            while (!((Collection)stack$iv$iv$iv).isEmpty()) {
                void $this$forEach$iv$iv$iv$iv;
                Iterable $this$butIf$iv$iv$iv$iv;
                void depth$iv$iv$iv;
                PsiElement it$iv$iv;
                pairArray = (Pair[])AddToStdlibKt.popLast(stack$iv$iv$iv);
                Object element$iv$iv$iv = pairArray.component1();
                int currentDepth$iv$iv$iv = ((Number)pairArray.component2()).intValue();
                if (currentDepth$iv$iv$iv != 0) {
                    void types$iv$iv$iv;
                    PsiElement bl2 = (PsiElement)element$iv$iv$iv;
                    void var26_60 = types$iv$iv$iv;
                    boolean bl3 = false;
                    IElementType iElementType = it$iv$iv.getNode().getElementType();
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
                    if (var26_60.contains(iElementType)) {
                        KtPsiSourceElement ktPsiSourceElement;
                        PsiElement it$iv = (PsiElement)element$iv$iv$iv;
                        boolean bl4 = false;
                        PsiElement $this$toKtPsiSourceElement_u24default$iv$iv = it$iv;
                        KtSourceElementKind kind$iv$iv = KtRealSourceElementKind.INSTANCE;
                        boolean $i$f$toKtPsiSourceElement = false;
                        KtSourceElementKind ktSourceElementKind = kind$iv$iv;
                        if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                            ktPsiSourceElement = new KtRealPsiSourceElement($this$toKtPsiSourceElement_u24default$iv$iv);
                        } else if (ktSourceElementKind instanceof KtFakeSourceElementKind) {
                            ktPsiSourceElement = new KtFakePsiSourceElement($this$toKtPsiSourceElement_u24default$iv$iv, (KtFakeSourceElementKind)kind$iv$iv);
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        KtSourceElement it = ktPsiSourceElement;
                        boolean bl5 = false;
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getNAMED_CONTEXT_PARAMETER_IN_FUNCTION_TYPE(), null, 8, null);
                    }
                }
                if (currentDepth$iv$iv$iv == depth$iv$iv$iv) continue;
                it$iv$iv = (PsiElement)element$iv$iv$iv;
                boolean bl6 = false;
                List list = SequencesKt.toList((Sequence)PsiUtilsKt.getAllChildren(it$iv$iv));
                boolean condition$iv$iv$iv$iv = true;
                boolean $i$f$butIf22 = false;
                void it$iv$iv$iv = $this$butIf$iv$iv$iv$iv;
                boolean bl7 = false;
                $this$butIf$iv$iv$iv$iv = CollectionsKt.asReversed((List)it$iv$iv$iv);
                boolean $i$f$forEach = false;
                Iterator $i$f$butIf22 = $this$forEach$iv$iv$iv$iv.iterator();
                while ($i$f$butIf22.hasNext()) {
                    Object element$iv$iv$iv$iv;
                    Object child$iv$iv$iv = element$iv$iv$iv$iv = $i$f$butIf22.next();
                    boolean bl8 = false;
                    ((Collection)stack$iv$iv$iv).add(TuplesKt.to(child$iv$iv$iv, (Object)(currentDepth$iv$iv$iv + 1)));
                }
            }
        } else if (var10_11 instanceof KtLightSourceElement) {
            void root$iv$iv$iv;
            LighterASTNode $this$forEachChildOfType$iv$iv = ((KtLightSourceElement)$this$forEachChildOfType_u24default$iv).getLighterASTNode();
            void types$iv$iv = types$iv;
            boolean depth$iv$iv = depth$iv;
            boolean reverse$iv$iv = reverse$iv;
            FlyweightCapableTreeStructure<LighterASTNode> treeStructure$iv$iv = ((KtLightSourceElement)$this$forEachChildOfType_u24default$iv).getTreeStructure();
            boolean $i$f$forEachChildOfType4 = false;
            LighterASTNode types$iv$iv$iv = $this$forEachChildOfType$iv$iv;
            void depth$iv$iv$iv = types$iv$iv;
            boolean reverse$iv$iv$iv = depth$iv$iv;
            boolean $i$f$forEachChildOfType3 = reverse$iv$iv;
            boolean $i$f$forEachChildOfType5 = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)root$iv$iv$iv, (Object)0)};
            List stack$iv$iv$iv = CollectionsKt.mutableListOf((Object[])pairArray);
            while (!((Collection)stack$iv$iv$iv).isEmpty()) {
                void $this$forEach$iv$iv$iv$iv;
                Iterable $this$butIf$iv$iv$iv$iv;
                void depth$iv$iv$iv2;
                LighterASTNode it$iv$iv;
                pairArray = (Pair[])AddToStdlibKt.popLast(stack$iv$iv$iv);
                Object element$iv$iv$iv = pairArray.component1();
                int currentDepth$iv$iv$iv = ((Number)pairArray.component2()).intValue();
                if (currentDepth$iv$iv$iv != 0) {
                    void types$iv$iv$iv2;
                    LighterASTNode lighterASTNode = (LighterASTNode)element$iv$iv$iv;
                    void var27_63 = types$iv$iv$iv2;
                    boolean bl = false;
                    IElementType iElementType = it$iv$iv.getTokenType();
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getTokenType(...)");
                    if (var27_63.contains(iElementType)) {
                        void $this$toKtLightSourceElement_u24default$iv$iv;
                        LighterASTNode it$iv = (LighterASTNode)element$iv$iv$iv;
                        boolean bl9 = false;
                        LighterASTNode kind$iv$iv = it$iv;
                        FlyweightCapableTreeStructure<LighterASTNode> tree$iv$iv = ((KtLightSourceElement)$this$forEachChildOfType_u24default$iv).getTreeStructure();
                        KtSourceElementKind kind$iv$iv2 = KtRealSourceElementKind.INSTANCE;
                        int startOffset$iv$iv = $this$toKtLightSourceElement_u24default$iv$iv.getStartOffset();
                        int endOffset$iv$iv = $this$toKtLightSourceElement_u24default$iv$iv.getEndOffset();
                        boolean $i$f$toKtLightSourceElement = false;
                        KtSourceElement it = new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv$iv, startOffset$iv$iv, endOffset$iv$iv, tree$iv$iv, kind$iv$iv2);
                        boolean bl10 = false;
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getNAMED_CONTEXT_PARAMETER_IN_FUNCTION_TYPE(), null, 8, null);
                    }
                }
                if (currentDepth$iv$iv$iv == depth$iv$iv$iv2) continue;
                it$iv$iv = (LighterASTNode)element$iv$iv$iv;
                boolean bl = false;
                List<LighterASTNode> element$iv$iv$iv$iv = LightTreeUtilsKt.getChildren(it$iv$iv, treeStructure$iv$iv);
                boolean condition$iv$iv$iv$iv = true;
                boolean $i$f$butIf = false;
                void it$iv$iv$iv = $this$butIf$iv$iv$iv$iv;
                boolean bl11 = false;
                $this$butIf$iv$iv$iv$iv = CollectionsKt.asReversed((List)it$iv$iv$iv);
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv$iv$iv2;
                    Object child$iv$iv$iv = element$iv$iv$iv$iv2 = iterator2.next();
                    boolean bl12 = false;
                    ((Collection)stack$iv$iv$iv).add(TuplesKt.to(child$iv$iv$iv, (Object)(currentDepth$iv$iv$iv + 1)));
                }
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        if (LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.ContextReceivers)) {
            if (FirContextParametersDeclarationChecker.INSTANCE.checkSubTypes(context2, FunctionalTypeUtilsKt.contextParameterTypes(typeRef.getConeType(), context2.getSession()))) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getSUBTYPING_BETWEEN_CONTEXT_RECEIVERS(), null, 8, null);
            }
            String message2 = FirContextParametersLanguageVersionSettingsChecker.INSTANCE.getMessage(context2.getLanguageVersionSettings());
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getCONTEXT_RECEIVERS_DEPRECATED(), (Object)message2, null, 16, null);
        } else {
            FirHelpersKt.requireFeatureSupport$default(context2, reporter, source, LanguageFeature.ContextParameters, null, 8, null);
        }
    }

    private final KtSourceElement findContextReceiverListSource(KtSourceElement $this$findContextReceiverListSource) {
        KtSourceElement ktSourceElement;
        KtSourceElement ktSourceElement2 = $this$findContextReceiverListSource;
        if (ktSourceElement2 instanceof KtPsiSourceElement) {
            ktSourceElement = FirContextualFunctionTypeChecker.findContextReceiverListSource$findContextReceiverListSource(((KtPsiSourceElement)$this$findContextReceiverListSource).getPsi());
        } else if (ktSourceElement2 instanceof KtLightSourceElement) {
            ktSourceElement = FirContextualFunctionTypeChecker.findContextReceiverListSource$findContextReceiverListSource$0(((KtLightSourceElement)$this$findContextReceiverListSource).getLighterASTNode(), ((KtLightSourceElement)$this$findContextReceiverListSource).getTreeStructure());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return ktSourceElement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final KtPsiSourceElement findContextReceiverListSource$findContextReceiverListSource(PsiElement $this$findContextReceiverListSource_u24findContextReceiverListSource) {
        KtPsiSourceElement ktPsiSourceElement;
        PsiElement psiElement = $this$findContextReceiverListSource_u24findContextReceiverListSource;
        if (psiElement instanceof KtTypeReference) {
            KtTypeElement ktTypeElement = ((KtTypeReference)$this$findContextReceiverListSource_u24findContextReceiverListSource).getTypeElement();
            if (ktTypeElement == null) return null;
            ktPsiSourceElement = FirContextualFunctionTypeChecker.findContextReceiverListSource$findContextReceiverListSource(ktTypeElement);
            return ktPsiSourceElement;
        } else if (psiElement instanceof KtNullableType) {
            KtTypeElement ktTypeElement = ((KtNullableType)$this$findContextReceiverListSource_u24findContextReceiverListSource).getInnerType();
            if (ktTypeElement == null) return null;
            ktPsiSourceElement = FirContextualFunctionTypeChecker.findContextReceiverListSource$findContextReceiverListSource(ktTypeElement);
            return ktPsiSourceElement;
        } else {
            if (!(psiElement instanceof KtFunctionType)) return null;
            KtContextReceiverList ktContextReceiverList = ((KtFunctionType)$this$findContextReceiverListSource_u24findContextReceiverListSource).getContextReceiverList();
            if (ktContextReceiverList == null) return null;
            PsiElement $this$toKtPsiSourceElement_u24default$iv = ktContextReceiverList;
            KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
            boolean $i$f$toKtPsiSourceElement = false;
            KtSourceElementKind ktSourceElementKind = kind$iv;
            if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                ktPsiSourceElement = new KtRealPsiSourceElement($this$toKtPsiSourceElement_u24default$iv);
                return ktPsiSourceElement;
            } else {
                if (!(ktSourceElementKind instanceof KtFakeSourceElementKind)) throw new NoWhenBranchMatchedException();
                ktPsiSourceElement = new KtFakePsiSourceElement($this$toKtPsiSourceElement_u24default$iv, (KtFakeSourceElementKind)kind$iv);
            }
        }
        return ktPsiSourceElement;
    }

    /*
     * WARNING - void declaration
     */
    private static final KtLightSourceElement findContextReceiverListSource$findContextReceiverListSource$0(LighterASTNode $this$findContextReceiverListSource_u24findContextReceiverListSource_u240, FlyweightCapableTreeStructure<LighterASTNode> tree) {
        KtLightSourceElement ktLightSourceElement;
        IElementType iElementType = $this$findContextReceiverListSource_u24findContextReceiverListSource_u240.getTokenType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.TYPE_REFERENCE) || Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.NULLABLE_TYPE)) {
            TokenSet tokenSet = KtTokenSets.TYPE_ELEMENT_TYPES;
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"TYPE_ELEMENT_TYPES");
            LighterASTNode lighterASTNode = LightTreePositioningStrategiesKt.findChildByType(tree, $this$findContextReceiverListSource_u24findContextReceiverListSource_u240, tokenSet);
            ktLightSourceElement = lighterASTNode != null ? FirContextualFunctionTypeChecker.findContextReceiverListSource$findContextReceiverListSource$0(lighterASTNode, tree) : null;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.FUNCTION_TYPE)) {
            IElementType iElementType2 = KtNodeTypes.CONTEXT_RECEIVER_LIST;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"CONTEXT_RECEIVER_LIST");
            LighterASTNode lighterASTNode = LightTreePositioningStrategiesKt.findChildByType(tree, $this$findContextReceiverListSource_u24findContextReceiverListSource_u240, iElementType2);
            if (lighterASTNode != null) {
                void $this$toKtLightSourceElement_u24default$iv;
                LighterASTNode lighterASTNode2 = lighterASTNode;
                FlyweightCapableTreeStructure<LighterASTNode> tree$iv = tree;
                KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
                int startOffset$iv = $this$toKtLightSourceElement_u24default$iv.getStartOffset();
                int endOffset$iv = $this$toKtLightSourceElement_u24default$iv.getEndOffset();
                boolean $i$f$toKtLightSourceElement = false;
                ktLightSourceElement = new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv, startOffset$iv, endOffset$iv, tree$iv, kind$iv);
            } else {
                ktLightSourceElement = null;
            }
        } else {
            ktLightSourceElement = null;
        }
        return ktLightSourceElement;
    }
}

