/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImplKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CatchClauseEnterNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CatchClauseExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitorVoid;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.Edge;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ElvisExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ElvisLhsExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ElvisLhsIsNotNullNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FinallyBlockEnterNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FinallyBlockExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FunctionCallExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FunctionExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.TailrecExitNodeMarker;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.TryMainBlockEnterNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.TryMainBlockExitNode;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTailrecFunctionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)V", "hasMoreFollowingInstructions", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "tailrecFunction", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "correspondingElvisExitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ElvisExitNode;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ElvisLhsExitNode;", "getCorrespondingElvisExitNode", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ElvisLhsExitNode;)Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ElvisExitNode;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirTailrecFunctionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTailrecFunctionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTailrecFunctionChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,126:1\n53#2:127\n23#2:128\n23#3,2:129\n*S KotlinDebug\n*F\n+ 1 FirTailrecFunctionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTailrecFunctionChecker\n*L\n34#1:127\n35#1:128\n124#1:129,2\n*E\n"})
public final class FirTailrecFunctionChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirTailrecFunctionChecker INSTANCE = new FirTailrecFunctionChecker();

    private FirTailrecFunctionChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFunction declaration) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirMemberDeclaration $this$isTailRec$iv = declaration;
        boolean $i$f$isTailRec = false;
        if (!$this$isTailRec$iv.getStatus().isTailRec()) {
            return;
        }
        if (!DeclarationUtilsKt.isEffectivelyFinal(declaration)) {
            FirMemberDeclaration $this$visibility$iv = declaration;
            boolean $i$f$getVisibility = false;
            if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getTAILREC_ON_VIRTUAL_MEMBER_ERROR(), null, 8, null);
            }
        }
        if ((object = declaration.getControlFlowGraphReference()) == null || (object = FirControlFlowGraphReferenceImplKt.getControlFlowGraph((FirControlFlowGraphReference)object)) == null) {
            return;
        }
        Object graph2 = object;
        Ref.IntRef tryScopeCount = new Ref.IntRef();
        Ref.IntRef catchScopeCount = new Ref.IntRef();
        Ref.IntRef finallyScopeCount = new Ref.IntRef();
        Ref.IntRef tailrecCount = new Ref.IntRef();
        ((ControlFlowGraph)graph2).traverse(new ControlFlowGraphVisitorVoid(tryScopeCount, catchScopeCount, finallyScopeCount, declaration, context2, reporter, tailrecCount){
            final /* synthetic */ Ref.IntRef $tryScopeCount;
            final /* synthetic */ Ref.IntRef $catchScopeCount;
            final /* synthetic */ Ref.IntRef $finallyScopeCount;
            final /* synthetic */ FirFunction $declaration;
            final /* synthetic */ CheckerContext $context;
            final /* synthetic */ DiagnosticReporter $reporter;
            final /* synthetic */ Ref.IntRef $tailrecCount;
            {
                this.$tryScopeCount = $tryScopeCount;
                this.$catchScopeCount = $catchScopeCount;
                this.$finallyScopeCount = $finallyScopeCount;
                this.$declaration = $declaration;
                this.$context = $context;
                this.$reporter = $reporter;
                this.$tailrecCount = $tailrecCount;
            }

            public void visitNode(CFGNode<?> node) {
                Intrinsics.checkNotNullParameter(node, (String)"node");
            }

            public void visitTryMainBlockEnterNode(TryMainBlockEnterNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                int n2 = this.$tryScopeCount.element;
                this.$tryScopeCount.element = n2 + 1;
            }

            public void visitTryMainBlockExitNode(TryMainBlockExitNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                int n2 = this.$tryScopeCount.element;
                this.$tryScopeCount.element = n2 + -1;
            }

            public void visitCatchClauseEnterNode(CatchClauseEnterNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                int n2 = this.$catchScopeCount.element;
                this.$catchScopeCount.element = n2 + 1;
            }

            public void visitCatchClauseExitNode(CatchClauseExitNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                int n2 = this.$catchScopeCount.element;
                this.$catchScopeCount.element = n2 + -1;
            }

            public void visitFinallyBlockEnterNode(FinallyBlockEnterNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                int n2 = this.$finallyScopeCount.element;
                this.$finallyScopeCount.element = n2 + 1;
            }

            public void visitFinallyBlockExitNode(FinallyBlockExitNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                int n2 = this.$finallyScopeCount.element;
                this.$finallyScopeCount.element = n2 + -1;
            }

            /*
             * Unable to fully structure code
             */
            public void visitFunctionCallExitNode(FunctionCallExitNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                functionCall = node.getFir();
                var5_3 = FirReferenceUtilsKt.toResolvedCallableSymbol$default(functionCall.getCalleeReference(), false, 1, null);
                v0 = var5_3 instanceof FirNamedFunctionSymbol != false ? (FirNamedFunctionSymbol)var5_3 : null;
                if (v0 == null) {
                    return;
                }
                resolvedSymbol = v0;
                if (!Intrinsics.areEqual((Object)resolvedSymbol, this.$declaration.getSymbol())) {
                    return;
                }
                $this$arguments$iv = functionCall;
                $i$f$getArguments = false;
                if ($this$arguments$iv.getArgumentList().getArguments().size() != resolvedSymbol.getValueParameterSymbols().size()) {
                    $this$isOverride$iv = resolvedSymbol;
                    $i$f$isOverride = false;
                    if ($this$isOverride$iv.getResolvedStatus().isOverride()) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)this.$context, this.$reporter, (AbstractKtSourceElement)functionCall.getSource(), FirErrors.INSTANCE.getNON_TAIL_RECURSIVE_CALL(), null, 8, null);
                        return;
                    }
                }
                dispatchReceiver = functionCall.getDispatchReceiver();
                v1 = this.$declaration.getDispatchReceiverType();
                v2 = dispatchReceiverOwner = v1 != null ? ToSymbolUtilsKt.toClassSymbol(v1, this.$context.getSession()) : null;
                if (dispatchReceiver == null || dispatchReceiver instanceof FirThisReceiverExpression && Intrinsics.areEqual(((FirThisReceiverExpression)dispatchReceiver).getCalleeReference().getBoundSymbol(), dispatchReceiverOwner)) ** GOTO lbl-1000
                v3 = dispatchReceiverOwner;
                v4 = v3 != null && (v3 = v3.getClassKind()) != null ? v3.isSingleton() : false;
                if (v4) lbl-1000:
                // 2 sources

                {
                    v5 = true;
                } else {
                    v5 = sameReceiver = false;
                }
                if (!sameReceiver) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)this.$context, this.$reporter, (AbstractKtSourceElement)functionCall.getSource(), FirErrors.INSTANCE.getNON_TAIL_RECURSIVE_CALL(), null, 8, null);
                } else if (this.$tryScopeCount.element > 0 || this.$catchScopeCount.element > 0 || this.$finallyScopeCount.element > 0) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)this.$context, this.$reporter, (AbstractKtSourceElement)functionCall.getSource(), FirErrors.INSTANCE.getTAIL_RECURSION_IN_TRY_IS_NOT_SUPPORTED(), null, 8, null);
                } else if (FirTailrecFunctionChecker.access$hasMoreFollowingInstructions(FirTailrecFunctionChecker.INSTANCE, node, this.$declaration, this.$context.getSession())) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)this.$context, this.$reporter, (AbstractKtSourceElement)functionCall.getSource(), FirErrors.INSTANCE.getNON_TAIL_RECURSIVE_CALL(), null, 8, null);
                } else if (!node.isDead()) {
                    var7_9 = this.$tailrecCount.element;
                    this.$tailrecCount.element = var7_9 + 1;
                }
            }
        });
        if (tailrecCount.element == 0) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getNO_TAIL_CALLS_FOUND(), null, 8, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasMoreFollowingInstructions(CFGNode<?> $this$hasMoreFollowingInstructions, FirFunction tailrecFunction, FirSession session) {
        boolean returnTypeMayBeNullable = TypeUtilsKt.canBeNull$default(FirTypeUtilsKt.getConeType(tailrecFunction.getReturnTypeRef()), session, false, 2, null);
        Iterator<CFGNode<?>> iterator2 = $this$hasMoreFollowingInstructions.getFollowingNodes().iterator();
        while (iterator2.hasNext()) {
            boolean hasMore;
            boolean bl;
            CFGNode<?> next = iterator2.next();
            Edge edge = $this$hasMoreFollowingInstructions.edgeTo(next);
            if (!edge.getKind().getUsedInCfa() || edge.getKind().isDead()) continue;
            if (edge.getKind().isBack()) {
                return true;
            }
            CFGNode<?> cFGNode = next;
            if (cFGNode instanceof FunctionExitNode) {
                if (Intrinsics.areEqual((Object)((FunctionExitNode)next).getFir(), (Object)tailrecFunction)) return false;
                return true;
            }
            if (cFGNode instanceof ElvisLhsExitNode && !returnTypeMayBeNullable) {
                ElvisExitNode elvisExitNode = this.getCorrespondingElvisExitNode((ElvisLhsExitNode)next);
                if (elvisExitNode == null) return true;
                bl = this.hasMoreFollowingInstructions(elvisExitNode, tailrecFunction, session);
            } else {
                if (!(cFGNode instanceof TailrecExitNodeMarker)) return true;
                bl = this.hasMoreFollowingInstructions(next, tailrecFunction, session);
            }
            if (hasMore = bl) return true;
        }
        return false;
    }

    @Nullable
    public final ElvisExitNode getCorrespondingElvisExitNode(@NotNull ElvisLhsExitNode $this$correspondingElvisExitNode) {
        ElvisExitNode elvisExitNode;
        Object object;
        Object v0;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$correspondingElvisExitNode, (String)"<this>");
            Iterable $this$firstIsInstanceOrNull$iv = $this$correspondingElvisExitNode.getFollowingNodes();
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof ElvisLhsIsNotNullNode)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        if ((object = (ElvisLhsIsNotNullNode)v0) != null && (object = ((CFGNode)object).getFollowingNodes()) != null) {
            Object v2;
            block5: {
                Iterable $this$firstIsInstanceOrNull$iv = (Iterable)object;
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv instanceof ElvisExitNode)) continue;
                    v2 = element$iv;
                    break block5;
                }
                v2 = null;
            }
            elvisExitNode = v2;
        } else {
            elvisExitNode = null;
        }
        return elvisExitNode;
    }

    public static final /* synthetic */ boolean access$hasMoreFollowingInstructions(FirTailrecFunctionChecker $this, CFGNode $receiver, FirFunction tailrecFunction, FirSession session) {
        return $this.hasMoreFollowingInstructions($receiver, tailrecFunction, session);
    }
}

