/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.AttributeList;
import org.jdom.Content;
import org.jdom.ContentList;
import org.jdom.DocType;
import org.jdom.IllegalAddException;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.filter2.Filters;

public class Element
extends Content
implements Serializable,
Parent {
    protected String name;
    protected Namespace namespace;
    transient List<Namespace> additionalNamespaces;
    transient AttributeList attributes = null;
    protected transient ContentList content = new ContentList(this);

    protected Element() {
        super(Content.CType.Element);
    }

    public String getName() {
        return this.name;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getNamespaceURI() {
        return this.namespace.getURI();
    }

    public String getQualifiedName() {
        if ("".equals(this.namespace.getPrefix())) {
            return this.getName();
        }
        return this.namespace.getPrefix() + ':' + this.name;
    }

    public void addNamespaceDeclaration(Namespace additionalNamespace) {
        if (this.additionalNamespaces == null) {
            this.additionalNamespaces = new ArrayList<Namespace>();
        } else {
            for (Namespace ns : this.additionalNamespaces) {
                if (ns != additionalNamespace) continue;
                return;
            }
        }
        String reason = Verifier.checkNamespaceCollision(additionalNamespace, this);
        if (reason != null) {
            throw new IllegalAddException(this, additionalNamespace, reason);
        }
        this.additionalNamespaces.add(additionalNamespace);
    }

    public List<Namespace> getAdditionalNamespaces() {
        if (this.additionalNamespaces == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.additionalNamespaces);
    }

    @Override
    public String getValue() {
        StringBuilder buffer = new StringBuilder();
        for (Content child : this.getContent()) {
            if (!(child instanceof Element) && !(child instanceof Text)) continue;
            buffer.append(child.getValue());
        }
        return buffer.toString();
    }

    public List<Content> getContent() {
        return this.content;
    }

    public Element addContent(Content child) {
        this.content.add(child);
        return this;
    }

    public boolean isAncestor(Element element) {
        Parent p2 = element.getParent();
        while (p2 instanceof Element) {
            if (p2 == this) {
                return true;
            }
            p2 = p2.getParent();
        }
        return false;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public boolean hasAdditionalNamespaces() {
        return this.additionalNamespaces != null && !this.additionalNamespaces.isEmpty();
    }

    private AttributeList getAttributeList() {
        if (this.attributes == null) {
            this.attributes = new AttributeList(this);
        }
        return this.attributes;
    }

    public List<Attribute> getAttributes() {
        return this.getAttributeList();
    }

    public String getAttributeValue(String name2) {
        return this.attributes == null ? null : this.getAttributeValue(name2, Namespace.NO_NAMESPACE, null);
    }

    public String getAttributeValue(String name2, Namespace ns) {
        return this.getAttributeValue(name2, ns, null);
    }

    public String getAttributeValue(String name2, Namespace ns, String defaultValue) {
        AttributeList attributes = this.attributes;
        Attribute attribute = attributes == null ? null : attributes.get(name2, ns);
        return attribute == null ? defaultValue : attribute.getValue();
    }

    public Element setAttribute(Attribute attribute) {
        this.getAttributeList().add(attribute);
        return this;
    }

    public String toString() {
        StringBuilder stringForm = new StringBuilder(64).append("[Element: <").append(this.getQualifiedName());
        String namespaceUri = this.getNamespaceURI();
        if (!"".equals(namespaceUri)) {
            stringForm.append(" [Namespace: ").append(namespaceUri).append("]");
        }
        stringForm.append("/>]");
        return stringForm.toString();
    }

    @Override
    public Element clone() {
        int i2;
        Element element = (Element)super.clone();
        element.content = new ContentList(element);
        AttributeList attributeList = element.attributes = this.attributes == null ? null : new AttributeList(element);
        if (this.attributes != null) {
            for (i2 = 0; i2 < this.attributes.size(); ++i2) {
                Attribute attribute = this.attributes.get(i2);
                element.attributes.add(attribute.clone());
            }
        }
        if (this.additionalNamespaces != null) {
            element.additionalNamespaces = new ArrayList<Namespace>(this.additionalNamespaces);
        }
        for (i2 = 0; i2 < this.content.size(); ++i2) {
            Content c2 = this.content.get(i2);
            element.content.add(c2.clone());
        }
        return element;
    }

    public List<Element> getChildren() {
        return this.content.getView(Filters.element());
    }

    public Element getChild(String cname, Namespace namespace) {
        for (Content child : this.content) {
            if (!(child instanceof Element)) continue;
            Element element = (Element)child;
            if (!element.name.equals(cname) || namespace != null && !namespace.equals(element.namespace)) continue;
            return element;
        }
        return null;
    }

    public final Element getChild(String cname) {
        return this.getChild(cname, Namespace.NO_NAMESPACE);
    }

    @Override
    public void canContainContent(Content child, int index, boolean replace) throws IllegalAddException {
        if (child instanceof DocType) {
            throw new IllegalAddException("A DocType is not allowed except at the document level");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int ans;
        out.defaultWriteObject();
        if (this.hasAdditionalNamespaces()) {
            ans = this.additionalNamespaces.size();
            out.writeInt(ans);
            for (Namespace additionalNamespace : this.additionalNamespaces) {
                out.writeObject(additionalNamespace);
            }
        } else {
            out.writeInt(0);
        }
        if (this.hasAttributes()) {
            ans = this.attributes.size();
            out.writeInt(ans);
            for (Attribute attribute : this.attributes) {
                out.writeObject(attribute);
            }
        } else {
            out.writeInt(0);
        }
        int cs = this.content.size();
        out.writeInt(cs);
        for (Content value2 : this.content) {
            out.writeObject(value2);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.content = new ContentList(this);
        int nss = in.readInt();
        while (--nss >= 0) {
            this.addNamespaceDeclaration((Namespace)in.readObject());
        }
        int ats = in.readInt();
        while (--ats >= 0) {
            this.setAttribute((Attribute)in.readObject());
        }
        int cs = in.readInt();
        while (--cs >= 0) {
            this.addContent((Content)in.readObject());
        }
    }
}

