/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.inline;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.inline.CallInlinerStrategy;
import org.jetbrains.kotlin.ir.inline.InlineFunctionBodyPreprocessor;
import org.jetbrains.kotlin.ir.inline.InlineFunctionResolverKt;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextKt;
import org.jetbrains.kotlin.ir.util.IrInlineUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\f\u0010\u0011\u001a\u00020\u0010*\u00020\u0010H\u0002J\f\u0010\u0012\u001a\u00020\u0010*\u00020\u0010H\u0002J\f\u0010\u0013\u001a\u00020\u0010*\u00020\u0010H\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/ir/inline/InlineFunctionSerializationPreProcessing;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/LoweringContext;)V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitSimpleFunction", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "copyAndEraseTypeParameters", "convertToTopLevel", "erasePrivateSymbols", "isEffectivelyPrivate", "", "Lorg/jetbrains/kotlin/ir/expressions/IrInlinedFunctionBlock;", "ir.inline"})
@SourceDebugExtension(value={"SMAP\nInlineFunctionSerializationPreProcessing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineFunctionSerializationPreProcessing.kt\norg/jetbrains/kotlin/ir/inline/InlineFunctionSerializationPreProcessing\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1193#2,2:68\n1267#2,4:70\n*S KotlinDebug\n*F\n+ 1 InlineFunctionSerializationPreProcessing.kt\norg/jetbrains/kotlin/ir/inline/InlineFunctionSerializationPreProcessing\n*L\n36#1:68,2\n36#1:70,4\n*E\n"})
public final class InlineFunctionSerializationPreProcessing
extends IrVisitorVoid
implements FileLoweringPass {
    @NotNull
    private final LoweringContext context;

    public InlineFunctionSerializationPreProcessing(@NotNull LoweringContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        irFile.accept(this, null);
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IrVisitorsKt.acceptChildrenVoid(element, this);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!declaration.isInline() || declaration.getBody() == null || InlineFunctionResolverKt.isConsideredAsPrivateForInlining(declaration.getSymbol())) {
            return;
        }
        IrInlineUtilsKt.setErasedTopLevelCopy(declaration, this.erasePrivateSymbols(this.convertToTopLevel(this.copyAndEraseTypeParameters(declaration))));
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction copyAndEraseTypeParameters(IrSimpleFunction $this$copyAndEraseTypeParameters) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = IrTypeSystemContextKt.extractTypeParameters($this$copyAndEraseTypeParameters);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            IrTypeParameter it = (IrTypeParameter)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getSymbol(), it.isReified() ? null : this.context.getIrBuiltIns().getAnyNType());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map typeArguments = destination$iv$iv;
        IrFunction irFunction = new InlineFunctionBodyPreprocessor(typeArguments, CallInlinerStrategy.DEFAULT.INSTANCE).preprocess($this$copyAndEraseTypeParameters);
        Intrinsics.checkNotNull((Object)irFunction, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
        return (IrSimpleFunction)irFunction;
    }

    private final IrSimpleFunction convertToTopLevel(IrSimpleFunction $this$convertToTopLevel) {
        $this$convertToTopLevel.setCorrespondingPropertySymbol(null);
        $this$convertToTopLevel.setParent(IrUtilsKt.getFile($this$convertToTopLevel));
        return $this$convertToTopLevel;
    }

    private final IrSimpleFunction erasePrivateSymbols(IrSimpleFunction $this$erasePrivateSymbols) {
        new IrVisitorVoid(this){
            final /* synthetic */ InlineFunctionSerializationPreProcessing this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                IrVisitorsKt.acceptChildrenVoid(element, this);
            }

            public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock) {
                Intrinsics.checkNotNullParameter((Object)inlinedBlock, (String)"inlinedBlock");
                IrVisitorsKt.acceptChildrenVoid((IrElement)inlinedBlock, this);
                if (InlineFunctionSerializationPreProcessing.access$isEffectivelyPrivate(this.this$0, inlinedBlock)) {
                    inlinedBlock.setInlinedFunctionSymbol(null);
                }
            }
        }.visitElement($this$erasePrivateSymbols);
        return $this$erasePrivateSymbols;
    }

    private final boolean isEffectivelyPrivate(IrInlinedFunctionBlock $this$isEffectivelyPrivate) {
        IrFunctionSymbol irFunctionSymbol = $this$isEffectivelyPrivate.getInlinedFunctionSymbol();
        return irFunctionSymbol != null ? InlineFunctionResolverKt.isConsideredAsPrivateAndNotLocalForInlining(irFunctionSymbol) : false;
    }

    public static final /* synthetic */ boolean access$isEffectivelyPrivate(InlineFunctionSerializationPreProcessing $this, IrInlinedFunctionBlock $receiver) {
        return $this.isEffectivelyPrivate($receiver);
    }
}

