/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SupertypeSupplier;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSupertypesResolutionKt;
import org.jetbrains.kotlin.fir.resolve.transformers.SupertypeComputationStatus;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.LocalClassesNavigationInfo;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0011J0\u0010\u001a\u001a\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t2\u0006\u0010\u001b\u001a\u00020\u00062\u0016\u0010\u001c\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t0\u001dJ0\u0010\u001e\u001a\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t2\u0006\u0010\u001f\u001a\u00020\f2\u0016\u0010\u001c\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t0\u001dJ0\u0010 \u001a\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t2\u0006\u0010\u001f\u001a\u00020\f2\u0016\u0010\u001c\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t0\u001dJ0\u0010!\u001a\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t2\u0006\u0010\u001f\u001a\u00020\f2\u0016\u0010\u001c\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t0\u001dJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u0011J\u001c\u0010$\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u00112\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&J\u001e\u0010*\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u00112\f\u0010+\u001a\b\u0012\u0004\u0012\u00020'0&H\u0014J\u0018\u0010,\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010&2\u0006\u0010\u0019\u001a\u00020\u0011H\u0014J\u001b\u0010+\u001a\b\u0012\u0004\u0012\u00020-0&2\u0006\u0010.\u001a\u00020\u0011H\u0010\u00a2\u0006\u0002\b/JZ\u00100\u001a\u00020#2\u0006\u0010.\u001a\u00020\u00112\u0006\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u0011042\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u0011042\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u0011042\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00110)2\b\u00108\u001a\u0004\u0018\u000109H\u0004J\u0018\u0010:\u001a\u00020#2\u0006\u00101\u001a\u0002022\b\u00108\u001a\u0004\u0018\u000109J\u0014\u0010;\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\u0019\u001a\u00020\u0011J\u000e\u0010<\u001a\u00020-2\u0006\u0010=\u001a\u00020>J\u0016\u0010?\u001a\u00020-2\u0006\u0010@\u001a\u00020-2\u0006\u00101\u001a\u000202J\u0012\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010=\u001a\u00020>H\u0002R>\u0010\u0004\u001a2\u0012\u0004\u0012\u00020\u0006\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t0\u0005j\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u000b\u001a2\u0012\u0004\u0012\u00020\f\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t0\u0005j\u0018\u0012\u0004\u0012\u00020\f\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\r\u001a2\u0012\u0004\u0012\u00020\f\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t0\u0005j\u0018\u0012\u0004\u0012\u00020\f\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u000e\u001a2\u0012\u0004\u0012\u00020\f\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t0\u0005j\u0018\u0012\u0004\u0012\u00020\f\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession;", "", "<init>", "()V", "fileScopesMap", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lkotlinx/collections/immutable/PersistentList;", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ScopePersistentList;", "Lkotlin/collections/HashMap;", "scopesForNestedClassesMap", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "scopesForStaticNestedClassesMap", "scopesForCompanionMap", "supertypeStatusMap", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationStatus;", "Lkotlin/collections/LinkedHashMap;", "supertypesSupplier", "Lorg/jetbrains/kotlin/fir/resolve/SupertypeSupplier;", "getSupertypesSupplier", "()Lorg/jetbrains/kotlin/fir/resolve/SupertypeSupplier;", "getSupertypesComputationStatus", "classLikeDeclaration", "getOrPutFileScope", "file", "scope", "Lkotlin/Function0;", "getOrPutScopeForNestedClasses", "klass", "getOrPutScopeForStaticNestedClasses", "getOrPutScopeForCompanion", "startComputingSupertypes", "", "storeSupertypes", "resolvedTypesRefs", "", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "newClassifiersForBreakingLoops", "", "reportLoopErrorRefs", "supertypeRefs", "getResolvedSuperTypeRefsForOutOfSessionDeclaration", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "declaration", "supertypeRefs$resolve", "breakLoopFor", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "visited", "", "looped", "pathSet", "path", "localClassesNavigationInfo", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/LocalClassesNavigationInfo;", "breakLoops", "getResolvedSupertypeRefs", "getResolvedExpandedTypeRef", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "expandTypealiasInPlace", "typeRef", "getResolvedExpandedType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirSupertypesResolution.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSupertypesResolution.kt\norg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n*L\n1#1,885:1\n382#2,7:886\n382#2,7:893\n382#2,7:900\n382#2,7:907\n808#3,11:914\n944#3,15:927\n1#4:925\n28#5:926\n*S KotlinDebug\n*F\n+ 1 FirSupertypesResolution.kt\norg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession\n*L\n626#1:886,7\n629#1:893,7\n632#1:900,7\n635#1:907,7\n666#1:914,11\n717#1:927,15\n869#1:926\n*E\n"})
public class SupertypeComputationSession {
    @NotNull
    private final HashMap<FirFile, PersistentList<FirScope>> fileScopesMap = new HashMap();
    @NotNull
    private final HashMap<FirClass, PersistentList<FirScope>> scopesForNestedClassesMap = new HashMap();
    @NotNull
    private final HashMap<FirClass, PersistentList<FirScope>> scopesForStaticNestedClassesMap = new HashMap();
    @NotNull
    private final HashMap<FirClass, PersistentList<FirScope>> scopesForCompanionMap = new HashMap();
    @NotNull
    private final LinkedHashMap<FirClassLikeDeclaration, SupertypeComputationStatus> supertypeStatusMap = new LinkedHashMap();
    @NotNull
    private final SupertypeSupplier supertypesSupplier = new SupertypeSupplier(this){
        final /* synthetic */ SupertypeComputationSession this$0;
        {
            this.this$0 = $receiver;
        }

        /*
         * WARNING - void declaration
         */
        public List<ConeClassLikeType> forClass(FirClass firClass, FirSession useSiteSession) {
            List list;
            List list2;
            List<FirResolvedTypeRef> typeRefsToReturn;
            Intrinsics.checkNotNullParameter((Object)firClass, (String)"firClass");
            Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
            SupertypeComputationStatus supertypeComputationStatus = this.this$0.getSupertypesComputationStatus(firClass);
            SupertypeComputationStatus.Computed computed = supertypeComputationStatus instanceof SupertypeComputationStatus.Computed ? (SupertypeComputationStatus.Computed)supertypeComputationStatus : null;
            List<FirResolvedTypeRef> typeRefsFromSession = computed != null ? computed.getSupertypeRefs() : null;
            List<FirResolvedTypeRef> list3 = typeRefsFromSession;
            if (list3 == null) {
                list3 = this.this$0.getResolvedSuperTypeRefsForOutOfSessionDeclaration(firClass);
            }
            List<FirResolvedTypeRef> list4 = typeRefsToReturn = list3;
            if (list4 != null) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = list4;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    ConeClassLikeType it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv$iv;
                    boolean bl2 = false;
                    FirTypeRef $this$coneTypeSafe$iv = it;
                    boolean $i$f$coneTypeSafe = false;
                    FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                    ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getConeType() : null;
                    if (!(coneKotlinType instanceof ConeClassLikeType)) {
                        coneKotlinType = null;
                    }
                    if ((ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = list = null;
            }
            if (list2 == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        /*
         * WARNING - void declaration
         */
        public ConeClassLikeType expansionForTypeAlias(FirTypeAlias typeAlias, FirSession useSiteSession) {
            ConeClassLikeType coneClassLikeType;
            FirResolvedTypeRef firResolvedTypeRef;
            SupertypeComputationStatus.Computed computed;
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
            if (typeAlias.getExpandedTypeRef() instanceof FirResolvedTypeRef) {
                return FirDeclarationUtilKt.getExpandedConeType(typeAlias);
            }
            Object object = this.this$0.getSupertypesComputationStatus(typeAlias);
            SupertypeComputationStatus.Computed computed2 = computed = object instanceof SupertypeComputationStatus.Computed ? (SupertypeComputationStatus.Computed)object : null;
            if (computed != null && (object = computed.getSupertypeRefs()) != null && (firResolvedTypeRef = (FirResolvedTypeRef)CollectionsKt.getOrNull((List)object, (int)0)) != null) {
                void $this$coneTypeSafe$iv;
                FirTypeRef firTypeRef = firResolvedTypeRef;
                boolean $i$f$coneTypeSafe = false;
                FirResolvedTypeRef firResolvedTypeRef2 = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                ConeKotlinType coneKotlinType = firResolvedTypeRef2 != null ? firResolvedTypeRef2.getConeType() : null;
                if (!(coneKotlinType instanceof ConeClassLikeType)) {
                    coneKotlinType = null;
                }
                coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
            } else {
                coneClassLikeType = null;
            }
            return coneClassLikeType;
        }
    };
    @NotNull
    private final List<FirClassLikeDeclaration> newClassifiersForBreakingLoops = new ArrayList();

    @NotNull
    public final SupertypeSupplier getSupertypesSupplier() {
        return this.supertypesSupplier;
    }

    @NotNull
    public final SupertypeComputationStatus getSupertypesComputationStatus(@NotNull FirClassLikeDeclaration classLikeDeclaration) {
        Intrinsics.checkNotNullParameter((Object)classLikeDeclaration, (String)"classLikeDeclaration");
        SupertypeComputationStatus supertypeComputationStatus = this.supertypeStatusMap.get(classLikeDeclaration);
        if (supertypeComputationStatus == null) {
            supertypeComputationStatus = SupertypeComputationStatus.NotComputed.INSTANCE;
        }
        return supertypeComputationStatus;
    }

    @NotNull
    public final PersistentList<FirScope> getOrPutFileScope(@NotNull FirFile file, @NotNull Function0<? extends PersistentList<? extends FirScope>> scope2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(scope2, (String)"scope");
        Map $this$getOrPut$iv = this.fileScopesMap;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(file);
        if (value$iv == null) {
            boolean bl = false;
            PersistentList answer$iv = (PersistentList)scope2.invoke();
            $this$getOrPut$iv.put(file, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (PersistentList)object;
    }

    @NotNull
    public final PersistentList<FirScope> getOrPutScopeForNestedClasses(@NotNull FirClass klass, @NotNull Function0<? extends PersistentList<? extends FirScope>> scope2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter(scope2, (String)"scope");
        Map $this$getOrPut$iv = this.scopesForNestedClassesMap;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(klass);
        if (value$iv == null) {
            boolean bl = false;
            PersistentList answer$iv = (PersistentList)scope2.invoke();
            $this$getOrPut$iv.put(klass, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (PersistentList)object;
    }

    @NotNull
    public final PersistentList<FirScope> getOrPutScopeForStaticNestedClasses(@NotNull FirClass klass, @NotNull Function0<? extends PersistentList<? extends FirScope>> scope2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter(scope2, (String)"scope");
        Map $this$getOrPut$iv = this.scopesForStaticNestedClassesMap;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(klass);
        if (value$iv == null) {
            boolean bl = false;
            PersistentList answer$iv = (PersistentList)scope2.invoke();
            $this$getOrPut$iv.put(klass, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (PersistentList)object;
    }

    @NotNull
    public final PersistentList<FirScope> getOrPutScopeForCompanion(@NotNull FirClass klass, @NotNull Function0<? extends PersistentList<? extends FirScope>> scope2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter(scope2, (String)"scope");
        Map $this$getOrPut$iv = this.scopesForCompanionMap;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(klass);
        if (value$iv == null) {
            boolean bl = false;
            PersistentList answer$iv = (PersistentList)scope2.invoke();
            $this$getOrPut$iv.put(klass, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (PersistentList)object;
    }

    public final void startComputingSupertypes(@NotNull FirClassLikeDeclaration classLikeDeclaration) {
        Intrinsics.checkNotNullParameter((Object)classLikeDeclaration, (String)"classLikeDeclaration");
        if (!(this.supertypeStatusMap.get(classLikeDeclaration) == null)) {
            boolean bl = false;
            String string = "Unexpected in startComputingSupertypes supertype status for " + classLikeDeclaration + ": " + this.supertypeStatusMap.get(classLikeDeclaration);
            throw new IllegalArgumentException(string.toString());
        }
        ((Map)this.supertypeStatusMap).put(classLikeDeclaration, SupertypeComputationStatus.Computing.INSTANCE);
    }

    public final void storeSupertypes(@NotNull FirClassLikeDeclaration classLikeDeclaration, @NotNull List<? extends FirResolvedTypeRef> resolvedTypesRefs) {
        Intrinsics.checkNotNullParameter((Object)classLikeDeclaration, (String)"classLikeDeclaration");
        Intrinsics.checkNotNullParameter(resolvedTypesRefs, (String)"resolvedTypesRefs");
        if (!(this.supertypeStatusMap.get(classLikeDeclaration) instanceof SupertypeComputationStatus.Computing)) {
            boolean bl = false;
            String string = "Unexpected in storeSupertypes supertype status for " + classLikeDeclaration + ": " + this.supertypeStatusMap.get(classLikeDeclaration);
            throw new IllegalArgumentException(string.toString());
        }
        ((Map)this.supertypeStatusMap).put(classLikeDeclaration, new SupertypeComputationStatus.Computed(resolvedTypesRefs));
        this.newClassifiersForBreakingLoops.add(classLikeDeclaration);
    }

    protected void reportLoopErrorRefs(@NotNull FirClassLikeDeclaration classLikeDeclaration, @NotNull List<? extends FirResolvedTypeRef> supertypeRefs) {
        Intrinsics.checkNotNullParameter((Object)classLikeDeclaration, (String)"classLikeDeclaration");
        Intrinsics.checkNotNullParameter(supertypeRefs, (String)"supertypeRefs");
        ((Map)this.supertypeStatusMap).put(classLikeDeclaration, new SupertypeComputationStatus.Computed(supertypeRefs));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected List<FirResolvedTypeRef> getResolvedSuperTypeRefsForOutOfSessionDeclaration(@NotNull FirClassLikeDeclaration classLikeDeclaration) {
        List list;
        Intrinsics.checkNotNullParameter((Object)classLikeDeclaration, (String)"classLikeDeclaration");
        FirClassLikeDeclaration firClassLikeDeclaration = classLikeDeclaration;
        if (firClassLikeDeclaration instanceof FirClass) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = ((FirClass)classLikeDeclaration).getSuperTypeRefs();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FirResolvedTypeRef)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else if (firClassLikeDeclaration instanceof FirTypeAlias) {
            FirTypeRef firTypeRef = ((FirTypeAlias)classLikeDeclaration).getExpandedTypeRef();
            list = CollectionsKt.listOfNotNull((Object)(firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    @NotNull
    public List<FirTypeRef> supertypeRefs$resolve(@NotNull FirClassLikeDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirClassLikeDeclaration firClassLikeDeclaration = declaration;
        return firClassLikeDeclaration instanceof FirRegularClass ? ((FirRegularClass)declaration).getSuperTypeRefs() : (firClassLikeDeclaration instanceof FirTypeAlias ? CollectionsKt.listOf((Object)((FirTypeAlias)declaration).getExpandedTypeRef()) : CollectionsKt.emptyList());
    }

    protected final void breakLoopFor(@NotNull FirClassLikeDeclaration declaration, @NotNull FirSession session2, @NotNull Set<FirClassLikeDeclaration> visited2, @NotNull Set<FirClassLikeDeclaration> looped, @NotNull Set<FirClassLikeDeclaration> pathSet, @NotNull List<FirClassLikeDeclaration> path, @Nullable LocalClassesNavigationInfo localClassesNavigationInfo) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter(visited2, (String)"visited");
        Intrinsics.checkNotNullParameter(looped, (String)"looped");
        Intrinsics.checkNotNullParameter(pathSet, (String)"pathSet");
        Intrinsics.checkNotNullParameter(path, (String)"path");
        if (!path.isEmpty()) {
            boolean $i$a$-require-SupertypeComputationSession$breakLoopFor$42 = false;
            String $i$a$-require-SupertypeComputationSession$breakLoopFor$42 = "Path should be empty";
            throw new IllegalArgumentException($i$a$-require-SupertypeComputationSession$breakLoopFor$42.toString());
        }
        if (!pathSet.isEmpty()) {
            boolean $i$a$-require-SupertypeComputationSession$breakLoopFor$52 = false;
            String $i$a$-require-SupertypeComputationSession$breakLoopFor$52 = "Path set should be empty";
            throw new IllegalArgumentException($i$a$-require-SupertypeComputationSession$breakLoopFor$52.toString());
        }
        SupertypeComputationSession.breakLoopFor$checkIsInLoop(this, visited2, pathSet, looped, path, session2, localClassesNavigationInfo, declaration, false, false);
        if (!path.isEmpty()) {
            boolean bl = false;
            String string = "Path should be empty";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final void breakLoops(@NotNull FirSession session2, @Nullable LocalClassesNavigationInfo localClassesNavigationInfo) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Set visitedClassLikeDecls = new LinkedHashSet();
        Set loopedClassLikeDecls = new LinkedHashSet();
        List path = new ArrayList();
        Set pathSet = new LinkedHashSet();
        for (FirClassLikeDeclaration classifier : this.newClassifiersForBreakingLoops) {
            this.breakLoopFor(classifier, session2, visitedClassLikeDecls, loopedClassLikeDecls, pathSet, path, localClassesNavigationInfo);
        }
        this.newClassifiersForBreakingLoops.clear();
    }

    @NotNull
    public final List<FirResolvedTypeRef> getResolvedSupertypeRefs(@NotNull FirClassLikeDeclaration classLikeDeclaration) {
        Intrinsics.checkNotNullParameter((Object)classLikeDeclaration, (String)"classLikeDeclaration");
        SupertypeComputationStatus status2 = this.getSupertypesComputationStatus(classLikeDeclaration);
        if (!(status2 instanceof SupertypeComputationStatus.Computed)) {
            boolean bl = false;
            String string = "Unexpected status at FirApplySupertypesTransformer: " + status2 + " for " + classLikeDeclaration.getSymbol().getClassId();
            throw new IllegalArgumentException(string.toString());
        }
        return ((SupertypeComputationStatus.Computed)status2).getSupertypeRefs();
    }

    @NotNull
    public final FirTypeRef getResolvedExpandedTypeRef(@NotNull FirTypeAlias typeAlias) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        List<FirResolvedTypeRef> supertypeRefs = this.getResolvedSupertypeRefs(typeAlias);
        boolean bl2 = bl = supertypeRefs.size() == 1;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Expected single supertypeRefs, but found " + supertypeRefs.size() + " in " + typeAlias.getSymbol().getClassId();
            throw new AssertionError((Object)string);
        }
        return supertypeRefs.get(0);
    }

    @NotNull
    public final FirTypeRef expandTypealiasInPlace(@NotNull FirTypeRef typeRef, @NotNull FirSession session2) {
        FirTypeRef firTypeRef;
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FirTypeRef firTypeRef2 = typeRef;
        if (firTypeRef2 instanceof FirImplicitBuiltinTypeRef || firTypeRef2 instanceof FirErrorTypeRef) {
            firTypeRef = typeRef;
        } else {
            ConeKotlinType expanded2 = TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(typeRef), session2, (Function1<? super FirTypeAlias, ? extends ConeClassLikeType>)((Function1)new Function1<FirTypeAlias, ConeClassLikeType>((Object)this){

                public final ConeClassLikeType invoke(FirTypeAlias p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return SupertypeComputationSession.access$getResolvedExpandedType((SupertypeComputationSession)this.receiver, p0);
                }
            }));
            if (Intrinsics.areEqual((Object)expanded2, (Object)FirTypeUtilsKt.getConeType(typeRef))) {
                firTypeRef = typeRef;
            } else if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(session2).getFlag(AnalysisFlags.getExpandTypeAliasesInTypeResolution()).booleanValue()) {
                ConeKotlinType p0 = expanded2;
                boolean bl = false;
                firTypeRef = TypeUtilsKt.withReplacedConeType$default(typeRef, p0, null, 2, null);
            } else {
                firTypeRef = typeRef;
            }
        }
        return firTypeRef;
    }

    private final ConeClassLikeType getResolvedExpandedType(FirTypeAlias typeAlias) {
        FirTypeRef firTypeRef;
        FirTypeRef it = firTypeRef = typeAlias.getExpandedTypeRef();
        boolean bl = false;
        FirTypeRef firTypeRef2 = it instanceof FirResolvedTypeRef ? firTypeRef : null;
        if (firTypeRef2 == null) {
            firTypeRef2 = this.getResolvedExpandedTypeRef(typeAlias);
        }
        FirTypeRef $this$coneTypeSafe$iv = firTypeRef2;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getConeType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        return (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
    }

    private static final void breakLoopFor$checkIsInLoop$checkTypeArgumentsRecursively(FirSession $session, boolean $wasSubtypingInvolved, boolean areTypeArgumentsCurrentlyInvolved, SupertypeComputationSession this$0, Set<FirClassLikeDeclaration> $visited, Set<FirClassLikeDeclaration> $pathSet, Set<FirClassLikeDeclaration> $looped, List<FirClassLikeDeclaration> $path, LocalClassesNavigationInfo $localClassesNavigationInfo, ConeKotlinType type, Set<ConeKotlinType> visitedTypes) {
        if (visitedTypes.contains(type)) {
            return;
        }
        ((Collection)visitedTypes).add(type);
        for (ConeTypeProjection typeArgument : type.getTypeArguments()) {
            ConeClassLikeType typeToCheck;
            ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(typeArgument);
            ConeRigidType coneRigidType = coneKotlinType != null ? ConeTypeUtilsKt.lowerBoundIfFlexible(coneKotlinType) : null;
            if ((coneRigidType instanceof ConeClassLikeType ? (ConeClassLikeType)coneRigidType : null) == null) continue;
            typeToCheck = typeToCheck;
            FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toSymbol(typeToCheck.getLookupTag(), $session);
            SupertypeComputationSession.breakLoopFor$checkIsInLoop(this$0, $visited, $pathSet, $looped, $path, $session, $localClassesNavigationInfo, firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null, $wasSubtypingInvolved, areTypeArgumentsCurrentlyInvolved);
            SupertypeComputationSession.breakLoopFor$checkIsInLoop$checkTypeArgumentsRecursively($session, $wasSubtypingInvolved, areTypeArgumentsCurrentlyInvolved, this$0, $visited, $pathSet, $looped, $path, $localClassesNavigationInfo, typeToCheck, visitedTypes);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void breakLoopFor$checkIsInLoop(SupertypeComputationSession this$0, Set<FirClassLikeDeclaration> $visited, Set<FirClassLikeDeclaration> $pathSet, Set<FirClassLikeDeclaration> $looped, List<FirClassLikeDeclaration> $path, FirSession $session, LocalClassesNavigationInfo $localClassesNavigationInfo, FirClassLikeDeclaration classLikeDeclaration, boolean wasSubtypingInvolved, boolean wereTypeArgumentsInvolved) {
        boolean isTypeAlias;
        boolean isSubtypingCurrentlyInvolved;
        List<FirResolvedTypeRef> list;
        if (classLikeDeclaration == null) {
            return;
        }
        if (!(!wasSubtypingInvolved || !wereTypeArgumentsInvolved)) {
            boolean $i$a$-require-SupertypeComputationSession$breakLoopFor$checkIsInLoop$22 = false;
            String $i$a$-require-SupertypeComputationSession$breakLoopFor$checkIsInLoop$22 = "This must hold by induction, because otherwise such a loop is allowed";
            throw new IllegalArgumentException($i$a$-require-SupertypeComputationSession$breakLoopFor$checkIsInLoop$22.toString());
        }
        SupertypeComputationStatus supertypeStatus = this$0.supertypeStatusMap.get(classLikeDeclaration);
        if (supertypeStatus != null) {
            if (!(supertypeStatus instanceof SupertypeComputationStatus.Computed)) {
                boolean $i$a$-require-SupertypeComputationSession$breakLoopFor$checkIsInLoop$supertypeRefs$22 = false;
                String $i$a$-require-SupertypeComputationSession$breakLoopFor$checkIsInLoop$supertypeRefs$22 = "Expected computed supertypes in breakLoops for " + classLikeDeclaration.getSymbol().getClassId();
                throw new IllegalArgumentException($i$a$-require-SupertypeComputationSession$breakLoopFor$checkIsInLoop$supertypeRefs$22.toString());
            }
            list = ((SupertypeComputationStatus.Computed)supertypeStatus).getSupertypeRefs();
        } else {
            list = this$0.getResolvedSuperTypeRefsForOutOfSessionDeclaration(classLikeDeclaration);
            if (list == null) {
                return;
            }
        }
        List<FirResolvedTypeRef> supertypeRefs = list;
        if ($visited.contains(classLikeDeclaration)) {
            if ($pathSet.contains(classLikeDeclaration)) {
                List list2;
                Set<FirClassLikeDeclaration> set;
                block29: {
                    void $this$takeLastWhile$iv;
                    $looped.add(classLikeDeclaration);
                    List<FirClassLikeDeclaration> list3 = $path;
                    set = $looped;
                    boolean $i$f$takeLastWhile = false;
                    if ($this$takeLastWhile$iv.isEmpty()) {
                        list2 = CollectionsKt.emptyList();
                    } else {
                        ListIterator iterator$iv = $this$takeLastWhile$iv.listIterator($this$takeLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            FirClassLikeDeclaration element = (FirClassLikeDeclaration)iterator$iv.previous();
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)element, (Object)classLikeDeclaration)) continue;
                            iterator$iv.next();
                            int expectedSize$iv = $this$takeLastWhile$iv.size() - iterator$iv.nextIndex();
                            if (expectedSize$iv == 0) {
                                list2 = CollectionsKt.emptyList();
                            } else {
                                ArrayList arrayList;
                                ArrayList $this$takeLastWhile_u24lambda_u246$iv = arrayList = new ArrayList(expectedSize$iv);
                                boolean bl2 = false;
                                while (iterator$iv.hasNext()) {
                                    $this$takeLastWhile_u24lambda_u246$iv.add(iterator$iv.next());
                                }
                                list2 = arrayList;
                            }
                            break block29;
                        }
                        list2 = CollectionsKt.toList((Iterable)((Iterable)$this$takeLastWhile$iv));
                    }
                }
                set.addAll(list2);
            }
            return;
        }
        $path.add(classLikeDeclaration);
        $pathSet.add(classLikeDeclaration);
        $visited.add(classLikeDeclaration);
        ClassId classId = FirDeclarationUtilKt.getClassId(classLikeDeclaration);
        if (classId.isNestedClass()) {
            FirClassLikeDeclaration firClassLikeDeclaration;
            if (!classId.isLocal()) {
                FirClassLikeSymbol<?> firClassLikeSymbol = FirProviderKt.getFirProvider($session).getContainingClass((FirBasedSymbol)classLikeDeclaration.getSymbol());
                firClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
            } else {
                LocalClassesNavigationInfo localClassesNavigationInfo = $localClassesNavigationInfo;
                if (localClassesNavigationInfo != null) {
                    firClassLikeDeclaration = localClassesNavigationInfo.getParentForClass().get(classLikeDeclaration);
                } else {
                    throw new IllegalStateException("Couldn't retrieve the parent of a local class because there's no `LocalClassesNavigationInfo`".toString());
                }
            }
            FirClassLikeDeclaration parentFir = firClassLikeDeclaration;
            if (parentFir != null) {
                SupertypeComputationSession.breakLoopFor$checkIsInLoop(this$0, $visited, $pathSet, $looped, $path, $session, $localClassesNavigationInfo, parentFir, wasSubtypingInvolved, wereTypeArgumentsInvolved);
            }
        }
        boolean bl = isSubtypingCurrentlyInvolved = !(isTypeAlias = classLikeDeclaration instanceof FirTypeAlias);
        if (wereTypeArgumentsInvolved && isSubtypingCurrentlyInvolved) {
            $path.remove($path.size() - 1);
            $pathSet.remove(classLikeDeclaration);
            return;
        }
        boolean isSubtypingInvolved = wasSubtypingInvolved || isSubtypingCurrentlyInvolved;
        boolean isErrorInSupertypesFound = false;
        List resultSupertypeRefs = new ArrayList();
        for (FirResolvedTypeRef supertypeRef : supertypeRefs) {
            FirResolvedTypeRef firResolvedTypeRef;
            FirClassLikeDeclaration firClassLikeDeclaration;
            if (isTypeAlias) {
                for (FirAnnotation annotation : supertypeRef.getAnnotations()) {
                    ConeClassLikeType resolvedType;
                    ConeKotlinType coneKotlinType = FirTypeUtilsKt.getResolvedType(annotation);
                    if ((coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null) == null) continue;
                    resolvedType = resolvedType;
                    FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toSymbol(resolvedType.getLookupTag(), $session);
                    FirClassLikeDeclaration typeArgumentClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
                    SupertypeComputationSession.breakLoopFor$checkIsInLoop(this$0, $visited, $pathSet, $looped, $path, $session, $localClassesNavigationInfo, typeArgumentClassLikeDeclaration, wasSubtypingInvolved, wereTypeArgumentsInvolved);
                }
            }
            if ((firClassLikeDeclaration = DeclarationUtilsKt.firClassLike(supertypeRef, $session)) == null) {
                firClassLikeDeclaration = DeclarationUtilsKt.firClassLike(supertypeRef, classLikeDeclaration.getModuleData().getSession());
            }
            FirClassLikeDeclaration supertypeFir = firClassLikeDeclaration;
            SupertypeComputationSession.breakLoopFor$checkIsInLoop(this$0, $visited, $pathSet, $looped, $path, $session, $localClassesNavigationInfo, supertypeFir, isSubtypingInvolved, wereTypeArgumentsInvolved);
            if (!isSubtypingInvolved) {
                boolean areTypeArgumentsCurrentlyInvolved = true;
                SupertypeComputationSession.breakLoopFor$checkIsInLoop$checkTypeArgumentsRecursively($session, wasSubtypingInvolved, areTypeArgumentsCurrentlyInvolved, this$0, $visited, $pathSet, $looped, $path, $localClassesNavigationInfo, supertypeRef.getConeType(), new LinkedHashSet());
            }
            if ($looped.contains(classLikeDeclaration) && !(supertypeRef instanceof FirImplicitBuiltinTypeRef)) {
                isErrorInSupertypesFound = true;
                firResolvedTypeRef = FirSupertypesResolutionKt.access$createErrorTypeRef(supertypeRef.getSource(), "Loop in supertypes involving " + classLikeDeclaration.getSymbol().getClassId(), isTypeAlias ? DiagnosticKind.RecursiveTypealiasExpansion : DiagnosticKind.LoopInSupertype);
            } else {
                firResolvedTypeRef = supertypeRef;
            }
            resultSupertypeRefs.add(firResolvedTypeRef);
        }
        if (isErrorInSupertypesFound) {
            this$0.reportLoopErrorRefs(classLikeDeclaration, resultSupertypeRefs);
        }
        $path.remove($path.size() - 1);
        $pathSet.remove(classLikeDeclaration);
    }

    public static final /* synthetic */ ConeClassLikeType access$getResolvedExpandedType(SupertypeComputationSession $this, FirTypeAlias typeAlias) {
        return $this.getResolvedExpandedType(typeAlias);
    }
}

