/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.checkers.ProtectedInSuperClassCompanionCallChecker$check$;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/ProtectedInSuperClassCompanionCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nProtectedInSuperClassCompanionCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtectedInSuperClassCompanionCallChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/ProtectedInSuperClassCompanionCallChecker\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,52:1\n477#2:53\n1251#2,2:54\n*S KotlinDebug\n*F\n+ 1 ProtectedInSuperClassCompanionCallChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/ProtectedInSuperClassCompanionCallChecker\n*L\n42#1:53\n44#1:54,2\n*E\n"})
public final class ProtectedInSuperClassCompanionCallChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor().getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getOriginal(...)");
        CallableDescriptor targetDescriptor = callableDescriptor;
        if (!Intrinsics.areEqual((Object)targetDescriptor.getVisibility(), (Object)DescriptorVisibilities.PROTECTED)) {
            return;
        }
        if (AnnotationUtilKt.hasJvmStaticAnnotation(targetDescriptor)) {
            return;
        }
        DeclarationDescriptor declarationDescriptor = targetDescriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        DeclarationDescriptor containerDescriptor = declarationDescriptor;
        if (containerDescriptor instanceof ClassDescriptor && ((ClassDescriptor)containerDescriptor).isCompanionObject()) {
            boolean bl;
            Sequence parentClassDescriptors;
            ClassDescriptor companionOwnerDescriptor;
            DeclarationDescriptor companionDescriptor;
            block7: {
                companionDescriptor = containerDescriptor;
                DeclarationDescriptor declarationDescriptor2 = ((ClassDescriptor)companionDescriptor).getContainingDeclaration();
                ClassDescriptor classDescriptor = declarationDescriptor2 instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor2 : null;
                if (classDescriptor == null) {
                    return;
                }
                companionOwnerDescriptor = classDescriptor;
                Sequence<DeclarationDescriptor> $this$filterIsInstance$iv = DescriptorUtilsKt.getParentsWithSelf(context.getScope().getOwnerDescriptor());
                boolean $i$f$filterIsInstance = false;
                Sequence sequence2 = SequencesKt.filter($this$filterIsInstance$iv, (Function1)check$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                Sequence $this$any$iv = parentClassDescriptors = sequence2;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    ClassDescriptor it = (ClassDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!DescriptorUtils.isSubclass(it, companionOwnerDescriptor)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
            if (!bl) {
                return;
            }
            if (!SequencesKt.contains((Sequence)parentClassDescriptors, (Object)companionDescriptor) && !SequencesKt.contains((Sequence)parentClassDescriptors, (Object)companionOwnerDescriptor)) {
                context.getTrace().report(ErrorsJvm.SUBCLASS_CANT_CALL_COMPANION_PROTECTED_NON_STATIC.on(reportOn));
            }
        }
    }
}

