/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/TypeOfChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "isTypeOf", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "frontend"})
public final class TypeOfChecker
implements CallChecker {
    @NotNull
    public static final TypeOfChecker INSTANCE = new TypeOfChecker();

    private TypeOfChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, (String)"getResultingDescriptor(...)");
        if (!this.isTypeOf((CallableDescriptor)obj)) {
            return;
        }
        Map<TypeParameterDescriptor, KotlinType> map = resolvedCall2.getTypeArguments();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getTypeArguments(...)");
        Iterator<Map.Entry<TypeParameterDescriptor, KotlinType>> iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            KotlinType argument = iterator2.next().getValue();
            Intrinsics.checkNotNull((Object)argument);
            if (!TypeUtilsKt.contains(argument, (Function1<? super UnwrappedType, Boolean>)((Function1)TypeOfChecker::check$lambda$0))) continue;
            context.getTrace().report(Errors.UNSUPPORTED.on(reportOn, "'typeOf' with non-reified type parameters is not supported"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isTypeOf(@NotNull CallableDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!Intrinsics.areEqual((Object)descriptor.getName().asString(), (Object)"typeOf")) return false;
        if (!descriptor.getValueParameters().isEmpty()) return false;
        DeclarationDescriptor declarationDescriptor = descriptor.getContainingDeclaration();
        PackageFragmentDescriptor packageFragmentDescriptor = declarationDescriptor instanceof PackageFragmentDescriptor ? (PackageFragmentDescriptor)declarationDescriptor : null;
        if (!Intrinsics.areEqual((Object)(packageFragmentDescriptor != null ? packageFragmentDescriptor.getFqName() : null), (Object)StandardNames.KOTLIN_REFLECT_FQ_NAME)) return false;
        return true;
    }

    private static final boolean check$lambda$0(UnwrappedType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ClassifierDescriptor descriptor = type2.getConstructor().getDeclarationDescriptor();
        return descriptor instanceof TypeParameterDescriptor && !((TypeParameterDescriptor)descriptor).isReified();
    }
}

