/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSessionComponent;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\b\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirEnumEntriesSupport;", "Lorg/jetbrains/kotlin/fir/FirSessionComponent;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "isEnumEntriesAvailable", "", "()Z", "isEnumEntriesAvailable$delegate", "Lkotlin/Lazy;", "canSynthesizeEnumEntriesFor", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "providers"})
public class FirEnumEntriesSupport
implements FirSessionComponent {
    @NotNull
    private final FirSession session;
    @NotNull
    private final Lazy isEnumEntriesAvailable$delegate;

    public FirEnumEntriesSupport(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        this.isEnumEntriesAvailable$delegate = LazyKt.lazy(() -> FirEnumEntriesSupport.isEnumEntriesAvailable_delegate$lambda$0(this));
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    protected final boolean isEnumEntriesAvailable() {
        Lazy lazy = this.isEnumEntriesAvailable$delegate;
        return (Boolean)lazy.getValue();
    }

    public boolean canSynthesizeEnumEntriesFor(@NotNull FirClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return ClassMembersKt.getHasEnumEntries(klass) && this.isEnumEntriesAvailable();
    }

    private static final boolean isEnumEntriesAvailable_delegate$lambda$0(FirEnumEntriesSupport this$0) {
        return FirSymbolProviderKt.getRegularClassSymbolByClassId(this$0.session, StandardClassIds.INSTANCE.getEnumEntries()) != null;
    }
}

