/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.contracts.description;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.KtBinaryLogicExpression;
import org.jetbrains.kotlin.contracts.description.KtCallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtConditionalEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtConstantReference;
import org.jetbrains.kotlin.contracts.description.KtContractDescriptionElement;
import org.jetbrains.kotlin.contracts.description.KtContractDescriptionVisitor;
import org.jetbrains.kotlin.contracts.description.KtIsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.KtIsNullPredicate;
import org.jetbrains.kotlin.contracts.description.KtLogicalNot;
import org.jetbrains.kotlin.contracts.description.KtReturnsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtValueParameterReference;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.FirLegacyRawContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirRawContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirResolvedContractDescription;
import org.jetbrains.kotlin.fir.declarations.FirContractDescriptionOwner;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.renderer.FirPrinter;
import org.jetbrains.kotlin.fir.renderer.FirRenderer;
import org.jetbrains.kotlin.fir.renderer.FirRendererComponents;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0001B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dJ\u0015\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b J\u0015\u0010\u0017\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b J\u0015\u0010\u0017\u001a\u00020\u00022\u0006\u0010#\u001a\u00020$H\u0000\u00a2\u0006\u0002\b J&\u0010%\u001a\u00020\u00022\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050'2\b\u0010(\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010)\u001a\u00020\u00022\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050+2\b\u0010(\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010,\u001a\u00020\u00022\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050.2\b\u0010(\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010/\u001a\u00020\u00022\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005012\b\u0010(\u001a\u0004\u0018\u00010\u0003H\u0016J&\u00102\u001a\u00020\u00022\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005042\b\u0010(\u001a\u0004\u0018\u00010\u0003H\u0016J&\u00105\u001a\u00020\u00022\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005072\b\u0010(\u001a\u0004\u0018\u00010\u0003H\u0016J&\u00108\u001a\u00020\u00022\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050:2\b\u0010(\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010;\u001a\u00020\u00022\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050=2\b\u0010(\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010>\u001a\u00020\u00022\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050@2\b\u0010(\u001a\u0004\u0018\u00010\u0003H\u0016J>\u0010A\u001a\u00020\u00022\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050C2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050C2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00020FH\u0002J\u0018\u0010G\u001a\u00020H*\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050CH\u0002J0\u0010I\u001a\u00020H2\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050C2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050CH\u0002R\u001a\u0010\b\u001a\u00020\tX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00060\u0013R\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006J"}, d2={"Lorg/jetbrains/kotlin/fir/contracts/description/ConeContractRenderer;", "Lorg/jetbrains/kotlin/contracts/description/KtContractDescriptionVisitor;", "", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "<init>", "()V", "components", "Lorg/jetbrains/kotlin/fir/renderer/FirRendererComponents;", "getComponents$tree", "()Lorg/jetbrains/kotlin/fir/renderer/FirRendererComponents;", "setComponents$tree", "(Lorg/jetbrains/kotlin/fir/renderer/FirRendererComponents;)V", "printer", "Lorg/jetbrains/kotlin/fir/renderer/FirPrinter;", "getPrinter", "()Lorg/jetbrains/kotlin/fir/renderer/FirPrinter;", "visitor", "Lorg/jetbrains/kotlin/fir/renderer/FirRenderer$Visitor;", "Lorg/jetbrains/kotlin/fir/renderer/FirRenderer;", "getVisitor", "()Lorg/jetbrains/kotlin/fir/renderer/FirRenderer$Visitor;", "render", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "contractDescription", "Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;", "effectDeclaration", "Lorg/jetbrains/kotlin/fir/contracts/FirEffectDeclaration;", "legacyRawContractDescription", "Lorg/jetbrains/kotlin/fir/contracts/FirLegacyRawContractDescription;", "render$tree", "rawContractDescription", "Lorg/jetbrains/kotlin/fir/contracts/FirRawContractDescription;", "resolvedContractDescription", "Lorg/jetbrains/kotlin/fir/contracts/FirResolvedContractDescription;", "visitConditionalEffectDeclaration", "conditionalEffect", "Lorg/jetbrains/kotlin/contracts/description/KtConditionalEffectDeclaration;", "data", "visitReturnsEffectDeclaration", "returnsEffect", "Lorg/jetbrains/kotlin/contracts/description/KtReturnsEffectDeclaration;", "visitCallsEffectDeclaration", "callsEffect", "Lorg/jetbrains/kotlin/contracts/description/KtCallsEffectDeclaration;", "visitLogicalBinaryOperationContractExpression", "binaryLogicExpression", "Lorg/jetbrains/kotlin/contracts/description/KtBinaryLogicExpression;", "visitLogicalNot", "logicalNot", "Lorg/jetbrains/kotlin/contracts/description/KtLogicalNot;", "visitIsInstancePredicate", "isInstancePredicate", "Lorg/jetbrains/kotlin/contracts/description/KtIsInstancePredicate;", "visitIsNullPredicate", "isNullPredicate", "Lorg/jetbrains/kotlin/contracts/description/KtIsNullPredicate;", "visitConstantDescriptor", "constantReference", "Lorg/jetbrains/kotlin/contracts/description/KtConstantReference;", "visitValueParameterReference", "valueParameterReference", "Lorg/jetbrains/kotlin/contracts/description/KtValueParameterReference;", "inBracketsIfNecessary", "parent", "Lorg/jetbrains/kotlin/contracts/description/KtContractDescriptionElement;", "child", "block", "Lkotlin/Function0;", "isAtom", "", "needsBrackets", "tree"})
@SourceDebugExtension(value={"SMAP\nConeContractRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConeContractRenderer.kt\norg/jetbrains/kotlin/fir/contracts/description/ConeContractRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n1863#2,2:144\n*S KotlinDebug\n*F\n+ 1 ConeContractRenderer.kt\norg/jetbrains/kotlin/fir/contracts/description/ConeContractRenderer\n*L\n69#1:144,2\n*E\n"})
public final class ConeContractRenderer
extends KtContractDescriptionVisitor {
    public FirRendererComponents components;

    @NotNull
    public final FirRendererComponents getComponents$tree() {
        FirRendererComponents firRendererComponents = this.components;
        if (firRendererComponents != null) {
            return firRendererComponents;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"components");
        return null;
    }

    public final void setComponents$tree(@NotNull FirRendererComponents firRendererComponents) {
        Intrinsics.checkNotNullParameter((Object)firRendererComponents, (String)"<set-?>");
        this.components = firRendererComponents;
    }

    private final FirPrinter getPrinter() {
        return this.getComponents$tree().getPrinter();
    }

    private final FirRenderer.Visitor getVisitor() {
        return this.getComponents$tree().getVisitor();
    }

    public final void render(@NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirElement firElement = declaration instanceof FirContractDescriptionOwner ? (FirContractDescriptionOwner)((Object)declaration) : null;
        if (firElement == null || (firElement = firElement.getContractDescription()) == null) {
            return;
        }
        FirElement contractDescription = firElement;
        this.render((FirContractDescription)contractDescription);
    }

    public final void render(@NotNull FirContractDescription contractDescription) {
        Intrinsics.checkNotNullParameter((Object)contractDescription, (String)"contractDescription");
        this.getPrinter().pushIndent$tree();
        this.getPrinter().newLine();
        String prefix = contractDescription instanceof FirResolvedContractDescription ? "R|" : "";
        Object object = new Object[]{'[' + prefix + "Contract description]"};
        this.getPrinter().print(object);
        object = contractDescription;
        if (object instanceof FirLegacyRawContractDescription) {
            this.render$tree((FirLegacyRawContractDescription)contractDescription);
        } else if (object instanceof FirRawContractDescription) {
            this.render$tree((FirRawContractDescription)contractDescription);
        } else if (object instanceof FirResolvedContractDescription) {
            this.getPrinter().println(new Object[0]);
            this.render$tree((FirResolvedContractDescription)contractDescription);
        }
        this.getPrinter().popIndent$tree();
    }

    public final void render(@NotNull FirEffectDeclaration effectDeclaration) {
        Intrinsics.checkNotNullParameter((Object)effectDeclaration, (String)"effectDeclaration");
        this.getPrinter().newLine();
        Object[] objectArray = new Object[]{"[Effect declaration] <"};
        this.getPrinter().println(objectArray);
        effectDeclaration.getEffect().accept(this, null);
        this.getPrinter().println(new Object[0]);
        objectArray = new Object[]{">"};
        this.getPrinter().println(objectArray);
    }

    public final void render$tree(@NotNull FirLegacyRawContractDescription legacyRawContractDescription) {
        Intrinsics.checkNotNullParameter((Object)legacyRawContractDescription, (String)"legacyRawContractDescription");
        this.getPrinter().renderInBraces("<", ">", (Function0<Unit>)((Function0)() -> ConeContractRenderer.render$lambda$0(legacyRawContractDescription, this)));
    }

    public final void render$tree(@NotNull FirRawContractDescription rawContractDescription) {
        Intrinsics.checkNotNullParameter((Object)rawContractDescription, (String)"rawContractDescription");
        this.getPrinter().renderInBraces("<", ">", (Function0<Unit>)((Function0)() -> ConeContractRenderer.render$lambda$1(this, rawContractDescription)));
    }

    public final void render$tree(@NotNull FirResolvedContractDescription resolvedContractDescription) {
        Intrinsics.checkNotNullParameter((Object)resolvedContractDescription, (String)"resolvedContractDescription");
        Object[] objectArray = new Object[]{" <"};
        this.getPrinter().println(objectArray);
        this.getPrinter().pushIndent$tree();
        Iterable $this$forEach$iv = resolvedContractDescription.getEffects();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirEffectDeclaration declaration = (FirEffectDeclaration)element$iv;
            boolean bl = false;
            declaration.getEffect().accept(this, null);
            this.getPrinter().println(new Object[0]);
        }
        this.getPrinter().popIndent$tree();
        objectArray = new Object[]{">"};
        this.getPrinter().println(objectArray);
    }

    public void visitConditionalEffectDeclaration(@NotNull KtConditionalEffectDeclaration<ConeKotlinType, ConeDiagnostic> conditionalEffect, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(conditionalEffect, (String)"conditionalEffect");
        conditionalEffect.getEffect().accept(this, data);
        Object[] objectArray = new Object[]{" -> "};
        this.getPrinter().print(objectArray);
        conditionalEffect.getCondition().accept(this, data);
    }

    public void visitReturnsEffectDeclaration(@NotNull KtReturnsEffectDeclaration<ConeKotlinType, ConeDiagnostic> returnsEffect, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(returnsEffect, (String)"returnsEffect");
        Object[] objectArray = new Object[]{"Returns("};
        this.getPrinter().print(objectArray);
        returnsEffect.getValue().accept(this, data);
        objectArray = new Object[]{")"};
        this.getPrinter().print(objectArray);
    }

    public void visitCallsEffectDeclaration(@NotNull KtCallsEffectDeclaration<ConeKotlinType, ConeDiagnostic> callsEffect, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(callsEffect, (String)"callsEffect");
        Object[] objectArray = new Object[]{"CallsInPlace("};
        this.getPrinter().print(objectArray);
        callsEffect.getValueParameterReference().accept(this, data);
        objectArray = new Object[]{", " + (Object)((Object)callsEffect.getKind()) + ')'};
        this.getPrinter().print(objectArray);
    }

    public void visitLogicalBinaryOperationContractExpression(@NotNull KtBinaryLogicExpression<ConeKotlinType, ConeDiagnostic> binaryLogicExpression, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(binaryLogicExpression, (String)"binaryLogicExpression");
        this.inBracketsIfNecessary((KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic>)binaryLogicExpression, (KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic>)binaryLogicExpression.getLeft(), (Function0<Unit>)((Function0)() -> ConeContractRenderer.visitLogicalBinaryOperationContractExpression$lambda$3(binaryLogicExpression, this, data)));
        Object[] objectArray = new Object[]{' ' + binaryLogicExpression.getKind().getToken() + ' '};
        this.getPrinter().print(objectArray);
        this.inBracketsIfNecessary((KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic>)binaryLogicExpression, (KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic>)binaryLogicExpression.getRight(), (Function0<Unit>)((Function0)() -> ConeContractRenderer.visitLogicalBinaryOperationContractExpression$lambda$4(binaryLogicExpression, this, data)));
    }

    public void visitLogicalNot(@NotNull KtLogicalNot<ConeKotlinType, ConeDiagnostic> logicalNot, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(logicalNot, (String)"logicalNot");
        this.inBracketsIfNecessary((KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic>)logicalNot, (KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic>)logicalNot.getArg(), (Function0<Unit>)((Function0)() -> ConeContractRenderer.visitLogicalNot$lambda$5(this)));
        logicalNot.getArg().accept(this, data);
    }

    public void visitIsInstancePredicate(@NotNull KtIsInstancePredicate<ConeKotlinType, ConeDiagnostic> isInstancePredicate, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(isInstancePredicate, (String)"isInstancePredicate");
        isInstancePredicate.getArg().accept(this, data);
        Object[] objectArray = new Object[]{' ' + (isInstancePredicate.isNegated() ? "!" : "") + "is " + ConeTypeUtilsKt.renderForDebugging(isInstancePredicate.getType())};
        this.getPrinter().print(objectArray);
    }

    public void visitIsNullPredicate(@NotNull KtIsNullPredicate<ConeKotlinType, ConeDiagnostic> isNullPredicate, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(isNullPredicate, (String)"isNullPredicate");
        isNullPredicate.getArg().accept(this, data);
        Object[] objectArray = new Object[]{' ' + (isNullPredicate.isNegated() ? "!=" : "==") + " null"};
        this.getPrinter().print(objectArray);
    }

    public void visitConstantDescriptor(@NotNull KtConstantReference<ConeKotlinType, ConeDiagnostic> constantReference, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(constantReference, (String)"constantReference");
        Object[] objectArray = new Object[]{constantReference.getName()};
        this.getPrinter().print(objectArray);
    }

    public void visitValueParameterReference(@NotNull KtValueParameterReference<ConeKotlinType, ConeDiagnostic> valueParameterReference, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(valueParameterReference, (String)"valueParameterReference");
        Object[] objectArray = new Object[]{valueParameterReference.getName()};
        this.getPrinter().print(objectArray);
    }

    private final void inBracketsIfNecessary(KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> parent2, KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> child, Function0<Unit> block) {
        if (this.needsBrackets(parent2, child)) {
            Object[] objectArray = new Object[]{"("};
            this.getPrinter().print(objectArray);
            block.invoke();
            objectArray = new Object[]{")"};
            this.getPrinter().print(objectArray);
        } else {
            block.invoke();
        }
    }

    private final boolean isAtom(KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> $this$isAtom) {
        return $this$isAtom instanceof KtValueParameterReference || $this$isAtom instanceof KtConstantReference || $this$isAtom instanceof KtIsNullPredicate || $this$isAtom instanceof KtIsInstancePredicate;
    }

    private final boolean needsBrackets(KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> parent2, KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> child) {
        if (this.isAtom(child)) {
            return false;
        }
        if (parent2 instanceof KtLogicalNot) {
            return true;
        }
        return parent2.getClass() != child.getClass();
    }

    private static final Unit render$lambda$0(FirLegacyRawContractDescription $legacyRawContractDescription, ConeContractRenderer this$0) {
        $legacyRawContractDescription.getContractCall().accept(this$0.getVisitor());
        this$0.getPrinter().newLine();
        return Unit.INSTANCE;
    }

    private static final Unit render$lambda$1(ConeContractRenderer this$0, FirRawContractDescription $rawContractDescription) {
        this$0.getPrinter().renderSeparatedWithNewlines$tree($rawContractDescription.getRawEffects(), this$0.getVisitor());
        this$0.getPrinter().newLine();
        return Unit.INSTANCE;
    }

    private static final Unit visitLogicalBinaryOperationContractExpression$lambda$3(KtBinaryLogicExpression $binaryLogicExpression, ConeContractRenderer this$0, Void $data) {
        $binaryLogicExpression.getLeft().accept(this$0, $data);
        return Unit.INSTANCE;
    }

    private static final Unit visitLogicalBinaryOperationContractExpression$lambda$4(KtBinaryLogicExpression $binaryLogicExpression, ConeContractRenderer this$0, Void $data) {
        $binaryLogicExpression.getRight().accept(this$0, $data);
        return Unit.INSTANCE;
    }

    private static final Unit visitLogicalNot$lambda$5(ConeContractRenderer this$0) {
        Object[] objectArray = new Object[]{"!"};
        this$0.getPrinter().print(objectArray);
        return Unit.INSTANCE;
    }
}

