/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirConflictsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirDeclarationCollector;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirConflictsDeclarationCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.PlatformConflictDeclarationsDiagnosticDispatcher;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeSessionKey;
import org.jetbrains.kotlin.fir.scopes.impl.FirPackageMemberScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirPackageMemberScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorsSubstitutingScopeKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002JB\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2 \u0010\u0013\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0015\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u00160\u00142\u0006\u0010\u0017\u001a\u00020\u0002H\u0002J*\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u001f2\u0006\u0010\t\u001a\u00020\nH\u0002R\u001c\u0010\u0018\u001a\u00020\u0019*\u0006\u0012\u0002\b\u00030\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001a\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictsDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "getDestructuredParameters", "", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "reportConflicts", "declarationConflictingSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/utils/SmartSet;", "container", "isPrimaryConstructor", "", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Z", "checkFile", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "inspector", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationCollector;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConflictsDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConflictsDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictsDeclarationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 ScopeSession.kt\norg/jetbrains/kotlin/fir/resolve/ScopeSession\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,174:1\n2632#2,3:175\n774#2:178\n865#2,2:179\n1628#2,3:181\n1619#2:184\n1863#2:185\n1864#2:187\n1620#2:188\n1734#2,3:190\n1#3:186\n1#3:193\n216#4:189\n217#4:194\n18#5:195\n19#5:199\n20#5,2:204\n381#6,3:196\n384#6,4:200\n*S KotlinDebug\n*F\n+ 1 FirConflictsDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictsDeclarationChecker\n*L\n90#1:175,3\n92#1:178\n92#1:179,2\n93#1:181,3\n95#1:184\n95#1:185\n95#1:187\n95#1:188\n122#1:190,3\n95#1:186\n107#1:189\n107#1:194\n144#1:195\n144#1:199\n144#1:204,2\n144#1:196,3\n144#1:200,4\n*E\n"})
public final class FirConflictsDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirConflictsDeclarationChecker INSTANCE = new FirConflictsDeclarationChecker();

    private FirConflictsDeclarationChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirFile) {
            FirDeclarationCollector inspector = new FirDeclarationCollector(context);
            this.checkFile((FirFile)declaration, inspector, context);
            this.reportConflicts(reporter, context, (Map)inspector.getDeclarationConflictingSymbols(), declaration);
        } else if (firDeclaration instanceof FirClass) {
            KtSourceElement ktSourceElement = ((FirClass)declaration).getSource();
            if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind)) {
                FirConflictsHelpersKt.checkForLocalRedeclarations(((FirClass)declaration).getTypeParameters(), context, reporter);
            }
            FirDeclarationCollector inspector = new FirDeclarationCollector(context);
            FirConflictsHelpersKt.collectClassMembers(inspector, ((FirClass)declaration).getSymbol());
            this.reportConflicts(reporter, context, (Map)inspector.getDeclarationConflictingSymbols(), declaration);
        } else {
            KtSourceElement ktSourceElement = declaration.getSource();
            if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) && declaration instanceof FirTypeParameterRefsOwner) {
                if (declaration instanceof FirFunction) {
                    List<FirVariable> destructuredParameters = this.getDestructuredParameters((FirFunction)declaration);
                    FirConflictsHelpersKt.checkForLocalRedeclarations(destructuredParameters, context, reporter);
                }
                FirConflictsHelpersKt.checkForLocalRedeclarations(((FirTypeParameterRefsOwner)((Object)declaration)).getTypeParameters(), context, reporter);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirVariable> getDestructuredParameters(FirFunction function2) {
        void $this$mapNotNullTo$iv;
        Collection destination$iv;
        Iterator iterator2;
        Iterable $this$mapTo$iv;
        void $this$filterTo$iv$iv;
        Object element$iv2;
        boolean bl;
        block8: {
            Iterable $this$none$iv = function2.getValueParameters();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$none$iv) {
                    FirValueParameter it = (FirValueParameter)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)SpecialNames.DESTRUCT)) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        if (bl) {
            return function2.getValueParameters();
        }
        Iterable $this$filter$iv = function2.getValueParameters();
        boolean $i$f$filter22 = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirValueParameter it = (FirValueParameter)element$iv$iv;
            boolean bl3 = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)SpecialNames.DESTRUCT)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Collection $i$f$filter22 = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            iterator2 = (FirValueParameter)item$iv;
            void var17_19 = destination$iv;
            boolean bl4 = false;
            var17_19.add(it.getSymbol());
        }
        Set destructuredParametersBoxes = (Set)destination$iv;
        FirBlock firBlock = function2.getBody();
        List list = firBlock != null ? firBlock.getStatements() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        $this$mapTo$iv = list;
        destination$iv = CollectionsKt.toMutableList((Collection)function2.getValueParameters());
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirVariable it$iv;
            Object destructuredParameter;
            Object element$iv$iv;
            Object element$iv3 = element$iv$iv = iterator2.next();
            boolean bl5 = false;
            FirStatement it = (FirStatement)element$iv3;
            boolean bl6 = false;
            Object object = it instanceof FirVariable ? (FirVariable)it : null;
            if ((object == null || (object = FirConflictsHelpersKt.getDestructuredParameter((FirVariable)object)) == null ? null : (destructuredParametersBoxes.contains(destructuredParameter = object) ? (FirVariable)it : null)) == null) continue;
            it$iv = it$iv;
            boolean bl7 = false;
            destination$iv.add(it$iv);
        }
        return (List)destination$iv;
    }

    private final void reportConflicts(DiagnosticReporter reporter, CheckerContext context, Map<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>> declarationConflictingSymbols, FirDeclaration container) {
        Map<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>> $this$forEach$iv = declarationConflictingSymbols;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            PlatformConflictDeclarationsDiagnosticDispatcher dispatcher;
            KtDiagnosticFactory1<Collection<FirBasedSymbol<?>>> factory;
            boolean bl;
            KtSourceElement source;
            KtSourceElement ktSourceElement;
            Map.Entry<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>> element$iv;
            Map.Entry<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            FirBasedSymbol<?> conflictingDeclaration = entry.getKey();
            SmartSet<FirBasedSymbol<?>> symbols2 = entry.getValue();
            FirBasedSymbol firBasedSymbol = conflictingDeclaration instanceof FirConstructorSymbol ? (FirConstructorSymbol)conflictingDeclaration : null;
            KtSourceElement typeAliasForConstructorSource = firBasedSymbol != null && (firBasedSymbol = TypeAliasConstructorsSubstitutingScopeKt.getTypeAliasForConstructor((FirConstructorSymbol)firBasedSymbol)) != null ? firBasedSymbol.getSource() : null;
            FirDeclarationOrigin origin = conflictingDeclaration.getOrigin();
            if (!(conflictingDeclaration instanceof FirCallableSymbol)) {
                ktSourceElement = conflictingDeclaration.getSource();
            } else if (Intrinsics.areEqual((Object)origin, (Object)FirDeclarationOrigin.Source.INSTANCE)) {
                ktSourceElement = ((FirCallableSymbol)conflictingDeclaration).getSource();
            } else {
                if (Intrinsics.areEqual((Object)origin, (Object)FirDeclarationOrigin.Library.INSTANCE)) continue;
                ktSourceElement = source = Intrinsics.areEqual((Object)origin, (Object)FirDeclarationOrigin.Synthetic.TypeAliasConstructor.INSTANCE) ? typeAliasForConstructorSource : container.getSource();
            }
            if (symbols2.isEmpty()) continue;
            if (INSTANCE.isPrimaryConstructor(conflictingDeclaration)) {
                boolean bl3;
                block13: {
                    Iterable $this$all$iv = (Iterable)((Object)symbols2);
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        for (Object element$iv2 : $this$all$iv) {
                            FirBasedSymbol it = (FirBasedSymbol)element$iv2;
                            boolean bl4 = false;
                            if (INSTANCE.isPrimaryConstructor(it)) continue;
                            bl3 = false;
                            break block13;
                        }
                        bl3 = true;
                    }
                }
                if (bl3) continue;
            }
            if ((FirBasedSymbol)CollectionsKt.singleOrNull((Iterable)((Iterable)((Object)symbols2))) != null) {
                FirBasedSymbol it;
                boolean bl5 = false;
                bl = FirConflictsHelpersKt.isExpectAndNonExpect(conflictingDeclaration, it);
            } else {
                bl = false;
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPECT_AND_ACTUAL_IN_THE_SAME_MODULE(), conflictingDeclaration, (DiagnosticContext)context, null, 16, null);
                continue;
            }
            PlatformConflictDeclarationsDiagnosticDispatcher platformConflictDeclarationsDiagnosticDispatcher = FirConflictsDeclarationCheckerKt.getConflictDeclarationsDiagnosticDispatcher(context.getSession());
            if (platformConflictDeclarationsDiagnosticDispatcher == null) {
                platformConflictDeclarationsDiagnosticDispatcher = PlatformConflictDeclarationsDiagnosticDispatcher.DEFAULT.INSTANCE;
            }
            if ((factory = (dispatcher = platformConflictDeclarationsDiagnosticDispatcher).getDiagnostic(conflictingDeclaration, symbols2, context)) == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, factory, symbols2, (DiagnosticContext)context, null, 16, null);
        }
    }

    private final boolean isPrimaryConstructor(FirBasedSymbol<?> $this$isPrimaryConstructor) {
        return $this$isPrimaryConstructor instanceof FirConstructorSymbol && ((FirConstructorSymbol)$this$isPrimaryConstructor).isPrimary() || Intrinsics.areEqual((Object)$this$isPrimaryConstructor.getOrigin(), (Object)FirDeclarationOrigin.Synthetic.TypeAliasConstructor.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFile(FirFile file2, FirDeclarationCollector<FirBasedSymbol<?>> inspector, CheckerContext context) {
        Object object;
        Object object2;
        void id$iv;
        void this_$iv;
        ScopeSession scopeSession = context.getSessionHolder().getScopeSession();
        Pair pair = TuplesKt.to((Object)UtilsKt.getPackageFqName(file2), (Object)context.getSession());
        ScopeSessionKey<Pair<FqName, FirSession>, FirPackageMemberScope> key$iv = FirPackageMemberScopeKt.getPACKAGE_MEMBER();
        boolean $i$f$getOrBuild = false;
        Map $this$getOrPut$iv$iv = this_$iv.scopes();
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(id$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            HashMap answer$iv$iv = new HashMap();
            $this$getOrPut$iv$iv.put(id$iv, answer$iv$iv);
            object2 = answer$iv$iv;
        } else {
            object2 = value$iv$iv;
        }
        $this$getOrPut$iv$iv = (Map)object2;
        $i$f$getOrPut = false;
        value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            boolean bl2 = false;
            FirPackageMemberScope answer$iv$iv = new FirPackageMemberScope(UtilsKt.getPackageFqName(file2), context.getSessionHolder().getSession(), null, null, 12, null);
            $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        FirPackageMemberScope packageMemberScope = (FirPackageMemberScope)object;
        FirConflictsHelpersKt.collectTopLevel(inspector, file2, packageMemberScope);
    }
}

