/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.AbstractModifierChecks;
import org.jetbrains.kotlin.util.Check;
import org.jetbrains.kotlin.util.Checks;
import org.jetbrains.kotlin.util.IsKPropertyCheck;
import org.jetbrains.kotlin.util.MemberKindCheck;
import org.jetbrains.kotlin.util.NoDefaultAndVarargsCheck;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.ReturnsCheck;
import org.jetbrains.kotlin.util.ValueParameterCountCheck;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/util/OperatorChecks;", "Lorg/jetbrains/kotlin/util/AbstractModifierChecks;", "<init>", "()V", "checks", "", "Lorg/jetbrains/kotlin/util/Checks;", "getChecks$descriptors", "()Ljava/util/List;", "incDecCheckForExpectClass", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "receiver", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "descriptors"})
@SourceDebugExtension(value={"SMAP\nmodifierChecks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 modifierChecks.kt\norg/jetbrains/kotlin/util/OperatorChecks\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 modifierChecks.kt\norg/jetbrains/kotlin/util/AbstractModifierChecks\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,264:1\n1#2:265\n171#3:266\n171#3:270\n171#3:271\n1755#4,3:267\n*S KotlinDebug\n*F\n+ 1 modifierChecks.kt\norg/jetbrains/kotlin/util/OperatorChecks\n*L\n189#1:266\n203#1:270\n220#1:271\n203#1:267,3\n*E\n"})
public final class OperatorChecks
extends AbstractModifierChecks {
    @NotNull
    public static final OperatorChecks INSTANCE = new OperatorChecks();
    @NotNull
    private static final List<Checks> checks;

    private OperatorChecks() {
    }

    @Override
    @NotNull
    public List<Checks> getChecks$descriptors() {
        return checks;
    }

    private final boolean incDecCheckForExpectClass(FunctionDescriptor $this$incDecCheckForExpectClass, ReceiverParameterDescriptor receiver) {
        ReceiverValue receiverValue = receiver.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)receiverValue, (String)"getValue(...)");
        ReceiverValue receiverValue2 = receiverValue;
        if (!(receiverValue2 instanceof ImplicitClassReceiver)) {
            return false;
        }
        ClassDescriptor classDescriptor = ((ImplicitClassReceiver)receiverValue2).getClassDescriptor();
        if (!classDescriptor.isExpect()) {
            return false;
        }
        ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)classDescriptor);
        if (classId == null) {
            return false;
        }
        ClassId potentialActualAliasId = classId;
        ClassifierDescriptor classifierDescriptor = FindClassInModuleKt.findClassifierAcrossModuleDependencies(DescriptorUtilsKt.getModule(classDescriptor), potentialActualAliasId);
        TypeAliasDescriptor typeAliasDescriptor = classifierDescriptor instanceof TypeAliasDescriptor ? (TypeAliasDescriptor)classifierDescriptor : null;
        if (typeAliasDescriptor == null) {
            return false;
        }
        TypeAliasDescriptor actualReceiverTypeAlias = typeAliasDescriptor;
        KotlinType kotlinType = $this$incDecCheckForExpectClass.getReturnType();
        if (kotlinType != null) {
            KotlinType returnType = kotlinType;
            boolean bl = false;
            return TypeUtilsKt.isSubtypeOf(returnType, actualReceiverTypeAlias.getExpandedType());
        }
        return false;
    }

    private static final String checks$lambda$2(FunctionDescriptor $this$Checks) {
        String string2;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$Checks, (String)"$this$Checks");
        List<ValueParameterDescriptor> list = $this$Checks.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.lastOrNull(list);
        if (valueParameterDescriptor != null) {
            ValueParameterDescriptor it = valueParameterDescriptor;
            boolean bl2 = false;
            bl = !DescriptorUtilsKt.declaresOrInheritsDefaultValue(it) && it.getVarargElementType() == null;
        } else {
            bl = false;
        }
        boolean lastIsOk = bl;
        AbstractModifierChecks this_$iv = INSTANCE;
        boolean $i$f$ensure = false;
        if (!lastIsOk) {
            boolean bl3 = false;
            string2 = "last parameter should not have a default value or be a vararg";
        } else {
            string2 = null;
        }
        return string2;
    }

    private static final boolean checks$lambda$6$isAny(DeclarationDescriptor $this$checks_u24lambda_u246_u24isAny) {
        return $this$checks_u24lambda_u246_u24isAny instanceof ClassDescriptor && KotlinBuiltIns.isAny((ClassDescriptor)$this$checks_u24lambda_u246_u24isAny);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String checks$lambda$6(FunctionDescriptor $this$Checks) {
        StringBuilder stringBuilder;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$Checks, (String)"$this$Checks");
        AbstractModifierChecks abstractModifierChecks = INSTANCE;
        DeclarationDescriptor declarationDescriptor = $this$Checks.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        if (OperatorChecks.checks$lambda$6$isAny(declarationDescriptor)) return null;
        Collection<? extends FunctionDescriptor> collection = $this$Checks.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getOverriddenDescriptors(...)");
        Iterable $this$any$iv = collection;
        boolean $i$f$any = false;
        if (((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                FunctionDescriptor it = (FunctionDescriptor)element$iv;
                boolean bl2 = false;
                DeclarationDescriptor declarationDescriptor2 = it.getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor2, (String)"getContainingDeclaration(...)");
                if (!OperatorChecks.checks$lambda$6$isAny(declarationDescriptor2)) continue;
                return null;
            }
            bl = false;
        }
        if (bl) return null;
        if (DescriptorUtilKt.isTypedEqualsInValueClass($this$Checks)) {
            return null;
        }
        boolean bl3 = false;
        boolean cond$iv = bl3;
        boolean $i$f$ensure = false;
        if (cond$iv) return null;
        boolean bl4 = false;
        StringBuilder $this$checks_u24lambda_u246_u24lambda_u245_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl5 = false;
        $this$checks_u24lambda_u246_u24lambda_u245_u24lambda_u244.append("must override ''equals()'' in Any");
        DeclarationDescriptor declarationDescriptor3 = $this$Checks.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor3, (String)"getContainingDeclaration(...)");
        if (InlineClassesUtilsKt.isValueClass(declarationDescriptor3)) {
            DeclarationDescriptor declarationDescriptor4 = $this$Checks.getContainingDeclaration();
            Intrinsics.checkNotNull((Object)declarationDescriptor4, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            SimpleType simpleType = ((ClassDescriptor)declarationDescriptor4).getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
            String expectedParameterTypeRendered = DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(TypeUtilsKt.replaceArgumentsWithStarProjections(simpleType));
            $this$checks_u24lambda_u246_u24lambda_u245_u24lambda_u244.append(" or define ''equals(other: " + expectedParameterTypeRendered + "): Boolean''");
        }
        String string2 = stringBuilder.toString();
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String checks$lambda$8(FunctionDescriptor $this$Checks) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$Checks, (String)"$this$Checks");
        ReceiverParameterDescriptor receiverParameterDescriptor = $this$Checks.getDispatchReceiverParameter();
        if (receiverParameterDescriptor == null) {
            receiverParameterDescriptor = $this$Checks.getExtensionReceiverParameter();
        }
        ReceiverParameterDescriptor receiver = receiverParameterDescriptor;
        AbstractModifierChecks abstractModifierChecks = INSTANCE;
        if (receiver == null) return "receiver must be a supertype of the return type";
        KotlinType kotlinType = $this$Checks.getReturnType();
        if (kotlinType != null) {
            KotlinType kotlinType2 = receiver.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
            bl = TypeUtilsKt.isSubtypeOf(kotlinType, kotlinType2);
        } else {
            bl = false;
        }
        if (bl) return null;
        if (!INSTANCE.incDecCheckForExpectClass($this$Checks, receiver)) return "receiver must be a supertype of the return type";
        return null;
    }

    static {
        Object[] objectArray = new Checks[19];
        Object[] objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, new ValueParameterCountCheck.AtLeast(1)};
        objectArray[0] = new Checks(OperatorNameConventions.GET, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, new ValueParameterCountCheck.AtLeast(2)};
        objectArray[1] = new Checks(OperatorNameConventions.SET, (Check[])objectArray2, (Function1<? super FunctionDescriptor, String>)((Function1)OperatorChecks::checks$lambda$2));
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE, new ValueParameterCountCheck.AtLeast(2), IsKPropertyCheck.INSTANCE};
        objectArray[2] = new Checks(OperatorNameConventions.GET_VALUE, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE, new ValueParameterCountCheck.AtLeast(3), IsKPropertyCheck.INSTANCE};
        objectArray[3] = new Checks(OperatorNameConventions.SET_VALUE, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE, new ValueParameterCountCheck.Equals(2), IsKPropertyCheck.INSTANCE};
        objectArray[4] = new Checks(OperatorNameConventions.PROVIDE_DELEGATE, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE};
        objectArray[5] = new Checks(OperatorNameConventions.INVOKE, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE, ReturnsCheck.ReturnsBoolean.INSTANCE};
        objectArray[6] = new Checks(OperatorNameConventions.CONTAINS, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE};
        objectArray[7] = new Checks(OperatorNameConventions.ITERATOR, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE};
        objectArray[8] = new Checks(OperatorNameConventions.NEXT, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE, ReturnsCheck.ReturnsBoolean.INSTANCE};
        objectArray[9] = new Checks(OperatorNameConventions.HAS_NEXT, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE};
        objectArray[10] = new Checks(OperatorNameConventions.RANGE_TO, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE};
        objectArray[11] = new Checks(OperatorNameConventions.RANGE_UNTIL, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.Member.INSTANCE};
        objectArray[12] = new Checks(OperatorNameConventions.EQUALS, (Check[])objectArray2, (Function1<? super FunctionDescriptor, String>)((Function1)OperatorChecks::checks$lambda$6));
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ReturnsCheck.ReturnsInt.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE};
        objectArray[13] = new Checks(OperatorNameConventions.COMPARE_TO, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE};
        objectArray[14] = new Checks(OperatorNameConventions.BINARY_OPERATION_NAMES, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE};
        objectArray[15] = new Checks(OperatorNameConventions.SIMPLE_UNARY_OPERATION_NAMES, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Name[]{OperatorNameConventions.INC, OperatorNameConventions.DEC};
        Collection collection = CollectionsKt.listOf((Object[])objectArray2);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE};
        objectArray[16] = new Checks(collection, (Check[])objectArray2, (Function1<? super FunctionDescriptor, String>)((Function1)OperatorChecks::checks$lambda$8));
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ReturnsCheck.ReturnsUnit.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE};
        objectArray[17] = new Checks(OperatorNameConventions.ASSIGNMENT_OPERATIONS, (Check[])objectArray2, null, 4, null);
        objectArray2 = new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE};
        objectArray[18] = new Checks(OperatorNameConventions.COMPONENT_REGEX, (Check[])objectArray2, null, 4, null);
        checks = CollectionsKt.listOf((Object[])objectArray);
    }
}

