/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.CoroutineMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0015H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/UsedImportsCollector;", "Lorg/jetbrains/kotlin/js/backend/ast/RecursiveJsVisitor;", "usedImports", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "<init>", "(Ljava/util/Set;)V", "getUsedImports", "()Ljava/util/Set;", "pseudoImports", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars$JsVar;", "getPseudoImports", "()Ljava/util/List;", "visit", "", "x", "visitNameRef", "nameRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "visitFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "js.translator"})
final class UsedImportsCollector
extends RecursiveJsVisitor {
    @NotNull
    private final Set<JsName> usedImports;
    @NotNull
    private final List<JsVars.JsVar> pseudoImports;

    public UsedImportsCollector(@NotNull Set<JsName> usedImports) {
        Intrinsics.checkNotNullParameter(usedImports, (String)"usedImports");
        this.usedImports = usedImports;
        this.pseudoImports = new ArrayList();
    }

    @NotNull
    public final Set<JsName> getUsedImports() {
        return this.usedImports;
    }

    @NotNull
    public final List<JsVars.JsVar> getPseudoImports() {
        return this.pseudoImports;
    }

    @Override
    public void visit(@NotNull JsVars.JsVar x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        JsName jsName = x.getName();
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getName(...)");
        if (MetadataProperties.getImported(jsName)) {
            ((Collection)this.pseudoImports).add(x);
        } else {
            super.visit(x);
        }
    }

    @Override
    public void visitNameRef(@NotNull JsNameRef nameRef) {
        Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
        JsName name2 = nameRef.getName();
        if (name2 != null && MetadataProperties.getImported(name2)) {
            ((Collection)this.usedImports).add(name2);
        }
        super.visitNameRef(nameRef);
    }

    @Override
    public void visitFunction(@NotNull JsFunction x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        CoroutineMetadata coroutineMetadata = MetadataProperties.getCoroutineMetadata(x);
        if (coroutineMetadata != null) {
            CoroutineMetadata coroutineMetadata2;
            CoroutineMetadata $this$visitFunction_u24lambda_u240 = coroutineMetadata2 = coroutineMetadata;
            boolean bl = false;
            this.accept((JsNode)$this$visitFunction_u24lambda_u240.getSuspendObjectRef());
            this.accept((JsNode)$this$visitFunction_u24lambda_u240.getBaseClassRef());
        }
        super.visitFunction(x);
    }
}

