/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.util.CollectionUtilsKt;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\u001a*\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\u0018\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0010H\u0002\u001a2\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u0006\u0010\u001a\u001a\u00020\u0014H\u0002\u00a8\u0006\u001b"}, d2={"removeDefaultInitializers", "", "arguments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "parameters", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "body", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "markAssignmentAsStaticRef", "name", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "node", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "getNameFromInitializer", "statement", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "isInitializedExpr", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperation;", "isNameInitialized", "", "initializer", "getDefaultParamsNames", "", "args", "params", "initialized", "js.translator"})
@SourceDebugExtension(value={"SMAP\nremoveDefaultInitializers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 removeDefaultInitializers.kt\norg/jetbrains/kotlin/js/inline/clean/RemoveDefaultInitializersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1368#2:139\n1454#2,5:140\n*S KotlinDebug\n*F\n+ 1 removeDefaultInitializers.kt\norg/jetbrains/kotlin/js/inline/clean/RemoveDefaultInitializersKt\n*L\n37#1:139\n37#1:140,5\n*E\n"})
public final class RemoveDefaultInitializersKt {
    /*
     * WARNING - void declaration
     */
    public static final void removeDefaultInitializers(@NotNull List<? extends JsExpression> arguments, @NotNull List<JsParameter> parameters, @NotNull JsBlock body2) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Set<JsName> toRemove = RemoveDefaultInitializersKt.getDefaultParamsNames(arguments, parameters, true);
        Set<JsName> toExpand = RemoveDefaultInitializersKt.getDefaultParamsNames(arguments, parameters, false);
        List<JsStatement> list = body2.getStatements();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getStatements(...)");
        List<JsStatement> statements = list;
        Iterable $this$flatMap$iv = statements;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List<JsStatement> list2;
            JsStatement it = (JsStatement)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            JsName name2 = RemoveDefaultInitializersKt.getNameFromInitializer(it);
            if (name2 != null && !RemoveDefaultInitializersKt.isNameInitialized(name2, it)) {
                throw new AssertionError((Object)"Unexpected initializer structure");
            }
            if (name2 != null && toRemove.contains(name2)) {
                list2 = CollectionsKt.emptyList();
            } else if (name2 != null && toExpand.contains(name2)) {
                JsStatement thenStatement;
                Intrinsics.checkNotNullExpressionValue((Object)((JsIf)it).getThenStatement(), (String)"getThenStatement(...)");
                RemoveDefaultInitializersKt.markAssignmentAsStaticRef(name2, thenStatement);
                List<JsStatement> list3 = JsAstUtils.flattenStatement(thenStatement);
                Intrinsics.checkNotNull(list3);
                list2 = list3;
            } else {
                list2 = CollectionsKt.listOf((Object)it);
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List newStatements = (List)destination$iv$iv;
        statements.clear();
        statements.addAll(newStatements);
    }

    private static final void markAssignmentAsStaticRef(JsName name2, JsNode node) {
        node.accept(new RecursiveJsVisitor(name2){
            final /* synthetic */ JsName $name;
            {
                this.$name = $name;
            }

            public void visitBinaryExpression(JsBinaryOperation x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Pair<JsName, JsExpression> pair = JsAstUtils.decomposeAssignmentToVariable(x);
                if (pair != null) {
                    Pair<JsName, JsExpression> pair2 = pair;
                    JsName jsName = this.$name;
                    Pair<JsName, JsExpression> pair3 = pair2;
                    boolean bl = false;
                    JsName assignmentTarget = (JsName)pair3.component1();
                    JsExpression assignmentExpr = (JsExpression)pair3.component2();
                    if (Intrinsics.areEqual((Object)assignmentTarget, (Object)jsName)) {
                        Intrinsics.checkNotNull((Object)assignmentTarget);
                        MetadataProperties.setStaticRef(assignmentTarget, assignmentExpr);
                    }
                }
                super.visitBinaryExpression(x);
            }
        });
    }

    private static final JsName getNameFromInitializer(JsStatement statement) {
        JsStatement elseStmt;
        JsIf ifStmt;
        JsIf jsIf = ifStmt = statement instanceof JsIf ? (JsIf)statement : null;
        JsExpression testExpr = jsIf != null ? jsIf.getIfExpression() : null;
        JsIf jsIf2 = ifStmt;
        JsStatement jsStatement = elseStmt = jsIf2 != null ? jsIf2.getElseStatement() : null;
        if (elseStmt == null && testExpr instanceof JsBinaryOperation) {
            return RemoveDefaultInitializersKt.getNameFromInitializer((JsBinaryOperation)testExpr);
        }
        return null;
    }

    private static final JsName getNameFromInitializer(JsBinaryOperation isInitializedExpr) {
        JsExpression arg1 = isInitializedExpr.getArg1();
        JsExpression arg2 = isInitializedExpr.getArg2();
        JsBinaryOperator jsBinaryOperator = isInitializedExpr.getOperator();
        Intrinsics.checkNotNullExpressionValue((Object)jsBinaryOperator, (String)"getOperator(...)");
        JsBinaryOperator op = jsBinaryOperator;
        if (arg1 == null || arg2 == null) {
            return null;
        }
        if (op == JsBinaryOperator.REF_EQ && JsAstUtils.isUndefinedExpression(arg2)) {
            JsNameRef jsNameRef = arg1 instanceof JsNameRef ? (JsNameRef)arg1 : null;
            return jsNameRef != null ? jsNameRef.getName() : null;
        }
        return null;
    }

    private static final boolean isNameInitialized(JsName name2, JsStatement initializer) {
        JsExpression expr;
        Intrinsics.checkNotNull((Object)initializer, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsIf");
        JsStatement jsStatement = ((JsIf)initializer).getThenStatement();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"getThenStatement(...)");
        JsStatement thenStmt = jsStatement;
        List<JsStatement> list = JsAstUtils.flattenStatement(thenStmt);
        Intrinsics.checkNotNullExpressionValue(list, (String)"flattenStatement(...)");
        JsStatement lastThenStmt = (JsStatement)CollectionsKt.last(list);
        JsExpressionStatement jsExpressionStatement = lastThenStmt instanceof JsExpressionStatement ? (JsExpressionStatement)lastThenStmt : null;
        JsExpression jsExpression = expr = jsExpressionStatement != null ? jsExpressionStatement.getExpression() : null;
        if (!(expr instanceof JsBinaryOperation)) {
            return false;
        }
        JsBinaryOperator jsBinaryOperator = ((JsBinaryOperation)expr).getOperator();
        Intrinsics.checkNotNullExpressionValue((Object)jsBinaryOperator, (String)"getOperator(...)");
        JsBinaryOperator op = jsBinaryOperator;
        if (!op.isAssignment()) {
            return false;
        }
        JsExpression arg1 = ((JsBinaryOperation)expr).getArg1();
        return arg1 instanceof HasName && ((HasName)((Object)arg1)).getName() == name2;
    }

    private static final Set<JsName> getDefaultParamsNames(List<? extends JsExpression> args, List<JsParameter> params, boolean initialized) {
        List argsParams = CollectionUtilsKt.zipWithDefault((Iterable)args, (Iterable)params, Namer.getUndefinedExpression());
        Sequence relevantParams = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)argsParams), RemoveDefaultInitializersKt::getDefaultParamsNames$lambda$1), arg_0 -> RemoveDefaultInitializersKt.getDefaultParamsNames$lambda$2(initialized, arg_0));
        Sequence names = SequencesKt.map((Sequence)relevantParams, RemoveDefaultInitializersKt::getDefaultParamsNames$lambda$3);
        return SequencesKt.toSet((Sequence)names);
    }

    private static final boolean getDefaultParamsNames$lambda$1(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return MetadataProperties.getHasDefaultValue((JsParameter)it.getSecond());
    }

    private static final boolean getDefaultParamsNames$lambda$2(boolean $initialized, Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $initialized == !JsAstUtils.isUndefinedExpression((JsExpression)it.getFirst());
    }

    private static final JsName getDefaultParamsNames$lambda$3(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((JsParameter)it.getSecond()).getName();
    }
}

