/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.multiproject;

import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.IncrementalModuleEntry;
import org.jetbrains.kotlin.incremental.IncrementalModuleInfo;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistoryAndroid;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistoryBase;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistoryJvm;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistoryKt;
import org.jetbrains.kotlin.incremental.util.Either;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0016J\u001c\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\f0\u000b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0014J\u001c\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\f0\u000b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u001c\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\f0\u000b2\u0006\u0010\u0012\u001a\u00020\u0003H\u0014J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00192\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J>\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\f0\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00030\u001eH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryAndroid;", "Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryBase;", "rootProjectDir", "Ljava/io/File;", "modulesInfo", "Lorg/jetbrains/kotlin/incremental/IncrementalModuleInfo;", "<init>", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalModuleInfo;)V", "delegate", "Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryJvm;", "historyFilesForChangedFiles", "Lorg/jetbrains/kotlin/incremental/util/Either;", "", "changedFiles", "getBuildHistoryFilesForJar", "jar", "abiSnapshot", "getBuildHistoryForDir", "file", "getPossibleModuleNamesFromJar", "", "", "path", "Ljava/nio/file/Path;", "getPossibleModuleNamesForDir", "", "getHistoryForModuleNames", "moduleNames", "", "fileLocation", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/incremental/IncrementalModuleEntry;", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nModulesApiHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModulesApiHistory.kt\norg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryAndroid\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,257:1\n3829#2:258\n4344#2,2:259\n1557#3:261\n1628#3,3:262\n1454#3,5:265\n774#3:270\n865#3,2:271\n1628#3,3:273\n*S KotlinDebug\n*F\n+ 1 ModulesApiHistory.kt\norg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryAndroid\n*L\n242#1:258\n242#1:259,2\n242#1:261\n242#1:262,3\n247#1:265,5\n248#1:270\n248#1:271,2\n251#1:273,3\n*E\n"})
public final class ModulesApiHistoryAndroid
extends ModulesApiHistoryBase {
    @NotNull
    private final ModulesApiHistoryJvm delegate;

    public ModulesApiHistoryAndroid(@NotNull File rootProjectDir, @NotNull IncrementalModuleInfo modulesInfo) {
        Intrinsics.checkNotNullParameter((Object)rootProjectDir, (String)"rootProjectDir");
        Intrinsics.checkNotNullParameter((Object)modulesInfo, (String)"modulesInfo");
        super(rootProjectDir, modulesInfo);
        this.delegate = new ModulesApiHistoryJvm(rootProjectDir, modulesInfo);
    }

    @Override
    @NotNull
    public Either<Set<File>> historyFilesForChangedFiles(@NotNull Set<? extends File> changedFiles) {
        Intrinsics.checkNotNullParameter(changedFiles, (String)"changedFiles");
        Either<Set<File>> historyFromDelegate = this.delegate.historyFilesForChangedFiles(changedFiles);
        if (historyFromDelegate instanceof Either.Success) {
            return historyFromDelegate;
        }
        return super.historyFilesForChangedFiles(changedFiles);
    }

    @Override
    @NotNull
    protected Either<Set<File>> getBuildHistoryFilesForJar(@NotNull File jar) {
        Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
        if (!this.isInProjectBuildDir(jar)) {
            return new Either.Error("Non-project jar is modified " + jar);
        }
        Path jarPath = Paths.get(jar.getAbsolutePath(), new String[0]);
        Intrinsics.checkNotNull((Object)jarPath);
        return this.getHistoryForModuleNames(jarPath, (Iterable<String>)this.getPossibleModuleNamesFromJar(jarPath), (Function1<? super IncrementalModuleEntry, ? extends File>)((Function1)getBuildHistoryFilesForJar.1.INSTANCE));
    }

    @Override
    @NotNull
    public Either<Set<File>> abiSnapshot(@NotNull File jar) {
        Either either;
        Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
        Path jarPath = Paths.get(jar.getAbsolutePath(), new String[0]);
        Intrinsics.checkNotNull((Object)jarPath);
        Either<Set<File>> result2 = this.getHistoryForModuleNames(jarPath, (Iterable<String>)this.getPossibleModuleNamesFromJar(jarPath), (Function1<? super IncrementalModuleEntry, ? extends File>)((Function1)abiSnapshot.result.1.INSTANCE));
        if (result2 instanceof Either.Success) {
            either = new Either.Success(((Either.Success)result2).getValue());
        } else if (result2 instanceof Either.Error) {
            either = new Either.Error(((Either.Error)result2).getReason());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return either;
    }

    @Override
    @NotNull
    protected Either<Set<File>> getBuildHistoryForDir(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!this.isInProjectBuildDir(file2)) {
            return new Either.Error("Non-project file while looking for history " + file2);
        }
        List moduleNames = CollectionsKt.plus((Collection)this.getPossibleModuleNamesForDir(FilesKt.resolve((File)file2, (String)"meta-inf")), (Iterable)this.getPossibleModuleNamesForDir(FilesKt.resolve((File)file2, (String)"META-INF")));
        if (moduleNames.isEmpty()) {
            Either either;
            if (file2.getParentFile() == null) {
                either = new Either.Error("Unable to find history for " + file2);
            } else {
                File file3 = file2.getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getParentFile(...)");
                either = this.getBuildHistoryForDir(file3);
            }
            return either;
        }
        Path path = file2.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return this.getHistoryForModuleNames(path, moduleNames, (Function1<? super IncrementalModuleEntry, ? extends File>)((Function1)getBuildHistoryForDir.1.INSTANCE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Collection<String> getPossibleModuleNamesFromJar(Path path) {
        HashSet<String> result2 = new HashSet<String>();
        try {
            Closeable closeable = new ZipFile(path.toFile());
            Throwable throwable = null;
            try {
                ZipFile zip = (ZipFile)closeable;
                boolean bl = false;
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name2 = entry.getName();
                    Intrinsics.checkNotNull((Object)name2);
                    if (!StringsKt.endsWith((String)name2, (String)".kotlin_module", (boolean)true)) continue;
                    result2.add(FilesKt.getNameWithoutExtension((File)new File(name2)));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable t) {
            return CollectionsKt.emptyList();
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getPossibleModuleNamesForDir(File path) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        if (!path.isDirectory()) {
            return CollectionsKt.emptyList();
        }
        File[] fileArray = path.listFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"listFiles(...)");
        Object[] $this$filter$iv = fileArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (File element$iv$iv : $this$filterTo$iv$iv) {
            File it = element$iv$iv;
            boolean bl = false;
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            if (!StringsKt.endsWith((String)string2, (String)".kotlin_module", (boolean)true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File element$iv$iv;
            element$iv$iv = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(FilesKt.getNameWithoutExtension((File)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Either<Set<File>> getHistoryForModuleNames(Path path, Iterable<String> moduleNames, Function1<? super IncrementalModuleEntry, ? extends File> fileLocation) {
        void $this$mapTo$iv;
        void $this$filterTo$iv$iv;
        void $this$flatMapTo$iv;
        Iterable<String> iterable = moduleNames;
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Set set = this.getModulesInfo().getNameToModules().get(it);
            if (set == null) {
                set = SetsKt.emptySet();
            }
            Iterable list$iv = set;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        HashSet possibleModules = (HashSet)destination$iv;
        Iterable $this$filter$iv = possibleModules;
        boolean $i$f$filter22 = false;
        Iterable iterable2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IncrementalModuleEntry it = (IncrementalModuleEntry)element$iv$iv;
            boolean bl = false;
            Path path2 = Paths.get(it.getBuildDir().getAbsolutePath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            if (!ModulesApiHistoryKt.access$isParentOf(path2, path)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List modules2 = (List)destination$iv$iv;
        if (modules2.isEmpty()) {
            return new Either.Error("Unknown module for " + path + " (candidates: " + CollectionsKt.joinToString$default((Iterable)possibleModules, null, null, null, (int)0, null, null, (int)63, null) + ')');
        }
        Iterable $i$f$filter22 = modules2;
        Collection destination$iv2 = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Object element$iv$iv;
            element$iv$iv = (IncrementalModuleEntry)item$iv;
            Collection collection = destination$iv2;
            boolean bl = false;
            collection.add((File)fileLocation.invoke((Object)it));
        }
        HashSet result2 = (HashSet)destination$iv2;
        return new Either.Success<HashSet>(result2);
    }
}

