/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.ir;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.JvmIrSpecialAnnotationSymbolProvider;
import org.jetbrains.kotlin.backend.jvm.ir.IrJvmFlexibleType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.SimpleTypeNullability;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeBuilder;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.types.impl.IrStarProjectionImpl;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.FlexibleTypeBoundsChecker;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b\r\u0010\u000eJ\f\u0010\u001e\u001a\u00020\u001f*\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0014\u0010\u001a\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0010R\u0014\u0010\u001c\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0010\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/backend/jvm/ir/IrJvmFlexibleTypeImpl;", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrJvmFlexibleType;", "irType", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "specialAnnotations", "Lorg/jetbrains/kotlin/backend/jvm/JvmIrSpecialAnnotationSymbolProvider;", "nullability", "", "mutability", "arrayVariance", "raw", "<init>", "(Lorg/jetbrains/kotlin/ir/types/IrSimpleType;Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/backend/jvm/JvmIrSpecialAnnotationSymbolProvider;ZZZZ)V", "getIrType", "()Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "getBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getSpecialAnnotations", "()Lorg/jetbrains/kotlin/backend/jvm/JvmIrSpecialAnnotationSymbolProvider;", "getNullability", "()Z", "getMutability", "getArrayVariance", "getRaw", "lowerBound", "getLowerBound", "upperBound", "getUpperBound", "getArrayElementType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "backend.jvm"})
@SourceDebugExtension(value={"SMAP\nIrJvmFlexibleType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrJvmFlexibleType.kt\norg/jetbrains/kotlin/backend/jvm/ir/IrJvmFlexibleTypeImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 IrSimpleTypeImpl.kt\norg/jetbrains/kotlin/ir/types/impl/IrSimpleTypeImplKt\n*L\n1#1,142:1\n1#2:143\n169#3:144\n169#3:145\n*S KotlinDebug\n*F\n+ 1 IrJvmFlexibleType.kt\norg/jetbrains/kotlin/backend/jvm/ir/IrJvmFlexibleTypeImpl\n*L\n46#1:144\n76#1:145\n*E\n"})
final class IrJvmFlexibleTypeImpl
implements IrJvmFlexibleType {
    @NotNull
    private final IrSimpleType irType;
    @NotNull
    private final IrBuiltIns builtIns;
    @NotNull
    private final JvmIrSpecialAnnotationSymbolProvider specialAnnotations;
    private final boolean nullability;
    private final boolean mutability;
    private final boolean arrayVariance;
    private final boolean raw;

    public IrJvmFlexibleTypeImpl(@NotNull IrSimpleType irType, @NotNull IrBuiltIns builtIns, @NotNull JvmIrSpecialAnnotationSymbolProvider specialAnnotations, boolean nullability, boolean mutability, boolean arrayVariance, boolean raw) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)specialAnnotations, (String)"specialAnnotations");
        this.irType = irType;
        this.builtIns = builtIns;
        this.specialAnnotations = specialAnnotations;
        this.nullability = nullability;
        this.mutability = mutability;
        this.arrayVariance = arrayVariance;
        this.raw = raw;
        if (!(!this.arrayVariance || !this.raw)) {
            boolean bl = false;
            String string2 = "Flexible variance is only possible for Array types, which cannot be raw: " + RenderIrElementKt.render$default(this.irType, null, 1, null);
            throw new IllegalStateException(string2.toString());
        }
    }

    @NotNull
    public final IrSimpleType getIrType() {
        return this.irType;
    }

    @NotNull
    public final IrBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    @NotNull
    public final JvmIrSpecialAnnotationSymbolProvider getSpecialAnnotations() {
        return this.specialAnnotations;
    }

    public final boolean getNullability() {
        return this.nullability;
    }

    public final boolean getMutability() {
        return this.mutability;
    }

    public final boolean getArrayVariance() {
        return this.arrayVariance;
    }

    public final boolean getRaw() {
        return this.raw;
    }

    @Override
    @NotNull
    public IrSimpleType getLowerBound() {
        IrSimpleTypeBuilder irSimpleTypeBuilder;
        IrSimpleType $this$buildSimpleType$iv = this.irType;
        boolean $i$f$buildSimpleType = false;
        IrSimpleTypeBuilder $this$_get_lowerBound__u24lambda_u241 = irSimpleTypeBuilder = IrSimpleTypeImplKt.toBuilder($this$buildSimpleType$iv);
        boolean bl = false;
        if (this.nullability) {
            $this$_get_lowerBound__u24lambda_u241.setNullability(SimpleTypeNullability.NOT_SPECIFIED);
        }
        $this$_get_lowerBound__u24lambda_u241.setKotlinType(null);
        if (this.mutability) {
            IrClassSymbol irClassSymbol;
            IrClassifierSymbol irClassifierSymbol = $this$_get_lowerBound__u24lambda_u241.getClassifier();
            Object object = irClassifierSymbol != null ? irClassifierSymbol.getOwner() : null;
            IrClass irClass = object instanceof IrClass ? (IrClass)object : null;
            if (irClass == null) {
                throw new IllegalStateException(("Mutability-flexible type's classifier is not a class: " + RenderIrElementKt.render$default(this.irType, null, 1, null)).toString());
            }
            IrClass klass = irClass;
            FqName fqName = IrUtilsKt.getFqNameWhenAvailable(klass);
            Intrinsics.checkNotNull((Object)fqName);
            FqName readonlyClassFqName = FlexibleTypeBoundsChecker.INSTANCE.getBaseBoundFqNameByMutability(fqName);
            object = readonlyClassFqName;
            if (Intrinsics.areEqual((Object)object, (Object)StandardNames.FqNames.iterable)) {
                irClassSymbol = this.builtIns.getMutableIterableClass();
            } else if (Intrinsics.areEqual((Object)object, (Object)StandardNames.FqNames.iterator)) {
                irClassSymbol = this.builtIns.getMutableIteratorClass();
            } else if (Intrinsics.areEqual((Object)object, (Object)StandardNames.FqNames.listIterator)) {
                irClassSymbol = this.builtIns.getMutableListIteratorClass();
            } else if (Intrinsics.areEqual((Object)object, (Object)StandardNames.FqNames.list)) {
                irClassSymbol = this.builtIns.getMutableListClass();
            } else if (Intrinsics.areEqual((Object)object, (Object)StandardNames.FqNames.collection)) {
                irClassSymbol = this.builtIns.getMutableCollectionClass();
            } else if (Intrinsics.areEqual((Object)object, (Object)StandardNames.FqNames.set)) {
                irClassSymbol = this.builtIns.getMutableSetClass();
            } else if (Intrinsics.areEqual((Object)object, (Object)StandardNames.FqNames.map)) {
                irClassSymbol = this.builtIns.getMutableMapClass();
            } else if (Intrinsics.areEqual((Object)object, (Object)StandardNames.FqNames.mapEntry)) {
                irClassSymbol = this.builtIns.getMutableMapEntryClass();
            } else {
                throw new IllegalStateException(("Mutability-flexible type with unknown classifier: " + RenderIrElementKt.render$default(this.irType, null, 1, null) + ", FQ name: " + readonlyClassFqName).toString());
            }
            $this$_get_lowerBound__u24lambda_u241.setClassifier(irClassSymbol);
        }
        if (this.arrayVariance) {
            $this$_get_lowerBound__u24lambda_u241.setArguments(CollectionsKt.listOf((Object)IrSimpleTypeImplKt.makeTypeProjection(this.getArrayElementType(this.irType), Variance.INVARIANT)));
        }
        if (this.raw) {
            $this$_get_lowerBound__u24lambda_u241.setAnnotations(CollectionsKt.listOf((Object)this.specialAnnotations.generateRawTypeAnnotationCall()));
        }
        return IrSimpleTypeImplKt.buildSimpleType(irSimpleTypeBuilder);
    }

    @Override
    @NotNull
    public IrSimpleType getUpperBound() {
        IrSimpleTypeBuilder irSimpleTypeBuilder;
        IrSimpleType $this$buildSimpleType$iv = this.irType;
        boolean $i$f$buildSimpleType = false;
        IrSimpleTypeBuilder $this$_get_upperBound__u24lambda_u243 = irSimpleTypeBuilder = IrSimpleTypeImplKt.toBuilder($this$buildSimpleType$iv);
        boolean bl = false;
        if (this.nullability) {
            $this$_get_upperBound__u24lambda_u243.setNullability(SimpleTypeNullability.MARKED_NULLABLE);
        }
        if (this.mutability) {
            IrClassSymbol irClassSymbol;
            IrClassifierSymbol irClassifierSymbol = $this$_get_upperBound__u24lambda_u243.getClassifier();
            Object object = irClassifierSymbol != null ? irClassifierSymbol.getOwner() : null;
            IrClass irClass = object instanceof IrClass ? (IrClass)object : null;
            if (irClass == null) {
                throw new IllegalStateException(("Mutability-flexible type's classifier is not a class: " + RenderIrElementKt.render$default(this.irType, null, 1, null)).toString());
            }
            IrClass klass = irClass;
            FqName fqName = IrUtilsKt.getFqNameWhenAvailable(klass);
            Intrinsics.checkNotNull((Object)fqName);
            FqName readonlyClassFqName = FlexibleTypeBoundsChecker.INSTANCE.getBaseBoundFqNameByMutability(fqName);
            object = readonlyClassFqName;
            if (Intrinsics.areEqual((Object)object, (Object)StandardNames.FqNames.iterable)) {
                irClassSymbol = this.builtIns.getIterableClass();
            } else if (Intrinsics.areEqual((Object)object, (Object)StandardNames.FqNames.iterator)) {
                irClassSymbol = this.builtIns.getIteratorClass();
            } else if (Intrinsics.areEqual((Object)object, (Object)StandardNames.FqNames.listIterator)) {
                irClassSymbol = this.builtIns.getListIteratorClass();
            } else if (Intrinsics.areEqual((Object)object, (Object)StandardNames.FqNames.list)) {
                irClassSymbol = this.builtIns.getListClass();
            } else if (Intrinsics.areEqual((Object)object, (Object)StandardNames.FqNames.collection)) {
                irClassSymbol = this.builtIns.getCollectionClass();
            } else if (Intrinsics.areEqual((Object)object, (Object)StandardNames.FqNames.set)) {
                irClassSymbol = this.builtIns.getSetClass();
            } else if (Intrinsics.areEqual((Object)object, (Object)StandardNames.FqNames.map)) {
                irClassSymbol = this.builtIns.getMapClass();
            } else if (Intrinsics.areEqual((Object)object, (Object)StandardNames.FqNames.mapEntry)) {
                irClassSymbol = this.builtIns.getMapEntryClass();
            } else {
                throw new IllegalStateException(("Mutability-flexible type with unknown classifier: " + RenderIrElementKt.render$default(this.irType, null, 1, null) + ", FQ name: " + readonlyClassFqName).toString());
            }
            $this$_get_upperBound__u24lambda_u243.setClassifier(irClassSymbol);
        }
        if (this.arrayVariance) {
            $this$_get_upperBound__u24lambda_u243.setArguments(CollectionsKt.listOf((Object)IrSimpleTypeImplKt.makeTypeProjection(this.getArrayElementType(this.irType), Variance.OUT_VARIANCE)));
        }
        if (this.raw) {
            int n = $this$_get_upperBound__u24lambda_u243.getArguments().size();
            IrSimpleTypeBuilder irSimpleTypeBuilder2 = $this$_get_upperBound__u24lambda_u243;
            ArrayList<IrStarProjectionImpl> arrayList = new ArrayList<IrStarProjectionImpl>(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n3 = n2++;
                ArrayList<IrStarProjectionImpl> arrayList2 = arrayList;
                boolean bl2 = false;
                arrayList2.add(IrStarProjectionImpl.INSTANCE);
            }
            irSimpleTypeBuilder2.setArguments((List<? extends IrTypeArgument>)arrayList);
        }
        $this$_get_upperBound__u24lambda_u243.setKotlinType(null);
        return IrSimpleTypeImplKt.buildSimpleType(irSimpleTypeBuilder);
    }

    private final IrType getArrayElementType(IrSimpleType $this$getArrayElementType) {
        IrTypeArgument argument = (IrTypeArgument)CollectionsKt.singleOrNull($this$getArrayElementType.getArguments());
        if (!(argument instanceof IrTypeProjection)) {
            if (argument instanceof IrStarProjection) {
                throw new IllegalStateException(("Star projection is not possible for the argument of Array type: " + RenderIrElementKt.render$default(this.irType, null, 1, null)).toString());
            }
            if (argument == null) {
                throw new IllegalStateException(("Flexible variance is only possible for Array types: " + RenderIrElementKt.render$default(this.irType, null, 1, null)).toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return ((IrTypeProjection)argument).getType();
    }
}

